/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

public class ShExprTest extends ShExprTestCase {

	public void testUnaries() {
		eqi("-1", -1);
		eqi("+1",  1);
		eqi("!0",  1);
		eqi("-1+2", 1);
		eqi("~1",  0xfffffffffffffffel);
	}

	public void testId1() {
		eqi("1", 1);
	}

	public void testVariable01() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR", "72");
		eqi(env, "VAR", 72);
		eqi(env, "VAR + 1", 73);
		eqi(env, "1 + VAR + 1", 74);
	}

	public void testVariable02() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR", "72");
		eqi(env, "VAR++", 72);
		eqi(env, "VAR", 73);
		eqi(env, "VAR--", 73);
		eqi(env, "VAR", 72);
	}

	public void testVariable03() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR", "72");
		eqi(env, "++VAR", 73);
		eqi(env, "VAR", 73);
		eqi(env, "--VAR", 72);
		eqi(env, "VAR", 72);
	}

	public void testVariable04() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR", "ku");
		eqi(env, "VAR  = 72", 72);
		eqi(env, "VAR", 72);
		eqi(env, "VAR2 = 72", 72);
		eqi(env, "VAR2", 72);
	}

	public void testVariable05() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR",  "10");
		env.bind("VAR2", "10");
		eqi(env, "VAR  += 72", 82);
		eqi(env, "VAR", 82);
		eqi(env, "VAR  += VAR2 += 10", 102);
		eqi(env, "VAR", 102);
		eqi(env, "VAR2", 20);
	}

	public void testVariable06() {
		ShEnvironment env = new ShRootShellEnvironment(new ShRootEnvStub());

		env.bind("VAR",  "10");
		eqi(env, "VAR += 10", 20);
		eqi(env, "VAR", 20);
		eqi(env, "VAR -= 10", 10);
		eqi(env, "VAR", 10);
		eqi(env, "VAR *= 10", 100);
		eqi(env, "VAR", 100);
		eqi(env, "VAR /= 10", 10);
		eqi(env, "VAR", 10);
		eqi(env, "VAR %= 10", 0);
		eqi(env, "VAR", 0);

		env.bind("VAR",  "1");
		eqi(env, "VAR <<= 8",  256);
		eqi(env, "VAR", 256);
		eqi(env, "VAR >>= 8",  1);
		eqi(env, "VAR", 1);
		eqi(env, "VAR |=  15", 15);
		eqi(env, "VAR", 15);
		eqi(env, "VAR &=  30", 14);
		eqi(env, "VAR", 14);
		eqi(env, "VAR ^=  15", 1);
		eqi(env, "VAR", 1);
	}

	public void testFactor() {
		eqi("2*3", 6);
		eqi("2*3*4", 24);
		eqi("5%3", 2);
		eqi("4/2", 2);
		eqi("24/4/3", 2);
		eqi("24/4*3", 18);
		eqi("5%3%2", 0);
		eqi("2*\"3\"", 6);
		eqi("4/\"2\"", 2);
		eqi("5%\"3\"", 2);
		eqi("3/2", 1);
	}

	public void testTerm() {
		eqi("3+2", 5);
		eqi("3-2", 1);
		eqi("3-2-1", 0);
		eqi("3-2+1", 2);
		eqi("3*5+18/3", 21);
		eqi("3+\"2\"", 5);
		eqi("3-\"2\"", 1);
	}

	public void testRelop() {
		eqi("7 >  2", 1);
		eqi("7 >= 2", 1);
		eqi("7 <  2", 0);
		eqi("7 <= 2", 0);
		eqi("7 == 2", 0);
		eqi("7 != 2", 1);
		eqi("7 >  7", 0);
		eqi("7 >= 7", 1);
		eqi("7 <  7", 0);
		eqi("7 <= 7", 1);
		eqi("7 == 7", 1);
		eqi("7 != 7", 0);
		eqi("7 >  8", 0);
		eqi("7 >= 8", 0);
		eqi("7 <  8", 1);
		eqi("7 <= 8", 1);
		eqi("7 == 8", 0);
		eqi("7 != 8", 1);
		eqi("7 >  2.0", 1);
		eqi("7 >= 2.0", 1);
		eqi("7 <  2.0", 0);
		eqi("7 <= 2.0", 0);
		eqi("7 == 2.0", 0);
		eqi("7 != 2.0", 1);
		eqi("7 >  7.0", 0);
		eqi("7 >= 7.0", 1);
		eqi("7 <  7.0", 0);
		eqi("7 <= 7.0", 1);
		eqi("7 == 7.0", 1);
		eqi("7 != 7.0", 0);
		eqi("7 >  8.0", 0);
		eqi("7 >= 8.0", 0);
		eqi("7 <  8.0", 1);
		eqi("7 <= 8.0", 1);
		eqi("7 == 8.0", 0);
		eqi("7 != 8.0", 1);
		eqi("1+6 >  2", 1);
		eqi("1+6 >= 2", 1);
		eqi("1+6 <  2", 0);
		eqi("1+6 <= 2", 0);
		eqi("1+6 == 2", 0);
		eqi("1+6 != 2", 1);
	}

	public void testLogand() {
		eqi("1 && 1", 1);
		eqi("0 && 1", 0);
		eqi("1 && 0", 0);
		eqi("0 && 0", 0);
		eqi("2 + 0 && 1 + 3", 4);
		eqi("2 == 2 && 1 == 1", 1);
		eqi("2 != 2 && 1 == 1", 0);
		eqi("2 == 2 && 1 != 1", 0);
		eqi("2 != 2 && 1 != 1", 0);
		eqi("1 && 1 && 0", 0);
		eqi("1 && 1 && 1", 1);
	}

	public void testLogor() {
		eqi("1 || 1", 1);
		eqi("0 || 1", 1);
		eqi("1 || 0", 1);
		eqi("0 || 0", 0);
		eqi("2 + 0 || 1 + 3", 2);
		eqi("2 == 2 || 1 == 1", 1);
		eqi("2 != 2 || 1 == 1", 1);
		eqi("2 == 2 || 1 != 1", 1);
		eqi("2 != 2 || 1 != 1", 0);
		eqi("0 || 0 || 0", 0);
		eqi("1 || 0 || 0", 1);
		eqi("1 && 1 || 1 && 0", 1);
	}

	public void testCond() {
		eqi("1 ? 3 : 4", 3);
		eqi("0 ? 3 : 4", 4);
		eqi("1 ? 3 + 4 : 4 + 8", 7);
		eqi("0 ? 3 + 4 : 4 + 5", 9);
		eqi("1 ? 1 || 1 : 0 || 0", 1);
		eqi("0 ? 1 || 1 : 0 || 0", 0);
	}

	public void testBAnd() {
		eqi("3&5", 1);
		eqi("2&3&2", 2);
	}

	public void testBOr() {
		eqi("3|5", 7);
		eqi("2|3|2", 3);
		eqi("7&3^7&5|3&5", 7);
	}

	public void testBXor() {
		eqi("3^5", 6);
		eqi("2^3^2", 3);
	}

	public void testShift() {
		eqi("1<<5", 32);
		eqi("32>>5", 1);
	}

	public void testPow() {
		eqi("2**3", 8);
		eqi("2**3**2", 512);
	}

}
