/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.bc;

import java.util.List;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/14
 */
public interface BcNamespace {

	/**
	 * 
	 * @param name
	 * @return
	 */
	public char getCharacter(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public char allocCharacter(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public char getFunction(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public char allocLocalCharacter(String name);

	/**
	 * 
	 */
	public void clearLocalCharacter();

	/**
	 * 
	 * @param name
	 * @return
	 */
	public char defineFunction(String name, List<String> args);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public int getArity(String name);

	/**
	 * 
	 * @return
	 */
	public int getLocalStart();

	/**
	 * 
	 * @return
	 */
	public char pushLoop();

	/**
	 * 
	 * @return
	 */
	public void popLoop();

}
