/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.statement;

import net.morilib.awk.AwkBreakException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkValue;

/**
 * break文の中間表現です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public class AwkBreak extends AwkExpression {

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		throw new AwkBreakException();
	}

	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.addJmp(brk);
	}

}
