/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import net.morilib.awk.code.AwkExecutable;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class ExtendAwkProgramTest extends AwkTestCase {

	public void testProgram0122() {
		AwkExecutable e = pre("" +
				"function$ ns.aaa(a, b) { bbb(a, b); }\n" +
				"function$ ns.bbb(a, b) { print a, b; }\n" +
				"{ ns.aaa($1, $2); }");

		e.execute(ns0, fs0, "aaa bbb");
		eot("aaa bbb");
	}

	public void testProgram0101() {
		AwkExecutable e = pre("" +
				"function$ aaa() { print a++; }" +
				"{ aaa(); print a; }");

		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		eot("0");
		eot("");
		eot("1");
		eot("");
		eot("2");
		eot("");
	}

	public void testProgram0111() {
		AwkExecutable e = pre("" +
				"BEGIN { aaa = function() { print 1; }; }\n" +
				"{ aaa(); }");

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "aaa bbb");
		eot("1");
		eot("1");
		eot("1");
	}

	public void testProgram0112() {
		AwkExecutable e = pre("" +
				"BEGIN { aaa = function(a) { print a; }; }\n" +
				"{ aaa($1); }");

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "ccc bbb");
		e.execute(ns0, fs0, "ddd bbb");
		eot("aaa");
		eot("ccc");
		eot("ddd");
	}

	public void testProgram0113() {
		AwkExecutable e = pre("" +
				"BEGIN { aaa = function(a, b) { print a, b; }; }\n" +
				"{ aaa($1, $2); }");

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "ccc bbb");
		e.execute(ns0, fs0, "ddd bbb");
		eot("aaa bbb");
		eot("ccc bbb");
		eot("ddd bbb");
	}

	public void testProgram0114() {
		AwkExecutable e = pre("" +
				"function$ aaa(a) { print a; }\n" +
				"function$ bbb(a, b) { a(b); }\n" +
				"{ bbb(@aaa, $1); }");

		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "ccc bbb");
		e.execute(ns0, fs0, "ddd bbb");
		eot("aaa");
		eot("ccc");
		eot("ddd");
	}

	public void testProgram0115() {
		AwkExecutable e = pre("" +
				"function$ aaa() { a = 0; function() { print a++; }; }\n" +
				"BEGIN { bbb = aaa(); }\n" +
				"{ bbb(); }\n" +
				"END { print a; }");

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, "aaa bbb");
		e.execute(ns0, fs0, "ccc bbb");
		e.execute(ns0, fs0, "ddd bbb");
		e.executeEnd(ns0, fs0);
		eot("0");
		eot("1");
		eot("2");
		eot("");
	}

	public void testProgram0121() {
		AwkExecutable e = pre("" +
				"function$ ns.aaa(a, b) { print a, b; }" +
				"{ ns.aaa($1, $2); }");

		e.execute(ns0, fs0, "aaa bbb");
		eot("aaa bbb");
	}

}
