/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkIOTest extends AwkTestCase {

	public void testPrint01() {
		exe("print 1;");
		eot("1");
		exe("print 1, 2, 3;");
		eot("1 2 3");
		exe("print(1, 2, 3);");
		eot("1 2 3");
		exe("print((1, 2), 3);");
		eot("2 3");
		exe("print 1 + 2;");
		eot("3");
		exe("print 1 + 2, 3;");
		eot("3 3");
	}

	public void testPrint02() {
		exe("print 10 > 2;");
		eet("10");
		exe("print 7, 6, 5 > 2;");
		eet("7 6 5");
		exe("print 7, 6, (5 > 2);");
		eot("7 6 1");
		exe("print(7, 6, 5) > 2;");
		eet("7 6 5");
	}

	public void testPrint03() {
		exe("print 10 >> 2;");
		eet("10");
		exe("print 7, 6, 5 >> 2;");
		eet("7 6 5");
		exe("print(7, 6, 5) >> 2;");
		eet("7 6 5");
	}

	public void testPrintf01() {
		exe("printf \"1\";");
		eot("1");
		exe("printf \"%02d\", 1;");
		eot("01");
		exe("printf(\"%02d\", 1);");
		eot("01");
		exe("printf \"%02d %4s\", 1, \"765\";");
		eot("01  765");
	}

	public void testPrintf02() {
		exe("printf \"1\" > 2;");
		eet("1");
		exe("printf \"%02d\", 1 > 2;");
		eet("01");
		exe("printf(\"%02d\", 1) > 2;");
		eet("01");
		exe("printf \"%02d %4s\", 1, \"765\" > 2;");
		eet("01  765");
		exe("printf \"%02d\", (1 > 2);");
		eot("00");
	}

	public void testPrintf03() {
		exe("printf \"1\" >> 2;");
		eet("1");
		exe("printf \"%02d\", 1 >> 2;");
		eet("01");
		exe("printf(\"%02d\", 1) >> 2;");
		eet("01");
		exe("printf \"%02d %4s\", 1, \"765\" >> 2;");
		eet("01  765");
	}

	public void testGetline01() {
		piw.println("7 6 5");
		piw.println("8 7 6");
		piw.close();
		eqi("getline;", 1);
		eqs("$1;", "7");
		eqi("getline ai;", 1);
		eqs("ai;", "8 7 6");
		eqi("getline;", 0);
	}

	public void testGetline02() {
		piw.println("7 6 5");
		piw.println("8 7 6");
		piw.close();
		eqi("getline < 0;", 1);
		eqs("$1;", "7");
		eqi("getline ai < 0;", 1);
		eqs("ai;", "8 7 6");
		eqi("getline < 0;", 0);
	}

}
