/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.util.Collection;
import java.util.List;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.expr.AwkFunctionPrototype;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkUserFunction extends AwkFunction {

	private AwkExpression function;
	private String[] argnames;

	/**
	 * 
	 * @param name
	 * @param function
	 * @param argnames
	 */
	public AwkUserFunction(String name, AwkNamespace env,
			AwkExpression function, Collection<String> argnames) {
		super(name, env);
		this.function = function;
		this.argnames = argnames.toArray(new String[0]);
	}

	/**
	 * 
	 * @param name
	 * @param function
	 * @param argnames
	 */
	public AwkUserFunction(AwkFunctionPrototype f, AwkNamespace env) {
		this(f.getName(), env, f.getFunction(), f.getArgnames());
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		AwkNamespace e = env == null ? ns : env;

		for(int i = 0; i < argnames.length; i++) {
			if(i < args.size()) {
				e.assign(argnames[i], args.get(i));
			} else {
				e.assign(argnames[i], AwkUndefined.UNDEF);
			}
		}
		return function.eval(e, o);
	}

	@Override
	public String getName() {
		return name;
	}

}
