/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.regex.Pattern;

import net.morilib.awk.expr.AwkCastException;

public class AwkString implements AwkValue {

	//
	private String value;

	private AwkString(String s) {
		value = s;
	}

	public static AwkString valueOf(String s) {
		return new AwkString(s);
	}

	public double toFloat() {
		try {
			return Double.parseDouble(value);
		} catch(NumberFormatException e) {
			throw new AwkCastException();
		}
	}

	public BigInteger toInteger() {
		try {
			return new BigInteger(value);
		} catch(NumberFormatException e) {
			throw new AwkCastException();
		}
	}

	public Number toReal() {
		try {
			return new BigInteger(value);
		} catch(NumberFormatException e) {
			try {
				return Double.parseDouble(value);
			} catch(NumberFormatException f) {
				throw new AwkCastException();
			}
		}
	}

	public boolean toBoolean() {
		return !value.equals("");
	}

	public Pattern toRegex() {
		throw new AwkCastException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return value;
	}

	public AwkValue referArray(AwkValue v) {
		throw new AwkCastException();
	}

	public AwkValue putArray(AwkValue k, AwkValue v) {
		throw new AwkCastException();
	}

	public AwkValue deleteArray(AwkValue v) {
		throw new AwkCastException();
	}

	public Collection<AwkValue> values() {
		throw new AwkCastException();
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		try {
			Double.parseDouble(value);
			return true;
		} catch(NumberFormatException e) {
			return false;
		}
	}

	public boolean isIntegerValue() {
		try {
			new BigInteger(value);
			return true;
		} catch(NumberFormatException e) {
			return false;
		}
	}

	public boolean isRealValue() {
		return isFloatValue() || isIntegerValue();
	}

	public boolean isString() {
		return true;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public int hashCode() {
		return value.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof AwkString) {
			return value.equals(((AwkString)o).value);
		}
		return false;
	}

	public String toString() {
		return value;
	}

	public int compareTo(AwkValue o) {
		if(o instanceof AwkUndefined) {
			return 1;
		} else {
			return value.compareTo(o.toString());
		}
	}

}
