/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkRangedPattern implements AwkPattern {

	//
	private AwkPattern begin, end;

	/**
	 * 
	 * @param begin
	 * @param end
	 */
	public AwkRangedPattern(AwkPattern begin, AwkPattern end) {
		this.begin = begin;
		this.end   = end;
	}

	public boolean isBegin() {
		return false;
	}

	public boolean isEnd() {
		return false;
	}

	public AwkMatchState match(AwkNamespace ns, AwkFiles fs,
			String s, AwkMatchState stat) {
		switch(stat) {
		case NO_MATCH:
			if(begin.match(ns, fs, s, stat).isNotMatched()) {
				return AwkMatchState.NO_MATCH;
			} else {
				return AwkMatchState.IS_MATCHING;
			}
		case IS_MATCHING:
			if(end.match(ns, fs, s, stat).isNotMatched()) {
				return AwkMatchState.IS_MATCHING;
			} else {
				return AwkMatchState.MATCHED;
			}
		case MATCHED:  return AwkMatchState.MATCHED;
		default:  throw new RuntimeException();
		}
	}

	public boolean isRanged() {
		return true;
	}

}
