/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

import net.morilib.awk.AwkRuntimeException;

public class AwkSyntaxException extends AwkRuntimeException {

	private AwkToken expected, but;
	private String variable;

	public AwkSyntaxException(AwkToken expected, AwkToken but) {
		super("expected " + expected + " but " + but);
		this.expected = expected;
		this.but = but;
	}

	public AwkSyntaxException(String variable, AwkToken but) {
		super("expected <" + variable + "> but " + but);
		this.variable = variable;
		this.but = but;
	}

	public AwkSyntaxException(String mesg) {
		super(mesg);
	}

	public AwkToken getExpected() {
		return expected;
	}

	public AwkToken getBut() {
		return but;
	}

	public String getVariable() {
		return variable;
	}

}
