/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

public class AwkReserved extends AwkToken {

	public static final AwkToken BLOCK_B = new AwkReserved("{");
	public static final AwkToken BLOCK_E = new AwkReserved("}");
	public static final AwkToken SEMICL = new AwkReserved(";");
	public static final AwkToken APNDOUT = new AwkReserved(">>");

	public static final AwkToken IF = new AwkReserved("if");
	public static final AwkToken ELSE = new AwkReserved("else");
	public static final AwkToken FOR = new AwkReserved("for");
	public static final AwkToken IN = new AwkReserved("in");
	public static final AwkToken WHILE = new AwkReserved("while");
	public static final AwkToken DO = new AwkReserved("do");
	public static final AwkToken BREAK = new AwkReserved("break");
	public static final AwkToken CONT = new AwkReserved("continue");
	public static final AwkToken NEXT = new AwkReserved("next");
	public static final AwkToken EXIT = new AwkReserved("exit");
	public static final AwkToken RETURN = new AwkReserved("return");
	public static final AwkToken DELETE = new AwkReserved("delete");
	public static final AwkToken FUNC = new AwkReserved("function");

	public static final AwkToken GETLINE = new AwkReserved("getline");
	public static final AwkToken PRINT = new AwkReserved("print");
	public static final AwkToken PRINTF = new AwkReserved("printf");

	public static final AwkToken EOL = new AwkReserved("<eol>");
	public static final AwkToken ENDMARKER = new AwkReserved("<eof>");

	AwkReserved(String desc) {
		super(desc);
	}

}
