/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import net.morilib.awk.AwkLocation;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkApplier extends AwkExpression {

	private AwkExpression function;
	private AwkExpression[]  args;

	/**
	 * 
	 * @param function
	 * @param args
	 */
	public AwkApplier(AwkExpression function,
			Collection<AwkExpression> args) {
		this.function = function;
		this.args     = args.toArray(new AwkExpression[0]);
	}

	@Override
	public AwkValue eval(AwkNamespace s, AwkFiles o) {
		List<AwkValue> l = new ArrayList<AwkValue>();
		AwkNamespace t = s;
		AwkLocation m;
		AwkFunction g;
		AwkValue fn, f;

		for(AwkExpression e : args)  l.add(e.eval(s, o));
		if(function instanceof AwkReferVariable) {
			m = ((AwkReferVariable)function).getLocation();
			for(int i = 0; i < m.sizeOfPath() - 1; i++) {
				t = t.referNamespace(m.getPathOf(i));
				if(t == null) {
					return AwkUndefined.UNDEF;
				}
			}
			f = t.findFunction(m.getName());
			if(f == null)  f = t.find(m.getName());
			if(f == null)  throw new AwkCastException();
			if(!(f instanceof AwkFunction)) {
				throw new AwkCastException();
			}
			return ((AwkFunction)f).apply(t, o, l);
		} else if((fn = function.eval(s, o)) instanceof AwkFunction) {
			g = (AwkFunction)fn;
			return g.apply(g.getEnvironment(), o, l);
		} else {
			throw new AwkCastException();
		}
	}

}
