package net.morilib.sh.misc;

import java.util.Iterator;

import net.morilib.unix.misc.OptionIterator;

import junit.framework.TestCase;

public class OptionIteratorTest extends TestCase {

	public void test001() {
		OptionIterator i = new OptionIterator("a", "-a");

		assertTrue(i.hasNext());
		assertEquals("-a", i.getLookahead());
		assertEquals('a', i.nextChar());
		assertFalse(i.hasNext());
	}

	public void test002() {
		OptionIterator i = new OptionIterator("abc", "-bac");

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertEquals(1, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals(1, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('c', i.nextChar());
		assertEquals(2, i.getIndex());
		assertFalse(i.hasNext());
	}

	public void test003() {
		OptionIterator i = new OptionIterator("abc", "-ba", "-c");

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertEquals(1, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals(2, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('c', i.nextChar());
		assertEquals(3, i.getIndex());
		assertFalse(i.hasNext());
	}

	public void test004() {
		OptionIterator i = new OptionIterator("abc", "-b", "-a", "-c");

		assertEquals(1, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertEquals(2, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals(3, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('c', i.nextChar());
		assertEquals(4, i.getIndex());
		assertFalse(i.hasNext());
	}

	public void test005() {
		OptionIterator i = new OptionIterator("a:bc", "-ba", "aaa");

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("aaa", i.getArgument());
		assertFalse(i.hasNext());
	}

	public void test006() {
		OptionIterator i = new OptionIterator("a:bc", "-ba", "aaa", "-c");

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("aaa", i.getArgument());
		assertTrue(i.hasNext());
		assertEquals('c', i.nextChar());
		assertFalse(i.hasNext());
	}

	public void test007() {
		OptionIterator i = new OptionIterator("a:bc", "-a", "aaa", "-bc");

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("aaa", i.getArgument());
		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('c', i.nextChar());
		assertFalse(i.hasNext());
	}

	public void test008() {
		OptionIterator i = new OptionIterator("a:bc", "-abc");

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("bc", i.getArgument());
		assertFalse(i.hasNext());
	}

	public void test009() {
		OptionIterator i = new OptionIterator("a:bc", "-babc");

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("bc", i.getArgument());
		assertFalse(i.hasNext());
	}

	public void test010() {
		OptionIterator i = new OptionIterator("a:bc", "");

		assertFalse(i.hasNext());
	}

	public void test011() {
		OptionIterator i = new OptionIterator("a:bc", "aaa", "bbb");
		Iterator<String> t;

		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("aaa", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
	}

	public void test012() {
		OptionIterator i = new OptionIterator("a:bc", "--", "aaa", "bbb");
		Iterator<String> t;

		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("aaa", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
	}

	public void test013() {
		OptionIterator i = new OptionIterator("a:bc", "-a", "--", "aaa", "bbb");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("aaa", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test014() {
		OptionIterator i = new OptionIterator("a:bc", "-a", "abc", "--", "aaa");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("abc", i.getArgument());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("aaa", t.next());
		assertFalse(t.hasNext());
	}

	public void test015() {
		OptionIterator i = new OptionIterator("a:bc", "-a", "abc", "bbb");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("abc", i.getArgument());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test016() {
		OptionIterator i = new OptionIterator("abc", "-a", "abc", "bbb");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("abc", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test017() {
		OptionIterator i = new OptionIterator("abc", "-a", "abc", "bbb");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("abc", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test018() {
		OptionIterator i = new OptionIterator("a:bc", "-b", "-a", "abc", "bbb");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("abc", i.getArgument());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test019() {
		OptionIterator i = new OptionIterator("abc", "-b", "-a", "abc", "bbb");
		Iterator<String> t;

		assertEquals(1, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('b', i.nextChar());
		assertEquals(2, i.getIndex());
		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals(3, i.getIndex());
		assertFalse(i.hasNext());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("abc", t.next());
		assertTrue(t.hasNext());
		assertEquals("bbb", t.next());
		assertFalse(t.hasNext());
	}

	public void test020() {
		OptionIterator i = new OptionIterator("a:bc", "-a", "abc");
		Iterator<String> t;

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertEquals("abc", i.getArgument());
		assertFalse(i.hasNext());
		assertEquals(i.getIndex(), 3);
		t = i.filenameIterator();
		assertFalse(t.hasNext());
	}

	public void test021() {
		OptionIterator i = new OptionIterator("a:bc", "abc");
		Iterator<String> t;

		assertFalse(i.hasNext());
		assertEquals(1, i.getIndex());
		t = i.filenameIterator();
		assertTrue(t.hasNext());
		assertEquals("abc", t.next());
		assertFalse(t.hasNext());
	}

	public void test101() {
		OptionIterator i = new OptionIterator("abc", "-ad:");

		assertTrue(i.hasNext());
		assertEquals('a', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('?', i.nextChar());
		assertTrue(i.hasNext());
		assertEquals('?', i.nextChar());
		assertFalse(i.hasNext());
	}

}
