package net.morilib.sh;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ShRootEnvStub implements ShEnvironment {

	public Map<String, String> export =
		new HashMap<String, String>();
	private Map<String, Attributes> attrs =
		new HashMap<String, Attributes>();

	public void bind(String name, String value) {
		export.put(name, value);
	}

	public void bind(String name, ShTree f) {
	}

	public boolean contains(String name) {
		return export.containsKey(name);
	}

	public String find(String name) {
		return export.containsKey(name) ? export.get(name) : "";
	}

	public ShTree findFunction(String name) {
		return null;
	}

	public List<String> getPath() {
		return Arrays.asList(new String[] { });
	}

	public ShEnvironment getEnvironment() {
		return null;
	}

	public boolean isEnvironment() {
		return true;
	}

	public void put(String name, String value) {
		export.put(name, value);
	}

	public void put(String name, ShTree function) {
	}

	public Properties toProperties() {
		Properties p = new Properties();

		for(String s : export.keySet()) {
			p.setProperty(s, export.get(s));
		}
		return p;
	}

	public void export(String name) {
		export.put(name, "");
	}

	public boolean isSet(String name) {
		return false;
	}

	public void set(String name) {
	}

	public void reset(String name) {
	}

	public void set(String name, boolean value) {
	}

	public void unbind(String name) {
		export.remove(name);
	}

	public boolean isReadonly(String name) {
		Attributes a;

		return (a = attrs.get(name)) != null && a.isReadonly();
	}

	public boolean isSystem(String name) {
		return false;
	}

	public void setReadonly(String name) {
		if(export.containsKey(name))  attrs.put(name, READONLY);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShEnvironment#getTrap(net.morilib.sh.ShSignal)
	 */
	public String getTrap(ShSignal signal) {
		// OS signals cannot trap by Java VM
		return null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShEnvironment#setTrap(net.morilib.sh.ShSignal, java.lang.String)
	 */
	public void setTrap(ShSignal signal, String cmd) {
		// OS signals cannot trap by Java VM
	}

}
