package net.morilib.sh;

public class ShCommandStatementExecuteTest extends ShCommandExecuteTest {

	public void testIf001() {
		exe("if [ aaa ]; then echo aaa; fi", 0);
		eot("aaa");
	}

	public void testIf002() {
		exe("if ! [ aaa ]; then echo aaa; fi", 0);
		eot();
	}

	public void testIf003() {
		exe("if [ aaa ]; then echo aaa; else echo bbb; fi", 0);
		eot("aaa");
	}

	public void testIf004() {
		exe("if ! [ aaa ]; then echo aaa; else echo bbb; fi", 0);
		eot("bbb");
	}

	public void testIf005() {
		exe(    "#comment\n" +
				"if ! [ aaa ] # comment\n" +
				"then\n" +
				"  echo aaa\n" +
				"elif [ bbb ]\n" +
				"then\n" +
				"  echo bbb\n" +
				"fi", 0);
		eot("bbb");
	}

	public void testIf006() {
		exe(    "if ! [ aaa ]\n" +
				"then\n" +
				"  echo aaa\n" +
				"elif [ bbb ]\n" +
				"then\n" +
				"  echo bbb\n" +
				"else\n" +
				"  echo ccc\n" +
				"fi", 0);
		eot("bbb");
	}

	public void testIf007() {
		exe(    "if ! [ aaa ]\n" +
				"then\n" +
				"  echo aaa\n" +
				"elif [ ! bbb ]\n" +
				"then\n" +
				"  echo bbb\n" +
				"fi", 0);
		eot();
	}

	public void testIf008() {
		exe(    "if ! [ aaa ]\n" +
				"then\n" +
				"  echo aaa\n" +
				"elif [ ! bbb ]\n" +
				"then\n" +
				"  echo bbb\n" +
				"else\n" +
				"  echo ccc\n" +
				"fi", 0);
		eot("ccc");
	}

	public void testIf009() {
		exe(    "if [ aaa ]\n" +
				"then\n" +
				"  echo aaa\n" +
				"elif [ ! bbb ]\n" +
				"then\n" +
				"  echo bbb\n" +
				"else\n" +
				"  echo ccc\n" +
				"fi", 0);
		eot("aaa");
	}

	public void testCase001() {
		exe(    "case aaa in\n" +
				"  aaa)  echo aaa;;" +
				"    *)  echo bbb;;" +
				"esac", 0);
		eot("aaa");
	}

	public void testCase002() {
		exe(    "case aaa in\n" +
				"  aaa )  echo aaa;;" +
				"    * )  echo bbb;;" +
				"esac", 0);
		eot("aaa");
	}

	public void testCase003() {
		exe(    "case ccc in" +
				"  aaa)  echo aaa;;" +
				"    *)  echo bbb;;" +
				"esac", 0);
		eot("bbb");
	}

	public void testCase004() {
		exe(    "case ccc in\n" +
				"  aaa )  echo aaa;;" +
				"    * )  echo bbb;;" +
				"esac", 0);
		eot("bbb");
	}

	public void testCase005() {
		exe(    "case aaa in\n" +
				"  'aaa')  echo aaa;;" +
				"      *)  echo bbb;;" +
				"esac", 0);
		eot("aaa");
	}

	public void testCase006() {
		exe(    "case aaa in\n" +
				"  aaa|bbb)  echo aaa;;" +
				"        *)  echo bbb;;" +
				"esac", 0);
		exe(    "case bbb in\n" +
				"  aaa|bbb)  echo aaa;;" +
				"        *)  echo bbb;;" +
				"esac", 0);
		exe(    "case aab in\n" +
				"  aaa|bbb)  echo aaa;;" +
				"        *)  echo bbb;;" +
				"esac", 0);
		eot("aaa");
		eot("aaa");
		eot("bbb");
	}

	public void testCase007() {
		exe(    "case aaa in\n" +
				"  'aaa|bbb')  echo aaa;;" +
				"          *)  echo bbb;;" +
				"esac", 0);
		exe(    "case 'aaa|bbb' in\n" +
				"  'aaa|bbb')  echo aaa;;" +
				"          *)  echo bbb;;" +
				"esac", 0);
		eot("bbb");
		eot("aaa");
	}

	public void testCase008() {
		exe(    "case $em in\n" +
				"  aaa)  echo aaa;;" +
				"    *)  echo bbb;;" +
				"esac", 0);
		eot("bbb");
	}

	public void testCase009() {
		exe(    "case $em in\n" +
				"  aaa)  echo aaa;;" +
				"esac", 0);
		eot();
	}

	public void testCase010() {
		exe(    "case $em in\n" +
				"esac", 0);
		eot();
	}

	public void testCase011() {
		exe(    "case $em in\n" +
				"  '')  echo aaa;;" +
				"esac", 0);
		eot("aaa");
	}

	public void testCase012() {
		exe(    "case $em in\n" +
				"  $es)  echo aaa;;" +
				"esac", 0);
		eot("aaa");
	}

	public void testWhile001() {
		env.bind("var", "5");
		exe("while [ $var -ne 0 ]; do echo $((var--)); done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");  eot("1");
		eot();
	}

	public void testWhile002() {
		env.bind("var", "5");
		exe(    "while [ $var -ne 0 ]\n" +
				"do\n" +
				"  echo $((var--))\n" +
				"done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");  eot("1");
		eot();
	}

	public void testWhile003() {
		env.bind("var", "5");
		exe(    "while [ $var -ne 0 ]\n" +
				"do\n" +
				"  if [ $var -eq 1 ]; then break; fi\n" +
				"  echo $((var--))\n" +
				"done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");
		eot();
	}

	public void testWhile004() {
		env.bind("var", "5");
		exe(    "while [ $var -ne 0 ]\n" +
				"do\n" +
				"  [ $var -eq 1 ] && break\n" +
				"  echo $((var--))\n" +
				"done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");
		eot();
	}

	public void testWhile005() {
		env.bind("var", "5");
		exe(    "while [ $var -ne 0 ]\n" +
				"do\n" +
				"  [ $((var--)) -eq 3 ] && continue\n" +
				"  echo $var\n" +
				"done", 0);
		eot("4");  eot("3");  eot("1");  eot("0");
		eot();
	}

	public void testUntil001() {
		env.bind("var", "5");
		exe("until [ $var -eq 0 ]; do echo $((var--)); done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");  eot("1");
		eot();
	}

	public void testUntil002() {
		env.bind("var", "5");
		exe(    "until [ $var -eq 0 ]\n" +
				"do\n" +
				"  echo $((var--))\n" +
				"done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");  eot("1");
		eot();
	}

	public void testUntil003() {
		env.bind("var", "5");
		exe(    "until [ $var -eq 0 ]\n" +
				"do\n" +
				"  [ $var -eq 1 ] && break\n" +
				"  echo $((var--))\n" +
				"done", 0);
		eot("5");  eot("4");  eot("3");  eot("2");
		eot();
	}

	public void testUntil004() {
		env.bind("var", "5");
		exe(    "until [ $var -eq 0 ]\n" +
				"do\n" +
				"  [ $((var--)) -eq 3 ] && continue\n" +
				"  echo $var\n" +
				"done", 0);
		eot("4");  eot("3");  eot("1");  eot("0");
		eot();
	}

	public void testBlock001() {
		exe("{ echo aaa; echo bbb; }", 0);
		eot("aaa");  eot("bbb");  eot();
	}

	public void testBlock002() {
		exe("{ echo aaa; [ ! aaa ]; }", 1);
		eot("aaa");  eot();
	}

	public void testBlock003() {
		exe("aa=1", 0);
		exe("{ aa=2; echo $aa; }", 0);
		exe("echo $aa", 0);
		eot("2");
		eot("2");
	}

	public void testFor001() {
		exe("for i in aaa bbb $em; do echo $i; done", 0);
		eot("aaa");  eot("bbb");  eot();
	}

	public void testFor002() {
		exe(    "for i in aaa bbb $em\n" +
				"do\n" +
				"  echo $i\n" +
				"done", 0);
		eot("aaa");  eot("bbb");  eot();
	}

	public void testFor003() {
		exe(    "for i in aaa bbb \"$em\" ddd\n" +
				"do\n" +
				"  [ \"x$i\" = 'x' ] && break\n" +
				"  echo $i\n" +
				"done", 0);
		eot("aaa");  eot("bbb");
		eot();
	}

	public void testFor004() {
		exe(    "for i in aaa bbb $em ddd\n" +
				"do\n" +
				"  [ $i = '' ] && continue\n" +
				"  echo $i\n" +
				"done", 0);
		eot("aaa");  eot("bbb");  eot("ddd");
		eot();
	}

	public void testRedirect001() {
		env.bind("var", "5");
		exe("while [ $var -ne 0 ]; do echo $((var--)); done > 1.txt", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "5");  eot(o1r, "4");
		eot(o1r, "3");  eot(o1r, "2");
		eot(o1r, "1");
	}

	public void testRedirect002() {
		env.bind("var", "5");
		exe("while [ $var -ne 0 ]; do echo $((var--)); done 1>&2", 0);
		eet("5");  eet("4");  eet("3");  eet("2");  eet("1");
		eet();
	}

	public void testOperator001() {
		exe("if [ aaa ]; then echo aaa; fi && echo bbb", 0);
		eot("aaa");
		eot("bbb");
	}

	public void testOperator002() {
		exe("! if [ aaa ]; then echo aaa; fi || echo bbb", 0);
		eot("aaa");
		eot("bbb");
	}

	public void testComment001() {
		exe(    "#\n" +
				"# comment\n" +
				"#\n" +
				"echo bbb  # comment\n" +
				"# aaaaa\n" +
				"echo ccc", 0);
		eot("bbb");
		eot("ccc");
	}

	public void testSubShell001() {
		exe("aa=1", 0);
		exe("( echo $aa )", 0);
		eot("");
	}

	public void testSubShell002() {
		exe("aa=1", 0);
		exe("( aa=2; echo $aa )", 0);
		exe("echo $aa", 0);
		eot("2");
		eot("1");
	}

	public void testSubShell003() {
		exe("cd haruka", 0);
		exe("( cd chihaya; pwd )", 0);
		exe("pwd", 0);
		eot("/chihaya");
		eot("/haruka");
	}

	public void testFunction001() {
		exe(    "aaa () {\n" +
				"  echo bbb\n" +
				"}", 0);
		exe("aaa", 0);
		eot("bbb");
	}

	public void testFunction002() {
		exe(    "aaa (  ) {\n" +
				"  echo bbb\n" +
				"  echo ccc\n" +
				"}", 0);
		exe("aaa", 0);
		eot("bbb");
		eot("ccc");
	}

	public void testFunction003() {
		exe(    "aaa ()\n" +
				"{\n" +
				"  echo bbb\n" +
				"}", 0);
		exe("aaa", 0);
		eot("bbb");
	}

	public void testFunction004() {
		exe(    "aaa () {\n" +
				"  echo bbb\n" +
				"} 1>&2", 0);
		exe("aaa", 0);
		eet("bbb");
	}

	public void testFunction005() {
		exe(    "function aaa {\n" +
				"  echo bbb\n" +
				"}", 0);
		exe("aaa", 0);
		eot("bbb");
	}

	public void testFunction006() {
		exe(    "function aaa\n" +
				"{\n" +
				"  echo bbb\n" +
				"}", 0);
		exe("aaa", 0);
		eot("bbb");
	}

	public void testFunction007() {
		exe(    "function aaa {\n" +
				"  echo bbb\n" +
				"} 1>&2", 0);
		exe("aaa", 0);
		eet("bbb");
	}

	public void testFunction008() {
		exe(    "function aaa {\n" +
				"  echo bbb\n" +
				"  return 1\n" +
				"}", 0);
		exe("aaa", 1);
		eot("bbb");
	}

	public void testFunction009() {
		exe(    "function aaa {\n" +
				"  echo bbb\n" +
				"  return 1\n" +
				"} 1>&2", 0);
		exe("aaa", 1);
		eet("bbb");
	}

	public void testFunction010() {
		env.put("1", "0");
		env.put("aaa", "zzz");
		env.put("bbb", "zzz");
		exe(    "function aaa {\n" +
				"  local bbb\n" +
				"  aaa=ccc bbb=ccc\n" +
				"  echo $2 $#\n" +
				"  echo $aaa $bbb\n" +
				"  return $1\n" +
				"}", 0);
		exe("echo $aaa $bbb", 0);
		exe("aaa 2 bbb", 2);
		exe("echo $1", 0);
		exe("echo $aaa $bbb", 0);
		eot("zzz zzz");
		eot("bbb 3");
		eot("ccc ccc");
		eot("0");
		eot("ccc zzz");
	}

	public void testFunction011() {
		exe(    "function aaa {\n" +
				"  if [ aaa ]\n" +
				"  then\n" +
				"    return 1\n" +
				"  else\n" +
				"    return 2\n" +
				"  fi\n" +
				"}", 0);
		exe("aaa", 1);
	}

}
