/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import net.morilib.awk.code.AwkExecutable;
import net.morilib.awk.misc.RecordInputStream;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/21
 */
public class MultibyteAwkProgramTest extends AwkTestCase {

	public void testProgram1001() throws IOException {
		AwkExecutable e = pre("" +
				"{ print }");
		RecordInputStream rd = new RecordInputStream(
				new ByteArrayInputStream(
						("天海春香\n" +
						"如月千早\n" +
						"萩原雪歩").getBytes()),
				ns0);

		e.executeBegin(ns0, fs0);
		e.execute(ns0, fs0, rd.readRecord());
		e.execute(ns0, fs0, rd.readRecord());
		e.execute(ns0, fs0, rd.readRecord());
		eot("天海春香");
		eot("如月千早");
		eot("萩原雪歩");
		rd.close();
	}

}
