/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.io.IOException;
import java.util.Arrays;

import net.morilib.awk.misc.FilesReader;
import junit.framework.TestCase;

public class FilesReaderTest extends TestCase {

	public void testRead01() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[72];

		f.read(a, 0, 72);
		assertEquals(new String(a),
				"1234567890\r\n1234567890\r\n" +
				"abcdefghij\r\nabcdefghij\r\n" +
				"ABCDEFGHIJ\r\nABCDEFGHIJ\r\n");
	}

	public void testRead02() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[60];

		f.read(a, 0, 60);
		assertEquals(new String(a),
				"1234567890\r\n1234567890\r\n" +
				"abcdefghij\r\nabcdefghij\r\n" +
				"ABCDEFGHIJ\r\n");
	}

	public void testRead03() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[100];
		int l = f.read(a, 0, 100);

		assertEquals(l, 72);
		assertEquals(new String(a, 0, l),
				"1234567890\r\n1234567890\r\n" +
				"abcdefghij\r\nabcdefghij\r\n" +
				"ABCDEFGHIJ\r\nABCDEFGHIJ\r\n");
	}

	public void testRead04() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[100];

		f.read(a,  0, 12);
		f.read(a, 12, 24);
		f.read(a, 36, 24);
		assertEquals(new String(a, 0, 60),
				"1234567890\r\n1234567890\r\n" +
				"abcdefghij\r\nabcdefghij\r\n" +
				"ABCDEFGHIJ\r\n");
	}

	public void testRead11() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[100];
		int c;

		for(int i = 0; i < 60; i++) {
			assertTrue((c = f.read()) >= 0);
			a[i] = (char)c;
		}
		assertEquals(new String(a, 0, 60),
				"1234567890\r\n1234567890\r\n" +
				"abcdefghij\r\nabcdefghij\r\n" +
				"ABCDEFGHIJ\r\n");
	}

	public void testSkip01() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[100];

		assertEquals(f.skip(60), 60);
		assertEquals(f.read(a, 0, 12), 12);
		assertEquals(new String(a, 0, 12),
				"ABCDEFGHIJ\r\n");
	}

	public void testSkip02() throws IOException {
		FilesReader f = FilesReader.newResorces(
				Arrays.asList(
						(Object)"/net/morilib/awk/files1.txt",
						(Object)"/net/morilib/awk/files2.txt",
						(Object)"/net/morilib/awk/files3.txt"));
		char[] a = new char[100];

		assertEquals(f.skip(12), 12);
		assertEquals(f.read(a, 0, 24), 24);
		assertEquals(new String(a, 0, 24),
				"1234567890\r\nabcdefghij\r\n");
	}

}
