/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

import net.morilib.awk.encoding.EncodingDetector;
import net.morilib.awk.encoding.EncodingDetectorFactory;

import junit.framework.TestCase;

public class EncodeDetectorTest extends TestCase {

	static ByteArrayInputStream ge(String s, String cs) {
		try {
			return new ByteArrayInputStream(s.getBytes(cs));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}

	static void eqj(String s, String cs, String c2) {
		EncodingDetector e =
			EncodingDetectorFactory.getInstance(Locale.JAPANESE);

		try {
			assertEquals(e.detect(ge(s, cs)), Charset.forName(c2));
		} catch (IOException e1) {
			throw new RuntimeException(e1);
		}
	}

	public void testUTF8() {
		eqj("アイドルマスター", "UTF-8", "UTF-8");
	}

	public void testSJIS() {
		eqj("アイドルマスター", "Windows-31J", "Windows-31J");
	}

	public void testEUCJP() {
		eqj("アイドルマスター", "EUC-JP", "EUC-JP");
	}

	public void testJIS() {
		eqj("アイドルマスター", "ISO-2022-JP", "ISO-2022-JP");
	}

	public void testUTF16BE() {
		eqj("アイドルマスター", "UTF-16BE", "UTF-16BE");
	}

	public void testUTF16LE() {
		eqj("アイドルマスター", "UTF-16LE", "UTF-16LE");
	}

}
