/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSignal;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/16
 */
public class ShTrap implements ShProcess {

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShProcess#main(net.morilib.sh.ShEnvironment, net.morilib.sh.ShFileSystem, java.io.InputStream, java.io.PrintStream, java.io.PrintStream, java.lang.String[])
	 */
	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		ShSignal s;
		int k = 1;

		if(args.length < 2) {
			err.println("trap: too few arguments.");
			return 2;
		} else if(args[k].equals("-p")) {
			for(ShSignal x : ShSignal.getAll()) {
				out.print("trap -- '");
				out.print(env.getTrap(x));
				out.print("' ");
				out.println(x);
			}
			return 0;
		} else if(args[k].equals("--")) {
			k++;
		}

		if(args.length - k < 2) {
			err.println("trap: too few arguments.");
			return 2;
		} else if((s = ShSignal.getInstance(args[k + 1])) == null) {
			err.print("trap: invalid signal: ");
			err.println(args[k + 1]);
			return 2;
		} else if(args[k].equals("")) {
			env.setTrap(s, null);
			return 0;
		} else {
			env.setTrap(s, args[k]);
			return 0;
		}
	}

}
