/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.List;
import java.util.Properties;

public interface ShEnvironment {

	public static class Attributes {

		private int flags;

		Attributes(int f) {
			flags = f;
		}

		public boolean isReadonly() {
			return (flags & 1) != 0;
		}

	}

	/**
	 * 
	 */
	public static final Attributes NONE = new Attributes(0);

	/**
	 * 
	 */
	public static final Attributes READONLY = new Attributes(1);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public String find(String name);

	/**
	 * 
	 * @param name
	 * @param value
	 */
	public void bind(String name, String value);

	/**
	 * 
	 * @param name
	 * @param value
	 */
	public void put(String name, String value);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean contains(String name);

	/**
	 * 
	 * @return
	 */
	public ShEnvironment getEnvironment();

	/**
	 * 
	 * @return
	 */
	public boolean isEnvironment();

	/**
	 * 
	 * @return
	 */
	public Properties toProperties();

	/**
	 * 
	 * @return
	 */
	public List<String> getPath();

	/**
	 * 
	 * @param name
	 * @param f
	 */
	public void bind(String name, ShTree f);

	/**
	 * 
	 * @param name
	 * @param value
	 */
	public void put(String name, ShTree function);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ShTree findFunction(String name);

	/**
	 * 
	 * @param name
	 */
	public void export(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean isSet(String name);

	/**
	 * 
	 * @param name
	 */
	public void set(String name);

	/**
	 * 
	 * @param name
	 */
	public void reset(String name);

	/**
	 * 
	 * @param name
	 * @param value
	 */
	public void set(String name, boolean value);

	/**
	 * 
	 * @param name
	 */
	public void unbind(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean isSystem(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean isReadonly(String name);

	/**
	 * 
	 * @param name
	 */
	public void setReadonly(String name);

	/**
	 * 
	 * @param signal
	 * @return
	 */
	public String getTrap(ShSignal signal);

	/**
	 * 
	 * @param signal
	 * @param cmd
	 */
	public void setTrap(ShSignal signal, String cmd);

}
