/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.parser;

import java.io.IOException;
import java.io.PushbackReader;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedSubstituteFlags;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.cmd.SedSCommand;

/**
 * sコマンドをパースするパーサです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class SedSParser implements SedCommandParser {

	public SedCommand parse(SedCommandBundle b,
			PushbackReader rd, SedLineOption l) throws IOException {
		StringBuffer fl = new StringBuffer();
		String pt, rp;
		int c, d;

		if((d = rd.read()) < 0)  throw new SedSyntaxException();
		pt = parseStr(rd, d);
		rp = parseStr(rd, d);
		while((c = rd.read()) >= 0) {
			if(c == '\n' || c == ';' || c == '}') {
				rd.unread(c);
				break;
			}
			fl.appendCodePoint(c);
		}
		return new SedSCommand(
				pt, rp, new SedSubstituteFlags(fl.toString()));
	}

	String parseStr(PushbackReader rd, int d) throws IOException {
		StringBuffer pt = new StringBuffer();
		boolean esc = false;
		int c;

		while((c = rd.read()) != d || esc) {
			if(c < 0) {
				throw new SedSyntaxException();
			} else if(!esc) {
				if(!(esc = c == '\\'))  pt.appendCodePoint(c);
			} else if(c == d) {
				pt.appendCodePoint(c);
				esc = false;
			} else {
				switch(c) {
				case 'n':   pt.append('\n');  break;
				case 'r':   pt.append('\r');  break;
				case 't':   pt.append('\t');  break;
				case 'b':   pt.append('\b');  break;
				case 'f':   pt.append('\f');  break;
				case '\\':  pt.append('\\');  break;
				default:    pt.append('\\').appendCodePoint(c);  break;
				}
				esc = false;
			}
		}
		return pt.toString();
	}

}
