/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;

/**
 * awkiumインスタンスのJavaクラスです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkClass extends AwkValue {

	private AwkNamespace ns;

	/**
	 * awkiumインスタンスを生成します。
	 * 
	 * @param ns 名前空間
	 */
	public AwkClass(AwkNamespace ns) {
		this.ns = ns;
	}

	@Override
	public boolean isFloat() {
		return false;
	}

	@Override
	public boolean isFloatValue() {
		return false;
	}

	@Override
	public boolean isFunction() {
		return false;
	}

	@Override
	public boolean isInteger() {
		return false;
	}

	@Override
	public boolean isIntegerValue() {
		return false;
	}

	@Override
	public boolean isNegativeValue() {
		return false;
	}

	@Override
	public boolean isPositiveValue() {
		return false;
	}

	@Override
	public boolean isReal() {
		return false;
	}

	@Override
	public boolean isRealValue() {
		return false;
	}

	@Override
	public boolean isRegex() {
		return false;
	}

	@Override
	public boolean isString() {
		return false;
	}

	@Override
	public boolean isZeroValue() {
		return false;
	}

	@Override
	public boolean toBoolean(AwkNamespace ns) {
		return false;
	}

	@Override
	public Object toObject() {
		return this;
	}

	@Override
	public boolean isEmpty() {
		return false;
	}

	@Override
	public String toString(AwkNamespace ns) {
		return "<class>";
	}

	public int compareTo(AwkValue o, AwkNamespace ns) {
		throw new AwkCastException(this + " is not comparable");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#getNamespace()
	 */
	public AwkNamespace getNamespace() {
		return ns;
	}

}
