/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.DoubleTransform;

/**
 * 確率分布を表すインターフェースです。
 * 
 *
 * @author MORIGUCHI, Yuichiro 2012/02/14
 */
public interface Distribution extends DoubleTransform {

	/**
	 * 累積確率分布を求めます。
	 * 
	 * @param x 値
	 * @return 累積確率分布
	 */
	public double cdf(double x);

	/**
	 * 累積確率分布を値x1からx2まで積分した結果を求めます。
	 * 
	 * @param x1 値1
	 * @param x2 値2
	 * @return 結果
	 */
	public double cdf(double x1, double x2);

	/**
	 * 期待値を求めます。
	 * 
	 * @return 期待値
	 */
	public double expectedValue();

	/**
	 * 分散を求めます。
	 * 
	 * @return 分散
	 */
	public double variance();

	/**
	 * モードを求めます。
	 * 
	 * @return モード
	 */
	public double mode();

	/**
	 * メディアンを求めます。
	 * 
	 * @return メディアン
	 */
	public double median();

	/**
	 * 歪度を求めます。
	 * 
	 * @return 歪度
	 */
	public double skewness();

	/**
	 * 尖度を求めます。
	 * 
	 * @return 尖度
	 */
	public double kurtosis();

}
