/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

/**
 * byteのリストです。
 * 
 * @author MORIGUCHI, Yuichiro 2010/10/11
 */
public interface ByteList extends ByteCollection {

	/**
	 * バイトを指定位置に追加します。
	 * 
	 * @param index 位置
	 * @param v バイト
	 */
	public void addByte(int index, byte v);

	/**
	 * バイトを指定位置に追加します。
	 * 
	 * @param index 位置
	 * @param v バイト
	 * @throws IllegalArgumentException 値が0～255の外にあるとき
	 */
	public void add(int index, int v);

	/**
	 * すべてのコレクションの要素を指定位置に追加します。
	 * 
	 * @param index 位置
	 * @param a バイトコレクション
	 * @return 追加されたときtrue
	 */
	public boolean addAllByte(int index, ByteCollection a);

	/**
	 * 最初の値を得ます。
	 * 
	 * @return 最初の値
	 */
	public byte first();

	/**
	 * 指定位置のバイトを得ます。
	 * 
	 * @param index 位置
	 * @return バイト
	 */
	public byte getByte(int index);

	/**
	 * 与えられたバイトの左から最初に出現した位置を返します。
	 * 
	 * @param v バイト
	 * @return 位置
	 */
	public int indexOfByte(byte v);

	/**
	 * 与えられたバイトの左から最初に出現した位置を返します。
	 * 
	 * @param v バイト
	 * @return 位置
	 * @throws IllegalArgumentException 値が0～255の外にあるとき
	 */
	public int indexOf(int v);

	/**
	 * 指定位置のバイトを削除します。
	 * 
	 * @param index 位置
	 * @return 削除されたバイト
	 */
	public byte removeAt(int index);

	/**
	 * 最後の値を得ます。
	 * 
	 * @return 最後の値
	 */
	public ByteList rest();

	/**
	 * 与えられた位置から最後までの部分リストを得ます。
	 * 
	 * @param index 位置
	 * @return 部分リスト
	 */
	public ByteList rest(int index);

	/**
	 * 指定位置にバイトを追加します。
	 * 
	 * @param index 位置
	 * @param v バイト
	 * @return 前の値
	 */
	public byte setByte(int index, byte v);

	/**
	 * 指定位置にバイトを追加します。
	 * 
	 * @param index 位置
	 * @param v バイト
	 * @return 前の値
	 * @throws IllegalArgumentException 値が0～255の外にあるとき
	 */
	public byte set(int index, int v);

}
