/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

/**
 * Bool代数系のインターフェースです。
 * 
 *
 * @author MORIGUCHI, Yuichiro 2010/08/28
 */
public interface BooleanAlgebra<A extends BooleanElement<A>> {

	/**
	 * Bool代数系の"0"を得ます。
	 * 
	 * @return "0"
	 */
	public A get0();

	/**
	 * Bool代数系の"1"を得ます。
	 * 
	 * @return "1"
	 */
	public A get1();

	/**
	 * 2つのBool代数の結び(和集合)を得ます。
	 * 
	 * @param x 値
	 * @param y 値
	 * @return 結び
	 */
	public A join(A x, A y);

	/**
	 * Bool代数の結びを得ます。
	 * 
	 * @param as 値
	 * @return 結び
	 */
	public A join(A... as);

	/**
	 * 2つのBool代数の交わり(共通部分)を得ます。
	 * 
	 * @param x 値
	 * @param y 値
	 * @return 交わり
	 */
	public A meet(A x, A y);

	/**
	 * Bool代数の交わりを得ます。
	 * 
	 * @param as 値
	 * @return 交わり
	 */
	public A meet(A... as);

	/**
	 * Bool代数の補集合を得ます。
	 * 
	 * @param x 値
	 * @return 補集合
	 */
	public A complement(A x);

}
