/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.stat.StatisticsUtils;

/**
 * 関数stat.varianceunbiasedの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class VarianceUnbiased extends AbstractAwkArrayArg {

	public VarianceUnbiased() {
		super("varianceUnbiased");
	}

	@Override
	public double eval(double... d) {
		return StatisticsUtils.unbiasedVariance(d);
	}

}
