/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 配列を第1引数と第2引数にとる関数の基底クラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public abstract class AbstractAwkArrayBinaryArgs
extends AwkBinaryArgs {

	/**
	 * 関数を生成します。
	 * 
	 * @param name 関数名
	 */
	public AbstractAwkArrayBinaryArgs(String name) {
		super(name);
	}

	/**
	 * 与えられた値について計算します。
	 * 
	 * @param x 値1
	 * @param y 値2
	 * @return 計算結果
	 */
	public abstract double eval(double[] x, double[] y);

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		double[] x, y;

		if((a1 instanceof AwkArray) && (a2 instanceof AwkArray)) {
			x = AwkStatUtils.toDoubleArray(a1);
			y = AwkStatUtils.toDoubleArray(a2);
			return AwkFloat.valueOf(eval(x, y));
		} else {
			return AwkUndefined.UNDEF;
		}
	}

}
