/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.rel;

import java.util.List;

import net.morilib.awk.AwkArgumentException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

/**
 * 関数rel.projectの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class RelProjection extends AwkFunction {

	protected RelProjection() {
		super("projection", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		String[] as;

		if(args.size() < 2) {
			throw new AwkArgumentException(2, -1, args.size());
		} else if(!args.get(0).isArray()) {
			throw new AwkCastException("array required");
		} else {
			as = new String[args.size() - 1];
			for(int i = 0; i < as.length; i++) {
				as[i] = args.get(i + 1).toString(ns);
			}
			return Relations.projection(args.get(0).toArray(),
					ns, as);
		}
	}

}
