/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.namespace.AwkNamespace;

/**
 * パッケージmatの関数を読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkMatBuiltInLoader {

	/**
	 * 
	 * @param ns
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("mat");

		ss.bindFunction("det", new MatDet());
		ss.bindFunction("invert", new MatInvert());
		ss.bindFunction("multiply", new MatMultiply());
		ss.bindFunction("solve", new MatSolve());
	}

}
