/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 * awkiumにおける関数の引数エラーです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkArgumentException extends AwkRuntimeException {

	private int require, got, max;

	/**
	 * 例外を発生します。
	 * 
	 * @param require 要求される引数の数
	 * @param got     実際の引数の数
	 */
	public AwkArgumentException(int require, int got) {
		super("invalid argument: require " + require + " got " + got);
		this.require = require;
		this.got = got;
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param require 要求される引数の数
	 * @param max     要求される最大の引数
	 * @param got     実際の引数の数
	 */
	public AwkArgumentException(int require, int max, int got) {
		super("invalid argument: least " +
				require +
				" arguments required");
		this.require = require;
		this.max = max;
	}

	/**
	 * 要求される引数の数を返します。
	 */
	public int getRequire() {
		return require;
	}

	/**
	 * 要求される最大の引数の数を返します。
	 */
	public int getMax() {
		return max;
	}

	/**
	 * 実際の引数の数を返します。
	 */
	public int getGot() {
		return got;
	}

}
