/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/26
 */
public class ExtendAwkSTest extends AwkTestCase {

	public void testSAsc() {
		eqi("s.asc(\" \")", 32);
		eqi("s.asc(\"\")", -1);
	}

	public void testSAt() {
		eqs("s.at(\"abc\", 1)", "a");
		eqs("s.at(\"abc\", 2)", "b");
		eqs("s.at(\"abc\", 3)", "c");
		erz("s.at(\"abc\", 0)");
		erz("s.at(\"abc\", 4)");
	}

	public void testSCasecmp() {
		neg("s.casecmp(\"abc\", \"DEF\")");
		eqi("s.casecmp(\"abc\", \"ABC\")", 0);
		pos("s.casecmp(\"abc\", \"ABB\")");
	}

	public void testSCaseequals() {
		eqi("s.caseequals(\"abc\", \"DEF\")", 0);
		tru("s.caseequals(\"abc\", \"ABC\")");
		eqi("s.caseequals(\"abc\", \"ABB\")", 0);
	}

	public void testSChecksum() {
		tru("s.checksum(\"abc\") == s.checksum(\"abc\")");
	}

	public void testSChomp() {
		eqs("s.chomp(\"abc\\n\", \"\\n\")", "abc");
		eqs("s.chomp(\"abc\\r\", \"\\n\")", "abc");
		eqs("s.chomp(\"abc\\r\\n\", \"\\n\")", "abc");
		eqs("s.chomp(\"abcn\", \"\\n\")", "abcn");
		eqs("s.chomp(\"abcaa\", \"aa\")", "abc");
		eqs("s.chomp(\"abcba\", \"aa\")", "abcba");
		eqs("s.chomp(\"abcba\", \"\")", "abcba");
		eqs("s.chomp(\"abc\\n\")", "abc");
		eqs("s.chomp(\"a\", \"aa\")", "a");
		eqs("s.chomp(\"\", \"a\")", "");
	}

	public void testSChop() {
		eqs("s.chop(\"abc\\n\")", "abc");
		eqs("s.chop(\"abc\\r\")", "abc");
		eqs("s.chop(\"abc\\r\\n\")", "abc");
		eqs("s.chop(\"abcn\")", "abc");
		eqs("s.chop(\"a\")", "");
		eqs("s.chop(\"\")", "");
	}

	public void testSChr() {
		eqs("s.chr(32)", " ");
		eqs("s.chr(-1)", "?");
		eqs("s.chr(65536)", "?");
	}

	public void testSCmp() {
		neg("s.cmp(\"abc\", \"def\")");
		eqi("s.cmp(\"abc\", \"abc\")", 0);
		pos("s.cmp(\"abc\", \"abb\")");
		pos("s.cmp(\"abc\", \"DEF\")");
		pos("s.cmp(\"abc\", \"ABC\")");
		pos("s.cmp(\"abc\", \"ABB\")");
	}

	public void testSContains() {
		tru("s.contains(\"abcde\", \"abcd\")");
		fal("s.contains(\"abcde\", \"abcdd\")");
		tru("s.contains(\"abcde\", \"abcde\")");
		tru("s.contains(\"abcde\", \"abcd\", \"bcd\")");
		fal("s.contains(\"abcde\", \"abcd\", \"cde\")");
		tru("s.contains(\"abcde\")");
		tru("s.contains()");
	}

	public void testSDump() {
		eqs("s.dump(\"\\r\\nabc\\034\")", "\\r\\nabc\\034");
		eqs("s.dump(\"\")", "");
	}

	public void testSEnds() {
		tru("s.ends(\"abcde\", \"cde\")");
		tru("s.ends(\"abcde\", \"abcde\")");
		tru("s.ends(\"abcde\", \"\")");
		fal("s.ends(\"abcde\", \"cdf\")");
		fal("s.ends(\"abcde\", \"aabcde\")");
		fal("s.ends(\"\", \"a\")");
		tru("s.ends(\"\", \"\")");
	}

	public void testSInsert() {
		eqs("s.insert(\"abcd\", 3, \"12\")", "ab12cd");
		eqs("s.insert(\"abcd\", 1, \"12\")", "12abcd");
		eqs("s.insert(\"abcd\", 5, \"12\")", "abcd12");
		eqs("s.insert(\"\", 1, \"12\")", "12");
		eqs("s.insert(\"abcd\", 3, \"\")", "abcd");
		erz("s.insert(\"abcd\", 0, \"a\")");
		erz("s.insert(\"abcd\", 6, \"a\")");
	}

	public void testSJoin() {
		eqs("s.join(a.c(11, 22, 33), \";\")", "11;22;33");
		eqs("s.join(a.c(11), \";\")", "11");
		eqs("s.join(a.c(), \";\")", "");
		eqs("s.join(a.c(11, 22, 33))", "11 22 33");
		und("s.join(1)");
	}

	public void testSLtrim() {
		eqs("s.ltrim(\"    aaaa    \")", "aaaa    ");
		eqs("s.ltrim(\"aaaa\")", "aaaa");
		eqs("s.ltrim(\"\")", "");
	}

	public void testSParseint() {
		eqi("s.parseint(\"99\", 16)", 0x99);
		eqi("s.parseint(\"99\", 10)", 99);
		eqi("s.parseint(\"99\")", 99);
		eqi("s.parseint(\"zz\", 36)", 36 * 36 - 1);
		eqi("s.parseint(\"11\", 2)", 3);
		und("s.parseint(\"99\", 9)");
		erz("s.parseint(\"99\", \"a\")");
		erz("s.parseint(\"99\", 1)");
		erz("s.parseint(\"99\", 37)");
	}

	public void testSReverse() {
		eqs("s.reverse(\"abcd\")", "dcba");
		eqs("s.reverse(\"a\")", "a");
		eqs("s.reverse(\"\")", "");
	}

	public void testSRindex() {
		eqi("s.rindex(\"12345345\", \"34\")", 6);
		eqi("s.rindex(\"12345\", \"34\")", 3);
		eqi("s.rindex(\"34\", \"34\")", 1);
		eqi("s.rindex(\"12345\", \"35\")", 0);
		eqi("s.rindex(\"\", \"34\")", 0);
		eqi("s.rindex(\"12345\", \"\")", 6);
		eqi("s.rindex(\"\", \"\")", 1);
	}

	public void testSRtrim() {
		eqs("s.rtrim(\"    aaaa    \")", "    aaaa");
		eqs("s.rtrim(\"aaaa\")", "aaaa");
		eqs("s.rtrim(\"\")", "");
	}

	public void testSStarts() {
		tru("s.starts(\"abcde\", \"abc\")");
		tru("s.starts(\"abcde\", \"abcde\")");
		tru("s.starts(\"abcde\", \"\")");
		fal("s.starts(\"abcde\", \"abd\")");
		fal("s.starts(\"abcde\", \"abcdee\")");
		fal("s.starts(\"\", \"a\")");
		tru("s.starts(\"\", \"\")");
	}

	public void testSTolower() {
		eqs("s.tolower(\"ABCDEabcde\")", "abcdeabcde");
		eqs("s.tolower(\"\")", "");
	}

	public void testSTostring() {
		eqs("s.tostring(153, 16)", "99");
		eqs("s.tostring(99, 10)", "99");
		eqs("s.tostring(99)", "99");
		eqs("s.tostring(1295, 36)", "zz");
		eqs("s.tostring(3, 2)", "11");
		erz("s.tostring(99, \"a\")");
		erz("s.tostring(99, 1)");
		erz("s.tostring(99, 37)");
	}

	public void testSToupper() {
		eqs("s.toupper(\"ABCDEabcde\")", "ABCDEABCDE");
		eqs("s.toupper(\"\")", "");
	}

	public void testSTr() {
		eqs("s.tr(\"a-zA-Z\", \"A-Za-z\", \"abcABC\")", "ABCabc");
		eqs("s.tr(\"a-y\", \"A-Z\", \"abyz\")", "ABYz");
		eqs("s.tr(\"a-z\", \"A-Y\", \"abyz\")", "ABYY");
		eqs("s.tr(\"\", \"A-Z\", \"aaa\")", "aaa");
		eqs("s.tr(\"A-Z\", \"\", \"aaa\")", "aaa");
		eqs("s.tr(\"\", \"\", \"aaa\")", "aaa");
	}

	public void testSTrim() {
		eqs("s.trim(\"    aaaa    \")", "aaaa");
		eqs("s.trim(\"aaaa\")", "aaaa");
		eqs("s.trim(\"\")", "");
	}

}
