/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.continuous.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.t1testの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class T1TestBoth extends AwkTernaryArgs {

	/**
	 * 
	 */
	public T1TestBoth() {
		super("t1testboth");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		TDistribution tdis;
		double[] obsv;
		double expected = a2.toFloat();
		double significance = a3.toFloat();
		double t, max, min, mean, var;
		int num;

		if(significance < 0 || significance > 1) {
			throw new AwkStatisticsException("Invaild significance");
		}
		obsv = AwkStatUtils.toDoubleValues(a1);
		num  = obsv.length;
		mean = StatisticsUtils.mean(obsv);
		var  = StatisticsUtils.unbiasedVariance(obsv);
		t    = (mean - expected) / Math.sqrt(var / num);
		tdis = new TDistribution(num - 1);
		min  = tdis.invCdf(significance / 2);
		max  = tdis.invCdf(1 - significance / 2);
		return (min < t && t < max) ? AwkInteger.ONE : AwkInteger.ZERO;
	}

}
