/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.expr;

import net.morilib.c.pre.CpreMacros;

/**
 * 条件演算子の中間表現です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreConditionOp extends CpreExpression {

	private CpreExpression e1, e2, e3;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param e 条件式
	 * @param f 式1
	 * @param g 式2
	 */
	public CpreConditionOp(CpreExpression e, CpreExpression f,
			CpreExpression g) {
		e1 = e;  e2 = f;  e3 = g;
	}

	@Override
	public CpreValue eval(int lineno, CpreMacros m) {
		return e1.eval(lineno, m).toBoolean() ? e2.eval(lineno, m) : e3.eval(lineno, m);
	}

}
