/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.parser.AwkRelop;
import net.morilib.awk.value.AwkValue;

public class AwkRelationOp extends AwkExpression {

	private AwkExpression e1, e2;
	private AwkRelop.Operator op;

	public AwkRelationOp(AwkExpression e1, AwkExpression e2,
			AwkRelop.Operator op) {
		this.e1 = e1;
		this.e2 = e2;
		this.op = op;
	}

	/**
	 * 
	 * @return
	 */
	public AwkExpression getLeft() {
		return e1;
	}

	/**
	 * 
	 * @return
	 */
	public AwkExpression getRight() {
		return e2;
	}

	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue r1 = e1.eval(ns, o), r2 = e2.eval(ns, o);

		switch(op) {
		case EQ:  return AwkValue.equals(r1, r2, ns);
		case NE:  return AwkValue.ne(r1, r2, ns);
		case LT:  return AwkValue.lt(r1, r2, ns);
		case LE:  return AwkValue.le(r1, r2, ns);
		case GT:  return AwkValue.gt(r1, r2, ns);
		case GE:  return AwkValue.ge(r1, r2, ns);
		default:  throw new RuntimeException();
		}
	}

	/**
	 * 
	 * @return
	 */
	public boolean maybeInputRedirect() {
		return op.equals(AwkRelop.Operator.LT);
	}

	/**
	 * 
	 * @return
	 */
	public boolean maybeOutputRedirect() {
		return op.equals(AwkRelop.Operator.GT);
	}

}
