/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.gui;

import java.nio.charset.Charset;

import javax.swing.JComboBox;

public class CharsetComboBox extends JComboBox {

	public CharsetComboBox() {
		Charset utf8 = Charset.forName("UTF-8");

		addItem("(system default)");
		addItem(utf8);
		for(Charset s : Charset.availableCharsets().values()) {
			if(!s.equals(utf8) &&
					!s.toString().startsWith("x") &&
					!s.toString().startsWith("X")) {
				addItem(s);
			}
		}
	}

	public Charset getSelectedCharset() {
		Object o = getSelectedItem();

		return (o instanceof Charset) ? (Charset)o : null;
	}

}
