/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.Collection;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkValue;

public abstract class AbstractAwkArrayArg extends AwkUnaryArgs {

	/**
	 * 
	 * @param name
	 */
	public AbstractAwkArrayArg(String name) {
		super(name);
	}

	/**
	 * 
	 * @param d
	 * @return
	 */
	public abstract double eval(double... d);

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		Collection<AwkValue> v;
		double[] d;
		int i = 0;

		if(a1 instanceof AwkArray) {
			v = a1.values();
			d = new double[v.size()];
			for(AwkValue a : v)  d[i++] = a.toFloat();
			return AwkFloat.valueOf(eval(d));
		} else {
			return a1;
		}
	}

}
