/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleVector;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/31
 */
public final class AwkMatrices {

	/**
	 * 
	 */
	public static final String SUBSEP = "SUBSEP";

	private AwkMatrices() {}

	/**
	 * 
	 * @param a
	 * @param sep
	 * @return
	 */
	public static DoubleMatrix toDoubleMatrix(AwkValue a,
			String sep) {
		int rs, cs = Integer.MAX_VALUE;
		String s11 = "1" + sep + "1";
		DoubleMatrix m;
		AwkValue v;

		if(!a.isArray()) {
			m = new ArrayDoubleMatrix(1, 1);
			m.set(0, 0, a.toFloat());
		} else if(a.referArray(s11) instanceof AwkUndefined) {
			m = null;
		} else {
			for(rs = 1;; rs++) {
				v = a.referArray(rs + sep + "1");
				if(v instanceof AwkUndefined)  break;
				for(int j = 1;; j++) {
					v = a.referArray(rs + sep + j);
					if(v instanceof AwkUndefined) {
						if(cs > --j)  cs = j;
						break;
					}
				}
			}

			m = new ArrayDoubleMatrix(cs, --rs);
			for(int i = 1; i <= rs; i++) {
				for(int j = 1; j <= cs; j++) {
					v = a.referArray(i + sep + j);
					m.set(j - 1, i - 1, v.toFloat());
				}
			}
		}
		return m;
	}

	/**
	 * 
	 * @param a
	 * @param sep
	 * @return
	 */
	public static DoubleMatrix toDoubleMatrix2(AwkValue a,
			String sep) {
		int rs, cs = Integer.MAX_VALUE;
		String s11 = "1" + sep + "1";
		DoubleMatrix m;
		AwkValue v;

		if(!a.isArray()) {
			m = new ArrayDoubleMatrix(1, 1);
			m.set(0, 0, a.toFloat());
		} else if(a.referArray(s11) instanceof AwkUndefined) {
			m = null;
		} else {
			for(rs = 1;; rs++) {
				v = a.referArray(rs + sep + "1");
				if(v instanceof AwkUndefined)  break;
				for(int j = 1;; j++) {
					v = a.referArray(rs + sep + j);
					if(v instanceof AwkUndefined) {
						if(cs > --j)  cs = j;
						break;
					}
				}
			}

			m = new ArrayDoubleMatrix(--rs, cs);
			for(int i = 1; i <= rs; i++) {
				for(int j = 1; j <= cs; j++) {
					v = a.referArray(i + sep + j);
					m.set(i - 1, j - 1, v.toFloat());
				}
			}
		}
		return m;
	}

	/**
	 * 
	 * @param a
	 * @return
	 */
	public static DoubleVector toDoubleVector(AwkValue a) {
		String s11 = "1";
		DoubleVector m;
		AwkValue v;
		int rs;

		if(!a.isArray()) {
			m = new ArrayDoubleVector(1);
			m.set(0, a.toFloat());
		} else if(a.referArray(s11) instanceof AwkUndefined) {
			m = null;
		} else {
			for(rs = 1;; rs++) {
				v = a.referArray(rs + "");
				if(v instanceof AwkUndefined)  break;
			}
	
			m = new ArrayDoubleVector(--rs);
			for(int i = 1; i <= rs; i++) {
				v = a.referArray(i + "");
				m.set(i - 1, v.toFloat());
			}
		}
		return m;
	}

	/**
	 * 
	 * @param m
	 * @param sep
	 * @return
	 */
	public static AwkArray toAwkArray(DoubleMatrix m, String sep) {
		AwkArray a = new AwkArray();

		for(int i = 1; i <= m.rowSize(); i++) {
			for(int j = 1; j <= m.columnSize(); j++) {
				a.putArray(i + sep + j,
						AwkFloat.valueOf(m.get(j - 1, i - 1)));
			}
		}
		return a;
	}

	/**
	 * 
	 * @param m
	 * @return
	 */
	public static AwkArray toAwkArray(DoubleVector m) {
		AwkArray a = new AwkArray();

		for(int i = 1; i <= m.size(); i++) {
			a.putArray(i + "",
					AwkFloat.valueOf(m.get(i - 1)));
		}
		return a;
	}

}
