/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.Map;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkValue;

public abstract class AwkMathFunction extends AwkUnaryArgs {

	protected AwkMathFunction(String s) {
		super(s);
	}

	protected abstract double f(double x);

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		AwkArray a;

		if(a1.isArray()) {
			a = new AwkArray();
			for(Map.Entry<String, AwkValue> z : a1.entrySet()) {
				a.putArray(z.getKey(),
						AwkFloat.valueOf(f(z.getValue().toFloat())));
			}
			return a;
		} else {
			return AwkFloat.valueOf(f(a1.toFloat()));
		}
	}

}
