/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/26
 */
public class AwkStatTest extends AwkTestCase {

	public void testBinomial() {
		erz("stat.binomial(1, 0, 0.5);");
		erz("stat.binomial(1, 1, -0.01);");
		erz("stat.binomial(1, 1, 1.01);");
		erz("stat.cdfbinomial(1, 0, 0.5);");
		erz("stat.cdfbinomial(1, 1, -0.01);");
		erz("stat.cdfbinomial(1, 1, 1.01);");
	}

	public void testDiscreteUniform() {
		erz("stat.discreteuniform(1, -1, 0);");
		erz("stat.discreteuniform(1, 1, -1);");
		erz("stat.discreteuniform(1, 2, 1);");
		erz("stat.cdfdiscreteuniform(1, -1, 0);");
		erz("stat.cdfdiscreteuniform(1, 1, -1);");
		erz("stat.cdfdiscreteuniform(1, 2, 1);");
	}

	public void testPoisson() {
		erz("stat.poisson(1, -0.01);");
		erz("stat.cdfpoisson(1, -0.01);");
	}

	public void testContinuousUniform() {
		erz("stat.continuousuniform(1, 2, 1);");
		erz("stat.cdfcontinuousuniform(1, 2, 1);");
	}

	public void testExponential() {
		erz("stat.exponential(1, -0.01);");
		erz("stat.cdfexponential(1, -0.01);");
	}

	public void testGamma() {
		erz("stat.gamma(1, 0, 0.5);");
		erz("stat.gamma(1, 1, 0);");
		erz("stat.cdfgamma(1, 0, 0.5);");
		erz("stat.cdfgamma(1, 1, 0);");
	}

	public void testNormal() {
		erz("stat.normal(1, 0, -0.01);");
		erz("stat.cdfnormal(1, 0, -0.01);");
	}

	public void testT() {
		erz("stat.t(1, -0.01);");
		erz("stat.cdft(1, -0.01);");
	}

	public void testChiSquared() {
		erz("stat.chisquared(1, 0);");
		erz("stat.cdfchisquared(1, 0);");
	}

}
