/***************************************************************************
	unmamed.c(pong.c)
***************************************************************************/

#include "driver.h"
#include "sndintrf.h"
#include "vidhrdw/pong.h"

extern struct SamplesSound_interface pong_samples_interface;

INPUT_PORTS_START( unmamed )
	PORT_START		/* IN0 buttons */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_DIPNAME( 0x02, 0x00, "Ending Score" )
	PORT_DIPSETTING(    0x00, "11" )
	PORT_DIPSETTING(    0x02, "15" )
	PORT_BIT( 0xfc, IP_ACTIVE_LOW,	IPT_UNUSED )

	PORT_START		/* IN1 control 1 */
	PORT_BIT( 0x1ff, (PONG_MAX_V-15)/2, IPT_AD_STICK_Y) PORT_MINMAX(PONG_VBLANK - 12, 255) PORT_SENSITIVITY(100) PORT_KEYDELTA(5) PORT_PLAYER(2)

	PORT_START		/* IN2 control 2 */
	PORT_BIT( 0x1ff, (PONG_MAX_V-15)/2, IPT_AD_STICK_Y) PORT_MINMAX(PONG_VBLANK - 12, 255) PORT_SENSITIVITY(100) PORT_KEYDELTA(5) PORT_PLAYER(1)
INPUT_PORTS_END

static unsigned short colortable_source[] =
{
	0,1,
	1,0,
	2,0,
};

#define PONG_CLOCK	PONG_FPS * PONG_MAX_V * PONG_MAX_H + 49410   /* Pong uses a standard US TV crystal with 14,318,100 Hz */

static int pong_video[] = {
    PONG_MAX_H, PONG_MAX_V,
    0, PONG_HSYNC0, PONG_HSYNC1, PONG_HBLANK,
    0, PONG_VSYNC0, PONG_VSYNC1, PONG_VBLANK
};

static PALETTE_INIT( pong )
{
	palette_set_color(0,0x00,0x00,0x00); /* black */
	palette_set_color(1,0xff,0xff,0xff); /* white (1k resistor) */
	palette_set_color(2,0xd4,0xd4,0xd4); /* slightly darker white (1.2k resistor) */
	memcpy(colortable,colortable_source,sizeof(colortable_source));
}

static MACHINE_DRIVER_START( unmamed )

	/* basic machine hardware */
	MDRV_CPU_ADD(GENSYNC, PONG_CLOCK)
	MDRV_CPU_CONFIG(pong_video)
	MDRV_CPU_VBLANK_INT(pong_vh_scanline, PONG_MAX_V)

	MDRV_FRAMES_PER_SECOND(PONG_FPS)
	MDRV_VBLANK_DURATION(0)  /* frames per second, vblank duration */

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(PONG_MAX_H, PONG_MAX_V)
	MDRV_VISIBLE_AREA(PONG_HBLANK, PONG_MAX_H-1, PONG_VBLANK, PONG_MAX_V-1)
	MDRV_PALETTE_LENGTH(3)
	MDRV_COLORTABLE_LENGTH(sizeof(colortable_source)/sizeof(colortable_source[0]))

	MDRV_PALETTE_INIT(pong)
	MDRV_VIDEO_START(pong)
	MDRV_VIDEO_UPDATE(pong)

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")

	MDRV_SOUND_ADD(SAMPLES, 0)
	MDRV_SOUND_CONFIG(pong_samples_interface)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.20)
MACHINE_DRIVER_END

/***************************************************************************

  Game driver(s)

***************************************************************************/

#define rom_excitemd 0
#define rom_touchdwn 0
#define rom_cmpspace 0
#define rom_cmpspacb 0
#define rom_startrec 0
#define rom_alimnatn 0
#define rom_astrrace 0
#define rom_deviscup 0
#define rom_elepong 0
#define rom_hockeytv 0
#define rom_pontron 0
#define rom_pontron2 0
#define rom_prohocky 0
#define rom_soccert 0
#define rom_spacrace 0
#define rom_suprpong 0
#define rom_basketbl 0
#define rom_formura 0
#define rom_goalkick 0
#define rom_grtruk10 0
#define rom_kadrpong 0
#define rom_kwack 0
#define rom_minihcky 0
#define rom_pingpon 0
#define rom_pongdbls 0
#define rom_rebound 0
#define rom_spdrace 0
#define rom_spike 0
#define rom_tank 0
#define rom_tblhocky 0
#define rom_truck20 0
#define rom_twinrace 0
#define rom_antiairc 0
#define rom_baloongn 0
#define rom_baretmak 0
#define rom_clshscor 0
#define rom_deadheat 0
#define rom_duckysht 0
#define rom_erase 0
#define rom_goal4 0
#define rom_highway 0
#define rom_indy800 0
#define rom_jetfight 0
#define rom_lastigng 0
#define rom_maneater 0
#define rom_persuit 0
#define rom_spdracdx 0
#define rom_steeplcs 0
#define rom_tahichi 0
#define rom_atack 0
#define rom_atarien 0
#define rom_breakout 0
#define rom_cleanswp 0
#define rom_crsgrace 0
#define rom_dairesha 0
#define rom_f1 0
#define rom_hvywcmpo 0
#define rom_indy4 0
#define rom_intrcept 0
#define rom_leman 0
#define rom_outlaw 0
#define rom_quizshow 0
#define rom_roadrace 0
#define rom_rocknbrk 0
#define rom_shttrenr 0
#define rom_skyhawk 0
#define rom_sparkcnr 0
#define rom_spdrtwin 0
#define rom_squadron 0
#define rom_stantcyc 0
#define rom_tavenger 0
#define rom_videobbl 0
#define rom_wildgnmn 0
#define rom_airbaven 0
#define rom_baricad2 0
#define rom_baricad3 0
#define rom_blckyard 0
#define rom_bombaway 0
#define rom_bomber 0
#define rom_clashcos 0
#define rom_cleansw2 0
#define rom_destroya 0
#define rom_fisco400 0
#define rom_flyfrts2 0
#define rom_flygftrs 0
#define rom_gunman 0
#define rom_loadchmp 0
#define rom_mantt 0
#define rom_missilex 0
#define rom_nblock 0
#define rom_ninjagun 0
#define rom_shighway 0
#define rom_soccerdx 0
#define rom_sprbowl 0
#define rom_tablescr 0
#define rom_tennis 0
#define rom_time 0
#define rom_ttbarier 0
#define rom_ttblock 0
#define rom_twincstt 0
#define rom_walbreak 0
#define rom_acrobat 0
#define rom_balncirc 0
#define rom_balnmini 0
#define rom_banish 0
#define rom_baseball 0
#define rom_blkchalg 0
#define rom_blockfvr 0
#define rom_blockinv 0
#define rom_blockpft 0
#define rom_bowling 0
#define rom_breaker 0
#define rom_cartngun 0
#define rom_clcircus 0
#define rom_cpothelo 0
#define rom_crosfire 0
#define rom_dballoon 0
#define rom_depthbom 0
#define rom_f1mach 0
#define rom_galaxwar 0
#define rom_helishtr 0
#define rom_hoping 0
#define rom_ipminvd2 0
#define rom_ipminvdr 0
#define rom_ipmmajan 0
#define rom_lineball 0
#define rom_marinwar 0
#define rom_micoblck 0
#define rom_micokit 0
#define rom_micokit2 0
#define rom_micokit3 0
#define rom_midnrace 0
#define rom_miraclsp 0
#define rom_monkymag 0
#define rom_newblhtr 0
#define rom_nyankoro 0
#define rom_piccolo 0
#define rom_proracer 0
#define rom_pwrblock 0
#define rom_scretwar 0
#define rom_scrtbase 0
#define rom_sdestroy 0
#define rom_smokyjoe 0
#define rom_snkyamat 0
#define rom_spacesip 0
#define rom_spbreak 0
#define rom_spbrek2 0
#define rom_spcarv12 0
#define rom_spcfigtr 0
#define rom_spmickit 0
#define rom_sprblock 0
#define rom_spstrsp 0
#define rom_ssjump 0
#define rom_ssjump2 0
#define rom_sspdrc 0
#define rom_sspdrcv 0
#define rom_stardust 0
#define rom_tablebar 0
#define rom_tblatacb 0
#define rom_tblatacg 0
#define rom_tblatack 0
#define rom_tblatacs 0
#define rom_tblblock 0
#define rom_tblbombr 0
#define rom_testdriv 0
#define rom_thdriver 0
#define rom_topbawlr 0
#define rom_toprunnr 0
#define rom_trumpoln 0
#define rom_tvcomdx 0
#define rom_wacrobat 0
#define rom_walablck 0
#define rom_wildwood 0
#define rom_alphainv 0
#define rom_atackace 0
#define rom_blockc 0
#define rom_bomba 0
#define rom_capslinv 0
#define rom_carchase 0
#define rom_carhunt 0
#define rom_casling 0
#define rom_daisanw 0
#define rom_dblblock 0
#define rom_dracurah 0
#define rom_eagleh 0
#define rom_fortress 0
#define rom_galaxyfc 0
#define rom_goldinvd 0
#define rom_helacles 0
#define rom_laserwar 0
#define rom_leachmj 0
#define rom_mahjandx 0
#define rom_melodyvd 0
#define rom_moonalph 0
#define rom_moonlakr 0
#define rom_moontruc 0
#define rom_moulhunt 0
#define rom_newblckx 0
#define rom_newblckz 0
#define rom_niceon 0
#define rom_richman 0
#define rom_saturn3d 0
#define rom_sheriff2 0
#define rom_spacecmb 0
#define rom_spblopen 0
#define rom_spcatck2 0
#define rom_spccmnd 0
#define rom_spcfigh2 0
#define rom_spdual 0
#define rom_spdual2 0
#define rom_spectwin 0
#define rom_spfightr 0
#define rom_spmeteo 0
#define rom_sptwin 0
#define rom_srunaway 0
#define rom_stantcar 0
#define rom_storm 0
#define rom_submarin 0
#define rom_supermn 0
#define rom_sweeper 0
#define rom_talegun2 0
#define rom_triplatk 0
#define rom_upsetblk 0
#define rom_yosaku 0
#define rom_znznblcl 0
#define rom_zunblock 0
#define rom_flyingat 0
#define rom_hadeth 0
#define rom_hanaaras 0
#define rom_playbal 0
#define rom_tspiramd 0
#define rom_astrocrf 0
#define rom_astrzone 0
#define rom_atmsmash 0
#define rom_barrian 0
#define rom_blckbetl 0
#define rom_blckjack 0
#define rom_btleachm 0
#define rom_cosmopol 0
#define rom_dancingq 0
#define rom_finalrag 0
#define rom_flyingst 0
#define rom_ftcyborg 0
#define rom_itazraag 0
#define rom_lasershk 0
#define rom_masuiju 0
#define rom_mazek 0
#define rom_mnhattan 0
#define rom_moonpuls 0
#define rom_moonridr 0
#define rom_moontrek 0
#define rom_neblar 0
#define rom_ninjatai 0
#define rom_prmonaco 0
#define rom_redtank 0
#define rom_rollngc2 0
#define rom_ron2mj 0
#define rom_seahuntr 0
#define rom_shogun 0
#define rom_sidewind 0
#define rom_spacecyc 0
#define rom_spbattle 0
#define rom_starfive 0
#define rom_taitan 0
#define rom_tballoon 0
#define rom_telejan 0
#define rom_thegoku 0
#define rom_themonky 0
#define rom_triatack 0
#define rom_warp1 0
#define rom_astrogat 0
#define rom_bobit 0
#define rom_driblint 0
#define rom_dsteljan 0
#define rom_flashboy 0
#define rom_flogspdr 0
#define rom_jancerx 0
#define rom_launchrz 0
#define rom_motoxer 0
#define rom_pooltabl 0
#define rom_proputer 0
#define rom_rollstrf 0
#define rom_spacex 0
#define rom_strlaker 0
#define rom_thetower 0
#define rom_tkmahjan 0
#define rom_ttmajan2 0
#define rom_ttmajanq 0
#define rom_ultradom 0
#define rom_boiger 0
#define rom_constela 0
#define rom_darkhose 0
#define rom_distroyr 0
#define rom_dxpunkid 0
#define rom_dynamite 0
#define rom_fevermjn 0
#define rom_fishing 0
#define rom_happydia 0
#define rom_hfkoikoi 0
#define rom_janjnan 0
#define rom_litljack 0
#define rom_magman 0
#define rom_maijan 0
#define rom_miraclht 0
#define rom_missilsp 0
#define rom_nameneko 0
#define rom_ohsho 0
#define rom_probilyd 0
#define rom_redselec 0
#define rom_rubicon 0
#define rom_rushboxr 0
#define rom_seljan 0
#define rom_skyprkng 0
#define rom_sneakq 0
#define rom_subloc3d 0
#define rom_sunshegg 0
#define rom_superglf 0
#define rom_tkhanafd 0
#define rom_tombling 0
#define rom_triplpnc 0
#define rom_tumego 0
#define rom_watedg7 0
#define rom_wonderhl 0
#define rom_au 0
#define rom_banpolin 0
#define rom_catfight 0
#define rom_daifugou 0
#define rom_discus 0
#define rom_excitebb 0
#define rom_firefox 0
#define rom_footfigh 0
#define rom_friday 0
#define rom_galleon 0
#define rom_gcoaster 0
#define rom_genmatai 0
#define rom_genmatal 0
#define rom_halokity 0
#define rom_hanahime 0
#define rom_hangridr 0
#define rom_intrstra 0
#define rom_jangou 0
#define rom_jansen 0
#define rom_jantotsu 0
#define rom_jgnight 0
#define rom_jokermj 0
#define rom_kankickk 0
#define rom_koikoip1 0
#define rom_lasergrp 0
#define rom_maihime 0
#define rom_majansen 0
#define rom_marmaid 0
#define rom_mjkyoust 0
#define rom_nightgal 0
#define rom_plumzone 0
#define rom_quizjump 0
#define rom_roiyalnt 0
#define rom_roppyaku 0
#define rom_sanninmj 0
#define rom_skeater 0
#define rom_sperky 0
#define rom_super7 0
#define rom_talbot2 0
#define rom_tangramq 0
#define rom_timeatak 0
#define rom_tkmjsen 0
#define rom_trybomb 0
#define rom_ultraqz 0
#define rom_utamaro 0
#define rom_vegasptl 0
#define rom_weddingb 0
#define rom_zeda 0
#define rom_akazukin 0
#define rom_arbegas 0
#define rom_badland 0
#define rom_champclo 0
#define rom_cyclemb 0
#define rom_driversl 0
#define rom_duckydck 0
#define rom_eshornml 0
#define rom_fightofe 0
#define rom_gpworld 0
#define rom_hgatebal 0
#define rom_highwayj 0
#define rom_intrstrz 0
#define rom_itaten 0
#define rom_jangould 0
#define rom_janou 0
#define rom_koihime 0
#define rom_maxmile 0
#define rom_mjgolila 0
#define rom_mjking 0
#define rom_msisaac1 0
#define rom_multirid 0
#define rom_nightbun 0
#define rom_njhayate 0
#define rom_oozumou 0
#define rom_outrzone 0
#define rom_polepsed 0
#define rom_rumbalmb 0
#define rom_seafly 0
#define rom_superdnq 0
#define rom_superice 0
#define rom_thundstm 0
#define rom_tokyomie 0
#define rom_toporo 0
#define rom_tx1v8 0
#define rom_ultramj 0
#define rom_vsurbanc 0
#define rom_wilytwr2 0
#define rom_008gun 0
#define rom_119 0
#define rom_afroland 0
#define rom_arcard 0
#define rom_bttlbird 0
#define rom_byegone 0
#define rom_captlung 0
#define rom_cheanpit 0
#define rom_cosmocir 0
#define rom_crwngolf 0
#define rom_ddpengin 0
#define rom_downhill 0
#define rom_empstbak 0
#define rom_exntgame 0
#define rom_geinouss 0
#define rom_getall 0
#define rom_hanaaw6 0
#define rom_hanaroyl 0
#define rom_hypupdwn 0
#define rom_janoh2 0
#define rom_jansin 0
#define rom_konamisc 0
#define rom_lnghouse 0
#define rom_longhitr 0
#define rom_mjjanmu 0
#define rom_mjyarou 0
#define rom_ntgalsum 0
#define rom_pjanputr 0
#define rom_roadblas 0
#define rom_ryokusnp 0
#define rom_scrambl2 0
#define rom_sexygal 0
#define rom_sixdevil 0
#define rom_skydstry 0
#define rom_spcross 0
#define rom_spdead2 0
#define rom_spdeadht 0
#define rom_speederb 0
#define rom_sppinpon 0
#define rom_supergal 0
#define rom_suprwing 0
#define rom_sweetgal 0
#define rom_tadaimat 0
#define rom_taikyoku 0
#define rom_thex 0
#define rom_timegal 0
#define rom_tokaido 0
#define rom_tokyomi2 0
#define rom_topgear 0
#define rom_uchuseny 0
#define rom_vanalblt 0
#define rom_wildboy 0
#define rom_wyvernf0 0
#define rom_yakumanc 0
#define rom_armwresg 0
#define rom_atakdon2 0
#define rom_babeltwr 0
#define rom_banbanbt 0
#define rom_bopeep 0
#define rom_btltank 0
#define rom_dangle 0
#define rom_galias 0
#define rom_janoh3 0
#define rom_lapius 0
#define rom_lionex 0
#define rom_lonewolf 0
#define rom_mightang 0
#define rom_mjparlor 0
#define rom_mjsenka 0
#define rom_pickpack 0
#define rom_pooyan2 0
#define rom_sjrakira 0
#define rom_slapshtr 0
#define rom_slipstep 0
#define rom_spaclove 0
#define rom_spchinse 0
#define rom_spcross2 0
#define rom_valkbokn 0
#define rom_violents 0
#define rom_vstriang 0
#define rom_warball 0
#define rom_weltotgm 0
#define rom_wldstdhm 0
#define rom_6d1 0
#define rom_avmjvdys 0
#define rom_besthit 0
#define rom_blckbstr 0
#define rom_eaglet 0
#define rom_extracrd 0
#define rom_famboxi 0
#define rom_famtenis 0
#define rom_firstlan 0
#define rom_gacho 0
#define rom_gelnica 0
#define rom_grifight 0
#define rom_janbow2 0
#define rom_liberty7 0
#define rom_madyula 0
#define rom_megumirc 0
#define rom_midlansp 0
#define rom_reapian 0
#define rom_shtgzon2 0
#define rom_shtgzone 0
#define rom_southkid 0
#define rom_supermot 0
#define rom_touchme 0
#define rom_trnmarka 0
#define rom_twinbee2 0
#define rom_yukai2ki 0
#define rom_armchamp 0
#define rom_centerct 0
#define rom_cntlyclb 0
#define rom_famsta88 0
#define rom_fightgolf 0
#define rom_firstdwn 0
#define rom_gforce 0
#define rom_hanashob 0
#define rom_heavyunt 0
#define rom_huddleup 0
#define rom_janyuki 0
#define rom_kinobokn 0
#define rom_photomj 0
#define rom_realmjgy 0
#define rom_spcirkit 0
#define rom_temption 0
#define rom_topshter 0
#define rom_vsgtenis 0
#define rom_battleax 0
#define rom_captude 0
#define rom_destruct 0
#define rom_dokaben2 0
#define rom_gollirac 0
#define rom_grdius2s 0
#define rom_grdius3s 0
#define rom_hanaagem 0
#define rom_hanajudn 0
#define rom_karon 0
#define rom_kyukokab 0
#define rom_metalfrz 0
#define rom_mjgekish 0
#define rom_mjsaiyuk 0
#define rom_ohhaipie 0
#define rom_pepplpl 0
#define rom_progolfg 0
#define rom_sagaia 0
#define rom_salamnds 0
#define rom_shadowwr 0
#define rom_slotgal 0
#define rom_tougenk 0
#define rom_winrunsz 0
#define rom_zerowin2 0
#define rom_ff3 0
#define rom_inazumas 0
#define rom_koutets2 0
#define rom_kuuga2 0
#define rom_p47ii 0
#define rom_samraigl 0
#define rom_silverml 0
#define rom_spbblpop 0
#define rom_tooga 0
#define rom_asttenki 0
#define rom_bishojos 0
#define rom_blockpal 0
#define rom_braifight 0
#define rom_contzero 0
#define rom_gal1bans 0
#define rom_hamerway 0
#define rom_hanajngi 0
#define rom_hanamaru 0
#define rom_hanaxmas 0
#define rom_lastsurv 0
#define rom_loops 0
#define rom_magicrod 0
#define rom_mtlrabit 0
#define rom_neogeou 0
#define rom_parastar 0
#define rom_pipy 0
#define rom_pplandbt 0
#define rom_royalpol 0
#define rom_suhadaym 0
#define rom_sunshine 0
#define rom_twoshot 0
#define rom_yanchcat 0
#define rom_yumekoib 0
#define rom_arcanum 0
#define rom_bontorun 0
#define rom_ceptima 0
#define rom_dunkstar 0
#define rom_bustblaz 0
#define rom_funfunbl 0
#define rom_gunfroex 0
#define rom_hanaangl 0
#define rom_hanakara 0
#define rom_hanatens 0
#define rom_hologram 0
#define rom_ladymakr 0
#define rom_ldmjmbhm 0
#define rom_ldquizdd 0
#define rom_maddogmc 0
#define rom_metlblex 0
#define rom_mjichibk 0
#define rom_mjougon 0
#define rom_mjtokyuk 0
#define rom_mjvegas 0
#define rom_mysticw 0
#define rom_rugenok 0
#define rom_sideefct 0
#define rom_with 0
#define rom_youyublk 0
#define rom_finalmsn 0
#define rom_danjtest 0
#define rom_finalpld 0
#define rom_frontrow 0
#define rom_hanzou 0
#define rom_ias 0
#define rom_janshi 0
#define rom_mjronjan 0
#define rom_opart 0
#define rom_speedskt 0
#define rom_sprintst 0
#define rom_tokmekct 0
#define rom_yunolgnd 0
#define rom_angelwsp 0
#define rom_athtekag 0
#define rom_battalin 0
#define rom_cavespdr 0
#define rom_cgangpnl 0
#define rom_chalhitr 0
#define rom_chanta 0
#define rom_cps2u 0
#define rom_cvsterra 0
#define rom_dogyuuno 0
#define rom_dreambal 0
#define rom_dt7 0
#define rom_enmadaio 0
#define rom_enmadx 0
#define rom_galax3pd 0
#define rom_gemurani 0
#define rom_gridfigt 0
#define rom_kokorozy 0
#define rom_loonychn 0
#define rom_mindesct 0
#define rom_mjcafedl 0
#define rom_pukunott 0
#define rom_quizcmbq 0
#define rom_quizdk 0
#define rom_saikyobt 0
#define rom_sdburnin 0
#define rom_shotway2 0
#define rom_spd3boss 0
#define rom_streetvip 0
#define rom_twilsprd 0
#define rom_uso800 0
#define rom_vartexer 0
#define rom_winforce 0
#define rom_xday 0
#define rom_ban2bstr 0
#define rom_bestelvn 0
#define rom_bisibasi 0
#define rom_carib 0
#define rom_chasebom 0
#define rom_chicago 0
#define rom_dice3 0
#define rom_distopia 0
#define rom_gaiden2 0
#define rom_galax3az 0
#define rom_galpn2sp 0
#define rom_galumpa 0
#define rom_headoncn 0
#define rom_mjcafdlg 0
#define rom_mjreach2 0
#define rom_nakidwar 0
#define rom_onecegun 0
#define rom_paknban2 0
#define rom_popoithe 0
#define rom_pzlclub 0
#define rom_qzmzidol 0
#define rom_realpunc 0
#define rom_spangpzl 0
#define rom_spstrikr 0
#define rom_sptfishn 0
#define rom_sstrongw 0
#define rom_starltft 0
#define rom_streetjam 0
#define rom_svoll94 0
#define rom_tekipak2 0
#define rom_airwalkr 0
#define rom_akamajan 0
#define rom_allstarv 0
#define rom_anmlznpw 0
#define rom_burnstrt 0
#define rom_calmaeye 0
#define rom_citydive 0
#define rom_comandwr 0
#define rom_dirtdush 0
#define rom_dreamsym 0
#define rom_fallism 0
#define rom_feeldscr 0
#define rom_fotbalft 0
#define rom_gakuenbt 0
#define rom_goalstrm 0
#define rom_hanagokb 0
#define rom_hoopitup 0
#define rom_kakattek 0
#define rom_kakutouv 0
#define rom_lodyssey 0
#define rom_mjraijin 0
#define rom_mjsdchka 0
#define rom_mjtensin 0
#define rom_muku2pon 0
#define rom_netmark 0
#define rom_ninsoukt 0
#define rom_oosaka 0
#define rom_pzbancho 0
#define rom_qmagical 0
#define rom_railcha2 0
#define rom_redzone 0
#define rom_rgear 0
#define rom_spedking 0
#define rom_spriggan 0
#define rom_stoon 0
#define rom_tanteiya 0
#define rom_techdoll 0
#define rom_tesouran 0
#define rom_timbokan 0
#define rom_trumpman 0
#define rom_trumpmn2 0
#define rom_vicviper 0
#define rom_warlock 0
#define rom_xmenaou 0
#define rom_aquajet 0
#define rom_attimuit 0
#define rom_caveu 0
#define rom_cdlmagic 0
#define rom_daitoyok 0
#define rom_droppers 0
#define rom_eyeoftp 0
#define rom_ginoutai 0
#define rom_hanabotn 0
#define rom_jetwave 0
#define rom_jnsnplus 0
#define rom_karatenj 0
#define rom_kickgogo 0
#define rom_magznopw 0
#define rom_mjseiryu 0
#define rom_mjtkmkjg 0
#define rom_pairwars 0
#define rom_piponcho 0
#define rom_qdrmfg3 0
#define rom_qzwatasi 0
#define rom_realfigt 0
#define rom_retrnsel 0
#define rom_risoutan 0
#define rom_rtrnsel2 0
#define rom_solasslt 0
#define rom_staraudt 0
#define rom_tokyowar 0
#define rom_ultimat4 0
#define rom_waverun 0
#define rom_wldpkscr 0
#define rom_3dtarott 0
#define rom_abnomalc 0
#define rom_armagirr 0
#define rom_aromaclb 0
#define rom_bbsecond 0
#define rom_cashking 0
#define rom_ddpblue 0
#define rom_fightush 0
#define rom_finalhln 0
#define rom_galpan3d 0
#define rom_gappori2 0
#define rom_gundogs 0
#define rom_huusuids 0
#define rom_liniastr 0
#define rom_mahoujuk 0
#define rom_monkyfwa 0
#define rom_pickle 0
#define rom_qp 0
#define rom_sams64 0
#define rom_skydev 0
#define rom_speeddiv 0
#define rom_tokimeki 0
#define rom_yukibuta 0
#define rom_aleck64u 0
#define rom_chaosht 0
#define rom_cyvrnpls 0
#define rom_ddrevol 0
#define rom_dynabb98 0
#define rom_elevbeat 0
#define rom_gnetu 0
#define rom_hofdead2 0
#define rom_janptrsp 0
#define rom_lamachin 0
#define rom_mgtrocav 0
#define rom_mjmhlump 0
#define rom_mjnenrik 0
#define rom_naomixu 0
#define rom_oceanhnt 0
#define rom_ofbeatrc 0
#define rom_popnm 0
#define rom_raycriss 0
#define rom_skichamp 0
#define rom_sys573u 0
#define rom_vj 0
#define rom_wkwkmnst 0
#define rom_18wheelr 0
#define rom_47pie3 0
#define rom_airlinep 0
#define rom_anglking 0
#define rom_barairo 0
#define rom_batlgear 0
#define rom_bm2dx 0
#define rom_cafebrek 0
#define rom_cafepara 0
#define rom_criszone 0
#define rom_crsytaxi 0
#define rom_dboclub 0
#define rom_doa2 0
#define rom_drmmania 0
#define rom_dttshang 0
#define rom_dynabb99 0
#define rom_f355chal 0
#define rom_flipmaze 0
#define rom_gachacmp 0
#define rom_giantgrm 0
#define rom_gtfleaks 0
#define rom_guitrjam 0
#define rom_gunbeat 0
#define rom_hanapoko 0
#define rom_hanaretu 0
#define rom_hanatubk 0
#define rom_hikaruu 0
#define rom_hsangel 0
#define rom_hyperbis 0
#define rom_jinchool 0
#define rom_jumpgrv 0
#define rom_kouhuku 0
#define rom_kurutstn 0
#define rom_landhigh 0
#define rom_mahjanoh 0
#define rom_marstv 0
#define rom_mayjisn3 0
#define rom_mjdaihao 0
#define rom_mjjanou 0
#define rom_mjtenku 0
#define rom_optiger 0
#define rom_otenami 0
#define rom_outtrigr 0
#define rom_popnstag 0
#define rom_powershb 0
#define rom_puyopyda 0
#define rom_pwrsmash 0
#define rom_pwrstone 0
#define rom_raceon 0
#define rom_ravmastr 0
#define rom_rcdego 0
#define rom_ringout4 0
#define rom_sambade 0
#define rom_sgtetris 0
#define rom_shoboshi 0
#define rom_spawn 0
#define rom_spmajl99 0
#define rom_sppzlbbl 0
#define rom_stepstg2 0
#define rom_stpchamp 0
#define rom_submrins 0
#define rom_tmmjprd2 0
#define rom_touchde 0
#define rom_toyfight 0
#define rom_unjamalm 0
#define rom_viperu 0
#define rom_vjdash 0
#define rom_vstr2000 0
#define rom_zombervg 0
#define rom_alienfrt 0
#define rom_animecmp 0
#define rom_batlgea2 0
#define rom_benh2000 0
#define rom_blodror3 0
#define rom_bm3dx 0
#define rom_confmisn 0
#define rom_crackndj 0
#define rom_cvs1 0
#define rom_dancemx 0
#define rom_deathcri 0
#define rom_dendeg3 0
#define rom_doa2m 0
#define rom_dreamodt 0
#define rom_ganbareu 0
#define rom_genbadeg 0
#define rom_ggx 0
#define rom_giantg2k 0
#define rom_gigawin2 0
#define rom_gunmania 0
#define rom_gunmanzp 0
#define rom_gunspike 0
#define rom_hanaboub 0
#define rom_hanarose 0
#define rom_hdlchamp 0
#define rom_jambosfr 0
#define rom_justice2 0
#define rom_keisatsu 0
#define rom_kinkyu24 0
#define rom_km 0
#define rom_koiparad 0
#define rom_marinfis 0
#define rom_mawasund 0
#define rom_mjdaisng 0
#define rom_mjgojas 0
#define rom_mjhouou 0
#define rom_mjhouryu 0
#define rom_mjnighti 0
#define rom_mjsikinr 0
#define rom_mjswtacd 0
#define rom_mvsc2 0
#define rom_nascarac 0
#define rom_ninjaasl 0
#define rom_ohmygods 0
#define rom_otopane 0
#define rom_panicprk 0
#define rom_planeth 0
#define rom_ppp 0
#define rom_pride2k 0
#define rom_psyvaria 0
#define rom_psyvarir 0
#define rom_pwrston2 0
#define rom_ridger5 0
#define rom_sambade2 0
#define rom_shakatan 0
#define rom_shansrsr 0
#define rom_slashout 0
#define rom_stoukon4 0
#define rom_strikeft 0
#define rom_sw1racer 0
#define rom_sxyreac3 0
#define rom_sys2x6u 0
#define rom_taikonot 0
#define rom_tmw2000 0
#define rom_tokyobus 0
#define rom_touchde2 0
#define rom_trckkskk 0
#define rom_variants 0
#define rom_vnba 0
#define rom_von2566 0
#define rom_worldkik 0
#define rom_zotenami 0
#define rom_airstorm 0
#define rom_airtrix 0
#define rom_angelicl 0
#define rom_beachspk 0
#define rom_clubkart 0
#define rom_cosmsmsh 0
#define rom_crackdj2 0
#define rom_cvs1pro 0
#define rom_cvs2 0
#define rom_dboclub2 0
#define rom_dynagolf 0
#define rom_f355cha2 0
#define rom_g13jtk 0
#define rom_gahaha 0
#define rom_garou5 0
#define rom_gundam 0
#define rom_gundam2 0
#define rom_gunsviv2 0
#define rom_hanagold 0
#define rom_hnsibari 0
#define rom_hvmtgmtx 0
#define rom_ikaruga 0
#define rom_iniciald 0
#define rom_inuosanp 0
#define rom_jpark3 0
#define rom_keisatu2 0
#define rom_kingrt66 0
#define rom_lupin3st 0
#define rom_manabek 0
#define rom_manboago 0
#define rom_mjbenikj 0
#define rom_mjdreach 0
#define rom_mjdrenso 0
#define rom_moerucsn 0
#define rom_monkybal 0
#define rom_nightrad 0
#define rom_otenkikr 0
#define rom_photobtl 0
#define rom_privates 0
#define rom_puzlet 0
#define rom_pwrsmsh2 0
#define rom_samraisx 0
#define rom_sfzero3u 0
#define rom_shakatat 0
#define rom_sikigami 0
#define rom_smshcoat 0
#define rom_sotenryu 0
#define rom_spacekpr 0
#define rom_spikbatl 0
#define rom_spmjreag 0
#define rom_srmpvs 0
#define rom_sscope3 0
#define rom_starbld2 0
#define rom_starseek 0
#define rom_stnttypn 0
#define rom_tekken4 0
#define rom_thrilld2 0
#define rom_tsurugi 0
#define rom_twinspr2 0
#define rom_ultrafev 0
#define rom_usagi 0
#define rom_vamnight 0
#define rom_vf4 0
#define rom_vonforce 0
#define rom_vstr3 0
#define rom_waverngp 0
#define rom_wildridr 0
#define rom_zerogun2 0
#define rom_aliensnp 0
#define rom_azmangap 0
#define rom_bm3dxfin 0
#define rom_bemfinal 0
#define rom_bonbort 0
#define rom_btlquix 0
#define rom_capftall 0
#define rom_chocomkr 0
#define rom_chocovdr 0
#define rom_clepatfp 0
#define rom_ddp3 0
#define rom_ddp3bl 0
#define rom_ddp3u 0
#define rom_dragoncr 0
#define rom_emajannt 0
#define rom_gbisicmp 0
#define rom_ggxx 0
#define rom_hanakiko 0
#define rom_hofdead3 0
#define rom_inicial2 0
#define rom_ketsui 0
#define rom_kinbanft 0
#define rom_martialb 0
#define rom_mazan 0
#define rom_mazeking 0
#define rom_mjbenik2 0
#define rom_mjdaimjn 0
#define rom_mjdaisgn 0
#define rom_mjryuou 0
#define rom_mjsenpu 0
#define rom_mjtenhou 0
#define rom_mkakutou 0
#define rom_necchupy 0
#define rom_nicetsuk 0
#define rom_paniclpn 0
#define rom_pnyaao 0
#define rom_prem11 0
#define rom_qketaiqm 0
#define rom_raijinpp 0
#define rom_samraign 0
#define rom_sega4mj 0
#define rom_sengkakm 0
#define rom_shanhist 0
#define rom_soulcrb2 0
#define rom_soulsurf 0
#define rom_talettwr 0
#define rom_tecnicbt 0
#define rom_triforcu 0
#define rom_vathrete 0
#define rom_vf4evo 0
#define rom_vstr2002 0
#define rom_wanganmn 0
#define rom_wccf0102 0
#define rom_wcombat 0
#define rom_wldscw11 0
#define rom_xiistag 0
#define rom_xtrialrc 0
#define rom_avalon 0
#define rom_balnstry 0
#define rom_batgea3t 0
#define rom_batgear3 0
#define rom_bordrdwn 0
#define rom_btlmarin 0
#define rom_chihirou 0
#define rom_colfulhs 0
#define rom_crsytaxh 0
#define rom_demofist 0
#define rom_dlphblue 0
#define rom_donchan 0
#define rom_drhythmx 0
#define rom_eemail 0
#define rom_espgalud 0
#define rom_exzeus 0
#define rom_fzeroax 0
#define rom_gekiprom 0
#define rom_ggisuka 0
#define rom_ggxxsrld 0
#define rom_hnsibar2 0
#define rom_janseido 0
#define rom_kintaro 0
#define rom_kollon 0
#define rom_konotaco 0
#define rom_kov7star 0
#define rom_krkrfrvr 0
#define rom_kyogokuh 0
#define rom_maximspd 0
#define rom_mjchukam 0
#define rom_mjtaketr 0
#define rom_mkakuto2 0
#define rom_musiking 0
#define rom_outrn2 0
#define rom_pratnetu 0
#define rom_pride2k3 0
#define rom_psyvari2 0
#define rom_puyofevr 0
#define rom_quizmaga 0
#define rom_rpmredtc 0
#define rom_sexial 0
#define rom_shamisen 0
#define rom_sikigam2 0
#define rom_spaceina 0
#define rom_srmshipi 0
#define rom_tgm3proh 0
#define rom_timecri3 0
#define rom_toresusi 0
#define rom_typexu 0
#define rom_usagi2 0
#define rom_vcop3 0
#define rom_wanganmr 0
#define rom_wldscw12 0
#define rom_yakinjrn 0
#define rom_zgundam 0
#define rom_atmiswu 0
#define rom_avalon2 0
#define rom_bm2dx11r 0
#define rom_btlcrmx 0
#define rom_capftjam 0
#define rom_chaosblk 0
#define rom_chaosfld 0
#define rom_ddrextrm 0
#define rom_dracr2ol 0
#define rom_drmmanv1 0
#define rom_fantstry 0
#define rom_ghostsqd 0
#define rom_gigawin3 0
#define rom_gtflekv1 0
#define rom_hanaotme 0
#define rom_hogwild 0
#define rom_kofnw 0
#define rom_lovebery 0
#define rom_mjknitri 0
#define rom_mjmomotr 0
#define rom_mjnyan2 0
#define rom_mjsusikn 0
#define rom_mkakuto3 0
#define rom_musihime 0
#define rom_orlyking 0
#define rom_outrn2sp 0
#define rom_popnm12i 0
#define rom_psatack 0
#define rom_questofd 0
#define rom_quizmag2 0
#define rom_ramblefh 0
#define rom_ryukamjn 0
#define rom_segamj2 0
#define rom_seiginoh 0
#define rom_sggolfnp 0
#define rom_srmship2 0
#define rom_ss5sp2 0
#define rom_tekken5 0
#define rom_tetriskw 0
#define rom_tokyocop 0
#define rom_trizeal 0
#define rom_vf4ftune 0
#define rom_vstr4 0
#define rom_wanganmx 0
#define rom_weapncop 0
#define rom_wttroopr 0
#define rom_xexth 0
#define rom_zgundam2 0
#define rom_zoidinf 0
#define rom_zooo 0
#define rom_akuma 0
#define rom_batgear4 0
#define rom_bbheros 0
#define rom_bisibsol 0
#define rom_bm2dx12h 0
#define rom_bobblock 0
#define rom_btlcrmx2 0
#define rom_cobratac 0
#define rom_countneo 0
#define rom_daedalus 0
#define rom_dinoking 0
#define rom_drmmanv2 0
#define rom_druagaol 0
#define rom_espgald2 0
#define rom_fastfurs 0
#define rom_gd0079cb 0
#define rom_ggxxslsh 0
#define rom_gtflekv2 0
#define rom_gunseed 0
#define rom_hanatuki 0
#define rom_harikrol 0
#define rom_himetama 0
#define rom_hofdead4 0
#define rom_hokuto 0
#define rom_homura 0
#define rom_hotgmkmx 0
#define rom_ibara 0
#define rom_idolmast 0
#define rom_inicial3 0
#define rom_janoudo 0
#define rom_kenju 0
#define rom_kof11 0
#define rom_kyoryukg 0
#define rom_lindbrgu 0
#define rom_mariocac 0
#define rom_meltybld 0
#define rom_mjdaikkm 0
#define rom_mjmomot2 0
#define rom_mjonigsm 0
#define rom_mjstudum 0
#define rom_mjsusik2 0
#define rom_mjtoryum 0
#define rom_mkakuto4 0
#define rom_mslug6 0
#define rom_neobatcl 0
#define rom_otenamif 0
#define rom_popnm13c 0
#define rom_pwrsmsh3 0
#define rom_qofd2 0
#define rom_quizmag3 0
#define rom_raiden3 0
#define rom_ramblef2 0
#define rom_razilgi 0
#define rom_samsho6 0
#define rom_sangokut 0
#define rom_sclegend 0
#define rom_segamj3 0
#define rom_sggolfvt 0
#define rom_sknronde 0
#define rom_spectral 0
#define rom_spicaadv 0
#define rom_sshan2k5 0
#define rom_superdbz 0
#define rom_targetfc 0
#define rom_tekken5d 0
#define rom_tgm3 0
#define rom_thrildv3 0
#define rom_toysmach 0
#define rom_typetune 0
#define rom_underdft 0
#define rom_usagi3 0
#define rom_victryhl 0
#define rom_vmjapan 0
#define rom_wanganm2 0
#define rom_warofgrl 0
#define rom_wccf0405 0
#define rom_zoidcard 0
#define rom_zoidifex 0
#define rom_afterbcx 0
#define rom_alcanaht 0
#define rom_batgea4t 0
#define rom_bbheros2 0
#define rom_bm2dx13d 0
#define rom_damudeva 0
#define rom_ddrsnova 0
#define rom_drmmanv3 0
#define rom_exelica 0
#define rom_gd0079c2 0
#define rom_ggxxaccr 0
#define rom_gtflekv3 0
#define rom_gundamsp 0
#define rom_gunseed2 0
#define rom_gunsenjo 0
#define rom_halflif2 0
#define rom_hofd4sp 0
#define rom_homura2 0
#define rom_hotgmk5 0
#define rom_ibarabl 0
#define rom_inicald4 0
#define rom_karasu 0
#define rom_kinnikmn 0
#define rom_kirarin 0
#define rom_krkrkaml 0
#define rom_krkrlabo 0
#define rom_letsjngl 0
#define rom_licachan 0
#define rom_medalink 0
#define rom_meltybd2 0
#define rom_minnnade 0
#define rom_mjsusik3 0
#define rom_mjumi8k 0
#define rom_mjumi8k2 0
#define rom_mkakuto5 0
#define rom_musihim2 0
#define rom_needfspd 0
#define rom_novausag 0
#define rom_outrn2sd 0
#define rom_pinkswts 0
#define rom_popnm14f 0
#define rom_psyphi 0
#define rom_qgundamt 0
#define rom_qofd3 0
#define rom_rockmanb 0
#define rom_sangokt2 0
#define rom_sangyuki 0
#define rom_segacasi 0
#define rom_sikigam3 0
#define rom_skrondsp 0
#define rom_soulcrb3 0
#define rom_taikono9 0
#define rom_timecri4 0
#define rom_toysmac2 0
#define rom_ttchzuno 0
#define rom_usagi4 0
#define rom_vf5 0
#define rom_vstr42k6 0
#define rom_wantame 0
#define rom_wccf0506 0
#define rom_wldscw13 0
#define rom_yuyuhaks 0
#define rom_zingistm 0
#define rom_aftrbcdx 0
#define rom_alcanah2 0
#define rom_alienext 0
#define rom_animkais 0
#define rom_ansransr 0
#define rom_aquaageo 0
#define rom_bbheros3 0
#define rom_bm2dx14g 0
#define rom_btlfanta 0
#define rom_cardracr 0
#define rom_chasehqn 0
#define rom_d1gp 0
#define rom_ddrsnov2 0
#define rom_dethsmil 0
#define rom_dinomax 0
#define rom_dmdekaex 0
#define rom_draquemb 0
#define rom_drgnblzb 0
#define rom_drmmanv4 0
#define rom_eternalk 0
#define rom_etwheel 0
#define rom_exzeal 0
#define rom_gd0083c2 0
#define rom_gd0083cb 0
#define rom_gstsqevo 0
#define rom_gtflekv4 0
#define rom_gundams2 0
#define rom_hlflf2s2 0
#define rom_hlflf2sd 0
#define rom_inufuku2 0
#define rom_ishowan2 0
#define rom_kenkioh 0
#define rom_kinnikm2 0
#define rom_kirarin2 0
#define rom_kkstomas 0
#define rom_kofmaxra 0
#define rom_konchuds 0
#define rom_licacha3 0
#define rom_marinx2 0
#define rom_mariogp2 0
#define rom_masclekk 0
#define rom_mjnigiri 0
#define rom_mjumiipt 0
#define rom_mkakuto6 0
#define rom_mkbancho 0
#define rom_msihim2b 0
#define rom_musikint 0
#define rom_newspodr 0
#define rom_otmedius 0
#define rom_pokaskag 0
#define rom_pokemonb 0
#define rom_pokewips 0
#define rom_popnm15a 0
#define rom_pricured 0
#define rom_qofd4 0
#define rom_quizmag4 0
#define rom_raiden4 0
#define rom_rithmtgk 0
#define rom_rockbowl 0
#define rom_saiyudn2 0
#define rom_segamj3e 0
#define rom_silenthl 0
#define rom_tacoron 0
#define rom_taikancc 0
#define rom_taiko10 0
#define rom_tekken6 0
#define rom_thrildv4 0
#define rom_twospicy 0
#define rom_vf5c 0
#define rom_wanganm3 0
#define rom_wccf0607 0
#define rom_actndeka 0
#define rom_akatsuki 0
#define rom_arcanah2 0
#define rom_bm2dx15t 0
#define rom_dboc2008 0
#define rom_fateuc 0
#define rom_gundamx2 0
#define rom_hoseridr 0
#define rom_illvero 0
#define rom_inicald5 0
#define rom_kirarin3 0
#define rom_kof12 0
#define rom_kof98ult 0
#define rom_kofmaxa2 0
#define rom_lordofvm 0
#define rom_mamorukn 0
#define rom_meltybd3 0
#define rom_popnm16p 0
#define rom_quizmag5 0
#define rom_samsho7 0
#define rom_sangokt3 0
#define rom_segamj4 0
#define rom_segarace 0
#define rom_sf4 0
#define rom_sgbasara 0
#define rom_taiko11 0
#define rom_vulcwars 0
#define rom_winele08 0
#define rom_skronde2 0
#define rom_jubeat 0
#define rom_gtflekv5 0
#define rom_drmmanv5 0
#define rom_ddp4 0
#define rom_mkakuto7 0
#define rom_brayblue 0
#define rom_tbwitchs 0
#define rom_nobiteke 0
#define rom_vf5r 0
#define rom_wndrmach 0
#define rom_monstrac 0
#define rom_lovbryrc 0
#define rom_motorx 0
#define rom_garileof 0
#define rom_pirategp 0
#define rom_mjchoumi 0
#define rom_konchds2 0
#define rom_rambo 0
#define rom_kirarin4 0
#define rom_afreco 0
#define rom_kaisokus 0
#define rom_brekshow 0
#define rom_doubutsu 0
#define rom_pwrdrif2 0
#define rom_maddance 0
#define rom_jigsawp 0
#define rom_quizkano 0
#define rom_x222 0
#define rom_bash 0
#define rom_sweetsri 0
#define rom_tsururin 0
#define rom_hofdex 0
#define rom_lovbryfc 0
#define rom_demonbrd 0
#define rom_arcanah3 0
#define rom_tvsc 0
#define rom_mvsc3 0
#define rom_akmajoac 0
#define rom_akmajomd 0
#define rom_ddrx 0
#define rom_ddp415 0
#define rom_hammer 0
#define rom_pokemnbs 0
#define rom_clubmajt 0
#define rom_blkjacna 0
#define rom_segarar2 0
#define rom_bbheros4 0
#define rom_inicial5 0
#define rom_bm2dx16e 0
#define rom_meteospk 0
#define rom_gticlubs 0
#define rom_druaga16 0
#define rom_eternlk2 0
#define rom_grndcrsp 0
#define rom_sangkt3s 0
#define rom_chce1929 0
#define rom_rangerms 0
#define rom_takkle 0
#define rom_crayshot 0
#define rom_starhose 0
#define rom_starhos2 0
#define rom_starhs24 0
#define rom_wangn3dx 0
#define rom_ggxxacrp 0
#define rom_sngk2rse 0
#define rom_dethsmmb 0
#define rom_dragondc 0
#define rom_gtosgami 0
#define rom_otomecrs 0
#define rom_ansrans2 0
#define rom_haleykor 0
#define rom_touchstr 0
#define rom_gunsenj2 0
#define rom_tekken62 0
#define rom_gundamxn 0
#define rom_nirin 0
#define rom_taiko12 0
#define rom_tenmile 0
#define rom_pricures 0
#define rom_blavehrs 0
#define rom_kubmadou 0
#define rom_sdgdmmdl 0
#define rom_gd008321 0
#define rom_fanzone2 0
#define rom_mjtendou 0
#define rom_lordofv2 0
#define rom_razingst 0
#define rom_hakotumi 0
#define rom_invadrba 0
#define rom_sketcher 0
#define rom_elacdeth 0
#define rom_senornp 0
#define rom_hoppingr 0
#define rom_skssbtrc 0
#define rom_ehontmgo 0
#define rom_djmaxtec 0
#define rom_gtflekv6 0
#define rom_drmmanv6 0
#define rom_popnm17m 0
#define rom_quizmag6 0
#define rom_razilgi2 0
#define rom_mjsgdama 0
#define rom_streetoz 0
#define rom_kotbkigp 0
#define rom_rizinsun 0
#define rom_salasnka 0
#define rom_rapfreek 0
#define rom_crgunhky 0
#define rom_galoprc4 0
#define rom_streetgf 0
#define rom_tybshot 0
#define rom_galoprc5 0
#define rom_hawaideg 0
#define rom_perfectp 0
#define rom_maghexgn 0
#define rom_etrnlglx 0
#define rom_pjctaltr 0
#define rom_sokyusnd 0
#define rom_moebtlpn 0
#define rom_nflclasc 0
#define rom_aitaktod 0
#define rom_grpstmp 0
#define rom_btlofdag 0
#define rom_pnijelly 0
#define rom_cosmowrr 0
#define rom_zanfine 0
#define rom_konomi 0
#define rom_wwfroyal 0
#define rom_eorldkk2 0
#define rom_tatakawm 0
#define rom_shtoutpl 0
#define rom_gspace 0
#define rom_mamimume 0
#define rom_hyperbwl 0
#define rom_quiztatk 0
#define rom_samyvcap 0
#define rom_dealerag 0
#define rom_paclipak 0
#define rom_suikohwd 0
#define rom_daishou 0
#define rom_crownmgc 0
#define rom_gticlubc 0
#define rom_pmhokuto 0
#define rom_pmhokto2 0
#define rom_ntvyosou 0
#define rom_photoply 0
#define rom_magicbox 0
#define rom_code1dph 0
#define rom_kinbansp 0
#define rom_speedhnt 0
#define rom_cgryuprt 0
#define rom_mjdaimdx 0
#define rom_ukiyobak 0
#define rom_chcasino 0
#define rom_happytor 0
#define rom_mjmhlum2 0
#define rom_vsnetsoc 0
#define rom_valvelmt 0
#define rom_himesiki 0
#define rom_cgryu2k1 0
#define rom_hajimeno 0
#define rom_bmastjoe 0
#define rom_dogstatn 0
#define rom_ryukamj2 0
#define rom_gundmbos 0
#define rom_gigadrak 0
#define rom_vpinball 0
#define rom_fishtime 0
#define rom_gamerobo 0
#define rom_pndsac 0
#define rom_pnysac 0
#define rom_pnxnac 0
#define rom_pnauac 0
#define rom_stepstg3 0
#define rom_coopers9 0
#define rom_gioramat 0
#define rom_kelberos 0
#define rom_higurasi 0
#define rom_idlparad 0
#define rom_hauntedm 0
#define rom_missingr 0
#define rom_hoserid2 0
#define rom_thebishi 0
#define rom_musicdgn 0
#define rom_moukenka 0
#define rom_bordrbrk 0
#define rom_mkakt777 0
#define rom_gouketjm 0
#define rom_nitropls 0
#define rom_dethsml2 0
#define rom_mj4saki 0
#define rom_chaoscod 0
#define rom_kf2k2ult 0
#define rom_gettenka 0
#define rom_lilpri 0
#define rom_bm2dx17s 0
#define rom_shanhain 0
#define rom_starhosp 0
#define rom_taiko12d 0
#define rom_tanktank 0
#define rom_ochainup 0
#define rom_zigsawpz 0
#define rom_touchman 0
#define rom_wccf0809 0
#define rom_mocapspt 0
#define rom_miraikbp 0
#define rom_mjkaktgt 0
#define rom_bbhero09 0
#define rom_sangkt3t 0
#define rom_chaomang 0
#define rom_chouchab 0
#define rom_metlgrac 0
#define rom_topspedn 0
#define rom_simensok 0
#define rom_garileo2 0
#define rom_mjkokryu 0
#define rom_mjokinam 0
#define rom_lordofv3 0
#define rom_lordofv4 0
#define rom_jubeatrp 0
#define rom_avalon3 0
#define rom_blockppl 0
#define rom_shiningf 0
#define rom_musikink 0
#define rom_cyberdiv 0
#define rom_uhauhaok 0
#define rom_tenkashg 0
#define rom_dstmpirt 0
#define rom_taiko13 0
#define rom_kofskyst 0
#define rom_minadewa 0
#define rom_dekalis 0
#define rom_tgm4 0
#define rom_gtflekxg 0
#define rom_drmmanxg 0
#define rom_zigsawwa 0
#define rom_eternlk3 0
#define rom_popnm18s 0
#define rom_satestrk 0
#define rom_arcanh3n 0
#define rom_lordofv5 0
#define rom_segamj4e 0
#define rom_medalgun 0
#define rom_roadftrs 0
#define rom_exceptn 0
#define rom_hammer2 0
#define rom_typhoons 0
#define rom_speedrid 0
#define rom_h2overdv 0
#define rom_specfire 0
#define rom_sgoroket 0
#define rom_heatuphc 0
#define rom_putt 0
#define rom_brayblu2 0
#define rom_quizmag7 0
#define rom_ongakup 0
#define rom_winele10 0
#define rom_prjdevac 0
#define rom_strania 0
#define rom_ddp4bl 0
#define rom_wangn3dp 0
#define rom_jubeatkt 0
#define rom_milionkp 0
#define rom_sngktisn 0
#define rom_meltybd4 0
#define rom_answr2dx 0
#define rom_ami3 0
#define rom_alajewel 0
#define rom_jewelpet 0
#define rom_gaiaatk4 0
#define rom_hoppinrk 0
#define rom_musicgdx 0
#define rom_sekiryuh 0
#define rom_gndmexvs 0
#define rom_razingsd 0
#define rom_tmntslvg 0
#define rom_pkmnkkgt 0
#define rom_rsonline 0
#define rom_kof13 0
#define rom_ochainun 0
#define rom_metalgac 0
#define rom_magician 0
#define rom_crutchst 0
#define rom_acesnper 0
#define rom_bbpirats 0
#define rom_fortunew 0
#define rom_stomprdx 0
#define rom_cookmain 0
#define rom_bakumaru 0
#define rom_giturftv 0
#define rom_dragonht 0
#define rom_enueink 0
#define rom_refrecbt 0
#define rom_kingyosk 0
#define rom_letsgois 0
#define rom_trfmanim 0
#define rom_bbhero10 0
#define rom_bm2dx18r 0
#define rom_ssf4 0
#define rom_sangkt3w 0
#define rom_gtflekv7 0
#define rom_drmmanv7 0
#define rom_ddrx2 0
#define rom_scardgen 0
#define rom_taiko14 0
#define rom_popnm19t 0
#define rom_panoramf 0
#define rom_tikitiki 0
#define rom_tttravel 0
#define rom_akaikata 0
#define rom_loveplus 0
#define rom_hanatudx 0
#define rom_hanakadx 0
#define rom_starhs25 0
#define rom_darabust 0
#define rom_hellokty 0
#define rom_pengo8 0
#define rom_mjkaktuv 0
#define rom_answr2lv 0
#define rom_vf5final 0
#define rom_taiko2 0
#define rom_taiko3 0
#define rom_taiko4 0
#define rom_taiko5 0
#define rom_taiko6 0
#define rom_taiko7 0
#define rom_taiko8 0
#define rom_popnm2 0
#define rom_popnm3 0
#define rom_popnm4 0
#define rom_popnm5 0
#define rom_popnm6 0
#define rom_popnm7 0
#define rom_popnm8 0
#define rom_popnm9 0
#define rom_popnm10 0
#define rom_popnm11 0
#define rom_namcos1x 0
#define rom_djmain 0
#define rom_firebeat 0
#define rom_beatm7th 0
#define rom_pstagex 0
#define rom_drumm 0
#define rom_drum2 0
#define rom_drum3 0
#define rom_drum4 0
#define rom_drum5 0
#define rom_drum6 0
#define rom_drum7 0
#define rom_stv 0
#define rom_priclub2 0
#define rom_nameclub 0
#define rom_priclubp 0
#define rom_namcos2x 0
#define rom_hajimei2 0
#define rom_gahahai2 0
#define rom_kurukuru 0
#define rom_panekuru 0


GAME( 19??,excitemd,0, unmamed, unmamed, 0, ROT0,"{Y","GLTCg}hi",GAME_NOT_WORKING )
GAME( 19??,touchdwn,0, unmamed, unmamed, 0, ROT0,"ZK","^b`_E",GAME_NOT_WORKING )
GAME( 1971,cmpspace,0, unmamed, unmamed, 0, ROT0,"Nutting Associates","Rs[^[Xy[X",GAME_NOT_WORKING )
GAME( 1972,cmpspacb,0, unmamed, unmamed, 0, ROT0,"Nutting Associates","Rs[^[Xy[X{[",GAME_NOT_WORKING )
GAME( 1972,startrec,0, unmamed, unmamed, 0, ROT0,"ForPlay","X^[gbN",GAME_NOT_WORKING )
GAME( 1973,alimnatn,0, unmamed, unmamed, 0, ROT0,"A^","G~l[V",GAME_NOT_WORKING )
GAME( 1973,astrrace,0, unmamed, unmamed, 0, ROT0,"^Cg[","AXg[X",GAME_NOT_WORKING )
GAME( 1973,deviscup,0, unmamed, unmamed, 0, ROT0,"^Cg[","frXJbv",GAME_NOT_WORKING )
GAME( 1973,elepong,0, unmamed, unmamed, 0, ROT0,"^Cg[","G|",GAME_NOT_WORKING )
GAME( 1973,hockeytv,0, unmamed, unmamed, 0, ROT0,"ZK","zbP[TV",GAME_NOT_WORKING )
GAME( 1973,pontron,0, unmamed, unmamed, 0, ROT0,"ZK","|g",GAME_NOT_WORKING )
GAME( 1973,pontron2,0, unmamed, unmamed, 0, ROT0,"ZK","|gU",GAME_NOT_WORKING )
GAME( 1973,prohocky,0, unmamed, unmamed, 0, ROT0,"^Cg[","vzbP[",GAME_NOT_WORKING )
GAME( 1973,soccert,0, unmamed, unmamed, 0, ROT0,"^Cg[","TbJ[",GAME_NOT_WORKING )
GAME( 1973,spacrace,0, unmamed, unmamed, 0, ROT0,"A^","Xy[X[X",GAME_NOT_WORKING )
GAME( 1973,suprpong,0, unmamed, unmamed, 0, ROT0,"A^","X[p[|",GAME_NOT_WORKING )
GAME( 1974,basketbl,0, unmamed, unmamed, 0, ROT0,"^Cg[","oXPbg{[",GAME_NOT_WORKING )
GAME( 1974,formura,0, unmamed, unmamed, 0, ROT0,"A^","tH[~",GAME_NOT_WORKING )
GAME( 1974,goalkick,0, unmamed, unmamed, 0, ROT0,"ZK","S[LbN",GAME_NOT_WORKING )
GAME( 1974,grtruk10,0, unmamed, unmamed, 0, ROT0,"A^","OhgbN10",GAME_NOT_WORKING )
GAME( 1974,kadrpong,0, unmamed, unmamed, 0, ROT0,"A^","Jh|",GAME_NOT_WORKING )
GAME( 1974,kwack,0, unmamed, unmamed, 0, ROT0,"A^","NbN",GAME_NOT_WORKING )
GAME( 1974,minihcky,0, unmamed, unmamed, 0, ROT0,"ZK","~jzbP[",GAME_NOT_WORKING )
GAME( 1974,pingpon,0, unmamed, unmamed, 0, ROT0,"A^","s|",GAME_NOT_WORKING )
GAME( 1974,pongdbls,0, unmamed, unmamed, 0, ROT0,"A^","|_uX",GAME_NOT_WORKING )
GAME( 1974,rebound,0, unmamed, unmamed, 0, ROT0,"A^","oEh",GAME_NOT_WORKING )
GAME( 1974,spdrace,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xs[h[X",GAME_NOT_WORKING )
GAME( 1974,spike,0, unmamed, unmamed, 0, ROT0,"A^","XpCN",GAME_NOT_WORKING )
GAME( 1974,tank,0, unmamed, unmamed, 0, ROT0,"A^","^N",GAME_NOT_WORKING )
GAME( 1974,tblhocky,0, unmamed, unmamed, 0, ROT0,"ZK","e[uzbP[",GAME_NOT_WORKING )
GAME( 1974,truck20,0, unmamed, unmamed, 0, ROT0,"A^","gbN20",GAME_NOT_WORKING )
GAME( 1974,twinrace,0, unmamed, unmamed, 0, ROT0,"A^","cC[T[",GAME_NOT_WORKING )
GAME( 1975,antiairc,0, unmamed, unmamed, 0, ROT0,"A^","A`GANtg",GAME_NOT_WORKING )
GAME( 1975,baloongn,0, unmamed, unmamed, 0, ROT0,"ZK","o[K",GAME_NOT_WORKING )
GAME( 1975,baretmak,0, unmamed, unmamed, 0, ROT0,"ZK","obg}[N",GAME_NOT_WORKING )
GAME( 1975,clshscor,0, unmamed, unmamed, 0, ROT0,"A^","NbVAhXRA",GAME_NOT_WORKING )
GAME( 1975,deadheat,0, unmamed, unmamed, 0, ROT0,"^Cg[","fbhq[g",GAME_NOT_WORKING )
GAME( 1975,duckysht,0, unmamed, unmamed, 0, ROT0,"ZK","_bL[V[g",GAME_NOT_WORKING )
GAME( 1975,erase,0, unmamed, unmamed, 0, ROT0,"ZK","C[X",GAME_NOT_WORKING )
GAME( 1975,goal4,0, unmamed, unmamed, 0, ROT0,"A^","S[4",GAME_NOT_WORKING )
GAME( 1975,highway,0, unmamed, unmamed, 0, ROT0,"A^","nCEFC",GAME_NOT_WORKING )
GAME( 1975,indy800,0, unmamed, unmamed, 0, ROT0,"A^","CfB800",GAME_NOT_WORKING )
GAME( 1975,jetfight,0, unmamed, unmamed, 0, ROT0,"A^","WFbgt@C^[",GAME_NOT_WORKING )
GAME( 1975,lastigng,0, unmamed, unmamed, 0, ROT0,"ZK","XgCjO",GAME_NOT_WORKING )
GAME( 1975,maneater,0, unmamed, unmamed, 0, ROT0,"iR/PSE","}C[^[",GAME_NOT_WORKING )
GAME( 1975,persuit,0, unmamed, unmamed, 0, ROT0,"A^","p[X[c",GAME_NOT_WORKING )
GAME( 1975,spdracdx,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xs[h[XDX",GAME_NOT_WORKING )
GAME( 1975,steeplcs,0, unmamed, unmamed, 0, ROT0,"A^","XeB[v`FCX",GAME_NOT_WORKING )
GAME( 1975,tahichi,0, unmamed, unmamed, 0, ROT0,"^Cg[","^q`A",GAME_NOT_WORKING )
GAME( 1976,atack,0, unmamed, unmamed, 0, ROT0,"^Cg[","A^bN",GAME_NOT_WORKING )
GAME( 1976,atarien,0, unmamed, unmamed, 0, ROT0,"A^","A^A",GAME_NOT_WORKING )
GAME( 1976,breakout,0, unmamed, unmamed, 0, ROT0,"A^","uCNAEg",GAME_NOT_WORKING )
GAME( 1976,cleanswp,0, unmamed, unmamed, 0, ROT0,"^Cg[","N[XC[v",GAME_NOT_WORKING )
GAME( 1976,crsgrace,0, unmamed, unmamed, 0, ROT0,"^Cg[","NbVO[X",GAME_NOT_WORKING )
GAME( 1976,dairesha,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","ԏP",GAME_NOT_WORKING )
GAME( 1976,f1,0, unmamed, unmamed, 0, ROT0,"A^","Gt",GAME_NOT_WORKING )
GAME( 1976,hvywcmpo,0, unmamed, unmamed, 0, ROT0,"ZK","wr[EFCg`v",GAME_NOT_WORKING )
GAME( 1976,indy4,0, unmamed, unmamed, 0, ROT0,"A^","CfB4",GAME_NOT_WORKING )
GAME( 1976,intrcept,0, unmamed, unmamed, 0, ROT0,"^Cg[","C^[Zv^[",GAME_NOT_WORKING )
GAME( 1976,leman,0, unmamed, unmamed, 0, ROT0,"A^","E}",GAME_NOT_WORKING )
GAME( 1976,outlaw,0, unmamed, unmamed, 0, ROT0,"A^","AEg[",GAME_NOT_WORKING )
GAME( 1976,quizshow,0, unmamed, unmamed, 0, ROT0,"A^","NCYV[",GAME_NOT_WORKING )
GAME( 1976,roadrace,0, unmamed, unmamed, 0, ROT0,"ZK","[h[X",GAME_NOT_WORKING )
GAME( 1976,rocknbrk,0, unmamed, unmamed, 0, ROT0,"ZK","bNo[N",GAME_NOT_WORKING )
GAME( 1976,shttrenr,0, unmamed, unmamed, 0, ROT0,"CV","V[eBOg[i[",GAME_NOT_WORKING )
GAME( 1976,skyhawk,0, unmamed, unmamed, 0, ROT0,"CV","XJCz[N",GAME_NOT_WORKING )
GAME( 1976,sparkcnr,0, unmamed, unmamed, 0, ROT0,"ZK","Xp[NOR[i[",GAME_NOT_WORKING )
GAME( 1976,spdrtwin,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xs[h[XcC",GAME_NOT_WORKING )
GAME( 1976,squadron,0, unmamed, unmamed, 0, ROT0,"ZK","XR[h",GAME_NOT_WORKING )
GAME( 1976,stantcyc,0, unmamed, unmamed, 0, ROT0,"A^","X^gTCN",GAME_NOT_WORKING )
GAME( 1976,tavenger,0, unmamed, unmamed, 0, ROT0,"^Cg[","AxW[",GAME_NOT_WORKING )
GAME( 1976,videobbl,0, unmamed, unmamed, 0, ROT0,"A^","rfIx[X{[",GAME_NOT_WORKING )
GAME( 1976,wildgnmn,0, unmamed, unmamed, 0, ROT0,"CV","ChK}",GAME_NOT_WORKING )
GAME( 1977,airbaven,0, unmamed, unmamed, 0, ROT0,"A^","GA{[AxW[",GAME_NOT_WORKING )
GAME( 1977,baricad2,0, unmamed, unmamed, 0, ROT0,"^Cg[/O","oP[hU",GAME_NOT_WORKING )
GAME( 1977,baricad3,0, unmamed, unmamed, 0, ROT0,"^Cg[/O","oP[hV",GAME_NOT_WORKING )
GAME( 1977,blckyard,0, unmamed, unmamed, 0, ROT0,"Ri~","ubN[h",GAME_NOT_WORKING )
GAME( 1977,bombaway,0, unmamed, unmamed, 0, ROT0,"^Cg[/hEY","{uXAEFC",GAME_NOT_WORKING )
GAME( 1977,bomber,0, unmamed, unmamed, 0, ROT0,"ZK","{o[",GAME_NOT_WORKING )
GAME( 1977,clashcos,0, unmamed, unmamed, 0, ROT0,"ZK","NbVR[X",GAME_NOT_WORKING )
GAME( 1977,cleansw2,0, unmamed, unmamed, 0, ROT0,"^Cg[","N[XC[vU",GAME_NOT_WORKING )
GAME( 1977,destroya,0, unmamed, unmamed, 0, ROT0,"Ri~","fXgC[",GAME_NOT_WORKING )
GAME( 1977,fisco400,0, unmamed, unmamed, 0, ROT0,"^Cg[","tBXR400",GAME_NOT_WORKING )
GAME( 1977,flyfrts2,0, unmamed, unmamed, 0, ROT0,"^Cg[","tCOtH[gXU",GAME_NOT_WORKING )
GAME( 1977,flygftrs,0, unmamed, unmamed, 0, ROT0,"^Cg[","tCOtH[gX",GAME_NOT_WORKING )
GAME( 1977,gunman,0, unmamed, unmamed, 0, ROT0,"^Cg[","K}",GAME_NOT_WORKING )
GAME( 1977,loadchmp,0, unmamed, unmamed, 0, ROT0,"^Cg[","[h`sI",GAME_NOT_WORKING )
GAME( 1977,mantt,0, unmamed, unmamed, 0, ROT0,"ZK","}TT",GAME_NOT_WORKING )
GAME( 1977,missilex,0, unmamed, unmamed, 0, ROT0,"^Cg[","~TCw",GAME_NOT_WORKING )
GAME( 1977,nblock,0, unmamed, unmamed, 0, ROT0,"iR","ubN",GAME_NOT_WORKING )
GAME( 1977,ninjagun,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","jWK",GAME_NOT_WORKING )
GAME( 1977,shighway,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[nCEFC",GAME_NOT_WORKING )
GAME( 1977,soccerdx,0, unmamed, unmamed, 0, ROT0,"^Cg[","TbJ[DX",GAME_NOT_WORKING )
GAME( 1977,sprbowl,0, unmamed, unmamed, 0, ROT0,"ZK","X[p[{E",GAME_NOT_WORKING )
GAME( 1977,tablescr,0, unmamed, unmamed, 0, ROT0,"^Cg[","e[uTbJ[",GAME_NOT_WORKING )
GAME( 1977,tennis,0, unmamed, unmamed, 0, ROT0,"^Cg[","ejX",GAME_NOT_WORKING )
GAME( 1977,time,0, unmamed, unmamed, 0, ROT0,"A^","^C",GAME_NOT_WORKING )
GAME( 1977,ttbarier,0, unmamed, unmamed, 0, ROT0,"^Cg[","TToA[",GAME_NOT_WORKING )
GAME( 1977,ttblock,0, unmamed, unmamed, 0, ROT0,"^Cg[","TTubN",GAME_NOT_WORKING )
GAME( 1977,twincstt,0, unmamed, unmamed, 0, ROT0,"ZK","cCR[XTT",GAME_NOT_WORKING )
GAME( 1977,walbreak,0, unmamed, unmamed, 0, ROT0,"^Cg[","EH[uCN",GAME_NOT_WORKING )
GAME( 1978,acrobat,0, unmamed, unmamed, 0, ROT0,"^Cg[","ANobg",GAME_NOT_WORKING )
GAME( 1978,balncirc,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","o[T[JX",GAME_NOT_WORKING )
GAME( 1978,balnmini,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","o[~j",GAME_NOT_WORKING )
GAME( 1978,banish,0, unmamed, unmamed, 0, ROT0,"ovXg","ojbV",GAME_NOT_WORKING )
GAME( 1978,baseball,0, unmamed, unmamed, 0, ROT0,"WR","x[X{[",GAME_NOT_WORKING )
GAME( 1978,blkchalg,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","ubN`W[",GAME_NOT_WORKING )
GAME( 1978,blockfvr,0, unmamed, unmamed, 0, ROT0,"CV","ubNtB[o[",GAME_NOT_WORKING )
GAME( 1978,blockinv,0, unmamed, unmamed, 0, ROT0,"Ri~","ubNCx[_[",GAME_NOT_WORKING )
GAME( 1978,blockpft,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","ubNp[tFNg",GAME_NOT_WORKING )
GAME( 1978,bowling,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","{EO",GAME_NOT_WORKING )
GAME( 1978,breaker,0, unmamed, unmamed, 0, ROT0,"Ri~","uCJ[",GAME_NOT_WORKING )
GAME( 1978,cartngun,0, unmamed, unmamed, 0, ROT0,"ZK","J[cK",GAME_NOT_WORKING )
GAME( 1978,clcircus,0, unmamed, unmamed, 0, ROT0,"AC","J[T[JX",GAME_NOT_WORKING )
GAME( 1978,cpothelo,0, unmamed, unmamed, 0, ROT0,"CV","Rs[^[IZQ[",GAME_NOT_WORKING )
GAME( 1978,crosfire,0, unmamed, unmamed, 0, ROT0,"^Cg[","NXt@CA[",GAME_NOT_WORKING )
GAME( 1978,dballoon,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","o[",GAME_NOT_WORKING )
GAME( 1978,depthbom,0, unmamed, unmamed, 0, ROT0,"ZK","fBvX{",GAME_NOT_WORKING )
GAME( 1978,f1mach,0, unmamed, unmamed, 0, ROT0,"A^","Gt}bn",GAME_NOT_WORKING )
GAME( 1978,galaxwar,0, unmamed, unmamed, 0, ROT0,"ZK","MNV[EH[",GAME_NOT_WORKING )
GAME( 1978,helishtr,0, unmamed, unmamed, 0, ROT0,"ZK","wV[^[",GAME_NOT_WORKING )
GAME( 1978,hoping,0, unmamed, unmamed, 0, ROT0,"WR","zbsO",GAME_NOT_WORKING )
GAME( 1978,ipminvd2,0, unmamed, unmamed, 0, ROT0,"AC","IPMCx[_[PART3",GAME_NOT_WORKING )
GAME( 1978,ipminvdr,0, unmamed, unmamed, 0, ROT0,"AC","IPMCx[_[PART2",GAME_NOT_WORKING )
GAME( 1978,ipmmajan,0, unmamed, unmamed, 0, ROT0,"AC","IPM",GAME_NOT_WORKING )
GAME( 1978,lineball,0, unmamed, unmamed, 0, ROT0,"AC","C{[",GAME_NOT_WORKING )
GAME( 1978,marinwar,0, unmamed, unmamed, 0, ROT0,"ovXg","}[EH[Y",GAME_NOT_WORKING )
GAME( 1978,micoblck,0, unmamed, unmamed, 0, ROT0,"SNK","}CRubN",GAME_NOT_WORKING )
GAME( 1978,micokit,0, unmamed, unmamed, 0, ROT0,"SNK","}CRLbg",GAME_NOT_WORKING )
GAME( 1978,micokit2,0, unmamed, unmamed, 0, ROT0,"SNK","}CRLbg2",GAME_NOT_WORKING )
GAME( 1978,micokit3,0, unmamed, unmamed, 0, ROT0,"SNK","}CRLbg3",GAME_NOT_WORKING )
GAME( 1978,midnrace,0, unmamed, unmamed, 0, ROT0,"WR","~bhiCg[X",GAME_NOT_WORKING )
GAME( 1978,miraclsp,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","~NX[p[",GAME_NOT_WORKING )
GAME( 1978,monkymag,0, unmamed, unmamed, 0, ROT0,"CV","L[}WbN",GAME_NOT_WORKING )
GAME( 1978,newblhtr,0, unmamed, unmamed, 0, ROT0,"Ri~","j[ubNn^[",GAME_NOT_WORKING )
GAME( 1978,nyankoro,0, unmamed, unmamed, 0, ROT0,"AC","jR",GAME_NOT_WORKING )
GAME( 1978,piccolo,0, unmamed, unmamed, 0, ROT0,"AC","sbR",GAME_NOT_WORKING )
GAME( 1978,proracer,0, unmamed, unmamed, 0, ROT0,"ZK","v[T[",GAME_NOT_WORKING )
GAME( 1978,pwrblock,0, unmamed, unmamed, 0, ROT0,"AC","p[ubN",GAME_NOT_WORKING )
GAME( 1978,scretwar,0, unmamed, unmamed, 0, ROT0,"ZK","V[NbgEH[",GAME_NOT_WORKING )
GAME( 1978,scrtbase,0, unmamed, unmamed, 0, ROT0,"ZK","V[Nbgx[X",GAME_NOT_WORKING )
GAME( 1978,sdestroy,0, unmamed, unmamed, 0, ROT0,"Ri~","X[p[fXgC[",GAME_NOT_WORKING )
GAME( 1978,smokyjoe,0, unmamed, unmamed, 0, ROT0,"A^","X[L[W[",GAME_NOT_WORKING )
GAME( 1978,snkyamat,0, unmamed, unmamed, 0, ROT0,"SNK","F̓}g",GAME_NOT_WORKING )
GAME( 1978,spacesip,0, unmamed, unmamed, 0, ROT0,"Ri~","Xy[XVbv",GAME_NOT_WORKING )
GAME( 1978,spbreak,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","X[p[uCN",GAME_NOT_WORKING )
GAME( 1978,spbrek2,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","X[p[uCNU",GAME_NOT_WORKING )
GAME( 1978,spcarv12,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","X[p[J[V-12",GAME_NOT_WORKING )
GAME( 1978,spcfigtr,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","Xy[Xt@C^[",GAME_NOT_WORKING )
GAME( 1978,spmickit,0, unmamed, unmamed, 0, ROT0,"SNK","Xy[X}CRLbg",GAME_NOT_WORKING )
GAME( 1978,sprblock,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[ubN",GAME_NOT_WORKING )
GAME( 1978,spstrsp,0, unmamed, unmamed, 0, ROT0,"ovXg","Xy[XXgW[X[p[",GAME_NOT_WORKING )
GAME( 1978,ssjump,0, unmamed, unmamed, 0, ROT0,"ZK","V[\x83\x5c[Wv",GAME_NOT_WORKING )
GAME( 1978,ssjump2,0, unmamed, unmamed, 0, ROT0,"ZK","V[\x83\x5c[Wv2",GAME_NOT_WORKING )
GAME( 1978,sspdrc,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[Xs[h[XCL5",GAME_NOT_WORKING )
GAME( 1978,sspdrcv,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[Xs[h[XV",GAME_NOT_WORKING )
GAME( 1978,stardust,0, unmamed, unmamed, 0, ROT0,"AC","X^[_Xg",GAME_NOT_WORKING )
GAME( 1978,tablebar,0, unmamed, unmamed, 0, ROT0,"^Cg[","e[uo[",GAME_NOT_WORKING )
GAME( 1978,tblatacb,0, unmamed, unmamed, 0, ROT0,"{Y","e[uA^bJ[ubN",GAME_NOT_WORKING )
GAME( 1978,tblatacg,0, unmamed, unmamed, 0, ROT0,"{Y","e[uA^bJ[K[h",GAME_NOT_WORKING )
GAME( 1978,tblatack,0, unmamed, unmamed, 0, ROT0,"{Y","e[uA^bJ[",GAME_NOT_WORKING )
GAME( 1978,tblatacs,0, unmamed, unmamed, 0, ROT0,"{Y","e[uA^bJ[XyV",GAME_NOT_WORKING )
GAME( 1978,tblblock,0, unmamed, unmamed, 0, ROT0,"AC","e[uubN",GAME_NOT_WORKING )
GAME( 1978,tblbombr,0, unmamed, unmamed, 0, ROT0,"{Y","e[u{o",GAME_NOT_WORKING )
GAME( 1978,testdriv,0, unmamed, unmamed, 0, ROT0,"CV","eXghCo[",GAME_NOT_WORKING )
GAME( 1978,thdriver,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","UEhCo[",GAME_NOT_WORKING )
GAME( 1978,topbawlr,0, unmamed, unmamed, 0, ROT0,"^Cg[","gbv{E[",GAME_NOT_WORKING )
GAME( 1978,toprunnr,0, unmamed, unmamed, 0, ROT0,"ZK","gbvi[",GAME_NOT_WORKING )
GAME( 1978,trumpoln,0, unmamed, unmamed, 0, ROT0,"^Cg[","g|",GAME_NOT_WORKING )
GAME( 1978,tvcomdx,0, unmamed, unmamed, 0, ROT0,"ovXg","erRs[^[fbNX",GAME_NOT_WORKING )
GAME( 1978,wacrobat,0, unmamed, unmamed, 0, ROT0,"^Cg[","EH[ANobg",GAME_NOT_WORKING )
GAME( 1978,walablck,0, unmamed, unmamed, 0, ROT0,"^Cg[","EH[AubN",GAME_NOT_WORKING )
GAME( 1978,wildwood,0, unmamed, unmamed, 0, ROT0,"ZK","ChEbh",GAME_NOT_WORKING )
GAME( 1979,alphainv,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","At@Cx[_[",GAME_NOT_WORKING )
GAME( 1979,atackace,0, unmamed, unmamed, 0, ROT0,"{Y","A^bJ[G[X",GAME_NOT_WORKING )
GAME( 1979,blockc,0, unmamed, unmamed, 0, ROT0,"^Cg[","ubNC",GAME_NOT_WORKING )
GAME( 1979,bomba,0, unmamed, unmamed, 0, ROT0,"{Y","{o",GAME_NOT_WORKING )
GAME( 1979,capslinv,0, unmamed, unmamed, 0, ROT0,"AC","JvZCx[_[",GAME_NOT_WORKING )
GAME( 1979,carchase,0, unmamed, unmamed, 0, ROT0,"Ri~","J[`FCX",GAME_NOT_WORKING )
GAME( 1979,carhunt,0, unmamed, unmamed, 0, ROT0,"ZK","J[ng",GAME_NOT_WORKING )
GAME( 1979,casling,0, unmamed, unmamed, 0, ROT0,"ZK","LXO",GAME_NOT_WORKING )
GAME( 1979,daisanw,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","Of",GAME_NOT_WORKING )
GAME( 1979,dblblock,0, unmamed, unmamed, 0, ROT0,"ZK","_uubN",GAME_NOT_WORKING )
GAME( 1979,dracurah,0, unmamed, unmamed, 0, ROT0,"eNmH","hLn^[",GAME_NOT_WORKING )
GAME( 1979,eagleh,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","C[OH",GAME_NOT_WORKING )
GAME( 1979,fortress,0, unmamed, unmamed, 0, ROT0,"ZK","tH[gX",GAME_NOT_WORKING )
GAME( 1979,galaxyfc,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","MNV[tH[X",GAME_NOT_WORKING )
GAME( 1979,goldinvd,0, unmamed, unmamed, 0, ROT0,"VO}","S[fCx[_[",GAME_NOT_WORKING )
GAME( 1979,helacles,0, unmamed, unmamed, 0, ROT0,"A^","wNX",GAME_NOT_WORKING )
GAME( 1979,laserwar,0, unmamed, unmamed, 0, ROT0,"^Cg[/Vl}gjNX","[U[EH[Y",GAME_NOT_WORKING )
GAME( 1979,leachmj,0, unmamed, unmamed, 0, ROT0,"AC","[`",GAME_NOT_WORKING )
GAME( 1979,mahjandx,0, unmamed, unmamed, 0, ROT0,"AC","DX",GAME_NOT_WORKING )
GAME( 1979,melodyvd,0, unmamed, unmamed, 0, ROT0,"SNK","fB[Cx[_[",GAME_NOT_WORKING )
GAME( 1979,moonalph,0, unmamed, unmamed, 0, ROT0,"{Y","[At@",GAME_NOT_WORKING )
GAME( 1979,moonlakr,0, unmamed, unmamed, 0, ROT0,"{Y","[CJ[",GAME_NOT_WORKING )
GAME( 1979,moontruc,0, unmamed, unmamed, 0, ROT0,"{Y","[gbJ[",GAME_NOT_WORKING )
GAME( 1979,moulhunt,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","En^[",GAME_NOT_WORKING )
GAME( 1979,newblckx,0, unmamed, unmamed, 0, ROT0,"AC","j[ubNX",GAME_NOT_WORKING )
GAME( 1979,newblckz,0, unmamed, unmamed, 0, ROT0,"AC","j[ubNZ",GAME_NOT_WORKING )
GAME( 1979,niceon,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","iCXI",GAME_NOT_WORKING )
GAME( 1979,richman,0, unmamed, unmamed, 0, ROT0,"Ri~","b`}",GAME_NOT_WORKING )
GAME( 1979,saturn3d,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","T^[3D",GAME_NOT_WORKING )
GAME( 1979,sheriff2,0, unmamed, unmamed, 0, ROT0,"CV","VFt2",GAME_NOT_WORKING )
GAME( 1979,spacecmb,0, unmamed, unmamed, 0, ROT0,"WR","Xy[XRobg",GAME_NOT_WORKING )
GAME( 1979,spblopen,0, unmamed, unmamed, 0, ROT0,"ZK","X[p[ubNI[v",GAME_NOT_WORKING )
GAME( 1979,spcatck2,0, unmamed, unmamed, 0, ROT0,"ZK","Xy[XA^bN2",GAME_NOT_WORKING )
GAME( 1979,spccmnd,0, unmamed, unmamed, 0, ROT0,"AC","Xy[XR}h",GAME_NOT_WORKING )
GAME( 1979,spcfigh2,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","Xy[Xt@C^[MKU",GAME_NOT_WORKING )
GAME( 1979,spdual,0, unmamed, unmamed, 0, ROT0,"ZK","XyVfA",GAME_NOT_WORKING )
GAME( 1979,spdual2,0, unmamed, unmamed, 0, ROT0,"ZK","XyVfA p[gU",GAME_NOT_WORKING )
GAME( 1979,spectwin,0, unmamed, unmamed, 0, ROT0,"WR","XyVcC",GAME_NOT_WORKING )
GAME( 1979,spfightr,0, unmamed, unmamed, 0, ROT0,"ZK","Xy[Xt@C^[",GAME_NOT_WORKING )
GAME( 1979,spmeteo,0, unmamed, unmamed, 0, ROT0,"ovXg","X[p[eI",GAME_NOT_WORKING )
GAME( 1979,sptwin,0, unmamed, unmamed, 0, ROT0,"ovXg","X[p[cC",GAME_NOT_WORKING )
GAME( 1979,srunaway,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","iEFC",GAME_NOT_WORKING )
GAME( 1979,stantcar,0, unmamed, unmamed, 0, ROT0,"{Y","X^gJ[",GAME_NOT_WORKING )
GAME( 1979,storm,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","Xg[",GAME_NOT_WORKING )
GAME( 1979,submarin,0, unmamed, unmamed, 0, ROT0,"A^","Tu}",GAME_NOT_WORKING )
GAME( 1979,supermn,0, unmamed, unmamed, 0, ROT0,"A^","X[p[}",GAME_NOT_WORKING )
GAME( 1979,sweeper,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","XC[p[",GAME_NOT_WORKING )
GAME( 1979,talegun2,0, unmamed, unmamed, 0, ROT0,"ZK/Vl}gjNX","eCKi[2",GAME_NOT_WORKING )
GAME( 1979,triplatk,0, unmamed, unmamed, 0, ROT0,"ZK","gvA^bN",GAME_NOT_WORKING )
GAME( 1979,upsetblk,0, unmamed, unmamed, 0, ROT0,"ZK","AbvZbgubN",GAME_NOT_WORKING )
GAME( 1979,yosaku,0, unmamed, unmamed, 0, ROT0,"SNK","^",GAME_NOT_WORKING )
GAME( 1979,znznblcl,0, unmamed, unmamed, 0, ROT0,"^Cg[","YYubNJ[",GAME_NOT_WORKING )
GAME( 1979,zunblock,0, unmamed, unmamed, 0, ROT0,"^Cg[","YYubN",GAME_NOT_WORKING )
GAME( 198?,flyingat,0, unmamed, unmamed, 0, ROT0,"^Cg[","tCOA^bN",GAME_NOT_WORKING )
GAME( 198?,hadeth,0, unmamed, unmamed, 0, ROT0,"^Cg[","nfX",GAME_NOT_WORKING )
GAME( 198?,hanaaras,0, unmamed, unmamed, 0, ROT0,"Ao","ԗ",GAME_NOT_WORKING )
GAME( 198?,playbal,0, unmamed, unmamed, 0, ROT0,"TNZX","vC{[",GAME_NOT_WORKING )
GAME( 198?,tspiramd,0, unmamed, unmamed, 0, ROT0,"O","TSs~bh",GAME_NOT_WORKING )
GAME( 1980,astrocrf,0, unmamed, unmamed, 0, ROT0,"^Cg[","AXgNtg",GAME_NOT_WORKING )
GAME( 1980,astrzone,0, unmamed, unmamed, 0, ROT0,"^Cg[","AXg][",GAME_NOT_WORKING )
GAME( 1980,atmsmash,0, unmamed, unmamed, 0, ROT0,"SNK","AgX}bV[",GAME_NOT_WORKING )
GAME( 1980,barrian,0, unmamed, unmamed, 0, ROT0,"Ri~","oA",GAME_NOT_WORKING )
GAME( 1980,blckbetl,0, unmamed, unmamed, 0, ROT0,"^Cg[/scr/~c","ubNr[gY",GAME_NOT_WORKING )
GAME( 1980,blckjack,0, unmamed, unmamed, 0, ROT0,"ZK","ubNWbN",GAME_NOT_WORKING )
GAME( 1980,btleachm,0, unmamed, unmamed, 0, ROT0,"AC","r[eB[[`}[W",GAME_NOT_WORKING )
GAME( 1980,cosmopol,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","RX|X",GAME_NOT_WORKING )
GAME( 1980,dancingq,0, unmamed, unmamed, 0, ROT0,"dC","_VONC[",GAME_NOT_WORKING )
GAME( 1980,finalrag,0, unmamed, unmamed, 0, ROT0,"ovXg","t@CiW[",GAME_NOT_WORKING )
GAME( 1980,flyingst,0, unmamed, unmamed, 0, ROT0,"WR","tCOT^[",GAME_NOT_WORKING )
GAME( 1980,ftcyborg,0, unmamed, unmamed, 0, ROT0,"WR","t@C^[TC{[O",GAME_NOT_WORKING )
GAME( 1980,itazraag,0, unmamed, unmamed, 0, ROT0,"AC","G[",GAME_NOT_WORKING )
GAME( 1980,lasershk,0, unmamed, unmamed, 0, ROT0,"WR","[U[VbN",GAME_NOT_WORKING )
GAME( 1980,masuiju,0, unmamed, unmamed, 0, ROT0,"C","e",GAME_NOT_WORKING )
GAME( 1980,mazek,0, unmamed, unmamed, 0, ROT0,"Ri~","CY",GAME_NOT_WORKING )
GAME( 1980,mnhattan,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","}nb^",GAME_NOT_WORKING )
GAME( 1980,moonpuls,0, unmamed, unmamed, 0, ROT0,"{Y","[pT[",GAME_NOT_WORKING )
GAME( 1980,moonridr,0, unmamed, unmamed, 0, ROT0,"WR","[C_[",GAME_NOT_WORKING )
GAME( 1980,moontrek,0, unmamed, unmamed, 0, ROT0,"{Y","[gbN",GAME_NOT_WORKING )
GAME( 1980,neblar,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","lu[",GAME_NOT_WORKING )
GAME( 1980,ninjatai,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","퍑Eґ",GAME_NOT_WORKING )
GAME( 1980,prmonaco,0, unmamed, unmamed, 0, ROT0,"ZK","vEiRGP",GAME_NOT_WORKING )
GAME( 1980,redtank,0, unmamed, unmamed, 0, ROT0,"VO}","bh^N",GAME_NOT_WORKING )
GAME( 1980,rollngc2,0, unmamed, unmamed, 0, ROT0,"{Y","[ONbV p[gU",GAME_NOT_WORKING )
GAME( 1980,ron2mj,0, unmamed, unmamed, 0, ROT0,"VEGC","El",GAME_NOT_WORKING )
GAME( 1980,seahuntr,0, unmamed, unmamed, 0, ROT0,"^Cg[","V[n^[",GAME_NOT_WORKING )
GAME( 1980,shogun,0, unmamed, unmamed, 0, ROT0,"ZK/IJ","R",GAME_NOT_WORKING )
GAME( 1980,sidewind,0, unmamed, unmamed, 0, ROT0,"Ri~","TChC_[",GAME_NOT_WORKING )
GAME( 1980,spacecyc,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xy[XTCN",GAME_NOT_WORKING )
GAME( 1980,spbattle,0, unmamed, unmamed, 0, ROT0,"ovXg","Xy[Xog",GAME_NOT_WORKING )
GAME( 1980,starfive,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","X^[t@Cu",GAME_NOT_WORKING )
GAME( 1980,taitan,0, unmamed, unmamed, 0, ROT0,"^Cg[","^C^",GAME_NOT_WORKING )
GAME( 1980,tballoon,0, unmamed, unmamed, 0, ROT0,"^Cg[","o[",GAME_NOT_WORKING )
GAME( 1980,telejan,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","eW",GAME_NOT_WORKING )
GAME( 1980,thegoku,0, unmamed, unmamed, 0, ROT0,"VO}","THE@",GAME_NOT_WORKING )
GAME( 1980,themonky,0, unmamed, unmamed, 0, ROT0,"SNK","UEL[",GAME_NOT_WORKING )
GAME( 1980,triatack,0, unmamed, unmamed, 0, ROT0,"^Cg[","gCA^bJ[",GAME_NOT_WORKING )
GAME( 1980,warp1,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","[v 1",GAME_NOT_WORKING )
GAME( 1981,astrogat,0, unmamed, unmamed, 0, ROT0,"WebN","AXgQ[^[",GAME_NOT_WORKING )
GAME( 1981,bobit,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","{rbg",GAME_NOT_WORKING )
GAME( 1981,driblint,0, unmamed, unmamed, 0, ROT0,"^Cg[","huO",GAME_NOT_WORKING )
GAME( 1981,dsteljan,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","DSeW",GAME_NOT_WORKING )
GAME( 1981,flashboy,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","tbV{[C",GAME_NOT_WORKING )
GAME( 1981,flogspdr,0, unmamed, unmamed, 0, ROT0,"^Cg[","tbOXpC_[",GAME_NOT_WORKING )
GAME( 1981,jancerx,0, unmamed, unmamed, 0, ROT0,"{Y","WT[X",GAME_NOT_WORKING )
GAME( 1981,launchrz,0, unmamed, unmamed, 0, ROT0,"VO}","`[y",GAME_NOT_WORKING )
GAME( 1981,motoxer,0, unmamed, unmamed, 0, ROT0,"ZK","gNbT[",GAME_NOT_WORKING )
GAME( 1981,pooltabl,0, unmamed, unmamed, 0, ROT0,"Ri~","v[e[u",GAME_NOT_WORKING )
GAME( 1981,proputer,0, unmamed, unmamed, 0, ROT0,"{Y","vs[^[",GAME_NOT_WORKING )
GAME( 1981,rollstrf,0, unmamed, unmamed, 0, ROT0,"VO}","[OX^[t@C[",GAME_NOT_WORKING )
GAME( 1981,spacex,0, unmamed, unmamed, 0, ROT0,"CV","Xy[XX",GAME_NOT_WORKING )
GAME( 1981,strlaker,0, unmamed, unmamed, 0, ROT0,"ZK","X^[CJ[",GAME_NOT_WORKING )
GAME( 1981,thetower,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","UE^[",GAME_NOT_WORKING )
GAME( 1981,tkmahjan,0, unmamed, unmamed, 0, ROT0,"{Y","΋ǃ}[W",GAME_NOT_WORKING )
GAME( 1981,ttmajan2,0, unmamed, unmamed, 0, ROT0,"^Cg[","ss}[W2",GAME_NOT_WORKING )
GAME( 1981,ttmajanq,0, unmamed, unmamed, 0, ROT0,"^Cg[","ss}[Wp",GAME_NOT_WORKING )
GAME( 1981,ultradom,0, unmamed, unmamed, 0, ROT0,"Ri~","Egh[",GAME_NOT_WORKING )
GAME( 1982,boiger,0, unmamed, unmamed, 0, ROT0,"eN","{CW[",GAME_NOT_WORKING )
GAME( 1982,constela,0, unmamed, unmamed, 0, ROT0,"{Y","RXe",GAME_NOT_WORKING )
GAME( 1982,darkhose,0, unmamed, unmamed, 0, ROT0,"VEGC","_[Nz[X",GAME_NOT_WORKING )
GAME( 1982,distroyr,0, unmamed, unmamed, 0, ROT0,"UPL","fBXgC[",GAME_NOT_WORKING )
GAME( 1982,dxpunkid,0, unmamed, unmamed, 0, ROT0,"AC","fbNXp`OLbh",GAME_NOT_WORKING )
GAME( 1982,dynamite,0, unmamed, unmamed, 0, ROT0,"jo[T","~ZX_Ci}Cg",GAME_NOT_WORKING )
GAME( 1982,fevermjn,0, unmamed, unmamed, 0, ROT0,"AC","tB[o[",GAME_NOT_WORKING )
GAME( 1982,fishing,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","tBbVO",GAME_NOT_WORKING )
GAME( 1982,happydia,0, unmamed, unmamed, 0, ROT0,"AC","nbs[_Ch",GAME_NOT_WORKING )
GAME( 1982,hfkoikoi,0, unmamed, unmamed, 0, ROT0,"Z^","ԎDRCRC",GAME_NOT_WORKING )
GAME( 1982,janjnan,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 1982,litljack,0, unmamed, unmamed, 0, ROT0,"s","gWbN",GAME_NOT_WORKING )
GAME( 1982,magman,0, unmamed, unmamed, 0, ROT0,"WebN","}O}",GAME_NOT_WORKING )
GAME( 1982,maijan,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 1982,miraclht,0, unmamed, unmamed, 0, ROT0,"ZK","~Nnbg",GAME_NOT_WORKING )
GAME( 1982,missilsp,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","~TCXv^[",GAME_NOT_WORKING )
GAME( 1982,nameneko,0, unmamed, unmamed, 0, ROT0,"Lbc","Ȃ߂Ȃ",GAME_NOT_WORKING )
GAME( 1982,ohsho,0, unmamed, unmamed, 0, ROT0,"ZK/RAh","",GAME_NOT_WORKING )
GAME( 1982,probilyd,0, unmamed, unmamed, 0, ROT0,"SNK","vr[h",GAME_NOT_WORKING )
GAME( 1982,redselec,0, unmamed, unmamed, 0, ROT0,"VEGC","bhZN^[",GAME_NOT_WORKING )
GAME( 1982,rubicon,0, unmamed, unmamed, 0, ROT0,"ZK","rR",GAME_NOT_WORKING )
GAME( 1982,rushboxr,0, unmamed, unmamed, 0, ROT0,"WebN","bV{NT[",GAME_NOT_WORKING )
GAME( 1982,seljan,0, unmamed, unmamed, 0, ROT0,"_CibNX","SEL",GAME_NOT_WORKING )
GAME( 1982,skyprkng,0, unmamed, unmamed, 0, ROT0,"WebN/Xd@","XJCp[LO",GAME_NOT_WORKING )
GAME( 1982,sneakq,0, unmamed, unmamed, 0, ROT0,"UPL","Xl[Q",GAME_NOT_WORKING )
GAME( 1982,subloc3d,0, unmamed, unmamed, 0, ROT0,"ZK","Xy[XTu}ETubN3D",GAME_NOT_WORKING )
GAME( 1982,sunshegg,0, unmamed, unmamed, 0, ROT0,"^Cg[","TVCGbO",GAME_NOT_WORKING )
GAME( 1982,superglf,0, unmamed, unmamed, 0, ROT0,"WebN","X[p[St",GAME_NOT_WORKING )
GAME( 1982,tkhanafd,0, unmamed, unmamed, 0, ROT0,"{Y","΋ǉԃs[^[",GAME_NOT_WORKING )
GAME( 1982,tombling,0, unmamed, unmamed, 0, ROT0,"^Cg[","guO",GAME_NOT_WORKING )
GAME( 1982,triplpnc,0, unmamed, unmamed, 0, ROT0,"VEGC","gvp`",GAME_NOT_WORKING )
GAME( 1982,tumego,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","l",GAME_NOT_WORKING )
GAME( 1982,watedg7,0, unmamed, unmamed, 0, ROT0,"ZK/ebN","EHebhG7",GAME_NOT_WORKING )
GAME( 1982,wonderhl,0, unmamed, unmamed, 0, ROT0,"AC","_[z[",GAME_NOT_WORKING )
GAME( 1983,au,0, unmamed, unmamed, 0, ROT0,"eN","Au !",GAME_NOT_WORKING )
GAME( 1983,banpolin,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","o|",GAME_NOT_WORKING )
GAME( 1983,catfight,0, unmamed, unmamed, 0, ROT0,"s","Lbgt@C^[",GAME_NOT_WORKING )
GAME( 1983,daifugou,0, unmamed, unmamed, 0, ROT0,"Z^","x",GAME_NOT_WORKING )
GAME( 1983,discus,0, unmamed, unmamed, 0, ROT0,"ovXg","fBXJX",GAME_NOT_WORKING )
GAME( 1983,excitebb,0, unmamed, unmamed, 0, ROT0,"WR","GLTCgx[X{[",GAME_NOT_WORKING )
GAME( 1983,firefox,0, unmamed, unmamed, 0, ROT0,"A^","t@CA[tHbNX",GAME_NOT_WORKING )
GAME( 1983,footfigh,0, unmamed, unmamed, 0, ROT0,"A^","tbgt@C^[",GAME_NOT_WORKING )
GAME( 1983,friday,0, unmamed, unmamed, 0, ROT0,"UPL","tCfB",GAME_NOT_WORKING )
GAME( 1983,galleon,0, unmamed, unmamed, 0, ROT0,"{Y","MI",GAME_NOT_WORKING )
GAME( 1983,gcoaster,0, unmamed, unmamed, 0, ROT0,"jo[T","S[IS[IR[X^[",GAME_NOT_WORKING )
GAME( 1983,genmatai,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","",GAME_NOT_WORKING )
GAME( 1983,genmatal,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","^bg",GAME_NOT_WORKING )
GAME( 1983,halokity,0, unmamed, unmamed, 0, ROT0,"iR","n[LeBejX",GAME_NOT_WORKING )
GAME( 1983,hanahime,0, unmamed, unmamed, 0, ROT0,"_CibNX","ԕP",GAME_NOT_WORKING )
GAME( 1983,hangridr,0, unmamed, unmamed, 0, ROT0,"^Cg[","nOC_[",GAME_NOT_WORKING )
GAME( 1983,intrstra,0, unmamed, unmamed, 0, ROT0,"DdC","C^[Xe",GAME_NOT_WORKING )
GAME( 1983,jangou,0, unmamed, unmamed, 0, ROT0,"{Y","",GAME_NOT_WORKING )
GAME( 1983,jansen,0, unmamed, unmamed, 0, ROT0,"{Y","WZ",GAME_NOT_WORKING )
GAME( 1983,jantotsu,0, unmamed, unmamed, 0, ROT0,"Tc","Wgc",GAME_NOT_WORKING )
GAME( 1983,jgnight,0, unmamed, unmamed, 0, ROT0,"{Y","iCg",GAME_NOT_WORKING )
GAME( 1983,jokermj,0, unmamed, unmamed, 0, ROT0,"_CibNX","W[J[",GAME_NOT_WORKING )
GAME( 1983,kankickk,0, unmamed, unmamed, 0, ROT0,"JlR","JLbNLbh",GAME_NOT_WORKING )
GAME( 1983,koikoip1,0, unmamed, unmamed, 0, ROT0,"LR","",GAME_NOT_WORKING )
GAME( 1983,lasergrp,0, unmamed, unmamed, 0, ROT0,"^Cg[","[U[Ov",GAME_NOT_WORKING )
GAME( 1983,maihime,0, unmamed, unmamed, 0, ROT0,"_CibNX","P",GAME_NOT_WORKING )
GAME( 1983,majansen,0, unmamed, unmamed, 0, ROT0,"_CibNX","搶",GAME_NOT_WORKING )
GAME( 1983,marmaid,0, unmamed, unmamed, 0, ROT0,"VEGC","}[Ch",GAME_NOT_WORKING )
GAME( 1983,mjkyoust,0, unmamed, unmamed, 0, ROT0,"SNK","",GAME_NOT_WORKING )
GAME( 1983,nightgal,0, unmamed, unmamed, 0, ROT0,"{Y","iCgM",GAME_NOT_WORKING )
GAME( 1983,plumzone,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","v]",GAME_NOT_WORKING )
GAME( 1983,quizjump,0, unmamed, unmamed, 0, ROT0,"VEGC","NCYWv",GAME_NOT_WORKING )
GAME( 1983,roiyalnt,0, unmamed, unmamed, 0, ROT0,"Cdq","CiCg",GAME_NOT_WORKING )
GAME( 1983,roppyaku,0, unmamed, unmamed, 0, ROT0,"LR","ZS",GAME_NOT_WORKING )
GAME( 1983,sanninmj,0, unmamed, unmamed, 0, ROT0,"{Y","Ol}[W",GAME_NOT_WORKING )
GAME( 1983,skeater,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","XP[^[",GAME_NOT_WORKING )
GAME( 1983,sperky,0, unmamed, unmamed, 0, ROT0,"Ri~","Xp[L[",GAME_NOT_WORKING )
GAME( 1983,super7,0, unmamed, unmamed, 0, ROT0,"LR","X[p[V",GAME_NOT_WORKING )
GAME( 1983,talbot2,0, unmamed, unmamed, 0, ROT0,"ADK","^{bgp[gU",GAME_NOT_WORKING )
GAME( 1983,tangramq,0, unmamed, unmamed, 0, ROT0,"SNK","^OQ",GAME_NOT_WORKING )
GAME( 1983,timeatak,0, unmamed, unmamed, 0, ROT0,"WR","NCY^CA^bN",GAME_NOT_WORKING )
GAME( 1983,tkmjsen,0, unmamed, unmamed, 0, ROT0,"{Y","΋ǖ",GAME_NOT_WORKING )
GAME( 1983,trybomb,0, unmamed, unmamed, 0, ROT0,"ovXg","gC{",GAME_NOT_WORKING )
GAME( 1983,ultraqz,0, unmamed, unmamed, 0, ROT0,"^Cg[","AJfEgNCY",GAME_NOT_WORKING )
GAME( 1983,utamaro,0, unmamed, unmamed, 0, ROT0,"dC","E^}",GAME_NOT_WORKING )
GAME( 1983,vegasptl,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","xK[Yog",GAME_NOT_WORKING )
GAME( 1983,weddingb,0, unmamed, unmamed, 0, ROT0,"s","EFfBOx",GAME_NOT_WORKING )
GAME( 1983,zeda,0, unmamed, unmamed, 0, ROT0,"ovXg","[_",GAME_NOT_WORKING )
GAME( 1984,akazukin,0, unmamed, unmamed, 0, ROT0,"ZCuJ","Ԃ",GAME_NOT_WORKING )
GAME( 1984,arbegas,0, unmamed, unmamed, 0, ROT0,"ZK","AxKX",GAME_NOT_WORKING )
GAME( 1984,badland,0, unmamed, unmamed, 0, ROT0,"Ri~","obhY",GAME_NOT_WORKING )
GAME( 1984,champclo,0, unmamed, unmamed, 0, ROT0,"ADK","`sINbP[",GAME_NOT_WORKING )
GAME( 1984,cyclemb,0, unmamed, unmamed, 0, ROT0,"^Cg[","TCNE}[V",GAME_NOT_WORKING )
GAME( 1984,driversl,0, unmamed, unmamed, 0, ROT0,"^Cg[","hCo[YCZX",GAME_NOT_WORKING )
GAME( 1984,duckydck,0, unmamed, unmamed, 0, ROT0,"^Cg[","_bL[_bN",GAME_NOT_WORKING )
GAME( 1984,eshornml,0, unmamed, unmamed, 0, ROT0,"DdC","GV[YI~",GAME_NOT_WORKING )
GAME( 1984,fightofe,0, unmamed, unmamed, 0, ROT0,"{Y","t@CgIuGLTC^[",GAME_NOT_WORKING )
GAME( 1984,gpworld,0, unmamed, unmamed, 0, ROT0,"ZK","GP[h",GAME_NOT_WORKING )
GAME( 1984,hgatebal,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","n[Q[g{[",GAME_NOT_WORKING )
GAME( 1984,highwayj,0, unmamed, unmamed, 0, ROT0,"^Cg[/JlR","nCEFCWp[",GAME_NOT_WORKING )
GAME( 1984,intrstrz,0, unmamed, unmamed, 0, ROT0,"DdC","C^[Xe@UKX",GAME_NOT_WORKING )
GAME( 1984,itaten,0, unmamed, unmamed, 0, ROT0,"{Y","YVg",GAME_NOT_WORKING )
GAME( 1984,jangould,0, unmamed, unmamed, 0, ROT0,"{Y","fB",GAME_NOT_WORKING )
GAME( 1984,janou,0, unmamed, unmamed, 0, ROT0,"v","",GAME_NOT_WORKING )
GAME( 1984,koihime,0, unmamed, unmamed, 0, ROT0,"_CibNX","P",GAME_NOT_WORKING )
GAME( 1984,maxmile,0, unmamed, unmamed, 0, ROT0,"Ri~","}bNX}C",GAME_NOT_WORKING )
GAME( 1984,mjgolila,0, unmamed, unmamed, 0, ROT0,"_CibNX","S",GAME_NOT_WORKING )
GAME( 1984,mjking,0, unmamed, unmamed, 0, ROT0,"{Y","LO",GAME_NOT_WORKING )
GAME( 1984,msisaac1,0, unmamed, unmamed, 0, ROT0,"^Cg[","^\x83\x5cW[ACUbN",GAME_NOT_WORKING )
GAME( 1984,multirid,0, unmamed, unmamed, 0, ROT0,"ZK","}`Ch",GAME_NOT_WORKING )
GAME( 1984,nightbun,0, unmamed, unmamed, 0, ROT0,"{Y","iCgoj[",GAME_NOT_WORKING )
GAME( 1984,njhayate,0, unmamed, unmamed, 0, ROT0,"^Cg[","E҃ne",GAME_NOT_WORKING )
GAME( 1984,oozumou,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","告o",GAME_NOT_WORKING )
GAME( 1984,outrzone,0, unmamed, unmamed, 0, ROT0,"^Cg[","AE^[][",GAME_NOT_WORKING )
GAME( 1984,polepsed,0, unmamed, unmamed, 0, ROT0,"iR","|[|WV(GfBbg^Cv)",GAME_NOT_WORKING )
GAME( 1984,rumbalmb,0, unmamed, unmamed, 0, ROT0,"^Cg[","oo",GAME_NOT_WORKING )
GAME( 1984,seafly,0, unmamed, unmamed, 0, ROT0,"^Cg[","ZAt[",GAME_NOT_WORKING )
GAME( 1984,superdnq,0, unmamed, unmamed, 0, ROT0,"jo[T","X[p[hLz[e",GAME_NOT_WORKING )
GAME( 1984,superice,0, unmamed, unmamed, 0, ROT0,"Ri~","X[p[ACXzbP[",GAME_NOT_WORKING )
GAME( 1984,thundstm,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","T_[Xg[",GAME_NOT_WORKING )
GAME( 1984,tokyomie,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","hff",GAME_NOT_WORKING )
GAME( 1984,toporo,0, unmamed, unmamed, 0, ROT0,"ovXg","g|",GAME_NOT_WORKING )
GAME( 1984,tx1v8,0, unmamed, unmamed, 0, ROT0,"^c~","TX-1 V8",GAME_NOT_WORKING )
GAME( 1984,ultramj,0, unmamed, unmamed, 0, ROT0,"{Y","Eg",GAME_NOT_WORKING )
GAME( 1984,vsurbanc,0, unmamed, unmamed, 0, ROT0,"CV","VSA[o`sI",GAME_NOT_WORKING )
GAME( 1984,wilytwr2,0, unmamed, unmamed, 0, ROT0,"AC","C[^[2",GAME_NOT_WORKING )
GAME( 1985,008gun,0, unmamed, unmamed, 0, ROT0,"ZK","008@Kt@C^[",GAME_NOT_WORKING )
GAME( 1985,119,0, unmamed, unmamed, 0, ROT0,"ovXg","PPX",GAME_NOT_WORKING )
GAME( 1985,afroland,0, unmamed, unmamed, 0, ROT0,"^Cg[","At_[",GAME_NOT_WORKING )
GAME( 1985,arcard,0, unmamed, unmamed, 0, ROT0,"WR","AJ[h",GAME_NOT_WORKING )
GAME( 1985,bttlbird,0, unmamed, unmamed, 0, ROT0,"AC","ogo[h",GAME_NOT_WORKING )
GAME( 1985,byegone,0, unmamed, unmamed, 0, ROT0,"^Cg[","oCS[",GAME_NOT_WORKING )
GAME( 1985,captlung,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","LveO",GAME_NOT_WORKING )
GAME( 1985,cheanpit,0, unmamed, unmamed, 0, ROT0,"ADK","`F[sbg",GAME_NOT_WORKING )
GAME( 1985,cosmocir,0, unmamed, unmamed, 0, ROT0,"^Cg[","RXXT[Lbg",GAME_NOT_WORKING )
GAME( 1985,crwngolf,0, unmamed, unmamed, 0, ROT0,"ZK/GXR","NEYStCnC",GAME_NOT_WORKING )
GAME( 1985,ddpengin,0, unmamed, unmamed, 0, ROT0,"ZK","ǂǂyMh",GAME_NOT_WORKING )
GAME( 1985,downhill,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","_Eqt@C^[",GAME_NOT_WORKING )
GAME( 1985,empstbak,0, unmamed, unmamed, 0, ROT0,"A^","GpCAXgCNobN",GAME_NOT_WORKING )
GAME( 1985,exntgame,0, unmamed, unmamed, 0, ROT0,"^Cg[","GLTCeBOiCgQ[",GAME_NOT_WORKING )
GAME( 1985,geinouss,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","|\x94\x5cli",GAME_NOT_WORKING )
GAME( 1985,getall,0, unmamed, unmamed, 0, ROT0,"ZK/TNZX","QbgI[",GAME_NOT_WORKING )
GAME( 1985,hanaaw6,0, unmamed, unmamed, 0, ROT0,"Z^","ԍ킹6EGTEX TURBO FEVER",GAME_NOT_WORKING )
GAME( 1985,hanaroyl,0, unmamed, unmamed, 0, ROT0,"{Y","ԃC",GAME_NOT_WORKING )
GAME( 1985,hypupdwn,0, unmamed, unmamed, 0, ROT0,"ovXg","nCp[Abv_E",GAME_NOT_WORKING )
GAME( 1985,janoh2,0, unmamed, unmamed, 0, ROT0,"SNK","Ui_CibNXj",GAME_NOT_WORKING )
GAME( 1985,jansin,0, unmamed, unmamed, 0, ROT0,"_CibNX","_",GAME_NOT_WORKING )
GAME( 1985,konamisc,0, unmamed, unmamed, 0, ROT0,"Ri~","Ri~̃TbJ[",GAME_NOT_WORKING )
GAME( 1985,lnghouse,0, unmamed, unmamed, 0, ROT0,"rfIVXe","WF[nEX",GAME_NOT_WORKING )
GAME( 1985,longhitr,0, unmamed, unmamed, 0, ROT0,"^Cg[","Oqb^[",GAME_NOT_WORKING )
GAME( 1985,mjjanmu,0, unmamed, unmamed, 0, ROT0,"EBO","",GAME_NOT_WORKING )
GAME( 1985,mjyarou,0, unmamed, unmamed, 0, ROT0,"rXR","Y",GAME_NOT_WORKING )
GAME( 1985,ntgalsum,0, unmamed, unmamed, 0, ROT0,"{Y","iCgMT}[",GAME_NOT_WORKING )
GAME( 1985,pjanputr,0, unmamed, unmamed, 0, ROT0,"ADK","p[tFNgWs[^[",GAME_NOT_WORKING )
GAME( 1985,roadblas,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","[huX^[",GAME_NOT_WORKING )
GAME( 1985,ryokusnp,0, unmamed, unmamed, 0, ROT0,"eN/GeNm","̋N",GAME_NOT_WORKING )
GAME( 1985,scrambl2,0, unmamed, unmamed, 0, ROT0,"Ri~","XNuQ",GAME_NOT_WORKING )
GAME( 1985,sexygal,0, unmamed, unmamed, 0, ROT0,"{Y","ZNV[M",GAME_NOT_WORKING )
GAME( 1985,sixdevil,0, unmamed, unmamed, 0, ROT0,"ZK","VbNXfr",GAME_NOT_WORKING )
GAME( 1985,skydstry,0, unmamed, unmamed, 0, ROT0,"^Cg[","XJCfXgC[",GAME_NOT_WORKING )
GAME( 1985,spcross,0, unmamed, unmamed, 0, ROT0,"ovXg","X[p[NX",GAME_NOT_WORKING )
GAME( 1985,spdead2,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[fbgq[gU",GAME_NOT_WORKING )
GAME( 1985,spdeadht,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[fbgq[g",GAME_NOT_WORKING )
GAME( 1985,speederb,0, unmamed, unmamed, 0, ROT0,"Ri~","Xs[_[oCN",GAME_NOT_WORKING )
GAME( 1985,sppinpon,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[s|",GAME_NOT_WORKING )
GAME( 1985,supergal,0, unmamed, unmamed, 0, ROT0,"Ri~","X[p[M",GAME_NOT_WORKING )
GAME( 1985,suprwing,0, unmamed, unmamed, 0, ROT0,"UPL","X[p[EBO",GAME_NOT_WORKING )
GAME( 1985,sweetgal,0, unmamed, unmamed, 0, ROT0,"{Y","XEB[gM",GAME_NOT_WORKING )
GAME( 1985,tadaimat,0, unmamed, unmamed, 0, ROT0,"ZK/RAh","ܓP",GAME_NOT_WORKING )
GAME( 1985,taikyoku,0, unmamed, unmamed, 0, ROT0,"WR","Ɍ",GAME_NOT_WORKING )
GAME( 1985,thex,0, unmamed, unmamed, 0, ROT0,"eN","UEX",GAME_NOT_WORKING )
GAME( 1985,timegal,0, unmamed, unmamed, 0, ROT0,"^Cg[","^CM",GAME_NOT_WORKING )
GAME( 1985,tokaido,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","C\x8f\x5cO",GAME_NOT_WORKING )
GAME( 1985,tokyomi2,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","hff2",GAME_NOT_WORKING )
GAME( 1985,topgear,0, unmamed, unmamed, 0, ROT0,"jo[T","gbvMA",GAME_NOT_WORKING )
GAME( 1985,uchuseny,0, unmamed, unmamed, 0, ROT0,"^Cg[","F̓}g",GAME_NOT_WORKING )
GAME( 1985,vanalblt,0, unmamed, unmamed, 0, ROT0,"^Cg[","oAxg",GAME_NOT_WORKING )
GAME( 1985,wildboy,0, unmamed, unmamed, 0, ROT0,"^Cg[","Ch{[C",GAME_NOT_WORKING )
GAME( 1985,wyvernf0,0, unmamed, unmamed, 0, ROT0,"^Cg[","Co[ e-0",GAME_NOT_WORKING )
GAME( 1985,yakumanc,0, unmamed, unmamed, 0, ROT0,"LR","𖞃Nu",GAME_NOT_WORKING )
GAME( 1986,armwresg,0, unmamed, unmamed, 0, ROT0,"CV","A[XO",GAME_NOT_WORKING )
GAME( 1986,atakdon2,0, unmamed, unmamed, 0, ROT0,"^Cg[","A^bNhh",GAME_NOT_WORKING )
GAME( 1986,babeltwr,0, unmamed, unmamed, 0, ROT0,"iR","ox̓",GAME_NOT_WORKING )
GAME( 1986,banbanbt,0, unmamed, unmamed, 0, ROT0,"eN","oor[g",GAME_NOT_WORKING )
GAME( 1986,bopeep,0, unmamed, unmamed, 0, ROT0,"ZK/RAh","{s[v",GAME_NOT_WORKING )
GAME( 1986,btltank,0, unmamed, unmamed, 0, ROT0,"^Cg[","og^N",GAME_NOT_WORKING )
GAME( 1986,dangle,0, unmamed, unmamed, 0, ROT0,"{Y","_O",GAME_NOT_WORKING )
GAME( 1986,galias,0, unmamed, unmamed, 0, ROT0,"AC","KAX̗v",GAME_NOT_WORKING )
GAME( 1986,janoh3,0, unmamed, unmamed, 0, ROT0,"SNK","Vi_CibNXj",GAME_NOT_WORKING )
GAME( 1986,lapius,0, unmamed, unmamed, 0, ROT0,"eN","sAX",GAME_NOT_WORKING )
GAME( 1986,lionex,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","CIlbNX",GAME_NOT_WORKING )
GAME( 1986,lonewolf,0, unmamed, unmamed, 0, ROT0,"^Cg[","[Et",GAME_NOT_WORKING )
GAME( 1986,mightang,0, unmamed, unmamed, 0, ROT0,"WR","}CeBGWF",GAME_NOT_WORKING )
GAME( 1986,mjparlor,0, unmamed, unmamed, 0, ROT0,"WR","p[[",GAME_NOT_WORKING )
GAME( 1986,mjsenka,0, unmamed, unmamed, 0, ROT0,"ZCuJ","",GAME_NOT_WORKING )
GAME( 1986,pickpack,0, unmamed, unmamed, 0, ROT0,"ovXg","PICK PACK",GAME_NOT_WORKING )
GAME( 1986,pooyan2,0, unmamed, unmamed, 0, ROT0,"Ri~","v[̖`",GAME_NOT_WORKING )
GAME( 1986,sjrakira,0, unmamed, unmamed, 0, ROT0,"^Cg[","Vlނ炿",GAME_NOT_WORKING )
GAME( 1986,slapshtr,0, unmamed, unmamed, 0, ROT0,"ZK","XbvV[^[",GAME_NOT_WORKING )
GAME( 1986,slipstep,0, unmamed, unmamed, 0, ROT0,"^Cg[","XbvXebv",GAME_NOT_WORKING )
GAME( 1986,spaclove,0, unmamed, unmamed, 0, ROT0,"ZK","Xy[Xu",GAME_NOT_WORKING )
GAME( 1986,spchinse,0, unmamed, unmamed, 0, ROT0,"iR/J`[u[","X[p[`Cj[Y",GAME_NOT_WORKING )
GAME( 1986,spcross2,0, unmamed, unmamed, 0, ROT0,"ovXg","X[p[NXU",GAME_NOT_WORKING )
GAME( 1986,valkbokn,0, unmamed, unmamed, 0, ROT0,"iR","L[̖`",GAME_NOT_WORKING )
GAME( 1986,violents,0, unmamed, unmamed, 0, ROT0,"^Cg[","oCIgV[eBO",GAME_NOT_WORKING )
GAME( 1986,vstriang,0, unmamed, unmamed, 0, ROT0,"_CibNX","VSgCAO",GAME_NOT_WORKING )
GAME( 1986,warball,0, unmamed, unmamed, 0, ROT0,"ZK","EH[{[",GAME_NOT_WORKING )
GAME( 1986,weltotgm,0, unmamed, unmamed, 0, ROT0,"^Cg[","EFJ@gD@U@gW[Q[",GAME_NOT_WORKING )
GAME( 1986,wldstdhm,0, unmamed, unmamed, 0, ROT0,"iR","[hX^WAz[ReXg",GAME_NOT_WORKING )
GAME( 1987,6d1,0, unmamed, unmamed, 0, ROT0,"{Y","6D-1",GAME_NOT_WORKING )
GAME( 1987,avmjvdys,0, unmamed, unmamed, 0, ROT0,"{Y","AV rfI̗d",GAME_NOT_WORKING )
GAME( 1987,besthit,0, unmamed, unmamed, 0, ROT0,"ZK","U@xXgqbg",GAME_NOT_WORKING )
GAME( 1987,blckbstr,0, unmamed, unmamed, 0, ROT0,"WR","ubNoX^[",GAME_NOT_WORKING )
GAME( 1987,eaglet,0, unmamed, unmamed, 0, ROT0,"eN","C[O",GAME_NOT_WORKING )
GAME( 1987,extracrd,0, unmamed, unmamed, 0, ROT0,"{Y","GNXgJ[h",GAME_NOT_WORKING )
GAME( 1987,famboxi,0, unmamed, unmamed, 0, ROT0,"iR/EbhvCX","t@~[{NVO",GAME_NOT_WORKING )
GAME( 1987,famtenis,0, unmamed, unmamed, 0, ROT0,"iR","t@~[ejX",GAME_NOT_WORKING )
GAME( 1987,firstlan,0, unmamed, unmamed, 0, ROT0,"Ri~","t@[Xg[",GAME_NOT_WORKING )
GAME( 1987,gacho,0, unmamed, unmamed, 0, ROT0,"AC","mKb`",GAME_NOT_WORKING )
GAME( 1987,gelnica,0, unmamed, unmamed, 0, ROT0,"AC","dbYkQjJ",GAME_NOT_WORKING )
GAME( 1987,grifight,0, unmamed, unmamed, 0, ROT0,"eN","O_CAt@Cg",GAME_NOT_WORKING )
GAME( 1987,janbow2,0, unmamed, unmamed, 0, ROT0,"SNK","W{E2",GAME_NOT_WORKING )
GAME( 1987,liberty7,0, unmamed, unmamed, 0, ROT0,"{Y","oeBZu",GAME_NOT_WORKING )
GAME( 1987,madyula,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","}hD[̗",GAME_NOT_WORKING )
GAME( 1987,megumirc,0, unmamed, unmamed, 0, ROT0,"ZK","ߑgXL[",GAME_NOT_WORKING )
GAME( 1987,midlansp,0, unmamed, unmamed, 0, ROT0,"^Cg[","~bhiCgfBO@XyVVer.",GAME_NOT_WORKING )
GAME( 1987,reapian,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","[rA",GAME_NOT_WORKING )
GAME( 1987,shtgzon2,0, unmamed, unmamed, 0, ROT0,"ZK","V[eBO][2",GAME_NOT_WORKING )
GAME( 1987,shtgzone,0, unmamed, unmamed, 0, ROT0,"ZK","V[eBO][",GAME_NOT_WORKING )
GAME( 1987,southkid,0, unmamed, unmamed, 0, ROT0,"^Cg[","TULbh̓",GAME_NOT_WORKING )
GAME( 1987,supermot,0, unmamed, unmamed, 0, ROT0,"Ri~","X[p[gNX",GAME_NOT_WORKING )
GAME( 1987,touchme,0, unmamed, unmamed, 0, ROT0,"Ri~","^b`~[",GAME_NOT_WORKING )
GAME( 1987,trnmarka,0, unmamed, unmamed, 0, ROT0,"^Cg[","g[igAJmCh",GAME_NOT_WORKING )
GAME( 1987,twinbee2,0, unmamed, unmamed, 0, ROT0,"Ri~","cCr[2",GAME_NOT_WORKING )
GAME( 1987,yukai2ki,0, unmamed, unmamed, 0, ROT0,"ZCuJ","JCc[JC",GAME_NOT_WORKING )
GAME( 1988,armchamp,0, unmamed, unmamed, 0, ROT0,"WR/[{","A[`v",GAME_NOT_WORKING )
GAME( 1988,centerct,0, unmamed, unmamed, 0, ROT0,"ZK","Z^[R[g",GAME_NOT_WORKING )
GAME( 1988,cntlyclb,0, unmamed, unmamed, 0, ROT0,"SNK","Jg[Nu",GAME_NOT_WORKING )
GAME( 1988,famsta88,0, unmamed, unmamed, 0, ROT0,"iR","t@~[X^WAf88",GAME_NOT_WORKING )
GAME( 1988,fightgolf,0, unmamed, unmamed, 0, ROT0,"SNK","[grm̃t@CeBOSt",GAME_NOT_WORKING )
GAME( 1988,firstdwn,0, unmamed, unmamed, 0, ROT0,"^Cg[","t@[Xg_E",GAME_NOT_WORKING )
GAME( 1988,gforce,0, unmamed, unmamed, 0, ROT0,"ZK","MNV[tH[X",GAME_NOT_WORKING )
GAME( 1988,hanashob,0, unmamed, unmamed, 0, ROT0,"_CibNX","؏Ҋ",GAME_NOT_WORKING )
GAME( 1988,heavyunt,0, unmamed, unmamed, 0, ROT0,"JlR","wr[jbg",GAME_NOT_WORKING )
GAME( 1988,huddleup,0, unmamed, unmamed, 0, ROT0,"AC","nhAbv",GAME_NOT_WORKING )
GAME( 1988,janyuki,0, unmamed, unmamed, 0, ROT0,"_CibNX","VL",GAME_NOT_WORKING )
GAME( 1988,kinobokn,0, unmamed, unmamed, 0, ROT0,"iR/Q[X^WI","JC̖`",GAME_NOT_WORKING )
GAME( 1988,photomj,0, unmamed, unmamed, 0, ROT0,"ZK/TgX/zCg{[h","tHg",GAME_NOT_WORKING )
GAME( 1988,realmjgy,0, unmamed, unmamed, 0, ROT0,"Ao","肠閃[ǖv",GAME_NOT_WORKING )
GAME( 1988,spcirkit,0, unmamed, unmamed, 0, ROT0,"ZK","X[p[T[Lbg",GAME_NOT_WORKING )
GAME( 1988,temption,0, unmamed, unmamed, 0, ROT0,"_CibNX","eve[V",GAME_NOT_WORKING )
GAME( 1988,topshter,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","gbvV[^[",GAME_NOT_WORKING )
GAME( 1988,vsgtenis,0, unmamed, unmamed, 0, ROT0,"WR","VSO[gejX",GAME_NOT_WORKING )
GAME( 1989,battleax,0, unmamed, unmamed, 0, ROT0,"ZK","ogAbNX",GAME_NOT_WORKING )
GAME( 1989,captude,0, unmamed, unmamed, 0, ROT0,"ZK","Lv`[h",GAME_NOT_WORKING )
GAME( 1989,destruct,0, unmamed, unmamed, 0, ROT0,"C[XgeNmW[","fXgNV",GAME_NOT_WORKING )
GAME( 1989,dokaben2,0, unmamed, unmamed, 0, ROT0,"JvR","hJx2",GAME_NOT_WORKING )
GAME( 1989,gollirac,0, unmamed, unmamed, 0, ROT0,"ovXg","SR}h",GAME_NOT_WORKING )
GAME( 1989,grdius2s,0, unmamed, unmamed, 0, ROT0,"Ri~","OfBEXII (OIIIACfAVer.)",GAME_NOT_WORKING )
GAME( 1989,grdius3s,0, unmamed, unmamed, 0, ROT0,"Ri~","OfBEXIII (Show Ver.)",GAME_NOT_WORKING )
GAME( 1989,hanaagem,0, unmamed, unmamed, 0, ROT0,"{Y","Ԃ̂܂",GAME_NOT_WORKING )
GAME( 1989,hanajudn,0, unmamed, unmamed, 0, ROT0,"_CibNX","؎a",GAME_NOT_WORKING )
GAME( 1989,karon,0, unmamed, unmamed, 0, ROT0,"ZK","J",GAME_NOT_WORKING )
GAME( 1989,kyukokab,0, unmamed, unmamed, 0, ROT0,"Ri~","}~",GAME_NOT_WORKING )
GAME( 1989,metalfrz,0, unmamed, unmamed, 0, ROT0,"ZCuJ","^t[U[",GAME_NOT_WORKING )
GAME( 1989,mjgekish,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 1989,mjsaiyuk,0, unmamed, unmamed, 0, ROT0,"{Y"," VL",GAME_NOT_WORKING )
GAME( 1989,ohhaipie,0, unmamed, unmamed, 0, ROT0,"{Y","OHIvs[",GAME_NOT_WORKING )
GAME( 1989,pepplpl,0, unmamed, unmamed, 0, ROT0,"^Cg[","ybvv",GAME_NOT_WORKING )
GAME( 1989,progolfg,0, unmamed, unmamed, 0, ROT0,"iR","vSt OhX",GAME_NOT_WORKING )
GAME( 1989,sagaia,0, unmamed, unmamed, 0, ROT0,"^Cg[","T[KCA",GAME_NOT_WORKING )
GAME( 1989,salamnds,0, unmamed, unmamed, 0, ROT0,"Ri~","֎ (OIIIACfAVer.)",GAME_NOT_WORKING )
GAME( 1989,shadowwr,0, unmamed, unmamed, 0, ROT0,"eN","Vh[EHA[Y",GAME_NOT_WORKING )
GAME( 1989,slotgal,0, unmamed, unmamed, 0, ROT0,"UPL","XbgM",GAME_NOT_WORKING )
GAME( 1989,tougenk,0, unmamed, unmamed, 0, ROT0,"{Y","",GAME_NOT_WORKING )
GAME( 1989,winrunsz,namcos2x, unmamed, unmamed, 0, ROT0,"iR","ECjO 鎭Ov",GAME_NOT_WORKING )
GAME( 1989,zerowin2,0, unmamed, unmamed, 0, ROT0,"v","[EBO (2P Ver.)",GAME_NOT_WORKING )
GAME( 199?,ff3,0, unmamed, unmamed, 0, ROT0,"JvR","t@Cit@CgR",GAME_NOT_WORKING )
GAME( 199?,inazumas,0, unmamed, unmamed, 0, ROT0,"eNm\x83\x5ctg","ȃZCo[",GAME_NOT_WORKING )
GAME( 199?,koutets2,0, unmamed, unmamed, 0, ROT0,"zbg rB","|S鍑2",GAME_NOT_WORKING )
GAME( 199?,kuuga2,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","2",GAME_NOT_WORKING )
GAME( 199?,p47ii,0, unmamed, unmamed, 0, ROT0,"WR","P-47 II",GAME_NOT_WORKING )
GAME( 199?,samraigl,0, unmamed, unmamed, 0, ROT0,"s","TCM",GAME_NOT_WORKING )
GAME( 199?,silverml,0, unmamed, unmamed, 0, ROT0,"s","Vo[~jA",GAME_NOT_WORKING )
GAME( 199?,spbblpop,neogeou, unmamed, unmamed, 0, ROT0,"xNgIWbN","X[p[ou|bv",GAME_NOT_WORKING )
GAME( 199?,tooga,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","",GAME_NOT_WORKING )
GAME( 1990,asttenki,0, unmamed, unmamed, 0, ROT0,"JvR","VCɂȂ",GAME_NOT_WORKING )
GAME( 1990,bishojos,0, unmamed, unmamed, 0, ROT0,"{Y","̑f",GAME_NOT_WORKING )
GAME( 1990,blockpal,neogeou, unmamed, unmamed, 0, ROT0,"ADK","ubNp_CX",GAME_NOT_WORKING )
GAME( 1990,braifight,0, unmamed, unmamed, 0, ROT0,"^Cg[","m",GAME_NOT_WORKING )
GAME( 1990,contzero,0, unmamed, unmamed, 0, ROT0,"ZK","JEg[",GAME_NOT_WORKING )
GAME( 1990,gal1bans,0, unmamed, unmamed, 0, ROT0,"{Y","M̈ԍ",GAME_NOT_WORKING )
GAME( 1990,hamerway,0, unmamed, unmamed, 0, ROT0,"ZK/TgX","n}[EFC",GAME_NOT_WORKING )
GAME( 1990,hanajngi,0, unmamed, unmamed, 0, ROT0,"_CibNX","ؐm`",GAME_NOT_WORKING )
GAME( 1990,hanamaru,0, unmamed, unmamed, 0, ROT0,"{Y","Ԃ܂q",GAME_NOT_WORKING )
GAME( 1990,hanaxmas,0, unmamed, unmamed, 0, ROT0,"{Y","LD Ԃ̃NX}XCu",GAME_NOT_WORKING )
GAME( 1990,lastsurv,0, unmamed, unmamed, 0, ROT0,"ZK","XgToCo[",GAME_NOT_WORKING )
GAME( 1990,loops,0, unmamed, unmamed, 0, ROT0,"JvR","[vX",GAME_NOT_WORKING )
GAME( 1990,magicrod,neogeou, unmamed, unmamed, 0, ROT0,"ADK","}WJbh",GAME_NOT_WORKING )
GAME( 1990,mtlrabit,0, unmamed, unmamed, 0, ROT0,"rfIVXe.","^rbg",GAME_NOT_WORKING )
GAME( 1990,neogeou,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_neogeo",GAME_NOT_WORKING )
GAME( 1990,parastar,0, unmamed, unmamed, 0, ROT0,"^Cg[","p\x83\x5cX^[",GAME_NOT_WORKING )
GAME( 1990,pipy,0, unmamed, unmamed, 0, ROT0,"iR","pCsB",GAME_NOT_WORKING )
GAME( 1990,pplandbt,0, unmamed, unmamed, 0, ROT0,"eN","PP-hog",GAME_NOT_WORKING )
GAME( 1990,royalpol,0, unmamed, unmamed, 0, ROT0,"^Cg[","Cv[",GAME_NOT_WORKING )
GAME( 1990,suhadaym,0, unmamed, unmamed, 0, ROT0,"{Y","f̖l",GAME_NOT_WORKING )
GAME( 1990,sunshine,neogeou, unmamed, unmamed, 0, ROT0,"ADK","TVC",GAME_NOT_WORKING )
GAME( 1990,twoshot,0, unmamed, unmamed, 0, ROT0,"{Y","c[Vbg",GAME_NOT_WORKING )
GAME( 1990,yanchcat,0, unmamed, unmamed, 0, ROT0,"{Y","񂿂ȎqL",GAME_NOT_WORKING )
GAME( 1990,yumekoib,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 1991,arcanum,0, unmamed, unmamed, 0, ROT0,"^Cg[","AJi",GAME_NOT_WORKING )
GAME( 1991,bontorun,0, unmamed, unmamed, 0, ROT0,"Ri~","{[ gD ",GAME_NOT_WORKING )
GAME( 1991,ceptima,0, unmamed, unmamed, 0, ROT0,"ZK","ZveB}",GAME_NOT_WORKING )
GAME( 1991,dunkstar,neogeou, unmamed, unmamed, 0, ROT0,"rXR","_NX^[",GAME_NOT_WORKING )
GAME( 1991,finalmsn,0, unmamed, unmamed, 0, ROT0,"UPL","t@Ci~bV",GAME_NOT_WORKING )
GAME( 1991,funfunbl,neogeou, unmamed, unmamed, 0, ROT0,"ADK","t@t@uU[Y",GAME_NOT_WORKING )
GAME( 1991,gunfroex,0, unmamed, unmamed, 0, ROT0,"^Cg[","KteBA@GLXgo[W",GAME_NOT_WORKING )
GAME( 1991,hanaangl,0, unmamed, unmamed, 0, ROT0,"{Y","Ԃ̃GWFtFCX",GAME_NOT_WORKING )
GAME( 1991,hanakara,0, unmamed, unmamed, 0, ROT0,"{Y","Ԃ̊kԂ",GAME_NOT_WORKING )
GAME( 1991,hanatens,0, unmamed, unmamed, 0, ROT0,"_CibNX","΂́uؓVgv",GAME_NOT_WORKING )
GAME( 1991,hologram,0, unmamed, unmamed, 0, ROT0,"ZK","^Cgx[ zO",GAME_NOT_WORKING )
GAME( 1991,ladymakr,0, unmamed, unmamed, 0, ROT0,"{Y","fB[J[",GAME_NOT_WORKING )
GAME( 1991,ldmjmbhm,0, unmamed, unmamed, 0, ROT0,"{Y","LD@}u[̓",GAME_NOT_WORKING )
GAME( 1991,ldquizdd,0, unmamed, unmamed, 0, ROT0,"{Y","LD QUIZNCYDEf[g",GAME_NOT_WORKING )
GAME( 1991,maddogmc,0, unmamed, unmamed, 0, ROT0,"JvR","}bhhbO}bN[",GAME_NOT_WORKING )
GAME( 1991,metlblex,0, unmamed, unmamed, 0, ROT0,"^Cg[","^ubN@GLXgo[W",GAME_NOT_WORKING )
GAME( 1991,mjichibk,0, unmamed, unmamed, 0, ROT0,"GNZ","Ԑ",GAME_NOT_WORKING )
GAME( 1991,mjougon,0, unmamed, unmamed, 0, ROT0,"_CibNX","̔v",GAME_NOT_WORKING )
GAME( 1991,mjtokyuk,0, unmamed, unmamed, 0, ROT0,"_CibNX","}]",GAME_NOT_WORKING )
GAME( 1991,mjvegas,0, unmamed, unmamed, 0, ROT0,"_CibNX","xKX",GAME_NOT_WORKING )
GAME( 1991,mysticw,neogeou, unmamed, unmamed, 0, ROT0,"ADK","~XeBbNh",GAME_NOT_WORKING )
GAME( 1991,rugenok,0, unmamed, unmamed, 0, ROT0,"{Y","[W̍",GAME_NOT_WORKING )
GAME( 1991,sideefct,0, unmamed, unmamed, 0, ROT0,"^Cg[","TChGtFNg",GAME_NOT_WORKING )
GAME( 1991,with,0, unmamed, unmamed, 0, ROT0,"WR","WITH",GAME_NOT_WORKING )
GAME( 1991,youyublk,0, unmamed, unmamed, 0, ROT0,"^Cg[","䂤̃ubN",GAME_NOT_WORKING )
GAME( 1992,bustblaz,neogeou, unmamed, unmamed, 0, ROT0,"ADK","NX\x83\x5c[hII@oX^[uCY",GAME_NOT_WORKING )
GAME( 1992,danjtest,0, unmamed, unmamed, 0, ROT0,"{Y","jƏ̐SeXg",GAME_NOT_WORKING )
GAME( 1992,finalpld,0, unmamed, unmamed, 0, ROT0,"{Y","t@Cip[h",GAME_NOT_WORKING )
GAME( 1992,frontrow,0, unmamed, unmamed, 0, ROT0,"q[}","tgE",GAME_NOT_WORKING )
GAME( 1992,hanzou,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","n]E",GAME_NOT_WORKING )
GAME( 1992,ias,0, unmamed, unmamed, 0, ROT0,"^Cg[","hD`Dr",GAME_NOT_WORKING )
GAME( 1992,janshi,0, unmamed, unmamed, 0, ROT0,"eN","t",GAME_NOT_WORKING )
GAME( 1992,mjronjan,0, unmamed, unmamed, 0, ROT0,"tFCX","",GAME_NOT_WORKING )
GAME( 1992,opart,0, unmamed, unmamed, 0, ROT0,"ZK/TNZX","I[p[c",GAME_NOT_WORKING )
GAME( 1992,speedskt,0, unmamed, unmamed, 0, ROT0,"ZK","Xs[hoXPbg",GAME_NOT_WORKING )
GAME( 1992,sprintst,0, unmamed, unmamed, 0, ROT0,"ZK","XvgX^[",GAME_NOT_WORKING )
GAME( 1992,tokmekct,0, unmamed, unmamed, 0, ROT0,"^Cg[","gLL`[g",GAME_NOT_WORKING )
GAME( 1992,yunolgnd,0, unmamed, unmamed, 0, ROT0,"^Cg[","m̓`",GAME_NOT_WORKING )
GAME( 1993,angelwsp,0, unmamed, unmamed, 0, ROT0,"AC","G[EBXp[",GAME_NOT_WORKING )
GAME( 1993,athtekag,0, unmamed, unmamed, 0, ROT0,"^Cg[","AXeJ̐_",GAME_NOT_WORKING )
GAME( 1993,battalin,0, unmamed, unmamed, 0, ROT0,"iR","o^A",GAME_NOT_WORKING )
GAME( 1993,cavespdr,0, unmamed, unmamed, 0, ROT0,"^Cg[","PCuXs[_[",GAME_NOT_WORKING )
GAME( 1993,cgangpnl,0, unmamed, unmamed, 0, ROT0,"iR","RXMOEUEpl",GAME_NOT_WORKING )
GAME( 1993,chalhitr,0, unmamed, unmamed, 0, ROT0,"^Cg[","`Wqb^[",GAME_NOT_WORKING )
GAME( 1993,chanta,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","`^ƃX[̃NXŃ|",GAME_NOT_WORKING )
GAME( 1993,cps2u,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_cps2",GAME_NOT_WORKING )
GAME( 1993,cvsterra,0, unmamed, unmamed, 0, ROT0,"^Cg[","TCo[Xe",GAME_NOT_WORKING )
GAME( 1993,dogyuuno,0, unmamed, unmamed, 0, ROT0,"v","hM[ (Show Ver.)",GAME_NOT_WORKING )
GAME( 1993,dreambal,0, unmamed, unmamed, 0, ROT0,"NDK","h[{[",GAME_NOT_WORKING )
GAME( 1993,dt7,0, unmamed, unmamed, 0, ROT0,"v","_Ci~bNgCA7",GAME_NOT_WORKING )
GAME( 1993,enmadaio,0, unmamed, unmamed, 0, ROT0,"v","ܑ剤",GAME_NOT_WORKING )
GAME( 1993,enmadx,0, unmamed, unmamed, 0, ROT0,"v","ܑ剤DX",GAME_NOT_WORKING )
GAME( 1993,galax3pd,0, unmamed, unmamed, 0, ROT0,"iR","MNVA3 vWFNghO[",GAME_NOT_WORKING )
GAME( 1993,gemurani,0, unmamed, unmamed, 0, ROT0,"{Y","WF̐肢X",GAME_NOT_WORKING )
GAME( 1993,gridfigt,0, unmamed, unmamed, 0, ROT0,"^Cg[","Obht@C^[",GAME_NOT_WORKING )
GAME( 1993,kokorozy,0, unmamed, unmamed, 0, ROT0,"ZK","ꂢRRW[",GAME_NOT_WORKING )
GAME( 1993,loonychn,0, unmamed, unmamed, 0, ROT0,"ZK","[j[`F[",GAME_NOT_WORKING )
GAME( 1993,mindesct,0, unmamed, unmamed, 0, ROT0,"^Cg[","}ChGXR[g",GAME_NOT_WORKING )
GAME( 1993,mjcafedl,0, unmamed, unmamed, 0, ROT0,"_CibNX","JtFh[",GAME_NOT_WORKING )
GAME( 1993,pukunott,0, unmamed, unmamed, 0, ROT0,"AC","Ղ񂨂Ƃ",GAME_NOT_WORKING )
GAME( 1993,quizcmbq,0, unmamed, unmamed, 0, ROT0,"WR","NCY΂Q",GAME_NOT_WORKING )
GAME( 1993,quizdk,0, unmamed, unmamed, 0, ROT0,"AgX","NCYhSiCg",GAME_NOT_WORKING )
GAME( 1993,saikyobt,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg/G|bN^}J","ŋog[`",GAME_NOT_WORKING )
GAME( 1993,sdburnin,0, unmamed, unmamed, 0, ROT0,"ovXg","SDK_O` o[jOA^bN",GAME_NOT_WORKING )
GAME( 1993,shotway2,0, unmamed, unmamed, 0, ROT0,"iR","V[^EFCU",GAME_NOT_WORKING )
GAME( 1993,spd3boss,0, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[cRanr",GAME_NOT_WORKING )
GAME( 1993,streetvip,0, unmamed, unmamed, 0, ROT0,"iR/vgW[","Xg[goCp[",GAME_NOT_WORKING )
GAME( 1993,twilsprd,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","gCCgXvbh",GAME_NOT_WORKING )
GAME( 1993,uso800,0, unmamed, unmamed, 0, ROT0,"ovXg","USO800",GAME_NOT_WORKING )
GAME( 1993,vartexer,0, unmamed, unmamed, 0, ROT0,"^Cg[","o[eNT[",GAME_NOT_WORKING )
GAME( 1993,winforce,0, unmamed, unmamed, 0, ROT0,"AgX","EBOtH[X",GAME_NOT_WORKING )
GAME( 1993,xday,0, unmamed, unmamed, 0, ROT0,"iR","X-DAY",GAME_NOT_WORKING )
GAME( 1994,ban2bstr,neogeou, unmamed, unmamed, 0, ROT0,"rXR","oooX^[Y",GAME_NOT_WORKING )
GAME( 1994,bestelvn,0, unmamed, unmamed, 0, ROT0,"AC","xXgCu",GAME_NOT_WORKING )
GAME( 1994,bisibasi,0, unmamed, unmamed, 0, ROT0,"^Cg[","rVoV",GAME_NOT_WORKING )
GAME( 1994,carib,neogeou, unmamed, unmamed, 0, ROT0,"tFCX","Ju̍",GAME_NOT_WORKING )
GAME( 1994,chasebom,0, unmamed, unmamed, 0, ROT0,"^Cg[","`FCX{o[Y",GAME_NOT_WORKING )
GAME( 1994,chicago,neogeou, unmamed, unmamed, 0, ROT0,"rXR","Vق̏@܌",GAME_NOT_WORKING )
GAME( 1994,dice3,0, unmamed, unmamed, 0, ROT0,"AC","_CX_CX_CX",GAME_NOT_WORKING )
GAME( 1994,distopia,0, unmamed, unmamed, 0, ROT0,"v","EfBXgsA",GAME_NOT_WORKING )
GAME( 1994,gaiden2,neogeou, unmamed, unmamed, 0, ROT0,"eN","EҊO`II",GAME_NOT_WORKING )
GAME( 1994,galax3az,0, unmamed, unmamed, 0, ROT0,"iR","MNVA3 A^bNIu U ]MA",GAME_NOT_WORKING )
GAME( 1994,galpn2sp,0, unmamed, unmamed, 0, ROT0,"JlR","MYpjbNU XyVGfBV",GAME_NOT_WORKING )
GAME( 1994,galumpa,cps2u, unmamed, unmamed, 0, ROT0,"~b`F"," (Japan 9406**)",GAME_NOT_WORKING )
GAME( 1994,headoncn,0, unmamed, unmamed, 0, ROT0,"ZK","wbhI`l",GAME_NOT_WORKING )
GAME( 1994,mjcafdlg,0, unmamed, unmamed, 0, ROT0,"_CibNX","JtFh[O[g",GAME_NOT_WORKING )
GAME( 1994,mjreach2,0, unmamed, unmamed, 0, ROT0,"_CibNX","2",GAME_NOT_WORKING )
GAME( 1994,nakidwar,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","lCLbhEH[",GAME_NOT_WORKING )
GAME( 1994,onecegun,0, unmamed, unmamed, 0, ROT0,"ZK","TK",GAME_NOT_WORKING )
GAME( 1994,paknban2,0, unmamed, unmamed, 0, ROT0,"JlR","pbNoo",GAME_NOT_WORKING )
GAME( 1994,popoithe,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","||BƁ@ւׂꂯ",GAME_NOT_WORKING )
GAME( 1994,pzlclub,neogeou, unmamed, unmamed, 0, ROT0,"rXR","pYbRNu",GAME_NOT_WORKING )
GAME( 1994,qzmzidol,0, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","NCY߂ACh",GAME_NOT_WORKING )
GAME( 1994,realpunc,0, unmamed, unmamed, 0, ROT0,"^Cg[","Ap`[",GAME_NOT_WORKING )
GAME( 1994,spangpzl,0, unmamed, unmamed, 0, ROT0,"q[}","ro`mfIro`mfI",GAME_NOT_WORKING )
GAME( 1994,spstrikr,0, unmamed, unmamed, 0, ROT0,"WR","X[p[XgCJ[",GAME_NOT_WORKING )
GAME( 1994,sptfishn,0, unmamed, unmamed, 0, ROT0,"ZK","X|[ctBbVO",GAME_NOT_WORKING )
GAME( 1994,sstrongw,0, unmamed, unmamed, 0, ROT0,"WR","X[p[XgOEHA[Y",GAME_NOT_WORKING )
GAME( 1994,starltft,0, unmamed, unmamed, 0, ROT0,"ZK","X^[CgtH[`",GAME_NOT_WORKING )
GAME( 1994,streetjam,0, unmamed, unmamed, 0, ROT0,"WR","Xg[gW",GAME_NOT_WORKING )
GAME( 1994,svoll94,neogeou, unmamed, unmamed, 0, ROT0,"rfIVXe.","X[p[o[94",GAME_NOT_WORKING )
GAME( 1994,tekipak2,0, unmamed, unmamed, 0, ROT0,"v","]Q[sdjhEo`jhQ",GAME_NOT_WORKING )
GAME( 1995,airwalkr,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","GAEH[J[Y",GAME_NOT_WORKING )
GAME( 1995,akamajan,0, unmamed, unmamed, 0, ROT0,"p_CXdq","Ԗ",GAME_NOT_WORKING )
GAME( 1995,allstarv,neogeou, unmamed, unmamed, 0, ROT0,"@/z[f[^","I[X^[o[",GAME_NOT_WORKING )
GAME( 1995,anmlznpw,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","Aj}]p[",GAME_NOT_WORKING )
GAME( 1995,burnstrt,0, unmamed, unmamed, 0, ROT0,"eN","o[jOXg[g",GAME_NOT_WORKING )
GAME( 1995,calmaeye,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","J}AC",GAME_NOT_WORKING )
GAME( 1995,citydive,0, unmamed, unmamed, 0, ROT0,"^Cg[","VeB_Co[",GAME_NOT_WORKING )
GAME( 1995,comandwr,0, unmamed, unmamed, 0, ROT0,"eN","R}hEH[",GAME_NOT_WORKING )
GAME( 1995,dirtdush,namcos2x, unmamed, unmamed, 0, ROT0,"iR","_[g_bV",GAME_NOT_WORKING )
GAME( 1995,dreamsym,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","h[VtHj[̐ff",GAME_NOT_WORKING )
GAME( 1995,fallism,0, unmamed, unmamed, 0, ROT0,"^Cg[","tHY",GAME_NOT_WORKING )
GAME( 1995,feeldscr,0, unmamed, unmamed, 0, ROT0,"Ri~","tB[hTbJ[",GAME_NOT_WORKING )
GAME( 1995,fotbalft,0, unmamed, unmamed, 0, ROT0,"eN","tbg{[t@C^[",GAME_NOT_WORKING )
GAME( 1995,gakuenbt,0, unmamed, unmamed, 0, ROT0,"AgX","woGeB[",GAME_NOT_WORKING )
GAME( 1995,goalstrm,0, unmamed, unmamed, 0, ROT0,"Ri~","S[Xg[",GAME_NOT_WORKING )
GAME( 1995,hanagokb,0, unmamed, unmamed, 0, ROT0,"_CibNX","،܌ԊO",GAME_NOT_WORKING )
GAME( 1995,hoopitup,0, unmamed, unmamed, 0, ROT0,"A^","t[v Cbg Abv",GAME_NOT_WORKING )
GAME( 1995,kakattek,0, unmamed, unmamed, 0, ROT0,"eN/IMS","ĂȂ",GAME_NOT_WORKING )
GAME( 1995,kakutouv,neogeou, unmamed, unmamed, 0, ROT0,"rfIVXe.","io[",GAME_NOT_WORKING )
GAME( 1995,lodyssey,neogeou, unmamed, unmamed, 0, ROT0,"mX","XgIfbZC",GAME_NOT_WORKING )
GAME( 1995,mjraijin,0, unmamed, unmamed, 0, ROT0,"_CibNX","_v",GAME_NOT_WORKING )
GAME( 1995,mjsdchka,0, unmamed, unmamed, 0, ROT0,"_CibNX","X[p[咆،",GAME_NOT_WORKING )
GAME( 1995,mjtensin,0, unmamed, unmamed, 0, ROT0,"_CibNX","V_v",GAME_NOT_WORKING )
GAME( 1995,muku2pon,0, unmamed, unmamed, 0, ROT0,"WR","ނނPONI",GAME_NOT_WORKING )
GAME( 1995,netmark,0, unmamed, unmamed, 0, ROT0,"ZK","lbg}[N",GAME_NOT_WORKING )
GAME( 1995,ninsoukt,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","lӒc",GAME_NOT_WORKING )
GAME( 1995,oosaka,0, unmamed, unmamed, 0, ROT0,"eN","U",GAME_NOT_WORKING )
GAME( 1995,pzbancho,0, unmamed, unmamed, 0, ROT0,"tEL","t]pYԒ",GAME_NOT_WORKING )
GAME( 1995,qmagical,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WJrW",GAME_NOT_WORKING )
GAME( 1995,railcha2,0, unmamed, unmamed, 0, ROT0,"ZK","[`FCX2",GAME_NOT_WORKING )
GAME( 1995,redzone,0, unmamed, unmamed, 0, ROT0,"WR","sRED ZONE",GAME_NOT_WORKING )
GAME( 1995,rgear,0, unmamed, unmamed, 0, ROT0,"^Cg[","A[MA",GAME_NOT_WORKING )
GAME( 1995,spedking,0, unmamed, unmamed, 0, ROT0,"Ri~","Xs[hLO",GAME_NOT_WORKING )
GAME( 1995,spriggan,0, unmamed, unmamed, 0, ROT0,"RpC","b@XvKp[h",GAME_NOT_WORKING )
GAME( 1995,stoon,neogeou, unmamed, unmamed, 0, ROT0,"AC}bNX","Αrsnnm",GAME_NOT_WORKING )
GAME( 1995,tanteiya,0, unmamed, unmamed, 0, ROT0,"WR","TYibN",GAME_NOT_WORKING )
GAME( 1995,techdoll,0, unmamed, unmamed, 0, ROT0,"{Y","eNmh[",GAME_NOT_WORKING )
GAME( 1995,tesouran,0, unmamed, unmamed, 0, ROT0,"ZK","葊Ȃ Ƃ݂",GAME_NOT_WORKING )
GAME( 1995,timbokan,0, unmamed, unmamed, 0, ROT0,"ovXg","^C{J",GAME_NOT_WORKING )
GAME( 1995,trumpman,0, unmamed, unmamed, 0, ROT0,"WR","UEgv}",GAME_NOT_WORKING )
GAME( 1995,trumpmn2,0, unmamed, unmamed, 0, ROT0,"WR","gv}̕svc}WbNɒI",GAME_NOT_WORKING )
GAME( 1995,vicviper,0, unmamed, unmamed, 0, ROT0,"Ri~","rbOoCp[",GAME_NOT_WORKING )
GAME( 1995,warlock,neogeou, unmamed, unmamed, 0, ROT0,"AYebN21","_L",GAME_NOT_WORKING )
GAME( 1995,xmenaou,cps2u, unmamed, unmamed, 0, ROT0,"JvR","X-MEN AOUo[W",GAME_NOT_WORKING )
GAME( 1996,aquajet,namcos2x, unmamed, unmamed, 0, ROT0,"iR","ANAWFbg",GAME_NOT_WORKING )
GAME( 1996,attimuit,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","ނăzC",GAME_NOT_WORKING )
GAME( 1996,caveu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_cave",GAME_NOT_WORKING )
GAME( 1996,cdlmagic,0, unmamed, unmamed, 0, ROT0,"^Cg[","Vf}WbN",GAME_NOT_WORKING )
GAME( 1996,daitoyok,0, unmamed, unmamed, 0, ROT0,"_CibNX","哌m",GAME_NOT_WORKING )
GAME( 1996,droppers,neogeou, unmamed, unmamed, 0, ROT0,"rfIVXe.","hbp[Y@V̑`",GAME_NOT_WORKING )
GAME( 1996,eyeoftp,neogeou, unmamed, unmamed, 0, ROT0,"rbR","ɒ",GAME_NOT_WORKING )
GAME( 1996,ginoutai,0, unmamed, unmamed, 0, ROT0,"iR","Z]",GAME_NOT_WORKING )
GAME( 1996,hanabotn,0, unmamed, unmamed, 0, ROT0,"_CibNX","؉O",GAME_NOT_WORKING )
GAME( 1996,jetwave,0, unmamed, unmamed, 0, ROT0,"Ri~","WFbgEF[u",GAME_NOT_WORKING )
GAME( 1996,jnsnplus,0, unmamed, unmamed, 0, ROT0,"_CibNX","_PLUS",GAME_NOT_WORKING )
GAME( 1996,karatenj,neogeou, unmamed, unmamed, 0, ROT0,"H[","Eҁ@",GAME_NOT_WORKING )
GAME( 1996,kickgogo,0, unmamed, unmamed, 0, ROT0,"ZK","LbNEAES[S[",GAME_NOT_WORKING )
GAME( 1996,magznopw,0, unmamed, unmamed, 0, ROT0,"ZK","}WJ]p[",GAME_NOT_WORKING )
GAME( 1996,mjseiryu,0, unmamed, unmamed, 0, ROT0,"_CibNX","`",GAME_NOT_WORKING )
GAME( 1996,mjtkmkjg,0, unmamed, unmamed, 0, ROT0,"XtBNX","Ƃ߂w",GAME_NOT_WORKING )
GAME( 1996,pairwars,neogeou, unmamed, unmamed, 0, ROT0,"T\x83\x5ctg","ւׂꂯ̃yAyAEH[Y",GAME_NOT_WORKING )
GAME( 1996,piponcho,0, unmamed, unmamed, 0, ROT0,"f[^C[Xg","NCY܂Pipon`I",GAME_NOT_WORKING )
GAME( 1996,qdrmfg3,0, unmamed, unmamed, 0, ROT0,"Ri~","NCYh~t@Ov3",GAME_NOT_WORKING )
GAME( 1996,qzwatasi,0, unmamed, unmamed, 0, ROT0,"WR","NCY̋C",GAME_NOT_WORKING )
GAME( 1996,realfigt,0, unmamed, unmamed, 0, ROT0,"^Cg[","At@C^[",GAME_NOT_WORKING )
GAME( 1996,retrnsel,0, unmamed, unmamed, 0, ROT0,"{Y","^[IuSEL",GAME_NOT_WORKING )
GAME( 1996,risoutan,0, unmamed, unmamed, 0, ROT0,"ZK/c","zT",GAME_NOT_WORKING )
GAME( 1996,rtrnsel2,0, unmamed, unmamed, 0, ROT0,"_CibNX","^[IuSELII",GAME_NOT_WORKING )
GAME( 1996,solasslt,0, unmamed, unmamed, 0, ROT0,"Ri~","\x83\x5c[[ATg",GAME_NOT_WORKING )
GAME( 1996,staraudt,0, unmamed, unmamed, 0, ROT0,"iR","X^AI[fBV",GAME_NOT_WORKING )
GAME( 1996,tokyowar,namcos2x, unmamed, unmamed, 0, ROT0,"iR","g[L[EH[Y",GAME_NOT_WORKING )
GAME( 1996,ultimat4,neogeou, unmamed, unmamed, 0, ROT0,"tFCX","AeBbgS",GAME_NOT_WORKING )
GAME( 1996,waverun,0, unmamed, unmamed, 0, ROT0,"ZK","EF[ui[",GAME_NOT_WORKING )
GAME( 1996,wldpkscr,0, unmamed, unmamed, 0, ROT0,"WR","[hojTbJ[V2",GAME_NOT_WORKING )
GAME( 1997,3dtarott,0, unmamed, unmamed, 0, ROT0,"ZK","3DEUE^bg",GAME_NOT_WORKING )
GAME( 1997,abnomalc,0, unmamed, unmamed, 0, ROT0,"iR","Aum[}`FbN",GAME_NOT_WORKING )
GAME( 1997,armagirr,namcos2x, unmamed, unmamed, 0, ROT0,"iR","A}W[VO",GAME_NOT_WORKING )
GAME( 1997,aromaclb,0, unmamed, unmamed, 0, ROT0,"ZK","A}Nu A}es[̐ff",GAME_NOT_WORKING )
GAME( 1997,bbsecond,0, unmamed, unmamed, 0, ROT0,"SNK","r[XgoX^[Y@ZJhiCgA",GAME_NOT_WORKING )
GAME( 1997,cashking,0, unmamed, unmamed, 0, ROT0,"WR","JVLO",GAME_NOT_WORKING )
GAME( 1997,ddpblue,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I@(Campaign Ver.)",GAME_NOT_WORKING )
GAME( 1997,fightush,0, unmamed, unmamed, 0, ROT0,"Ri~","t@CeBOp",GAME_NOT_WORKING )
GAME( 1997,finalhln,0, unmamed, unmamed, 0, ROT0,"iR","t@Cin",GAME_NOT_WORKING )
GAME( 1997,galpan3d,0, unmamed, unmamed, 0, ROT0,"JlR","MYpjbN3D",GAME_NOT_WORKING )
GAME( 1997,gappori2,neogeou, unmamed, unmamed, 0, ROT0,"rfIVXe.","傫ӂ܂ăKb|",GAME_NOT_WORKING )
GAME( 1997,gundogs,0, unmamed, unmamed, 0, ROT0,"ZCuJ","KhbOX",GAME_NOT_WORKING )
GAME( 1997,huusuids,0, unmamed, unmamed, 0, ROT0,"ovXg","`",GAME_NOT_WORKING )
GAME( 1997,liniastr,0, unmamed, unmamed, 0, ROT0,"ZK","jAXgCJ[",GAME_NOT_WORKING )
GAME( 1997,mahoujuk,neogeou, unmamed, unmamed, 0, ROT0,"UEX/R[|[V","܂قキ",GAME_NOT_WORKING )
GAME( 1997,monkyfwa,0, unmamed, unmamed, 0, ROT0,"TCY","L`b`̂ӂӂpY",GAME_NOT_WORKING )
GAME( 1997,pickle,0, unmamed, unmamed, 0, ROT0,"ovXg","҂",GAME_NOT_WORKING )
GAME( 1997,qp,neogeou, unmamed, unmamed, 0, ROT0,"TNZX","po (NCYp[eB)",GAME_NOT_WORKING )
GAME( 1997,sams64,0, unmamed, unmamed, 0, ROT0,"SNK","@`TCXsbc`",GAME_NOT_WORKING )
GAME( 1997,skydev,0, unmamed, unmamed, 0, ROT0,"Ri~","XJCfoXe[^[",GAME_NOT_WORKING )
GAME( 1997,speeddiv,0, unmamed, unmamed, 0, ROT0,"JlR","Xs[h_Cu",GAME_NOT_WORKING )
GAME( 1997,tokimeki,0, unmamed, unmamed, 0, ROT0,"Ri~","Ƃ߂A@ăAn[g",GAME_NOT_WORKING )
GAME( 1997,yukibuta,0, unmamed, unmamed, 0, ROT0,"JlR/PCu","Lu^} P",GAME_NOT_WORKING )
GAME( 1998,aleck64u,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_aleck64",GAME_NOT_WORKING )
GAME( 1998,chaosht,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","JIXq[g",GAME_NOT_WORKING )
GAME( 1998,cyvrnpls,0, unmamed, unmamed, 0, ROT0,"JlR","TC@[vX",GAME_NOT_WORKING )
GAME( 1998,ddrevol,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V",GAME_NOT_WORKING )
GAME( 1998,dynabb98,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_Ci}Cgx[X{['98",GAME_NOT_WORKING )
GAME( 1998,elevbeat,aleck64u, unmamed, unmamed, 0, ROT0,"rXR","Cur[g",GAME_NOT_WORKING )
GAME( 1998,gnetu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_g-net",GAME_NOT_WORKING )
GAME( 1998,hofdead2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","UEnEXEIuEUEfbh2",GAME_NOT_WORKING )
GAME( 1998,janptrsp,0, unmamed, unmamed, 0, ROT0,"_CibNX","Ws[^[SP",GAME_NOT_WORKING )
GAME( 1998,lamachin,0, unmamed, unmamed, 0, ROT0,"ZK","kD`D}VKY",GAME_NOT_WORKING )
GAME( 1998,mgtrocav,0, unmamed, unmamed, 0, ROT0,"ZK","}WJgbRAhx`[",GAME_NOT_WORKING )
GAME( 1998,mjmhlump,0, unmamed, unmamed, 0, ROT0,"p_CXdq","@̃v",GAME_NOT_WORKING )
GAME( 1998,mjnenrik,0, unmamed, unmamed, 0, ROT0,"/IGS","O͎",GAME_NOT_WORKING )
GAME( 1998,naomixu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_naomi",GAME_NOT_WORKING )
GAME( 1998,oceanhnt,0, unmamed, unmamed, 0, ROT0,"ZK","I[Vn^[",GAME_NOT_WORKING )
GAME( 1998,ofbeatrc,0, unmamed, unmamed, 0, ROT0,"SNK","Itr[g[T[I",GAME_NOT_WORKING )
GAME( 1998,popnm,djmain, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN",GAME_NOT_WORKING )
GAME( 1998,raycriss,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","CNCVX",GAME_NOT_WORKING )
GAME( 1998,skichamp,0, unmamed, unmamed, 0, ROT0,"ZK","XL[`v",GAME_NOT_WORKING )
GAME( 1998,sys573u,0, unmamed, unmamed, 0, ROT0,"Ri~","_Ήi_system573",GAME_NOT_WORKING )
GAME( 1998,vj,0, unmamed, unmamed, 0, ROT0,"WR","VJirfIWbL[j",GAME_NOT_WORKING )
GAME( 1998,wkwkmnst,0, unmamed, unmamed, 0, ROT0,"Ag","킭킭X^[",GAME_NOT_WORKING )
GAME( 1999,18wheelr,naomixu, unmamed, unmamed, 0, ROT0,"ZK","GCeB[EzC[[Y",GAME_NOT_WORKING )
GAME( 1999,47pie3,naomixu, unmamed, unmamed, 0, ROT0,"WR","AChm@X[`[pCIII",GAME_NOT_WORKING )
GAME( 1999,airlinep,naomixu, unmamed, unmamed, 0, ROT0,"ZK","GACpCbc",GAME_NOT_WORKING )
GAME( 1999,anglking,0, unmamed, unmamed, 0, ROT0,"iR","AO[LO",GAME_NOT_WORKING )
GAME( 1999,barairo,0, unmamed, unmamed, 0, ROT0,"iR","J^NCY@oF}Ct[`[",GAME_NOT_WORKING )
GAME( 1999,batlgear,0, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA",GAME_NOT_WORKING )
GAME( 1999,bm2dx,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw",GAME_NOT_WORKING )
GAME( 1999,cafebrek,0, unmamed, unmamed, 0, ROT0,"_CibNX","JtFuCN",GAME_NOT_WORKING )
GAME( 1999,cafepara,0, unmamed, unmamed, 0, ROT0,"_CibNX","JtFp_CX",GAME_NOT_WORKING )
GAME( 1999,criszone,0, unmamed, unmamed, 0, ROT0,"iR","NCVX][",GAME_NOT_WORKING )
GAME( 1999,crsytaxi,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NCW[^NV[",GAME_NOT_WORKING )
GAME( 1999,dboclub,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_[r[I[i[YNu",GAME_NOT_WORKING )
GAME( 1999,doa2,naomixu, unmamed, unmamed, 0, ROT0,"eN","fbhIAACu2",GAME_NOT_WORKING )
GAME( 1999,drmmania,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","h}jA",GAME_NOT_WORKING )
GAME( 1999,dttshang,naomixu, unmamed, unmamed, 0, ROT0,"ZK","dVgΐ햃VO",GAME_NOT_WORKING )
GAME( 1999,dynabb99,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_Ci}Cgx[X{['99",GAME_NOT_WORKING )
GAME( 1999,f355chal,naomixu, unmamed, unmamed, 0, ROT0,"ZK","F355`W",GAME_NOT_WORKING )
GAME( 1999,flipmaze,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/Moss","tbvCY",GAME_NOT_WORKING )
GAME( 1999,gachacmp,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","K`K`v",GAME_NOT_WORKING )
GAME( 1999,giantgrm,naomixu, unmamed, unmamed, 0, ROT0,"ZK","S{vXQ@WCAgO",GAME_NOT_WORKING )
GAME( 1999,gtfleaks,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NX",GAME_NOT_WORKING )
GAME( 1999,guitrjam,0, unmamed, unmamed, 0, ROT0,"iR","M^[W",GAME_NOT_WORKING )
GAME( 1999,gunbeat,naomixu, unmamed, unmamed, 0, ROT0,"gW[","Kr[g",GAME_NOT_WORKING )
GAME( 1999,hanapoko,naomixu, unmamed, unmamed, 0, ROT0,"PCu","Ђ݂̉ԃ|R",GAME_NOT_WORKING )
GAME( 1999,hanaretu,0, unmamed, unmamed, 0, ROT0,"_CibNX","ؗz`",GAME_NOT_WORKING )
GAME( 1999,hanatubk,0, unmamed, unmamed, 0, ROT0,"_CibNX","ؒ",GAME_NOT_WORKING )
GAME( 1999,hikaruu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_hikaru",GAME_NOT_WORKING )
GAME( 1999,hsangel,namcos1x, unmamed, unmamed, 0, ROT0,"iR","NCY@nCXN[GWF",GAME_NOT_WORKING )
GAME( 1999,hyperbis,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","nCp[rVoV`v",GAME_NOT_WORKING )
GAME( 1999,jinchool,0, unmamed, unmamed, 0, ROT0,"{VXe","li񂿂[j",GAME_NOT_WORKING )
GAME( 1999,jumpgrv,0, unmamed, unmamed, 0, ROT0,"iR","WsOO[",GAME_NOT_WORKING )
GAME( 1999,kouhuku,0, unmamed, unmamed, 0, ROT0,"iR","J^NCY K̗l",GAME_NOT_WORKING )
GAME( 1999,kurutstn,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NbgXg[",GAME_NOT_WORKING )
GAME( 1999,landhigh,0, unmamed, unmamed, 0, ROT0,"^Cg[","fBOnCWp",GAME_NOT_WORKING )
GAME( 1999,mahjanoh,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/","",GAME_NOT_WORKING )
GAME( 1999,marstv,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ΐ`lE}[Ysu",GAME_NOT_WORKING )
GAME( 1999,mayjisn3,aleck64u, unmamed, unmamed, 0, ROT0,"Z^","w ܌w3",GAME_NOT_WORKING )
GAME( 1999,mjdaihao,0, unmamed, unmamed, 0, ROT0,"_CibNX","e",GAME_NOT_WORKING )
GAME( 1999,mjjanou,0, unmamed, unmamed, 0, ROT0,"_CibNX","c",GAME_NOT_WORKING )
GAME( 1999,mjtenku,0, unmamed, unmamed, 0, ROT0,"_CibNX","V̐_",GAME_NOT_WORKING )
GAME( 1999,optiger,0, unmamed, unmamed, 0, ROT0,"^Cg[","Iy[V^CK[",GAME_NOT_WORKING )
GAME( 1999,otenami,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","ĂȂݔq",GAME_NOT_WORKING )
GAME( 1999,outtrigr,naomixu, unmamed, unmamed, 0, ROT0,"ZK","AEggK[",GAME_NOT_WORKING )
GAME( 1999,popnstag,djmain, unmamed, unmamed, 0, ROT0,"Ri~","|bvXe[W",GAME_NOT_WORKING )
GAME( 1999,powershb,0, unmamed, unmamed, 0, ROT0,"^Cg[","p[Vxɏ낤II",GAME_NOT_WORKING )
GAME( 1999,puyopyda,naomixu, unmamed, unmamed, 0, ROT0,"ZK/RpC","ՂՂc`I",GAME_NOT_WORKING )
GAME( 1999,pwrsmash,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","p[X}bV",GAME_NOT_WORKING )
GAME( 1999,pwrstone,naomixu, unmamed, unmamed, 0, ROT0,"JvR","p[Xg[",GAME_NOT_WORKING )
GAME( 1999,raceon,0, unmamed, unmamed, 0, ROT0,"iR","Race on!",GAME_NOT_WORKING )
GAME( 1999,ravmastr,0, unmamed, unmamed, 0, ROT0,"WR","C}X^[",GAME_NOT_WORKING )
GAME( 1999,rcdego,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","RCGO!",GAME_NOT_WORKING )
GAME( 1999,ringout4,naomixu, unmamed, unmamed, 0, ROT0,"ZK","OAEgS~S ",GAME_NOT_WORKING )
GAME( 1999,sambade,naomixu, unmamed, unmamed, 0, ROT0,"ZK/\x83\x5cjbN`[","ToDEA~[S",GAME_NOT_WORKING )
GAME( 1999,sgtetris,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ZKegX",GAME_NOT_WORKING )
GAME( 1999,shoboshi,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","hm uCut@C[t@C^[Y",GAME_NOT_WORKING )
GAME( 1999,spawn,naomixu, unmamed, unmamed, 0, ROT0,"JvR","X|[",GAME_NOT_WORKING )
GAME( 1999,spmajl99,naomixu, unmamed, unmamed, 0, ROT0,"ZK","X[p[W[[O'99",GAME_NOT_WORKING )
GAME( 1999,sppzlbbl,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","X[p[pY{u",GAME_NOT_WORKING )
GAME( 1999,stepstg2,0, unmamed, unmamed, 0, ROT0,"WR","XebsOXe[WQ Xv[",GAME_NOT_WORKING )
GAME( 1999,stpchamp,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","Xebv`v",GAME_NOT_WORKING )
GAME( 1999,submrins,0, unmamed, unmamed, 0, ROT0,"iR","Tu}Y",GAME_NOT_WORKING )
GAME( 1999,tmmjprd2,0, unmamed, unmamed, 0, ROT0,"fBA","Ƃ߂p_CX -fBAE}CEu `ǂǂҁ`",GAME_NOT_WORKING )
GAME( 1999,touchde,naomixu, unmamed, unmamed, 0, ROT0,"ZK","^b`fEm[!",GAME_NOT_WORKING )
GAME( 1999,toyfight,naomixu, unmamed, unmamed, 0, ROT0,"ZK","gCt@C^[",GAME_NOT_WORKING )
GAME( 1999,unjamalm,0, unmamed, unmamed, 0, ROT0,"iR","EW}~[",GAME_NOT_WORKING )
GAME( 1999,viperu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_viper",GAME_NOT_WORKING )
GAME( 1999,vjdash,0, unmamed, unmamed, 0, ROT0,"WR","VJ DASH",GAME_NOT_WORKING )
GAME( 1999,vstr2000,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`XgCJ[2@o[W2000",GAME_NOT_WORKING )
GAME( 1999,zombervg,naomixu, unmamed, unmamed, 0, ROT0,"ZK","]rxW",GAME_NOT_WORKING )
GAME( 2000,alienfrt,naomixu, unmamed, unmamed, 0, ROT0,"ZK","GCAtg",GAME_NOT_WORKING )
GAME( 2000,animecmp,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","Aj`v",GAME_NOT_WORKING )
GAME( 2000,batlgea2,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA2",GAME_NOT_WORKING )
GAME( 2000,benh2000,0, unmamed, unmamed, 0, ROT0,"C^bNWp","xn[2000",GAME_NOT_WORKING )
GAME( 2000,blodror3,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ubfBAR",GAME_NOT_WORKING )
GAME( 2000,bm3dx,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIII",GAME_NOT_WORKING )
GAME( 2000,confmisn,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","RtBfV~bV",GAME_NOT_WORKING )
GAME( 2000,crackndj,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NbLDJ",GAME_NOT_WORKING )
GAME( 2000,cvs1,naomixu, unmamed, unmamed, 0, ROT0,"JvR/SNK","JvR vs SNK ~jAt@Cg2000",GAME_NOT_WORKING )
GAME( 2000,dancemx,0, unmamed, unmamed, 0, ROT0,"Ri~","_X}jAbNX",GAME_NOT_WORKING )
GAME( 2000,deathcri,naomixu, unmamed, unmamed, 0, ROT0,"ZK/GR[","fXN]OX",GAME_NOT_WORKING )
GAME( 2000,dendeg3,0, unmamed, unmamed, 0, ROT0,"^Cg[","dԂGo!3ʋΕ",GAME_NOT_WORKING )
GAME( 2000,doa2m,naomixu, unmamed, unmamed, 0, ROT0,"eN","fbhIAACu2~jA",GAME_NOT_WORKING )
GAME( 2000,dreamodt,0, unmamed, unmamed, 0, ROT0,"WR","h[I[fBV",GAME_NOT_WORKING )
GAME( 2000,ganbareu,0, unmamed, unmamed, 0, ROT0,"^Cg[","΂^]m!!",GAME_NOT_WORKING )
GAME( 2000,genbadeg,0, unmamed, unmamed, 0, ROT0,"^Cg[","ŃKK ssJv",GAME_NOT_WORKING )
GAME( 2000,ggx,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMA [NX",GAME_NOT_WORKING )
GAME( 2000,giantg2k,naomixu, unmamed, unmamed, 0, ROT0,"ZK","WCAgO2000 S{vXR h̗EҒB",GAME_NOT_WORKING )
GAME( 2000,gigawin2,naomixu, unmamed, unmamed, 0, ROT0,"JvR/^N~","MKECO2",GAME_NOT_WORKING )
GAME( 2000,gunmania,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","K}jA",GAME_NOT_WORKING )
GAME( 2000,gunmanzp,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","K}jA ][vX",GAME_NOT_WORKING )
GAME( 2000,gunspike,naomixu, unmamed, unmamed, 0, ROT0,"JvR/ʋ","KXpCN",GAME_NOT_WORKING )
GAME( 2000,hanaboub,0, unmamed, unmamed, 0, ROT0,"_CibNX","؛",GAME_NOT_WORKING )
GAME( 2000,hanarose,0, unmamed, unmamed, 0, ROT0,"_CibNX","ԎDiCg[Y",GAME_NOT_WORKING )
GAME( 2000,hdlchamp,sys573u, unmamed, unmamed, 0, ROT0,"Ri~","nh`v",GAME_NOT_WORKING )
GAME( 2000,jambosfr,naomixu, unmamed, unmamed, 0, ROT0,"ZK","W{ITt@",GAME_NOT_WORKING )
GAME( 2000,justice2,naomixu, unmamed, unmamed, 0, ROT0,"JvR","R!WXeBXw",GAME_NOT_WORKING )
GAME( 2000,keisatsu,viperu, unmamed, unmamed, 0, ROT0,"Ri~","UEx@ Vh24",GAME_NOT_WORKING )
GAME( 2000,kinkyu24,viperu, unmamed, unmamed, 0, ROT0,"Ri~","ً}ԗ24",GAME_NOT_WORKING )
GAME( 2000,km,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","L[{[h}jA",GAME_NOT_WORKING )
GAME( 2000,koiparad,0, unmamed, unmamed, 0, ROT0,"iR","̃pp",GAME_NOT_WORKING )
GAME( 2000,marinfis,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ZK } tBbVO",GAME_NOT_WORKING )
GAME( 2000,mawasund,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","܂킷񂾁`",GAME_NOT_WORKING )
GAME( 2000,mjdaisng,0, unmamed, unmamed, 0, ROT0,"_CibNX","O",GAME_NOT_WORKING )
GAME( 2000,mjgojas,0, unmamed, unmamed, 0, ROT0,"_CibNX","S[WXiCg",GAME_NOT_WORKING )
GAME( 2000,mjhouou,0, unmamed, unmamed, 0, ROT0,"_CibNX","P",GAME_NOT_WORKING )
GAME( 2000,mjhouryu,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 2000,mjnighti,0, unmamed, unmamed, 0, ROT0,"_CibNX","iCgC[W",GAME_NOT_WORKING )
GAME( 2000,mjsikinr,0, unmamed, unmamed, 0, ROT0,"_CibNX","O",GAME_NOT_WORKING )
GAME( 2000,mjswtacd,0, unmamed, unmamed, 0, ROT0,"_CibNX","XEB[gAJf~[",GAME_NOT_WORKING )
GAME( 2000,mvsc2,naomixu, unmamed, unmamed, 0, ROT0,"JvR","}[uvsJvR2",GAME_NOT_WORKING )
GAME( 2000,nascarac,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","iXJ[A[P[h",GAME_NOT_WORKING )
GAME( 2000,ninjaasl,naomixu, unmamed, unmamed, 0, ROT0,"iR","jWATg",GAME_NOT_WORKING )
GAME( 2000,ohmygods,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NCY_܂@`ƋɁ`",GAME_NOT_WORKING )
GAME( 2000,otopane,0, unmamed, unmamed, 0, ROT0,"WR","pl",GAME_NOT_WORKING )
GAME( 2000,panicprk,0, unmamed, unmamed, 0, ROT0,"iR","pjbNp[N",GAME_NOT_WORKING )
GAME( 2000,planeth,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","vlbgnA[Y",GAME_NOT_WORKING )
GAME( 2000,ppp,viperu, unmamed, unmamed, 0, ROT0,"Ri~","ppp_CX",GAME_NOT_WORKING )
GAME( 2000,pride2k,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","PRIDE GP 2000",GAME_NOT_WORKING )
GAME( 2000,psyvaria,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","TC@A",GAME_NOT_WORKING )
GAME( 2000,psyvarir,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","TC@ArW",GAME_NOT_WORKING )
GAME( 2000,pwrston2,naomixu, unmamed, unmamed, 0, ROT0,"JvR","p[Xg[Q",GAME_NOT_WORKING )
GAME( 2000,ridger5,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","bW[T[V A[P[hog",GAME_NOT_WORKING )
GAME( 2000,sambade2,naomixu, unmamed, unmamed, 0, ROT0,"ZK/\x83\x5cjbN`[","ToDEA~[Sver2000",GAME_NOT_WORKING )
GAME( 2000,shakatan,naomixu, unmamed, unmamed, 0, ROT0,"ZK","VJƃ^o",GAME_NOT_WORKING )
GAME( 2000,shansrsr,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","C `ėՁ`",GAME_NOT_WORKING )
GAME( 2000,slashout,naomixu, unmamed, unmamed, 0, ROT0,"ZK","XbVAEg",GAME_NOT_WORKING )
GAME( 2000,stoukon4,naomixu, unmamed, unmamed, 0, ROT0,"iR","V{vXO`4",GAME_NOT_WORKING )
GAME( 2000,strikeft,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ZKXgCNt@C^[",GAME_NOT_WORKING )
GAME( 2000,sw1racer,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","X^[EH[Y Gs\x83\x5c[h1[T[EA[P[h",GAME_NOT_WORKING )
GAME( 2000,sxyreac3,0, unmamed, unmamed, 0, ROT0,"T~[","p`RZNV[ANVR }eBbNtY@võT}[oP[V",GAME_NOT_WORKING )
GAME( 2000,sys2x6u,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_system2x6",GAME_NOT_WORKING )
GAME( 2000,taikonot,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl",GAME_NOT_WORKING )
GAME( 2000,tmw2000,0, unmamed, unmamed, 0, ROT0,"eN","eN[hJbv~jA",GAME_NOT_WORKING )
GAME( 2000,tokyobus,naomixu, unmamed, unmamed, 0, ROT0,"ZK","oXē",GAME_NOT_WORKING )
GAME( 2000,touchde2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","^b`fEm[!2 ǂ͂ӂŃ^b`",GAME_NOT_WORKING )
GAME( 2000,trckkskk,0, unmamed, unmamed, 0, ROT0,"iR/g","gbN",GAME_NOT_WORKING )
GAME( 2000,variants,aleck64u, unmamed, unmamed, 0, ROT0,"Z^","oAgVoc@[",GAME_NOT_WORKING )
GAME( 2000,vnba,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`NBA",GAME_NOT_WORKING )
GAME( 2000,von2566,naomixu, unmamed, unmamed, 0, ROT0,"ZK","d]@o[`IgI^OVer5.66",GAME_NOT_WORKING )
GAME( 2000,worldkik,naomixu, unmamed, unmamed, 0, ROT0,"iR","[hLbNX",GAME_NOT_WORKING )
GAME( 2000,zotenami,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","ĂȂݔq",GAME_NOT_WORKING )
GAME( 2001,airstorm,0, unmamed, unmamed, 0, ROT0,"NEXECESOFT","GAXg[",GAME_NOT_WORKING )
GAME( 2001,airtrix,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","GAgbNX",GAME_NOT_WORKING )
GAME( 2001,angelicl,0, unmamed, unmamed, 0, ROT0,"AJ","GWFbNC[",GAME_NOT_WORKING )
GAME( 2001,beachspk,naomixu, unmamed, unmamed, 0, ROT0,"ZK","r[`XpCJ[Y",GAME_NOT_WORKING )
GAME( 2001,clubkart,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NuJ[g european session",GAME_NOT_WORKING )
GAME( 2001,cosmsmsh,naomixu, unmamed, unmamed, 0, ROT0,"ZK","RY~bNX}bV",GAME_NOT_WORKING )
GAME( 2001,crackdj2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","NbLDJ2",GAME_NOT_WORKING )
GAME( 2001,cvs1pro,naomixu, unmamed, unmamed, 0, ROT0,"JvR/SNK","JvR vs SNK ~jAt@Cg2000 pro",GAME_NOT_WORKING )
GAME( 2001,cvs2,naomixu, unmamed, unmamed, 0, ROT0,"JvR/SNK","JvR vs SNK2",GAME_NOT_WORKING )
GAME( 2001,dboclub2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_[r[I[i[YNu2",GAME_NOT_WORKING )
GAME( 2001,dynagolf,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_Ci~bNSt",GAME_NOT_WORKING )
GAME( 2001,f355cha2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","F355`W2",GAME_NOT_WORKING )
GAME( 2001,g13jtk,namcos1x, unmamed, unmamed, 0, ROT0,"iR","SSPR@e̒",GAME_NOT_WORKING )
GAME( 2001,gahaha,namcos1x, unmamed, unmamed, 0, ROT0,"iR / g","GAHAHAꔭ",GAME_NOT_WORKING )
GAME( 2001,garou5,neogeou, unmamed, unmamed, 0, ROT0,"SNK","T -Mark of the Wolves-@2",GAME_NOT_WORKING )
GAME( 2001,gundam,naomixu, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mK_AMVSWI",GAME_NOT_WORKING )
GAME( 2001,gundam2,naomixu, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mK_AMVSWIDX",GAME_NOT_WORKING )
GAME( 2001,gunsviv2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","KToCo[Q oCInU[h Code: Veronica",GAME_NOT_WORKING )
GAME( 2001,hanagold,0, unmamed, unmamed, 0, ROT0,"_CibNX","ԎDS[h[",GAME_NOT_WORKING )
GAME( 2001,hnsibari,0, unmamed, unmamed, 0, ROT0,"rXR","ؔ",GAME_NOT_WORKING )
GAME( 2001,hvmtgmtx,naomixu, unmamed, unmamed, 0, ROT0,"ZK","wr[^@WI}gbNX",GAME_NOT_WORKING )
GAME( 2001,ikaruga,naomixu, unmamed, unmamed, 0, ROT0,"gW[","",GAME_NOT_WORKING )
GAME( 2001,iniciald,naomixu, unmamed, unmamed, 0, ROT0,"ZK","c A[P[hGfBV",GAME_NOT_WORKING )
GAME( 2001,inuosanp,naomixu, unmamed, unmamed, 0, ROT0,"ZK","̂",GAME_NOT_WORKING )
GAME( 2001,jpark3,viperu, unmamed, unmamed, 0, ROT0,"Ri~","WVbNp[NV",GAME_NOT_WORKING )
GAME( 2001,keisatu2,viperu, unmamed, unmamed, 0, ROT0,"Ri~","UEx@2 SǐՃXyV",GAME_NOT_WORKING )
GAME( 2001,kingrt66,naomixu, unmamed, unmamed, 0, ROT0,"ZK","U@LO@Iu@[g66",GAME_NOT_WORKING )
GAME( 2001,lupin3st,naomixu, unmamed, unmamed, 0, ROT0,"ZK","pV THE SHOOTING",GAME_NOT_WORKING )
GAME( 2001,manabek,0, unmamed, unmamed, 0, ROT0,"ZCuJ","OrARNV 炩 ZEPPIN V[Y",GAME_NOT_WORKING )
GAME( 2001,manboago,0, unmamed, unmamed, 0, ROT0,"Ri~","}{EAES[S[",GAME_NOT_WORKING )
GAME( 2001,mjbenikj,0, unmamed, unmamed, 0, ROT0,"_CibNX","gE",GAME_NOT_WORKING )
GAME( 2001,mjdreach,0, unmamed, unmamed, 0, ROT0,"_CibNX","嗧",GAME_NOT_WORKING )
GAME( 2001,mjdrenso,0, unmamed, unmamed, 0, ROT0,"_CibNX","A",GAME_NOT_WORKING )
GAME( 2001,moerucsn,naomixu, unmamed, unmamed, 0, ROT0,"Ag","GJWɂ ",GAME_NOT_WORKING )
GAME( 2001,monkybal,naomixu, unmamed, unmamed, 0, ROT0,"ZK","L[{[",GAME_NOT_WORKING )
GAME( 2001,nightrad,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/^N~","iCgCh",GAME_NOT_WORKING )
GAME( 2001,otenkikr,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/^N~","˂ǋʃpYEVC",GAME_NOT_WORKING )
GAME( 2001,photobtl,0, unmamed, unmamed, 0, ROT0,"iR","tHgog[",GAME_NOT_WORKING )
GAME( 2001,privates,0, unmamed, unmamed, 0, ROT0,"Ri~","vCx[gVbg",GAME_NOT_WORKING )
GAME( 2001,puzlet,0, unmamed, unmamed, 0, ROT0,"[j[YR[|[V","pYkds",GAME_NOT_WORKING )
GAME( 2001,pwrsmsh2,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","p[X}bV2",GAME_NOT_WORKING )
GAME( 2001,samraisx,0, unmamed, unmamed, 0, ROT0,"iR","g TCT[tw",GAME_NOT_WORKING )
GAME( 2001,sfzero3u,naomixu, unmamed, unmamed, 0, ROT0,"JvR","Xg[gt@C^[ZERO3Abp[",GAME_NOT_WORKING )
GAME( 2001,shakatat,naomixu, unmamed, unmamed, 0, ROT0,"ZK","VJƃ^o p[Abvb`",GAME_NOT_WORKING )
GAME( 2001,sikigami,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/At@VXe","_̏",GAME_NOT_WORKING )
GAME( 2001,smshcoat,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","X}bVR[gEvg[ig",GAME_NOT_WORKING )
GAME( 2001,sotenryu,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","V",GAME_NOT_WORKING )
GAME( 2001,spacekpr,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xy[XL[p[Y",GAME_NOT_WORKING )
GAME( 2001,spikbatl,naomixu, unmamed, unmamed, 0, ROT0,"ZK","XpCJ[Yog",GAME_NOT_WORKING )
GAME( 2001,spmjreag,naomixu, unmamed, unmamed, 0, ROT0,"ZK","X[p[W[[O",GAME_NOT_WORKING )
GAME( 2001,srmpvs,aleck64u, unmamed, unmamed, 0, ROT0,"Z^","X[p[AVS",GAME_NOT_WORKING )
GAME( 2001,sscope3,viperu, unmamed, unmamed, 0, ROT0,"Ri~","_(TCgXR[v3)",GAME_NOT_WORKING )
GAME( 2001,starbld2,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","X^[u[hEIy[Vu[vlbg",GAME_NOT_WORKING )
GAME( 2001,starseek,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/Ot","ǂǂACh@X^[V[J[",GAME_NOT_WORKING )
GAME( 2001,stnttypn,0, unmamed, unmamed, 0, ROT0,"^Cg[","X^g^Ct[",GAME_NOT_WORKING )
GAME( 2001,tekken4,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","S4",GAME_NOT_WORKING )
GAME( 2001,thrilld2,viperu, unmamed, unmamed, 0, ROT0,"Ri~","XhCu2",GAME_NOT_WORKING )
GAME( 2001,tsurugi,viperu, unmamed, unmamed, 0, ROT0,"Ri~","`srtqtfh",GAME_NOT_WORKING )
GAME( 2001,twinspr2,neogeou, unmamed, unmamed, 0, ROT0,"ADK","eBNX^[XvCcQ@̗E",GAME_NOT_WORKING )
GAME( 2001,ultrafev,0, unmamed, unmamed, 0, ROT0,"ovXg","Eg} t@CeBOG{[V",GAME_NOT_WORKING )
GAME( 2001,usagi,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/","e -쐫̓v-",GAME_NOT_WORKING )
GAME( 2001,vamnight,sys2x6u, unmamed, unmamed, 0, ROT0,"iR/ZK","@pCAiCg",GAME_NOT_WORKING )
GAME( 2001,vf4,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[S",GAME_NOT_WORKING )
GAME( 2001,vonforce,hikaruu, unmamed, unmamed, 0, ROT0,"ZK","d]@o[` tH[X",GAME_NOT_WORKING )
GAME( 2001,vstr3,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`XgCJ[3",GAME_NOT_WORKING )
GAME( 2001,waverngp,naomixu, unmamed, unmamed, 0, ROT0,"ZK","EF[ui[GP ",GAME_NOT_WORKING )
GAME( 2001,wildridr,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ChC_[Y",GAME_NOT_WORKING )
GAME( 2001,zerogun2,naomixu, unmamed, unmamed, 0, ROT0,"ʋ","[Ki[Q",GAME_NOT_WORKING )
GAME( 2002,aliensnp,0, unmamed, unmamed, 0, ROT0,"iR","GCAXiCp[",GAME_NOT_WORKING )
GAME( 2002,azmangap,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/Moss","܂񂪑剤pY{u",GAME_NOT_WORKING )
GAME( 2002,bm3dxfin,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIII@FINAL",GAME_NOT_WORKING )
GAME( 2002,bemfinal,djmain, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jA@FINAL",GAME_NOT_WORKING )
GAME( 2002,bonbort,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","{{[g",GAME_NOT_WORKING )
GAME( 2002,btlquix,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","ogNCbNX",GAME_NOT_WORKING )
GAME( 2002,capftall,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","JvRt@CeBOI[X^[Y",GAME_NOT_WORKING )
GAME( 2002,chocomkr,naomixu, unmamed, unmamed, 0, ROT0,"ZK/GR[","TsB̃`R}[J[",GAME_NOT_WORKING )
GAME( 2002,chocovdr,0, unmamed, unmamed, 0, ROT0,"iR","F`Rx[_[ R^NeB[",GAME_NOT_WORKING )
GAME( 2002,clepatfp,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/Ag","NIpgtH[`[vX@܂܂_ł",GAME_NOT_WORKING )
GAME( 2002,ddp3,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I@剝",GAME_NOT_WORKING )
GAME( 2002,ddp3bl,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I@剝@ubN[x",GAME_NOT_WORKING )
GAME( 2002,ddp3u,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖IIII",GAME_NOT_WORKING )
GAME( 2002,dragoncr,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","hSNjN",GAME_NOT_WORKING )
GAME( 2002,emajannt,0, unmamed, unmamed, 0, ROT0,"Ao","e.net",GAME_NOT_WORKING )
GAME( 2002,gbisicmp,0, unmamed, unmamed, 0, ROT0,"Ri~","O[grVoV`v@`{^@x񔭗߁`",GAME_NOT_WORKING )
GAME( 2002,ggxx,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMA CO[NX",GAME_NOT_WORKING )
GAME( 2002,hanakiko,0, unmamed, unmamed, 0, ROT0,"_CibNX","؋j[",GAME_NOT_WORKING )
GAME( 2002,hofdead3,naomixu, unmamed, unmamed, 0, ROT0,"ZK","UEnEXEIuEUEfbh3",GAME_NOT_WORKING )
GAME( 2002,inicial2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","c A[P[hXe[W Ver.2",GAME_NOT_WORKING )
GAME( 2002,ketsui,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","PcC@`Jn`",GAME_NOT_WORKING )
GAME( 2002,kinbanft,0, unmamed, unmamed, 0, ROT0,"Ri~","ؓԕttbg{[}X^[Y",GAME_NOT_WORKING )
GAME( 2002,martialb,0, unmamed, unmamed, 0, ROT0,"Ri~","}[Vr[g",GAME_NOT_WORKING )
GAME( 2002,mazan,naomixu, unmamed, unmamed, 0, ROT0,"iR","a MAZAN",GAME_NOT_WORKING )
GAME( 2002,mazeking,naomixu, unmamed, unmamed, 0, ROT0,"ZK","UECYEIuEUELOX",GAME_NOT_WORKING )
GAME( 2002,mjbenik2,0, unmamed, unmamed, 0, ROT0,"_CibNX","gESPECIAL",GAME_NOT_WORKING )
GAME( 2002,mjdaimjn,0, unmamed, unmamed, 0, ROT0,"_CibNX","喾_",GAME_NOT_WORKING )
GAME( 2002,mjdaisgn,0, unmamed, unmamed, 0, ROT0,"_CibNX","叫R",GAME_NOT_WORKING )
GAME( 2002,mjryuou,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 2002,mjsenpu,0, unmamed, unmamed, 0, ROT0,"IG^\x83\x5ctg","",GAME_NOT_WORKING )
GAME( 2002,mjtenhou,0, unmamed, unmamed, 0, ROT0,"_CibNX","VP",GAME_NOT_WORKING )
GAME( 2002,mkakutou,viperu, unmamed, unmamed, 0, ROT0,"Ri~","iy",GAME_NOT_WORKING )
GAME( 2002,necchupy,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","M`[! v싅2002",GAME_NOT_WORKING )
GAME( 2002,nicetsuk,0, unmamed, unmamed, 0, ROT0,"iR","iCXcbR~",GAME_NOT_WORKING )
GAME( 2002,paniclpn,0, unmamed, unmamed, 0, ROT0,"iR","pjNplN",GAME_NOT_WORKING )
GAME( 2002,pnyaao,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/RpC","|`bƃj`(prototype)",GAME_NOT_WORKING )
GAME( 2002,prem11,atmiswu, unmamed, unmamed, 0, ROT0,"T~[/fBvX","v~ACu",GAME_NOT_WORKING )
GAME( 2002,qketaiqm,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/AfI","NCY P[^CQ[h MailChatTel",GAME_NOT_WORKING )
GAME( 2002,raijinpp,0, unmamed, unmamed, 0, ROT0,"^Cg[","CWs|",GAME_NOT_WORKING )
GAME( 2002,samraign,cps2u, unmamed, unmamed, 0, ROT0,"~b`F","TCKi[ (Japan 02****)",GAME_NOT_WORKING )
GAME( 2002,sega4mj,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ZKllłMJ",GAME_NOT_WORKING )
GAME( 2002,sengkakm,0, unmamed, unmamed, 0, ROT0,"Ri~","oI퍑v",GAME_NOT_WORKING )
GAME( 2002,shanhist,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[//T\x83\x5ctg","C`OvV",GAME_NOT_WORKING )
GAME( 2002,soulcrb2,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","\x83\x5cELo[2",GAME_NOT_WORKING )
GAME( 2002,soulsurf,naomixu, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","\x83\x5cET[t@[",GAME_NOT_WORKING )
GAME( 2002,talettwr,0, unmamed, unmamed, 0, ROT0,"iR/fGNgjNX","^bg^[",GAME_NOT_WORKING )
GAME( 2002,tecnicbt,sys2x6u, unmamed, unmamed, 0, ROT0,"iR/AJ","eNjNr[g",GAME_NOT_WORKING )
GAME( 2002,triforcu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_triforce",GAME_NOT_WORKING )
GAME( 2002,vathrete,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`AX[g",GAME_NOT_WORKING )
GAME( 2002,vf4evo,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[S G{[V",GAME_NOT_WORKING )
GAME( 2002,vstr2002,triforcu, unmamed, unmamed, 0, ROT0,"ZK","o[`XgCJ[2002",GAME_NOT_WORKING )
GAME( 2002,wanganmn,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCg",GAME_NOT_WORKING )
GAME( 2002,wccf0102,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","[hNu `sItbg{[ ZGA 2001-2002",GAME_NOT_WORKING )
GAME( 2002,wcombat,viperu, unmamed, unmamed, 0, ROT0,"Ri~","[hRobg",GAME_NOT_WORKING )
GAME( 2002,wldscw11,0, unmamed, unmamed, 0, ROT0,"Ri~","[hTbJ[ ECjOCu A[P[hQ[X^C",GAME_NOT_WORKING )
GAME( 2002,xiistag,gnetu, unmamed, unmamed, 0, ROT0,"gCAOT[rX","XIISTAG",GAME_NOT_WORKING )
GAME( 2002,xtrialrc,viperu, unmamed, unmamed, 0, ROT0,"Ri~","GbNXgCA[VO",GAME_NOT_WORKING )
GAME( 2003,avalon,triforcu, unmamed, unmamed, 0, ROT0,"ZK","A@̌",GAME_NOT_WORKING )
GAME( 1999,balnstry,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","oXgC",GAME_NOT_WORKING )
GAME( 2003,batgea3t,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA3 Tuned",GAME_NOT_WORKING )
GAME( 2003,batgear3,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA3",GAME_NOT_WORKING )
GAME( 2003,bordrdwn,naomixu, unmamed, unmamed, 0, ROT0,"ZK/Ot","{[_[_E",GAME_NOT_WORKING )
GAME( 2003,btlmarin,pratnetu, unmamed, unmamed, 0, ROT0,"A[","og}A[P[h",GAME_NOT_WORKING )
GAME( 2003,chihirou,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_chihiro",GAME_NOT_WORKING )
GAME( 2003,colfulhs,0, unmamed, unmamed, 0, ROT0,"iR","tNCYJtnCXN[",GAME_NOT_WORKING )
GAME( 2003,crsytaxh,chihirou, unmamed, unmamed, 0, ROT0,"ZK","NCW[^NV[ nC[[",GAME_NOT_WORKING )
GAME( 2003,demofist,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","fbVtBXg",GAME_NOT_WORKING )
GAME( 2003,dlphblue,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","htBu[",GAME_NOT_WORKING )
GAME( 2003,donchan,aleck64u, unmamed, unmamed, 0, ROT0,"A[","hpY ԉ΂Ńh[!",GAME_NOT_WORKING )
GAME( 2003,drhythmx,neogeou, unmamed, unmamed, 0, ROT0,"ADK","_XY~bNX",GAME_NOT_WORKING )
GAME( 2003,eemail,0, unmamed, unmamed, 0, ROT0,"Ri~","ee'MALL",GAME_NOT_WORKING )
GAME( 2003,espgalud,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","GXvK[_",GAME_NOT_WORKING )
GAME( 2003,exzeus,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/HyperDevBox","CO[EX EXZEUS",GAME_NOT_WORKING )
GAME( 2003,fzeroax,triforcu, unmamed, unmamed, 0, ROT0,"ZK","F-ZERO AX X^[Ch",GAME_NOT_WORKING )
GAME( 2003,gekiprom,triforcu, unmamed, unmamed, 0, ROT0,"ZK","v싅 ViI[X^[Yurv싅",GAME_NOT_WORKING )
GAME( 2003,ggisuka,atmiswu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMA CXJ",GAME_NOT_WORKING )
GAME( 2003,ggxxsrld,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMA CO[NX V[v [h U ~bhiCgJ[jo",GAME_NOT_WORKING )
GAME( 2003,hnsibar2,0, unmamed, unmamed, 0, ROT0,"rXR","ؔ pԓ`",GAME_NOT_WORKING )
GAME( 2003,janseido,pratnetu, unmamed, unmamed, 0, ROT0,"A[","",GAME_NOT_WORKING )
GAME( 2003,kintaro,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","lbgZNg T[}Y",GAME_NOT_WORKING )
GAME( 2003,kollon,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/TCo[tg","R KOLLON",GAME_NOT_WORKING )
GAME( 2003,konotaco,0, unmamed, unmamed, 0, ROT0,"JvR/~b`F","TACOI",GAME_NOT_WORKING )
GAME( 2003,kov7star,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","VEOL@]",GAME_NOT_WORKING )
GAME( 2003,krkrfrvr,aleck64u, unmamed, unmamed, 0, ROT0,"A[","邭tB[o[",GAME_NOT_WORKING )
GAME( 2003,kyogokuh,0, unmamed, unmamed, 0, ROT0,"_CibNX","ɉ؂̕",GAME_NOT_WORKING )
GAME( 2003,maximspd,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","}LV}Xs[h",GAME_NOT_WORKING )
GAME( 2003,mjchukam,0, unmamed, unmamed, 0, ROT0,"_CibNX","ؖ",GAME_NOT_WORKING )
GAME( 2003,mjtaketr,0, unmamed, unmamed, 0, ROT0,"_CibNX","|`",GAME_NOT_WORKING )
GAME( 2003,mkakuto2,viperu, unmamed, unmamed, 0, ROT0,"Ri~","iy2",GAME_NOT_WORKING )
GAME( 2003,musiking,naomixu, unmamed, unmamed, 0, ROT0,"ZK","b҃VLO",GAME_NOT_WORKING )
GAME( 2003,outrn2,chihirou, unmamed, unmamed, 0, ROT0,"ZK","AEgQ",GAME_NOT_WORKING )
GAME( 2003,pratnetu,0, unmamed, unmamed, 0, ROT0,"A[","_Ήi_pratnet",GAME_NOT_WORKING )
GAME( 2003,pride2k3,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","PRIDE GP 2003",GAME_NOT_WORKING )
GAME( 2003,psyvari2,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","TC@AQ",GAME_NOT_WORKING )
GAME( 2003,puyofevr,naomixu, unmamed, unmamed, 0, ROT0,"ZK","ՂՂtB[o[",GAME_NOT_WORKING )
GAME( 2003,quizmaga,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[",GAME_NOT_WORKING )
GAME( 2003,rpmredtc,0, unmamed, unmamed, 0, ROT0,"Ri~","r.p.m.RED Tuned Car Championship",GAME_NOT_WORKING )
GAME( 2003,sexial,0, unmamed, unmamed, 0, ROT0,"Lbc","ZNV",GAME_NOT_WORKING )
GAME( 2003,shamisen,0, unmamed, unmamed, 0, ROT0,"Ri~/JgE쏊","OuU[X",GAME_NOT_WORKING )
GAME( 2003,sikigam2,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/At@VXe","_̏II",GAME_NOT_WORKING )
GAME( 2003,spaceina,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","Xy[XCx[_[@Ajo[T[",GAME_NOT_WORKING )
GAME( 2003,srmshipi,aleck64u, unmamed, unmamed, 0, ROT0,"A[/Z^","VX[p[AV[Y HiPaip_CX",GAME_NOT_WORKING )
GAME( 2003,tgm3proh,0, unmamed, unmamed, 0, ROT0,"^Cg[/AJ","egXEUEOh}X^[R (prohibit Ver.)",GAME_NOT_WORKING )
GAME( 2003,timecri3,0, unmamed, unmamed, 0, ROT0,"iR","^CNCVX3",GAME_NOT_WORKING )
GAME( 2003,toresusi,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","ƂƂIi",GAME_NOT_WORKING )
GAME( 2003,typexu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_type-x",GAME_NOT_WORKING )
GAME( 2003,usagi2,naomixu, unmamed, unmamed, 0, ROT0,"^Cg[/","e -쐫̓v-@R閃",GAME_NOT_WORKING )
GAME( 2003,vcop3,chihirou, unmamed, unmamed, 0, ROT0,"ZK","o[`RbvR",GAME_NOT_WORKING )
GAME( 2003,wanganmr,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgR",GAME_NOT_WORKING )
GAME( 2003,wldscw12,0, unmamed, unmamed, 0, ROT0,"Ri~","[hTbJ[ ECjOCu 2003 A[P[hQ[X^C",GAME_NOT_WORKING )
GAME( 2003,yakinjrn,0, unmamed, unmamed, 0, ROT0,"Lbc","ΐ",GAME_NOT_WORKING )
GAME( 2003,zgundam,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mZK_GD[SVSeB^[Y",GAME_NOT_WORKING )
GAME( 2004,atmiswu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_atmisw",GAME_NOT_WORKING )
GAME( 2004,avalon2,triforcu, unmamed, unmamed, 0, ROT0,"ZK","A@̌2 -Ɖ-",GAME_NOT_WORKING )
GAME( 2004,bm2dx11r,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw11@IIDX RED",GAME_NOT_WORKING )
GAME( 2004,btlcrmx,0, unmamed, unmamed, 0, ROT0,"Ri~","bXA[i@ogNC}bNXI",GAME_NOT_WORKING )
GAME( 2004,capftjam,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","JvRt@CeBOW",GAME_NOT_WORKING )
GAME( 2004,chaosblk,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","JIXuCJ[",GAME_NOT_WORKING )
GAME( 2004,chaosfld,naomixu, unmamed, unmamed, 0, ROT0,"GCu/}CXg[","JIXtB[h",GAME_NOT_WORKING )
GAME( 2004,ddrextrm,0, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V@GNXg[",GAME_NOT_WORKING )
GAME( 2004,dracr2ol,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","hSNjNIC`V匈`",GAME_NOT_WORKING )
GAME( 2004,drmmanv1,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV ",GAME_NOT_WORKING )
GAME( 2004,fantstry,0, unmamed, unmamed, 0, ROT0,"ErX/y\x83\x5ctg","t@^W[Xg[[",GAME_NOT_WORKING )
GAME( 2004,ghostsqd,chihirou, unmamed, unmamed, 0, ROT0,"ZK","S[XgXJbh",GAME_NOT_WORKING )
GAME( 2004,gigawin3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","_ GIGAWING GENERATIONS",GAME_NOT_WORKING )
GAME( 2004,gtflekv1,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV",GAME_NOT_WORKING )
GAME( 2004,hanaotme,0, unmamed, unmamed, 0, ROT0,"_CibNX","؉",GAME_NOT_WORKING )
GAME( 2004,hogwild,0, unmamed, unmamed, 0, ROT0,"ErX/tEL","zbOCh `FCXAbvI",GAME_NOT_WORKING )
GAME( 2004,kofnw,atmiswu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOEIuEt@C^[Y lIEFCu",GAME_NOT_WORKING )
GAME( 2004,lovebery,naomixu, unmamed, unmamed, 0, ROT0,"ZK","IV u and x[",GAME_NOT_WORKING )
GAME( 2004,mjknitri,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 2004,mjmomotr,0, unmamed, unmamed, 0, ROT0,"_CibNX","Y",GAME_NOT_WORKING )
GAME( 2004,mjnyan2,0, unmamed, unmamed, 0, ROT0,"_CibNX","XѓX",GAME_NOT_WORKING )
GAME( 2004,mjsusikn,0, unmamed, unmamed, 0, ROT0,"_CibNX","iH˂I",GAME_NOT_WORKING )
GAME( 2004,mkakuto3,0, unmamed, unmamed, 0, ROT0,"Ri~","iy3",GAME_NOT_WORKING )
GAME( 2004,musihime,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","P",GAME_NOT_WORKING )
GAME( 2004,orlyking,chihirou, unmamed, unmamed, 0, ROT0,"ZK","I[[LO",GAME_NOT_WORKING )
GAME( 2004,outrn2sp,chihirou, unmamed, unmamed, 0, ROT0,"ZK","AEgQXyVcA[Y",GAME_NOT_WORKING )
GAME( 2004,popnm12i,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN12@",GAME_NOT_WORKING )
GAME( 2004,psatack,0, unmamed, unmamed, 0, ROT0,"ErX/tEL","s[YA^bN",GAME_NOT_WORKING )
GAME( 2004,questofd,chihirou, unmamed, unmamed, 0, ROT0,"ZK/AM2","NGXg Iu fB[",GAME_NOT_WORKING )
GAME( 2004,quizmag2,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[2",GAME_NOT_WORKING )
GAME( 2004,ramblefh,atmiswu, unmamed, unmamed, 0, ROT0,"T~[/fBvX","UEutBbV",GAME_NOT_WORKING )
GAME( 2004,ryukamjn,0, unmamed, unmamed, 0, ROT0,"iR","ؖ",GAME_NOT_WORKING )
GAME( 2004,segamj2,chihirou, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃MJ2",GAME_NOT_WORKING )
GAME( 2004,seiginoh,0, unmamed, unmamed, 0, ROT0,"Ri~","ZCMmq[[",GAME_NOT_WORKING )
GAME( 2004,sggolfnp,chihirou, unmamed, unmamed, 0, ROT0,"ZK","ZK StNu lbg[NvcA[",GAME_NOT_WORKING )
GAME( 2004,srmship2,aleck64u, unmamed, unmamed, 0, ROT0,"A[/Z^","VX[p[AV[Y HiPaip_CX2 ɍsI",GAME_NOT_WORKING )
GAME( 2004,ss5sp2,neogeou, unmamed, unmamed, 0, ROT0,"IIG^[vCY/SNKvCA","TCXsbcXyV@S",GAME_NOT_WORKING )
GAME( 2004,tekken5,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","S5",GAME_NOT_WORKING )
GAME( 2004,tetriskw,0, unmamed, unmamed, 0, ROT0,"TNZX","egXɓ",GAME_NOT_WORKING )
GAME( 2004,tokyocop,0, unmamed, unmamed, 0, ROT0,"iR/KGR","TOKYO COP",GAME_NOT_WORKING )
GAME( 2004,trizeal,naomixu, unmamed, unmamed, 0, ROT0,"gCAOT[rX","gCW[",GAME_NOT_WORKING )
GAME( 2004,vf4ftune,naomixu, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[4 t@Ci`[h",GAME_NOT_WORKING )
GAME( 2004,vstr4,triforcu, unmamed, unmamed, 0, ROT0,"ZK","o[`XgCJ[4",GAME_NOT_WORKING )
GAME( 2004,wanganmx,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgMAXI TUNE",GAME_NOT_WORKING )
GAME( 2004,weapncop,0, unmamed, unmamed, 0, ROT0,"ErX/tEL","EF|Rbv",GAME_NOT_WORKING )
GAME( 2004,wttroopr,0, unmamed, unmamed, 0, ROT0,"Ri~","EH[gEg[p[Y",GAME_NOT_WORKING )
GAME( 2004,xexth,0, unmamed, unmamed, 0, ROT0,"Mh","[NX",GAME_NOT_WORKING )
GAME( 2004,zgundam2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mZK_GD[SVSeB^[YDX",GAME_NOT_WORKING )
GAME( 2004,zoidinf,0, unmamed, unmamed, 0, ROT0,"^Cg[","]ChCtBjeB",GAME_NOT_WORKING )
GAME( 2004,zooo,0, unmamed, unmamed, 0, ROT0,"TNZX","ZOOO",GAME_NOT_WORKING )
GAME( 2005,akuma,0, unmamed, unmamed, 0, ROT0,"^Cg[/EXY","(AKUMA)",GAME_NOT_WORKING )
GAME( 2005,batgear4,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA4",GAME_NOT_WORKING )
GAME( 2005,bbheros,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y",GAME_NOT_WORKING )
GAME( 2005,bisibsol,0, unmamed, unmamed, 0, ROT0,"Ri~","rVoV`vIC Ό̑S!?",GAME_NOT_WORKING )
GAME( 2005,bm2dx12h,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw12@HAPPY SKY",GAME_NOT_WORKING )
GAME( 2005,bobblock,0, unmamed, unmamed, 0, ROT0,"^Cg[","ouubN",GAME_NOT_WORKING )
GAME( 2005,btlcrmx2,0, unmamed, unmamed, 0, ROT0,"Ri~","ogNC}bNX!!2@vX㌈",GAME_NOT_WORKING )
GAME( 2005,cobratac,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","Ru U A[P[h",GAME_NOT_WORKING )
GAME( 2005,countneo,0, unmamed, unmamed, 0, ROT0,"iR","JE^[XgCN lI",GAME_NOT_WORKING )
GAME( 2005,daedalus,pratnetu, unmamed, unmamed, 0, ROT0,"A[","_C_X̖{",GAME_NOT_WORKING )
GAME( 2005,dinoking,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/D-GATE","_CmLOog",GAME_NOT_WORKING )
GAME( 2005,drmmanv2,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV2 ",GAME_NOT_WORKING )
GAME( 2005,druagaol,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","hA[K IC UEXg[[EIuEI[",GAME_NOT_WORKING )
GAME( 2005,espgald2,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","GXvK[_II",GAME_NOT_WORKING )
GAME( 2005,fastfurs,0, unmamed, unmamed, 0, ROT0,"^Cg[","t@Xg&t[AX",GAME_NOT_WORKING )
GAME( 2005,gd0079cb,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/iR","@mK_0079 J[hr_[",GAME_NOT_WORKING )
GAME( 2005,ggxxslsh,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMA CO[NX XbV",GAME_NOT_WORKING )
GAME( 2005,gtflekv2,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV2",GAME_NOT_WORKING )
GAME( 2005,gunseed,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mK_SEED A VS. Z.A.F.T.",GAME_NOT_WORKING )
GAME( 2005,hanatuki,0, unmamed, unmamed, 0, ROT0,"_CibNX","،",GAME_NOT_WORKING )
GAME( 2005,harikrol,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","nLICv싅",GAME_NOT_WORKING )
GAME( 2005,himetama,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","pYIP",GAME_NOT_WORKING )
GAME( 2005,hofdead4,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","UEnEXEIuEUEfbh4",GAME_NOT_WORKING )
GAME( 2005,hokuto,atmiswu, unmamed, unmamed, 0, ROT0,"ZK","kľ",GAME_NOT_WORKING )
GAME( 2005,homura,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","HOMURA",GAME_NOT_WORKING )
GAME( 2005,hotgmkmx,typexu, unmamed, unmamed, 0, ROT0,"NXm[c","ΐzbgM~bN ~bNXp[eB",GAME_NOT_WORKING )
GAME( 2005,ibara,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","KN",GAME_NOT_WORKING )
GAME( 2005,idolmast,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ACh}X^[",GAME_NOT_WORKING )
GAME( 2005,inicial3,chihirou, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","c A[P[hXe[W Ver.3",GAME_NOT_WORKING )
GAME( 2005,janoudo,pratnetu, unmamed, unmamed, 0, ROT0,"A[","",GAME_NOT_WORKING )
GAME( 2005,kenju,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","b",GAME_NOT_WORKING )
GAME( 2005,kof11,atmiswu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOEIuEt@C^[Y@Cu",GAME_NOT_WORKING )
GAME( 2005,kyoryukg,naomixu, unmamed, unmamed, 0, ROT0,"ZK","Ñ㉤ LO",GAME_NOT_WORKING )
GAME( 2005,lindbrgu,0, unmamed, unmamed, 0, ROT0,"VXe","_Ήi_lindbergh",GAME_NOT_WORKING )
GAME( 2005,mariocac,triforcu, unmamed, unmamed, 0, ROT0,"iR","}IJ[gA[P[hGP",GAME_NOT_WORKING )
GAME( 2005,meltybld,naomixu, unmamed, unmamed, 0, ROT0,"GR[/TYPEMOON","eBubh ANgJfc@",GAME_NOT_WORKING )
GAME( 2005,mjdaikkm,0, unmamed, unmamed, 0, ROT0,"_CibNX","-qdun@v",GAME_NOT_WORKING )
GAME( 2005,mjmomot2,0, unmamed, unmamed, 0, ROT0,"_CibNX","YHOT",GAME_NOT_WORKING )
GAME( 2005,mjonigsm,0, unmamed, unmamed, 0, ROT0,"_CibNX","S",GAME_NOT_WORKING )
GAME( 2005,mjstudum,0, unmamed, unmamed, 0, ROT0,"_CibNX","MIX^WA",GAME_NOT_WORKING )
GAME( 2005,mjsusik2,0, unmamed, unmamed, 0, ROT0,"_CibNX","iH˂IHOT",GAME_NOT_WORKING )
GAME( 2005,mjtoryum,0, unmamed, unmamed, 0, ROT0,"GCu/IIG^[vCY","ʐMΐ햃 ",GAME_NOT_WORKING )
GAME( 2005,mkakuto4,0, unmamed, unmamed, 0, ROT0,"Ri~","iy4",GAME_NOT_WORKING )
GAME( 2005,mslug6,atmiswu, unmamed, unmamed, 0, ROT0,"SNKvCA","^XbOU",GAME_NOT_WORKING )
GAME( 2005,neobatcl,atmiswu, unmamed, unmamed, 0, ROT0,"T~[/SNKvCA","lIWI ogRVA",GAME_NOT_WORKING )
GAME( 2005,otenamif,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[/TNZX","ĂȂݔqehm`k",GAME_NOT_WORKING )
GAME( 2005,popnm13c,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN13@J[jo",GAME_NOT_WORKING )
GAME( 2005,pwrsmsh3,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","p[X}bV3",GAME_NOT_WORKING )
GAME( 2005,qofd2,chihirou, unmamed, unmamed, 0, ROT0,"ZK/AM2","NGXg Iu fB[Ver.2.0 아̌p",GAME_NOT_WORKING )
GAME( 2005,quizmag3,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[3",GAME_NOT_WORKING )
GAME( 2005,raiden3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/Moss","dIII",GAME_NOT_WORKING )
GAME( 2005,ramblef2,atmiswu, unmamed, unmamed, 0, ROT0,"T~[/fBvX","UEutBbVQ",GAME_NOT_WORKING )
GAME( 2005,razilgi,naomixu, unmamed, unmamed, 0, ROT0,"}CXg[","WM",GAME_NOT_WORKING )
GAME( 2005,samsho6,atmiswu, unmamed, unmamed, 0, ROT0,"SNKvCA","TCXsbc@Vꌕq`",GAME_NOT_WORKING )
GAME( 2005,sangokut,chihirou, unmamed, unmamed, 0, ROT0,"ZK","Ou",GAME_NOT_WORKING )
GAME( 2005,sclegend,pratnetu, unmamed, unmamed, 0, ROT0,"A[","\x83\x5c[TAWFh",GAME_NOT_WORKING )
GAME( 2005,segamj3,chihirou, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃MJ3",GAME_NOT_WORKING )
GAME( 2005,sggolfvt,chihirou, unmamed, unmamed, 0, ROT0,"ZK","ZK StNuo[W2006 lNXgcA[",GAME_NOT_WORKING )
GAME( 2005,sknronde,naomixu, unmamed, unmamed, 0, ROT0,"ZK/Ot","̗֕",GAME_NOT_WORKING )
GAME( 2005,spectral,0, unmamed, unmamed, 0, ROT0,"AMI/IGS/ACfAt@Ng[","XyNg VS WFl[V",GAME_NOT_WORKING )
GAME( 2005,spicaadv,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","XsJAhx`[",GAME_NOT_WORKING )
GAME( 2005,sshan2k5,naomixu, unmamed, unmamed, 0, ROT0,"GCu/X^[tBbV","X[p[C2005",GAME_NOT_WORKING )
GAME( 2005,superdbz,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/Ntg&}CX^[","hS{[Z",GAME_NOT_WORKING )
GAME( 2005,targetfc,0, unmamed, unmamed, 0, ROT0,"^Cg[","^[QbgtH[X",GAME_NOT_WORKING )
GAME( 2005,tekken5d,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","S5 DARK RESURRECTION",GAME_NOT_WORKING )
GAME( 2005,tgm3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/AJ","egXEUEOh}X^[R@e[CXeBNg",GAME_NOT_WORKING )
GAME( 2005,thrildv3,0, unmamed, unmamed, 0, ROT0,"Ri~","XhCu3",GAME_NOT_WORKING )
GAME( 2005,toysmach,0, unmamed, unmamed, 0, ROT0,"Ri~","gCY}[`",GAME_NOT_WORKING )
GAME( 2005,typetune,pratnetu, unmamed, unmamed, 0, ROT0,"A[","^Cv`[",GAME_NOT_WORKING )
GAME( 2005,underdft,naomixu, unmamed, unmamed, 0, ROT0,"ZK/Ot","A_[fBtB[g",GAME_NOT_WORKING )
GAME( 2005,usagi3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/","e -쐫̓v- ONLINE",GAME_NOT_WORKING )
GAME( 2005,victryhl,atmiswu, unmamed, unmamed, 0, ROT0,"ZK","lbgZNgn rNg[n",GAME_NOT_WORKING )
GAME( 2005,vmjapan,pratnetu, unmamed, unmamed, 0, ROT0,"A[","ulWp@L",GAME_NOT_WORKING )
GAME( 2005,wanganm2,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgMAXI TUNE 2",GAME_NOT_WORKING )
GAME( 2005,warofgrl,typexu, unmamed, unmamed, 0, ROT0,"JvR","EI[EIuEUEOC",GAME_NOT_WORKING )
GAME( 2005,wccf0405,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","[hNu `sItbg{[ [sANuX 2004-2005",GAME_NOT_WORKING )
GAME( 2005,zoidcard,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","]ChJ[hRVA",GAME_NOT_WORKING )
GAME( 2005,zoidifex,0, unmamed, unmamed, 0, ROT0,"^Cg[/g~[","]ChCtBjeBEX",GAME_NOT_WORKING )
GAME( 2006,afterbcx,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","At^[o[i[NC}bNX",GAME_NOT_WORKING )
GAME( 2006,alcanaht,0, unmamed, unmamed, 0, ROT0,"IIG^[vCY","AJin[g",GAME_NOT_WORKING )
GAME( 2006,batgea4t,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","ogMA4Tuned",GAME_NOT_WORKING )
GAME( 2006,bbheros2,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y2",GAME_NOT_WORKING )
GAME( 2006,bm2dx13d,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw13@DistorteD",GAME_NOT_WORKING )
GAME( 2006,damudeva,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","_fB[@",GAME_NOT_WORKING )
GAME( 2006,ddrsnova,0, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V@X[p[m@",GAME_NOT_WORKING )
GAME( 2006,drmmanv3,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV3 ",GAME_NOT_WORKING )
GAME( 2006,exelica,naomixu, unmamed, unmamed, 0, ROT0,"ZK/","gK[n[g@GO[J",GAME_NOT_WORKING )
GAME( 2006,gd0079c2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/iR","@mK_0079 J[hr_[ Ver.2.0",GAME_NOT_WORKING )
GAME( 2006,ggxxaccr,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMACO[NX@ANZgRA",GAME_NOT_WORKING )
GAME( 2006,gtflekv3,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV3",GAME_NOT_WORKING )
GAME( 2006,gundamsp,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_ XsbcIuWI `C̑o`",GAME_NOT_WORKING )
GAME( 2006,gunseed2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/JvR","@mK_SEED DESTINY Avs.Z.A.F.T.II",GAME_NOT_WORKING )
GAME( 2006,gunsenjo,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg/iR","@mK_@J",GAME_NOT_WORKING )
GAME( 2006,halflif2,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","HALF-LIFE 2 SURVIVOR",GAME_NOT_WORKING )
GAME( 2006,hofd4sp,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","UEnEXEIuEUEfbh4 XyV",GAME_NOT_WORKING )
GAME( 2006,homura2,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","HOMURA2",GAME_NOT_WORKING )
GAME( 2006,hotgmk5,typexu, unmamed, unmamed, 0, ROT0,"NXm[c","ΐzbgM~bNT ii݂炢փS[j",GAME_NOT_WORKING )
GAME( 2006,ibarabl,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","KN@ubN[x",GAME_NOT_WORKING )
GAME( 2006,inicald4,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","c A[P[hXe[W Ver.4",GAME_NOT_WORKING )
GAME( 2006,karasu,naomixu, unmamed, unmamed, 0, ROT0,"}CXg[","iJXj",GAME_NOT_WORKING )
GAME( 2006,kinnikmn,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","L} }bXOv",GAME_NOT_WORKING )
GAME( 2006,kirarin,typexu, unmamed, unmamed, 0, ROT0,"AgX","񁙃{[V nbs[AChCt 1 rs`fd",GAME_NOT_WORKING )
GAME( 2006,krkrkaml,naomixu, unmamed, unmamed, 0, ROT0,"GCu/X^[tBbV","邭JI",GAME_NOT_WORKING )
GAME( 2006,krkrlabo,0, unmamed, unmamed, 0, ROT0,"Ri~","]J NN{",GAME_NOT_WORKING )
GAME( 2006,letsjngl,chihirou, unmamed, unmamed, 0, ROT0,"ZK","bc S[ WO!",GAME_NOT_WORKING )
GAME( 2006,licachan,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/{VXe","LLACh@J",GAME_NOT_WORKING )
GAME( 2006,medalink,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","_N ",GAME_NOT_WORKING )
GAME( 2006,meltybd2,naomixu, unmamed, unmamed, 0, ROT0,"GR[/TYPEMOON","eBubh ANgJfc@ Ver.B",GAME_NOT_WORKING )
GAME( 2006,minnnade,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","݂ȂŒbS]g[jO",GAME_NOT_WORKING )
GAME( 2006,mjsusik3,0, unmamed, unmamed, 0, ROT0,"_CibNX","ViH˂I",GAME_NOT_WORKING )
GAME( 2006,mjumi8k,0, unmamed, unmamed, 0, ROT0,"_CibNX","Ci",GAME_NOT_WORKING )
GAME( 2006,mjumi8k2,0, unmamed, unmamed, 0, ROT0,"_CibNX","\x89\x5c̐VCi",GAME_NOT_WORKING )
GAME( 2006,mkakuto5,0, unmamed, unmamed, 0, ROT0,"Ri~","iy5",GAME_NOT_WORKING )
GAME( 2006,musihim2,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","P܁@ӂ ",GAME_NOT_WORKING )
GAME( 2006,needfspd,0, unmamed, unmamed, 0, ROT0,"GCuR[|[V","j[h tH[ Xs[h",GAME_NOT_WORKING )
GAME( 2006,novausag,0, unmamed, unmamed, 0, ROT0,"Ri~","NOVÃQ[dew!?",GAME_NOT_WORKING )
GAME( 2006,outrn2sd,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","AEgQ XyVcA[Y X[p[fbNX",GAME_NOT_WORKING )
GAME( 2006,pinkswts,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","sNXEB[c@`KNꂩ`",GAME_NOT_WORKING )
GAME( 2006,popnm14f,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN14@tB[o[",GAME_NOT_WORKING )
GAME( 2006,psyphi,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK"," PSY-PHI",GAME_NOT_WORKING )
GAME( 2006,qgundamt,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","NCY@mK_ Em",GAME_NOT_WORKING )
GAME( 2006,qofd3,chihirou, unmamed, unmamed, 0, ROT0,"ZK/AM2","NGXg Iu fB[Ver.3.0 ̎",GAME_NOT_WORKING )
GAME( 2006,rockmanb,0, unmamed, unmamed, 0, ROT0,"JvR","bN}GO[@og`bvX^WA",GAME_NOT_WORKING )
GAME( 2006,sangokt2,chihirou, unmamed, unmamed, 0, ROT0,"ZK","Ou2",GAME_NOT_WORKING )
GAME( 2006,sangyuki,0, unmamed, unmamed, 0, ROT0,"GCuR[|[V","OuVL",GAME_NOT_WORKING )
GAME( 2006,segacasi,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[NJWmNu",GAME_NOT_WORKING )
GAME( 2006,sikigam3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/At@VXe","_̏III",GAME_NOT_WORKING )
GAME( 2006,skrondsp,naomixu, unmamed, unmamed, 0, ROT0,"ZK/Ot","̗֕SP",GAME_NOT_WORKING )
GAME( 2006,soulcrb3,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","\x83\x5cELo[3 ARCADE EDITION",GAME_NOT_WORKING )
GAME( 2006,taikono9,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl9",GAME_NOT_WORKING )
GAME( 2006,timecri4,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","^CNCVX4",GAME_NOT_WORKING )
GAME( 2006,toysmac2,0, unmamed, unmamed, 0, ROT0,"Ri~","gCY}[`2",GAME_NOT_WORKING )
GAME( 2006,ttchzuno,naomixu, unmamed, unmamed, 0, ROT0,"ZK","]\x94\x5c͌}V[@^b`ŃYm[@y`FbN?Ƃog!?",GAME_NOT_WORKING )
GAME( 2006,usagi4,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/","e -쐫̓v- ONLINE  DĎ",GAME_NOT_WORKING )
GAME( 2006,vf5,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[5",GAME_NOT_WORKING )
GAME( 2006,vstr42k6,triforcu, unmamed, unmamed, 0, ROT0,"ZK","o[`XgCJ[4 Ver.2006",GAME_NOT_WORKING )
GAME( 2006,wantame,0, unmamed, unmamed, 0, ROT0,"JvR","^ ~[WbN`lI",GAME_NOT_WORKING )
GAME( 2006,wccf0506,naomixu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","[hNu `sItbg{[ [sANuX 2005-2006",GAME_NOT_WORKING )
GAME( 2006,wldscw13,0, unmamed, unmamed, 0, ROT0,"Ri~","[hTbJ[ ECjOCu 2006 A[P[h`sIVbv",GAME_NOT_WORKING )
GAME( 2006,yuyuhaks,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","THE BATTLE OF HV `!Íp`",GAME_NOT_WORKING )
GAME( 2006,zingistm,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","m`Xg[",GAME_NOT_WORKING )
GAME( 2007,aftrbcdx,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","At^[o[i[NC}bNXSDX",GAME_NOT_WORKING )
GAME( 2007,alcanah2,0, unmamed, unmamed, 0, ROT0,"IIG^[vCY","AJin[gFULL!",GAME_NOT_WORKING )
GAME( 2007,alienext,0, unmamed, unmamed, 0, ROT0,"Ri~","GCAEGNX^[~l[V",GAME_NOT_WORKING )
GAME( 2007,animkais,0, unmamed, unmamed, 0, ROT0,"iR","SbAj}JCU[",GAME_NOT_WORKING )
GAME( 2007,ansransr,0, unmamed, unmamed, 0, ROT0,"ZK","lbg[NΐNCY Answer~Answer",GAME_NOT_WORKING )
GAME( 2007,aquaageo,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","ANGAGCW@I^ieBu",GAME_NOT_WORKING )
GAME( 2007,bbheros3,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y3",GAME_NOT_WORKING )
GAME( 2007,bm2dx14g,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw14@GOLD",GAME_NOT_WORKING )
GAME( 2007,btlfanta,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","ogt@^WA",GAME_NOT_WORKING )
GAME( 2007,cardracr,0, unmamed, unmamed, 0, ROT0,"JvR","J[h[T[",GAME_NOT_WORKING )
GAME( 2007,chasehqn,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","`FCXg.p.Q@`iV[ً}A",GAME_NOT_WORKING )
GAME( 2007,d1gp,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","D1GP Arcade",GAME_NOT_WORKING )
GAME( 2007,ddrsnov2,0, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V@X[p[m@Q",GAME_NOT_WORKING )
GAME( 2007,dethsmil,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","fXX}CY",GAME_NOT_WORKING )
GAME( 2007,dinomax,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","_Cm}bNX",GAME_NOT_WORKING )
GAME( 2007,dmdekaex,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","_Ci}CgYEX AWA_Ci}Cg",GAME_NOT_WORKING )
GAME( 2007,draquemb,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","hSNGXgX^[og[h",GAME_NOT_WORKING )
GAME( 2007,drgnblzb,0, unmamed, unmamed, 0, ROT0,"ovXg","hS{[Z CpNg",GAME_NOT_WORKING )
GAME( 2007,drmmanv4,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV4 Rock x Rock",GAME_NOT_WORKING )
GAME( 2007,eternalk,0, unmamed, unmamed, 0, ROT0,"Ri~","G^[iiCc",GAME_NOT_WORKING )
GAME( 2007,etwheel,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","Iv̎ԗ G^[izC[",GAME_NOT_WORKING )
GAME( 2007,exzeal,naomixu, unmamed, unmamed, 0, ROT0,"ZK","GNXW[",GAME_NOT_WORKING )
GAME( 2007,gd0083c2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_0083J[hr_[@Ver2.0@Y",GAME_NOT_WORKING )
GAME( 2007,gd0083cb,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_0083J[hr_[",GAME_NOT_WORKING )
GAME( 2007,gstsqevo,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","S[XgXJbh G{[V",GAME_NOT_WORKING )
GAME( 2007,gtflekv4,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV4 Rock x Rock",GAME_NOT_WORKING )
GAME( 2007,gundams2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_ Xsbc Iu WI m̋L",GAME_NOT_WORKING )
GAME( 2007,hlflf2s2,0, unmamed, unmamed, 0, ROT0,"^Cg[","n[tCtQToCo[(Ver2.0)",GAME_NOT_WORKING )
GAME( 2007,hlflf2sd,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","HALF-LIFE 2 SURVIVOR SD",GAME_NOT_WORKING )
GAME( 2007,inufuku2,0, unmamed, unmamed, 0, ROT0,"nX^[","NCYoGeB Q@Ƃ",GAME_NOT_WORKING )
GAME( 2007,ishowan2,0, unmamed, unmamed, 0, ROT0,"ZK","Ƀ",GAME_NOT_WORKING )
GAME( 2007,kenkioh,0, unmamed, unmamed, 0, ROT0,"Ri~","Ƃ!PLI[",GAME_NOT_WORKING )
GAME( 2007,kinnikm2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","L} }bXOvQ",GAME_NOT_WORKING )
GAME( 2007,kirarin2,typexu, unmamed, unmamed, 0, ROT0,"AgX","񁙃{[V nbs[AChCt Q rs`fd",GAME_NOT_WORKING )
GAME( 2007,kkstomas,naomixu, unmamed, unmamed, 0, ROT0,"ZK","񂵂g[}X",GAME_NOT_WORKING )
GAME( 2007,kofmaxra,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","KOF }LV}CpNg M[VA",GAME_NOT_WORKING )
GAME( 2007,konchuds,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_bV",GAME_NOT_WORKING )
GAME( 2007,licacha3,typexu, unmamed, unmamed, 0, ROT0,"^Cg[/{VXe","LLACh@J R@rs`fd",GAME_NOT_WORKING )
GAME( 2007,marinx2,0, unmamed, unmamed, 0, ROT0,"ZK","}} ~i~nRtOƎXʂ̒ԒB",GAME_NOT_WORKING )
GAME( 2007,mariogp2,triforcu, unmamed, unmamed, 0, ROT0,"o_CiRQ[X","}IJ[gA[P[hGP2",GAME_NOT_WORKING )
GAME( 2007,masclekk,0, unmamed, unmamed, 0, ROT0,"iR","}bXsi",GAME_NOT_WORKING )
GAME( 2007,mjnigiri,0, unmamed, unmamed, 0, ROT0,"_CibNX","ɂ꒚",GAME_NOT_WORKING )
GAME( 2007,mjumiipt,0, unmamed, unmamed, 0, ROT0,"_CibNX","Cꔭ",GAME_NOT_WORKING )
GAME( 2007,mkakuto6,0, unmamed, unmamed, 0, ROT0,"Ri~","iy6",GAME_NOT_WORKING )
GAME( 2007,mkbancho,0, unmamed, unmamed, 0, ROT0,"PCu","_@Ԓ",GAME_NOT_WORKING )
GAME( 2007,msihim2b,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","P܁@ӂ@ubN[x",GAME_NOT_WORKING )
GAME( 2007,musikint,naomixu, unmamed, unmamed, 0, ROT0,"ZK","b҃VLO ΐog[Y^[~i",GAME_NOT_WORKING )
GAME( 2007,newspodr,0, unmamed, unmamed, 0, ROT0,"iR","NEW SPACE ORDER",GAME_NOT_WORKING )
GAME( 2007,otmedius,0, unmamed, unmamed, 0, ROT0,"Ri~","IgfBEX",GAME_NOT_WORKING )
GAME( 2007,pokaskag,0, unmamed, unmamed, 0, ROT0,"ZK","|JXJS[Xg",GAME_NOT_WORKING )
GAME( 2007,pokemonb,typexu, unmamed, unmamed, 0, ROT0,"^Jg~[/AQC^NeBu","|PogI",GAME_NOT_WORKING )
GAME( 2007,pokewips,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","ނނ|[NI",GAME_NOT_WORKING )
GAME( 2007,popnm15a,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN15@Ahx`[",GAME_NOT_WORKING )
GAME( 2007,pricured,0, unmamed, unmamed, 0, ROT0,"ovXg","!vLAh[Ct",GAME_NOT_WORKING )
GAME( 2007,qofd4,chihirou, unmamed, unmamed, 0, ROT0,"ZK/AM2","NGXg Iu fB[@UEogLO_",GAME_NOT_WORKING )
GAME( 2007,quizmag4,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[4",GAME_NOT_WORKING )
GAME( 2007,raiden4,typexu, unmamed, unmamed, 0, ROT0,"Moss","dIV",GAME_NOT_WORKING )
GAME( 2007,rithmtgk,0, unmamed, unmamed, 0, ROT0,"ZK","YV",GAME_NOT_WORKING )
GAME( 2007,rockbowl,0, unmamed, unmamed, 0, ROT0,"iR","bNE{E}",GAME_NOT_WORKING )
GAME( 2007,saiyudn2,0, unmamed, unmamed, 0, ROT0,"IGS","VߖB2",GAME_NOT_WORKING )
GAME( 2007,segamj3e,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃MJ3 G{[V",GAME_NOT_WORKING )
GAME( 2007,silenthl,0, unmamed, unmamed, 0, ROT0,"Ri~","TCgq@U@A[P[h",GAME_NOT_WORKING )
GAME( 2007,tacoron,0, unmamed, unmamed, 0, ROT0,"RpCn[g","́[݂RlRlpY ",GAME_NOT_WORKING )
GAME( 2007,taikancc,0, unmamed, unmamed, 0, ROT0,"{VXe/fW^WbN","̊NCW[NC}[",GAME_NOT_WORKING )
GAME( 2007,taiko10,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl10",GAME_NOT_WORKING )
GAME( 2007,tekken6,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","S6",GAME_NOT_WORKING )
GAME( 2007,thrildv4,0, unmamed, unmamed, 0, ROT0,"Ri~","XhCu4 NCW[Xg[g",GAME_NOT_WORKING )
GAME( 2007,twospicy,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","2 SPICYigD[XpCV[j",GAME_NOT_WORKING )
GAME( 2007,vf5c,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[5 Ver.C",GAME_NOT_WORKING )
GAME( 2007,wanganm3,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgMAXI TUNE 3",GAME_NOT_WORKING )
GAME( 2007,wccf0607,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","[hNu `sItbg{[ C^[iViNuX 2006-2007",GAME_NOT_WORKING )
GAME( 2008,actndeka,0, unmamed, unmamed, 0, ROT0,"Ri~","ANVY",GAME_NOT_WORKING )
GAME( 2008,akatsuki,naomixu, unmamed, unmamed, 0, ROT0,"SUBTLE STYLE","AJcLdLAusf.Achse",GAME_NOT_WORKING )
GAME( 2008,arcanah2,0, unmamed, unmamed, 0, ROT0,"GNT","AJin[g2",GAME_NOT_WORKING )
GAME( 2008,bm2dx15t,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw15@DJ TROOPERS",GAME_NOT_WORKING )
GAME( 2008,dboc2008,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","_[r[I[i[YNu2008",GAME_NOT_WORKING )
GAME( 2008,fateuc,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR/GCfBO","tFCg/A~ebhR[h",GAME_NOT_WORKING )
GAME( 2008,gundamx2,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","@mK_@K_VS.K_",GAME_NOT_WORKING )
GAME( 2008,hoseridr,0, unmamed, unmamed, 0, ROT0,"Ri~","z[XC_[Y",GAME_NOT_WORKING )
GAME( 2008,illvero,naomixu, unmamed, unmamed, 0, ROT0,"}CXg[","C}eBbNGx[u",GAME_NOT_WORKING )
GAME( 2008,inicald5,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","c A[P[hXe[W4",GAME_NOT_WORKING )
GAME( 2008,kirarin3,typexu, unmamed, unmamed, 0, ROT0,"AgX","񁙃{[V nbs[AChCt R rs`fd",GAME_NOT_WORKING )
GAME( 2009,kof12,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOEIuEt@C^[Y@gEF",GAME_NOT_WORKING )
GAME( 2008,kof98ult,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOIut@C^[Y'98 ULTIMATE MATCH",GAME_NOT_WORKING )
GAME( 2009,kofmaxa2,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","KOF }LV}CpNg M[VA2",GAME_NOT_WORKING )
GAME( 2008,lordofvm,0, unmamed, unmamed, 0, ROT0,"XNEFAGjbNX/^Cg[","[hIu@[~I",GAME_NOT_WORKING )
GAME( 2008,mamorukn,naomixu, unmamed, unmamed, 0, ROT0,"Ot/K`","܂N͎Ă܂I",GAME_NOT_WORKING )
GAME( 2008,meltybd3,naomixu, unmamed, unmamed, 0, ROT0,"GR[/TYPEMOON","eBubh ANgXAQC",GAME_NOT_WORKING )
GAME( 2008,popnm16p,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN16@p[eB",GAME_NOT_WORKING )
GAME( 2008,quizmag5,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[5",GAME_NOT_WORKING )
GAME( 2008,samsho7,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","TCXsbc@M",GAME_NOT_WORKING )
GAME( 2008,sangokt3,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","Ou3",GAME_NOT_WORKING )
GAME( 2008,segamj4,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃MJ4",GAME_NOT_WORKING )
GAME( 2008,segarace,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","SEGARaceTV",GAME_NOT_WORKING )
GAME( 2008,sf4,typexu, unmamed, unmamed, 0, ROT0,"JvR","Xg[gt@C^[IV",GAME_NOT_WORKING )
GAME( 2008,sgbasara,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR/A[NVXe[NX","퍑BASARA X(NX)",GAME_NOT_WORKING )
GAME( 2008,taiko11,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl11",GAME_NOT_WORKING )
GAME( 2009,vulcwars,0, unmamed, unmamed, 0, ROT0,"AgX/Gj[[NX","oJEH[Y",GAME_NOT_WORKING )
GAME( 2008,winele08,0, unmamed, unmamed, 0, ROT0,"Ri~","[hTbJ[ ECjOCu A[P[h`sIVbv 2008",GAME_NOT_WORKING )
GAME( 2009,skronde2,typexu, unmamed, unmamed, 0, ROT0,"ZK/Ot","̗֕ Dis-United Order",GAME_NOT_WORKING )
GAME( 2008,jubeat,0, unmamed, unmamed, 0, ROT0,"Ri~","jubeat",GAME_NOT_WORKING )
GAME( 2008,gtflekv5,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV5 Rock to infinity",GAME_NOT_WORKING )
GAME( 2008,drmmanv5,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV5 Rock to infinity",GAME_NOT_WORKING )
GAME( 2008,ddp4,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I啜",GAME_NOT_WORKING )
GAME( 2008,mkakuto7,0, unmamed, unmamed, 0, ROT0,"Ri~","iy7",GAME_NOT_WORKING )
GAME( 2008,brayblue,sys2x6u, unmamed, unmamed, 0, ROT0,"A[NVXe[NX","uCu[",GAME_NOT_WORKING )
GAME( 2008,tbwitchs,typexu, unmamed, unmamed, 0, ROT0,"X^WIVGX^","guEBb`[YAC",GAME_NOT_WORKING )
GAME( 2008,nobiteke,0, unmamed, unmamed, 0, ROT0,"Ri~","̂тĂ! rr",GAME_NOT_WORKING )
GAME( 2008,vf5r,0, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[5R",GAME_NOT_WORKING )
GAME( 2008,wndrmach,0, unmamed, unmamed, 0, ROT0,"Ri~","_[}[`",GAME_NOT_WORKING )
GAME( 2008,monstrac,typexu, unmamed, unmamed, 0, ROT0,"8105graphics","X^[ Ancient Cline",GAME_NOT_WORKING )
GAME( 2008,lovbryrc,naomixu, unmamed, unmamed, 0, ROT0,"ZK","IV u and x[@o[RNV",GAME_NOT_WORKING )
GAME( 2008,motorx,0, unmamed, unmamed, 0, ROT0,"Ri~","[^[X",GAME_NOT_WORKING )
GAME( 2008,garileof,0, unmamed, unmamed, 0, ROT0,"ZK","KIt@Ng[",GAME_NOT_WORKING )
GAME( 2008,pirategp,0, unmamed, unmamed, 0, ROT0,"PCu/AMI","pC[cIuۂ",GAME_NOT_WORKING )
GAME( 2008,mjchoumi,0, unmamed, unmamed, 0, ROT0,"_CibNX","Ci",GAME_NOT_WORKING )
GAME( 2008,konchds2,naomixu, unmamed, unmamed, 0, ROT0,"ZK","_bVQ",GAME_NOT_WORKING )
GAME( 2008,rambo,0, unmamed, unmamed, 0, ROT0,"ZK","{[",GAME_NOT_WORKING )
GAME( 2008,kirarin4,typexu, unmamed, unmamed, 0, ROT0,"AgX","񁙃{[V NLAChfCY",GAME_NOT_WORKING )
GAME( 2007,afreco,0, unmamed, unmamed, 0, ROT0,"iR","AtRI",GAME_NOT_WORKING )
GAME( 1992,kaisokus,0, unmamed, unmamed, 0, ROT0,"UPL","Iς`II",GAME_NOT_WORKING )
GAME( 1992,brekshow,0, unmamed, unmamed, 0, ROT0,"UPL","BREAK SHOW",GAME_NOT_WORKING )
GAME( 1989,doubutsu,0, unmamed, unmamed, 0, ROT0,"UPL","",GAME_NOT_WORKING )
GAME( 1988,pwrdrif2,0, unmamed, unmamed, 0, ROT0,"ZK","p[htg@R~jP[Vo[W",GAME_NOT_WORKING )
GAME( 1992,maddance,0, unmamed, unmamed, 0, ROT0,"q[}","}bh_VO",GAME_NOT_WORKING )
GAME( 1996,jigsawp,0, unmamed, unmamed, 0, ROT0,"AC}bNX","WO\x83\x5c[p_CX",GAME_NOT_WORKING )
GAME( 1996,quizkano,0, unmamed, unmamed, 0, ROT0,"AC}bNX","NCYޏneiɒBBB",GAME_NOT_WORKING )
GAME( 2000,x222,0, unmamed, unmamed, 0, ROT0,"IG^\x83\x5ctg","X2222",GAME_NOT_WORKING )
GAME( 2000,bash,0, unmamed, unmamed, 0, ROT0,"IG^\x83\x5ctg","obV",GAME_NOT_WORKING )
GAME( 2008,sweetsri,typexu, unmamed, unmamed, 0, ROT0,"^Jg~[","XEB[c",GAME_NOT_WORKING )
GAME( 1985,tsururin,0, unmamed, unmamed, 0, ROT0,"Ri~","񂭂",GAME_NOT_WORKING )
GAME( 2008,hofdex,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","nEXIuUfbhEX@舤V^C",GAME_NOT_WORKING )
GAME( 2008,lovbryfc,naomixu, unmamed, unmamed, 0, ROT0,"ZK","IV u and x[@tBi[RNV",GAME_NOT_WORKING )
GAME( 2009,demonbrd,0, unmamed, unmamed, 0, ROT0,"GNT","fuCh",GAME_NOT_WORKING )
GAME( 2008,arcanah3,0, unmamed, unmamed, 0, ROT0,"GNT","I@AJin[g2@`]Z@˂ƂȂȁ`",GAME_NOT_WORKING )
GAME( 2008,tvsc,typexu, unmamed, unmamed, 0, ROT0,"JvR","^cmRVS.JvR NXWFl[VIuq[[Y",GAME_NOT_WORKING )
GAME( 2009,mvsc3,typexu, unmamed, unmamed, 0, ROT0,"JvR","}[xVSJvRR",GAME_NOT_WORKING )
GAME( 2008,akmajoac,0, unmamed, unmamed, 0, ROT0,"Ri~","hL The ARCADE",GAME_NOT_WORKING )
GAME( 2008,akmajomd,0, unmamed, unmamed, 0, ROT0,"Ri~","hL The MEDAL",GAME_NOT_WORKING )
GAME( 2009,ddrx,0, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V X",GAME_NOT_WORKING )
GAME( 2008,ddp415,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I啜 Ver.1.5",GAME_NOT_WORKING )
GAME( 2009,hammer,0, unmamed, unmamed, 0, ROT0,"ZK","HUMMER",GAME_NOT_WORKING )
GAME( 2008,pokemnbs,typexu, unmamed, unmamed, 0, ROT0,"^Jg~[/AQC^NeBu","|PogIS(X[p[)",GAME_NOT_WORKING )
GAME( 2008,clubmajt,0, unmamed, unmamed, 0, ROT0,"ZK","Nu@}WFXeB",GAME_NOT_WORKING )
GAME( 2008,blkjacna,0, unmamed, unmamed, 0, ROT0,"ZK","ubNWbN@N.A.",GAME_NOT_WORKING )
GAME( 2009,segarar2,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","q(`[h)@AeBbgXg[g[VO",GAME_NOT_WORKING )
GAME( 2008,bbheros4,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y2008@e",GAME_NOT_WORKING )
GAME( 2009,inicial5,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/ZKb\x83\x5c","c A[P[hXe[W5",GAME_NOT_WORKING )
GAME( 2008,bm2dx16e,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIcw16@EMPRESS",GAME_NOT_WORKING )
GAME( 2008,meteospk,0, unmamed, unmamed, 0, ROT0,"Ri~","eIXp[N",GAME_NOT_WORKING )
GAME( 2008,gticlubs,0, unmamed, unmamed, 0, ROT0,"Ri~","GTINu supermini FestaI",GAME_NOT_WORKING )
GAME( 2008,druaga16,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","hA[K IC UEXg[[EIuEI[ Ver1.6",GAME_NOT_WORKING )
GAME( 2008,eternlk2,0, unmamed, unmamed, 0, ROT0,"Ri~","G^[iiCc2@̐",GAME_NOT_WORKING )
GAME( 2008,grndcrsp,0, unmamed, unmamed, 0, ROT0,"Ri~","OhNX@v~A",GAME_NOT_WORKING )
GAME( 2008,sangkt3s,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","Ou3@V̗",GAME_NOT_WORKING )
GAME( 2003,chce1929,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","`FCX1929",GAME_NOT_WORKING )
GAME( 2003,rangerms,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","W[~bV",GAME_NOT_WORKING )
GAME( 1993,takkle,0, unmamed, unmamed, 0, ROT0,"^Cg[","`^bN",GAME_NOT_WORKING )
GAME( 1976,crayshot,0, unmamed, unmamed, 0, ROT0,"֐퐻쏊","N[V[eBO",GAME_NOT_WORKING )
GAME( 2003,starhose,0, unmamed, unmamed, 0, ROT0,"ZK","X^[z[X",GAME_NOT_WORKING )
GAME( 2005,starhos2,0, unmamed, unmamed, 0, ROT0,"ZK","X^[z[X2 j[WFl[V",GAME_NOT_WORKING )
GAME( 2008,starhs24,0, unmamed, unmamed, 0, ROT0,"ZK","X^[z[X2 tH[XArV",GAME_NOT_WORKING )
GAME( 2008,wangn3dx,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgMAXI TUNE 3 DX",GAME_NOT_WORKING )
GAME( 2008,ggxxacrp,naomixu, unmamed, unmamed, 0, ROT0,"T~[/A[NVXe","MeBMACO[NX@ANZgRA PLUS",GAME_NOT_WORKING )
GAME( 2009,sngk2rse,0, unmamed, unmamed, 0, ROT0,"IGS/A^","OL2pY",GAME_NOT_WORKING )
GAME( 2008,dethsmmb,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","fXX}CY@KubN[x",GAME_NOT_WORKING )
GAME( 2008,dragondc,0, unmamed, unmamed, 0, ROT0,"TNZX/AMI","hS_X",GAME_NOT_WORKING )
GAME( 2009,gtosgami,0, unmamed, unmamed, 0, ROT0,"GNT","Q[e[uIC _̗VY",GAME_NOT_WORKING )
GAME( 2009,otomecrs,0, unmamed, unmamed, 0, ROT0,"GNT","IgNCVX",GAME_NOT_WORKING )
GAME( 2008,ansrans2,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","lbg[NΐNCY Answer~Answer2",GAME_NOT_WORKING )
GAME( 2009,haleykor,0, unmamed, unmamed, 0, ROT0,"ZK","n[[_rbh\x83\x5c@LOIuU[h",GAME_NOT_WORKING )
GAME( 2009,touchstr,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","^b`XgCJ[",GAME_NOT_WORKING )
GAME( 2008,gunsenj2,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_@J@{CX`bgΉVer.",GAME_NOT_WORKING )
GAME( 2008,tekken62,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","S6@BLOODLINE REBELLION",GAME_NOT_WORKING )
GAME( 2009,gundamxn,sys2x6u, unmamed, unmamed, 0, ROT0,"JvR","@mK_@K_VSK_NEXT",GAME_NOT_WORKING )
GAME( 2009,nirin,0, unmamed, unmamed, 0, ROT0,"iR"," NIRIN",GAME_NOT_WORKING )
GAME( 2008,taiko12,0, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl12",GAME_NOT_WORKING )
GAME( 2009,tenmile,0, unmamed, unmamed, 0, ROT0,"tEL","V܂Ń}CI",GAME_NOT_WORKING )
GAME( 2009,pricures,0, unmamed, unmamed, 0, ROT0,"ovXg","vLAI[X^[YGOGOh[Cu",GAME_NOT_WORKING )
GAME( 2009,blavehrs,0, unmamed, unmamed, 0, ROT0,"Ri~","uCuq[[Y",GAME_NOT_WORKING )
GAME( 2009,kubmadou,0, unmamed, unmamed, 0, ROT0,"NET&TECH","󕑖w@PARSE RORUNPE",GAME_NOT_WORKING )
GAME( 2009,sdgdmmdl,0, unmamed, unmamed, 0, ROT0,"ovXg","SDK_@_F",GAME_NOT_WORKING )
GAME( 2009,gd008321,sys2x6u, unmamed, unmamed, 0, ROT0,"ovXg","@mK_0083J[hr_[@Ver2.1@Y",GAME_NOT_WORKING )
GAME( 2008,fanzone2,0, unmamed, unmamed, 0, ROT0,"ZK","t@^W[][II",GAME_NOT_WORKING )
GAME( 2008,mjtendou,0, unmamed, unmamed, 0, ROT0,"_CibNX","VÓ",GAME_NOT_WORKING )
GAME( 2009,lordofv2,typexu, unmamed, unmamed, 0, ROT0,"XNEFAGjbNX/^Cg[","[hIu@[~I@_Xւ̗",GAME_NOT_WORKING )
GAME( 2009,razingst,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","CWOXg[",GAME_NOT_WORKING )
GAME( 2009,hakotumi,0, unmamed, unmamed, 0, ROT0,"tEL","ςMAX",GAME_NOT_WORKING )
GAME( 2009,invadrba,0, unmamed, unmamed, 0, ROT0,"^Cg[","Xy[XCx[_[@U@r[gA^bJ[",GAME_NOT_WORKING )
GAME( 2009,sketcher,0, unmamed, unmamed, 0, ROT0,"GNT","XPb`[",GAME_NOT_WORKING )
GAME( 2009,elacdeth,0, unmamed, unmamed, 0, ROT0,"^Cg[","Gx[^[ANV fXp[h",GAME_NOT_WORKING )
GAME( 2009,senornp,0, unmamed, unmamed, 0, ROT0,"^Cg[","Zj[@jb|I",GAME_NOT_WORKING )
GAME( 2009,hoppingr,0, unmamed, unmamed, 0, ROT0,"^Cg[","zbsO[h",GAME_NOT_WORKING )
GAME( 2009,skssbtrc,0, unmamed, unmamed, 0, ROT0,"ZK","ŋőog[T[",GAME_NOT_WORKING )
GAME( 2009,ehontmgo,0, unmamed, unmamed, 0, ROT0,"ZK","ق̂܂",GAME_NOT_WORKING )
GAME( 2009,djmaxtec,0, unmamed, unmamed, 0, ROT0,"Neo Wiz","DJMAX TECHNIKA",GAME_NOT_WORKING )
GAME( 2009,gtflekv6,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV6 BLAZING!!!!",GAME_NOT_WORKING )
GAME( 2009,drmmanv6,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV6 BLAZING!!!!",GAME_NOT_WORKING )
GAME( 2009,popnm17m,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN17@UE[r[",GAME_NOT_WORKING )
GAME( 2009,quizmag6,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[6",GAME_NOT_WORKING )
GAME( 2009,razilgi2,naomixu, unmamed, unmamed, 0, ROT0,"}CXg[","WMmA",GAME_NOT_WORKING )
GAME( 2009,mjsgdama,0, unmamed, unmamed, 0, ROT0,"_CibNX","퍑",GAME_NOT_WORKING )
GAME( 1999,streetoz,0, unmamed, unmamed, 0, ROT0,"ZK","Xg[g",GAME_NOT_WORKING )
GAME( 1999,kotbkigp,0, unmamed, unmamed, 0, ROT0,"eN","ƂԂOv",GAME_NOT_WORKING )
GAME( 1999,rizinsun,0, unmamed, unmamed, 0, ROT0,"eN","CWOU UTCK}",GAME_NOT_WORKING )
GAME( 1999,salasnka,0, unmamed, unmamed, 0, ROT0,"eN","T[}",GAME_NOT_WORKING )
GAME( 1999,rapfreek,0, unmamed, unmamed, 0, ROT0,"Ri~","bvt[NX",GAME_NOT_WORKING )
GAME( 1999,crgunhky,0, unmamed, unmamed, 0, ROT0,"eN","NC} KzbP[",GAME_NOT_WORKING )
GAME( 2000,galoprc4,0, unmamed, unmamed, 0, ROT0,"eN","Mbv[T[~jA",GAME_NOT_WORKING )
GAME( 2000,streetgf,0, unmamed, unmamed, 0, ROT0,"eN","Xg[gSt@[",GAME_NOT_WORKING )
GAME( 2000,tybshot,0, unmamed, unmamed, 0, ROT0,"Ri~","eCNAxXgVbg",GAME_NOT_WORKING )
GAME( 2001,galoprc5,sys2x6u, unmamed, unmamed, 0, ROT0,"eN","Mbv[T[T",GAME_NOT_WORKING )
GAME( 2002,hawaideg,0, unmamed, unmamed, 0, ROT0,"Ri~","nCSt`[LvSt",GAME_NOT_WORKING )
GAME( 2002,perfectp,0, unmamed, unmamed, 0, ROT0,"Ri~","p[tFNgv[",GAME_NOT_WORKING )
GAME( 2003,maghexgn,pratnetu, unmamed, unmamed, 0, ROT0,"A[","}WJwLTS",GAME_NOT_WORKING )
GAME( 2003,etrnlglx,pratnetu, unmamed, unmamed, 0, ROT0,"A[","G^[iMNV[",GAME_NOT_WORKING )
GAME( 2003,pjctaltr,pratnetu, unmamed, unmamed, 0, ROT0,"A[","vWFNgA^[",GAME_NOT_WORKING )
GAME( 2003,sokyusnd,pratnetu, unmamed, unmamed, 0, ROT0,"A[","ũZi[f",GAME_NOT_WORKING )
GAME( 2003,moebtlpn,pratnetu, unmamed, unmamed, 0, ROT0,"A[","GogI茠`ՂɂՂɂ炯̃Q[",GAME_NOT_WORKING )
GAME( 2003,nflclasc,0, unmamed, unmamed, 0, ROT0,"iR","mekNVbNtbg{[",GAME_NOT_WORKING )
GAME( 2004,aitaktod,0, unmamed, unmamed, 0, ROT0,"JgE","̃^Ng_X",GAME_NOT_WORKING )
GAME( 2004,grpstmp,0, unmamed, unmamed, 0, ROT0,"JgE","O[rXgv",GAME_NOT_WORKING )
GAME( 2004,btlofdag,0, unmamed, unmamed, 0, ROT0,"iR","UogIuEhA[K",GAME_NOT_WORKING )
GAME( 1999,pnijelly,0, unmamed, unmamed, 0, ROT0,"iR","ՂɂՂɂ[",GAME_NOT_WORKING )
GAME( 1999,cosmowrr,gnetu, unmamed, unmamed, 0, ROT0,"^Cg[","j[xO̎w",GAME_NOT_WORKING )
GAME( 1999,zanfine,sys573u, unmamed, unmamed, 0, ROT0,"Ri~/TNZX","Ut@C",GAME_NOT_WORKING )
GAME( 1999,konomi,0, unmamed, unmamed, 0, ROT0,"s","؂̎",GAME_NOT_WORKING )
GAME( 2000,wwfroyal,naomixu, unmamed, unmamed, 0, ROT0,"ZK","vveCu",GAME_NOT_WORKING )
GAME( 2001,eorldkk2,naomixu, unmamed, unmamed, 0, ROT0,"iR","[hLbNXEIC",GAME_NOT_WORKING )
GAME( 2002,tatakawm,0, unmamed, unmamed, 0, ROT0,"TNZX","E[}",GAME_NOT_WORKING )
GAME( 2002,shtoutpl,naomixu, unmamed, unmamed, 0, ROT0,"ZK","V[gAEgv[",GAME_NOT_WORKING )
GAME( 2002,gspace,0, unmamed, unmamed, 0, ROT0,"iR","f|ro`bd",GAME_NOT_WORKING )
GAME( 2002,mamimume,naomixu, unmamed, unmamed, 0, ROT0,"ZK","܂݂ނ߁ {[",GAME_NOT_WORKING )
GAME( 2003,hyperbwl,0, unmamed, unmamed, 0, ROT0,"ZK","nCp[{E",GAME_NOT_WORKING )
GAME( 2003,quiztatk,0, unmamed, unmamed, 0, ROT0,"T~[","NCY@^CA^bN",GAME_NOT_WORKING )
GAME( 2004,samyvcap,atmiswu, unmamed, unmamed, 0, ROT0,"T~[","T~[vsJvR",GAME_NOT_WORKING )
GAME( 2005,dealerag,0, unmamed, unmamed, 0, ROT0,"A[","fB[[GWFY",GAME_NOT_WORKING )
GAME( 2005,paclipak,0, unmamed, unmamed, 0, ROT0,"Lbc","pbNpbN",GAME_NOT_WORKING )
GAME( 1997,suikohwd,0, unmamed, unmamed, 0, ROT0,"s","_",GAME_NOT_WORKING )
GAME( 2002,daishou,0, unmamed, unmamed, 0, ROT0,"O؏","召",GAME_NOT_WORKING )
GAME( 2002,crownmgc,0, unmamed, unmamed, 0, ROT0,"GCuR[|[V","NE}WbN",GAME_NOT_WORKING )
GAME( 2000,gticlubc,viperu, unmamed, unmamed, 0, ROT0,"Ri~","GTINuER\x83\x5cC^A[m",GAME_NOT_WORKING )
GAME( 2000,pmhokuto,0, unmamed, unmamed, 0, ROT0,"Ri~","p`}jAEkľ",GAME_NOT_WORKING )
GAME( 2000,pmhokto2,0, unmamed, unmamed, 0, ROT0,"Ri~","p`}jAEkľ2 C̍",GAME_NOT_WORKING )
GAME( 2000,ntvyosou,naomixu, unmamed, unmamed, 0, ROT0,"ZK","e\x97\x5czX^WI",GAME_NOT_WORKING )
GAME( 2000,photoply,0, unmamed, unmamed, 0, ROT0,"eN","tHgvC",GAME_NOT_WORKING )
GAME( 2000,magicbox,0, unmamed, unmamed, 0, ROT0,"IG^\x83\x5ctg","}WbN{bNX",GAME_NOT_WORKING )
GAME( 2000,code1dph,viperu, unmamed, unmamed, 0, ROT0,"Ri~","R[hfBXpb`",GAME_NOT_WORKING )
GAME( 2000,kinbansp,0, unmamed, unmamed, 0, ROT0,"Ri~","tbg{[}X^[Y ؓԕtRXyV",GAME_NOT_WORKING )
GAME( 2000,speedhnt,0, unmamed, unmamed, 0, ROT0,"WR","Xs[hn^[",GAME_NOT_WORKING )
GAME( 2001,cgryuprt,0, unmamed, unmamed, 0, ROT0,"IGS","veB`X",GAME_NOT_WORKING )
GAME( 2002,mjdaimdx,0, unmamed, unmamed, 0, ROT0,"_CibNX","喾_DX",GAME_NOT_WORKING )
GAME( 19??,ukiyobak,0, unmamed, unmamed, 0, ROT0,"GNZgVXe","",GAME_NOT_WORKING )
GAME( 19??,chcasino,0, unmamed, unmamed, 0, ROT0,"rfIVXe","`Cj[YJWm",GAME_NOT_WORKING )
GAME( 2005,happytor,0, unmamed, unmamed, 0, ROT0,"GAVJpj[","nbs[cA[",GAME_NOT_WORKING )
GAME( 1999,mjmhlum2,0, unmamed, unmamed, 0, ROT0,"p_CXdq","@̃v2",GAME_NOT_WORKING )
GAME( 19??,vsnetsoc,0, unmamed, unmamed, 0, ROT0,"Ri~","@[TXlbgTbJ[",GAME_NOT_WORKING )
GAME( 2005,valvelmt,typexu, unmamed, unmamed, 0, ROT0,"WR","ou~bg",GAME_NOT_WORKING )
GAME( 19??,himesiki,0, unmamed, unmamed, 0, ROT0,"s","PlG",GAME_NOT_WORKING )
GAME( 2001,cgryu2k1,0, unmamed, unmamed, 0, ROT0,"IGS","2001",GAME_NOT_WORKING )
GAME( 2001,hajimeno,namcos1x, unmamed, unmamed, 0, ROT0,"^Cg[","n[hp`[ ͂߂̈",GAME_NOT_WORKING )
GAME( 2001,bmastjoe,viperu, unmamed, unmamed, 0, ROT0,"Ri~","{NVO}jAẼW[",GAME_NOT_WORKING )
GAME( 2002,dogstatn,0, unmamed, unmamed, 0, ROT0,"Ri~","hbOXe[V",GAME_NOT_WORKING )
GAME( 2005,ryukamj2,0, unmamed, unmamed, 0, ROT0,"iR","ؖQ +4lł",GAME_NOT_WORKING )
GAME( 2005,gundmbos,0, unmamed, unmamed, 0, ROT0,"ovXg","K_@ogIuV~[V",GAME_NOT_WORKING )
GAME( 2006,gigadrak,0, unmamed, unmamed, 0, ROT0,"Ri~","MKhCN IC",GAME_NOT_WORKING )
GAME( 2006,vpinball,0, unmamed, unmamed, 0, ROT0,"tEL","o[`s{[",GAME_NOT_WORKING )
GAME( 2006,fishtime,0, unmamed, unmamed, 0, ROT0,"GCuR[|[V","tBbV^C",GAME_NOT_WORKING )
GAME( 2006,gamerobo,0, unmamed, unmamed, 0, ROT0,"Ri~","Q[{",GAME_NOT_WORKING )
GAME( 2004,pndsac,pratnetu, unmamed, unmamed, 0, ROT0,"A[","hSXC[AC",GAME_NOT_WORKING )
GAME( 2004,pnysac,pratnetu, unmamed, unmamed, 0, ROT0,"A[","C[XAC",GAME_NOT_WORKING )
GAME( 2004,pnxnac,pratnetu, unmamed, unmamed, 0, ROT0,"A[","UihDAC",GAME_NOT_WORKING )
GAME( 2004,pnauac,pratnetu, unmamed, unmamed, 0, ROT0,"A[","pY`AC",GAME_NOT_WORKING )
GAME( 2000,stepstg3,0, unmamed, unmamed, 0, ROT0,"WR","XebsOXe[WR XyA",GAME_NOT_WORKING )
GAME( 2006,coopers9,0, unmamed, unmamed, 0, ROT0,"Ri~","N[p[Y9",GAME_NOT_WORKING )
GAME( 2009,gioramat,0, unmamed, unmamed, 0, ROT0,"ZK","WI}S",GAME_NOT_WORKING )
GAME( 2009,kelberos,naomixu, unmamed, unmamed, 0, ROT0,"zr{bNX","vWFNgPxX",GAME_NOT_WORKING )
GAME( 2009,higurasi,0, unmamed, unmamed, 0, ROT0,"AQC^NeBu","Ђ炵̖ɐ",GAME_NOT_WORKING )
GAME( 2009,idlparad,0, unmamed, unmamed, 0, ROT0,"TNZX/AMI","AChp_CX",GAME_NOT_WORKING )
GAME( 2009,hauntedm,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","z[ebh~[WA",GAME_NOT_WORKING )
GAME( 2009,missingr,0, unmamed, unmamed, 0, ROT0,"Ri~","~bVOOX",GAME_NOT_WORKING )
GAME( 2009,hoserid2,0, unmamed, unmamed, 0, ROT0,"Ri~","z[XC_[Y2",GAME_NOT_WORKING )
GAME( 2009,thebishi,0, unmamed, unmamed, 0, ROT0,"Ri~","UErVoV",GAME_NOT_WORKING )
GAME( 2009,musicdgn,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","~[WbNKKI",GAME_NOT_WORKING )
GAME( 2009,moukenka,0, unmamed, unmamed, 0, ROT0,"PCu","艉̂̉ԓ",GAME_NOT_WORKING )
GAME( 2009,bordrbrk,0, unmamed, unmamed, 0, ROT0,"ZK","{[_[uCN",GAME_NOT_WORKING )
GAME( 2009,mkakt777,0, unmamed, unmamed, 0, ROT0,"Ri~","iy7.77",GAME_NOT_WORKING )
GAME( 2009,gouketjm,0, unmamed, unmamed, 0, ROT0,"AgX/mCYt@Ng[","ꑰՁ@`c{`",GAME_NOT_WORKING )
GAME( 2009,nitropls,0, unmamed, unmamed, 0, ROT0,"}CXg[","jgvXΐi",GAME_NOT_WORKING )
GAME( 2009,dethsml2,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","fXX}CY2@Ẽ[NX}X",GAME_NOT_WORKING )
GAME( 2009,mj4saki,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃Saki~MJ4",GAME_NOT_WORKING )
GAME( 2009,chaoscod,0, unmamed, unmamed, 0, ROT0,"FKfW^","JIXR[h",GAME_NOT_WORKING )
GAME( 2009,kf2k2ult,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOIut@C^[Y2002 ULTIMATE MATCH",GAME_NOT_WORKING )
GAME( 2009,gettenka,0, unmamed, unmamed, 0, ROT0,"ZK","jΐQbeJ",GAME_NOT_WORKING )
GAME( 2009,lilpri,0, unmamed, unmamed, 0, ROT0,"ZK","Ղ@тՂЂ߃`FI",GAME_NOT_WORKING )
GAME( 2009,bm2dx17s,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIDX17 SIRIUS",GAME_NOT_WORKING )
GAME( 2009,shanhain,0, unmamed, unmamed, 0, ROT0,"TNZX","C",GAME_NOT_WORKING )
GAME( 2009,starhosp,0, unmamed, unmamed, 0, ROT0,"ZK","X^[z[X vOX^[Y",GAME_NOT_WORKING )
GAME( 2009,taiko12d,0, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl12 h[IƑʔ",GAME_NOT_WORKING )
GAME( 2009,tanktank,0, unmamed, unmamed, 0, ROT0,"iR","TANK! TANK! TANK!",GAME_NOT_WORKING )
GAME( 2009,ochainup,0, unmamed, unmamed, 0, ROT0,"ACfAt@Ng[","pY",GAME_NOT_WORKING )
GAME( 2009,zigsawpz,0, unmamed, unmamed, 0, ROT0,"ACfAt@Ng[","WO\x83\x5c[pXq[[",GAME_NOT_WORKING )
GAME( 2009,touchman,0, unmamed, unmamed, 0, ROT0,"ACfAt@Ng[","^b`}jA",GAME_NOT_WORKING )
GAME( 2009,wccf0809,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK/qbg[J[","[hNu `sItbg{[ C^[iViNuX 2008-2009",GAME_NOT_WORKING )
GAME( 2009,mocapspt,0, unmamed, unmamed, 0, ROT0,"Ri~","[LvX|[c",GAME_NOT_WORKING )
GAME( 2009,miraikbp,0, unmamed, unmamed, 0, ROT0,"ZK","x@og|[X",GAME_NOT_WORKING )
GAME( 2009,mjkaktgt,0, unmamed, unmamed, 0, ROT0,"Ri~","iy@䗴]",GAME_NOT_WORKING )
GAME( 2009,bbhero09,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y2009e",GAME_NOT_WORKING )
GAME( 2009,sangkt3t,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","Ou3@Ver3.5@҂P̓V",GAME_NOT_WORKING )
GAME( 2009,chaomang,0, unmamed, unmamed, 0, ROT0,"ZK","Ⴈ܂񂪃Xe[V",GAME_NOT_WORKING )
GAME( 2010,chouchab,0, unmamed, unmamed, 0, ROT0,"^Cg[","EԑԂI",GAME_NOT_WORKING )
GAME( 2009,metlgrac,0, unmamed, unmamed, 0, ROT0,"Ri~","^MAA[P[h",GAME_NOT_WORKING )
GAME( 2009,topspedn,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","gbvXs[h",GAME_NOT_WORKING )
GAME( 2009,simensok,0, unmamed, unmamed, 0, ROT0,"GNT","V\x83\x5cJX",GAME_NOT_WORKING )
GAME( 2009,garileo2,0, unmamed, unmamed, 0, ROT0,"ZK","KIt@Ng[2",GAME_NOT_WORKING )
GAME( 2008,mjkokryu,0, unmamed, unmamed, 0, ROT0,"_CibNX","",GAME_NOT_WORKING )
GAME( 2009,mjokinam,0, unmamed, unmamed, 0, ROT0,"_CibNX","ꖺ",GAME_NOT_WORKING )
GAME( 2009,lordofv3,typexu, unmamed, unmamed, 0, ROT0,"XNEFAGjbNX/^Cg[","[hIu@[~I@̗U",GAME_NOT_WORKING )
GAME( 2009,lordofv4,typexu, unmamed, unmamed, 0, ROT0,"XNEFAGjbNX/^Cg[","[hIu@[~I@ׂւ̉A",GAME_NOT_WORKING )
GAME( 2009,jubeatrp,0, unmamed, unmamed, 0, ROT0,"Ri~","jubeat ripples",GAME_NOT_WORKING )
GAME( 2009,avalon3,0, unmamed, unmamed, 0, ROT0,"ZK","A@̌ ONLINE",GAME_NOT_WORKING )
GAME( 2009,blockppl,0, unmamed, unmamed, 0, ROT0,"ZK","Ԃҁ[ہ[",GAME_NOT_WORKING )
GAME( 2009,shiningf,0, unmamed, unmamed, 0, ROT0,"ZK","VCjOtH[XNX",GAME_NOT_WORKING )
GAME( 2009,musikink,0, unmamed, unmamed, 0, ROT0,"ZK","KbcII VLOog",GAME_NOT_WORKING )
GAME( 2009,cyberdiv,typexu, unmamed, unmamed, 0, ROT0,"^Cg[","TCo[_Co[",GAME_NOT_WORKING )
GAME( 2009,uhauhaok,0, unmamed, unmamed, 0, ROT0,"PCu","EnEn剜",GAME_NOT_WORKING )
GAME( 2010,tenkashg,0, unmamed, unmamed, 0, ROT0,"Ri~","Vꏫ",GAME_NOT_WORKING )
GAME( 2010,dstmpirt,0, unmamed, unmamed, 0, ROT0,"iR","fbhXg[pC[c",GAME_NOT_WORKING )
GAME( 2009,taiko13,0, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl13",GAME_NOT_WORKING )
GAME( 2010,kofskyst,0, unmamed, unmamed, 0, ROT0,"^Cg[","KOF SKY STAGE",GAME_NOT_WORKING )
GAME( 2010,minadewa,0, unmamed, unmamed, 0, ROT0,"^Cg[","݂ȂŃbƁI",GAME_NOT_WORKING )
GAME( 2009,dekalis,0, unmamed, unmamed, 0, ROT0,"ZK","TETRIS fJX",GAME_NOT_WORKING )
GAME( 2010,tgm4,0, unmamed, unmamed, 0, ROT0,"ZK/AJ","egXEUEOh}X^[4@UE}X^[YIuEh",GAME_NOT_WORKING )
GAME( 2010,gtflekxg,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXXG",GAME_NOT_WORKING )
GAME( 2010,drmmanxg,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAXG",GAME_NOT_WORKING )
GAME( 2010,zigsawwa,0, unmamed, unmamed, 0, ROT0,"ACfAt@Ng[","WO\x83\x5c[[hA[i",GAME_NOT_WORKING )
GAME( 2010,eternlk3,0, unmamed, unmamed, 0, ROT0,"Ri~","G^[iiCcR@E҂̌n",GAME_NOT_WORKING )
GAME( 2010,popnm18s,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN18@񂲂`",GAME_NOT_WORKING )
GAME( 2010,satestrk,0, unmamed, unmamed, 0, ROT0,"Ri~","TeCgXgCN",GAME_NOT_WORKING )
GAME( 2009,arcanh3n,0, unmamed, unmamed, 0, ROT0,"GNT","AJin[g3",GAME_NOT_WORKING )
GAME( 2009,lordofv5,0, unmamed, unmamed, 0, ROT0,"XNEFAGjbNX/^Cg[","[hIu@[~III",GAME_NOT_WORKING )
GAME( 2010,segamj4e,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","ZKlbg[Nΐ햃MJ4 G{[V",GAME_NOT_WORKING )
GAME( 2010,medalgun,0, unmamed, unmamed, 0, ROT0,"ZK","_̃K}",GAME_NOT_WORKING )
GAME( 2010,roadftrs,0, unmamed, unmamed, 0, ROT0,"Ri~","[ht@C^[Y",GAME_NOT_WORKING )
GAME( 2010,exceptn,0, unmamed, unmamed, 0, ROT0,"TNZX","GNZvV",GAME_NOT_WORKING )
GAME( 2010,hammer2,0, unmamed, unmamed, 0, ROT0,"ZK","HUMMER EXTREME EDITION",GAME_NOT_WORKING )
GAME( 2010,typhoons,0, unmamed, unmamed, 0, ROT0,"ZK/gIebN","TYPHOON",GAME_NOT_WORKING )
GAME( 2010,speedrid,0, unmamed, unmamed, 0, ROT0,"IGS/A^","Xs[hC_[",GAME_NOT_WORKING )
GAME( 2010,h2overdv,0, unmamed, unmamed, 0, ROT0,"iR","H2 OVERDRIVE",GAME_NOT_WORKING )
GAME( 2010,specfire,0, unmamed, unmamed, 0, ROT0,"^Cg[","XyNg t@CA[{[",GAME_NOT_WORKING )
GAME( 2010,sgoroket,0, unmamed, unmamed, 0, ROT0,"ZK","߁IXSPbc",GAME_NOT_WORKING )
GAME( 2010,heatuphc,0, unmamed, unmamed, 0, ROT0,"ZK","q[gAbvzbP[ C}[W",GAME_NOT_WORKING )
GAME( 2010,putt,0, unmamed, unmamed, 0, ROT0,"Ri~","PUTT!",GAME_NOT_WORKING )
GAME( 2009,brayblu2,sys2x6u, unmamed, unmamed, 0, ROT0,"A[NVXe[NX","uCu[ ReBjAVtg",GAME_NOT_WORKING )
GAME( 2010,quizmag7,0, unmamed, unmamed, 0, ROT0,"Ri~","NCY}WbNAJf~[7",GAME_NOT_WORKING )
GAME( 2010,ongakup,0, unmamed, unmamed, 0, ROT0,"Ri~","IKNp_CX",GAME_NOT_WORKING )
GAME( 2010,winele10,0, unmamed, unmamed, 0, ROT0,"Ri~","[hTbJ[ ECjOCu A[P[h`sIVbv 2010",GAME_NOT_WORKING )
GAME( 2010,prjdevac,0, unmamed, unmamed, 0, ROT0,"ZK","vWFNgfB[@@A[P[h",GAME_NOT_WORKING )
GAME( 2010,strania,typexu, unmamed, unmamed, 0, ROT0,"Ot","|@XgjA",GAME_NOT_WORKING )
GAME( 2010,ddp4bl,caveu, unmamed, unmamed, 0, ROT0,"PCu/AMI","{̖I啜 ubN[x",GAME_NOT_WORKING )
GAME( 2010,wangn3dp,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","p݃~bhiCgMAXI TUNE 3 DX+",GAME_NOT_WORKING )
GAME( 2010,jubeatkt,0, unmamed, unmamed, 0, ROT0,"Ri~","jubeat@knit",GAME_NOT_WORKING )
GAME( 2010,milionkp,0, unmamed, unmamed, 0, ROT0,"Ri~","MILLION KEEPER",GAME_NOT_WORKING )
GAME( 2010,sngktisn,0, unmamed, unmamed, 0, ROT0,"ZK","퍑",GAME_NOT_WORKING )
GAME( 2010,meltybd4,0, unmamed, unmamed, 0, ROT0,"GR[/TYPEMOON","eBubh@ANgXAQC@JgR[h",GAME_NOT_WORKING )
GAME( 2010,answr2dx,0, unmamed, unmamed, 0, ROT0,"ZK","lbg[NΐNCYAnswer~Answer2DX",GAME_NOT_WORKING )
GAME( 2010,ami3,0, unmamed, unmamed, 0, ROT0,"ZK","A~No3",GAME_NOT_WORKING )
GAME( 2010,alajewel,0, unmamed, unmamed, 0, ROT0,"ZK","ArAWG",GAME_NOT_WORKING )
GAME( 2010,jewelpet,0, unmamed, unmamed, 0, ROT0,"ZK","WGybg `LL@̕Δ`",GAME_NOT_WORKING )
GAME( 2010,gaiaatk4,0, unmamed, unmamed, 0, ROT0,"^Cg[","KCAA^bN4",GAME_NOT_WORKING )
GAME( 2010,hoppinrk,0, unmamed, unmamed, 0, ROT0,"^Cg[","zbsO[hLbY",GAME_NOT_WORKING )
GAME( 2010,musicgdx,0, unmamed, unmamed, 0, ROT0,"^Cg[","~[WbNKKIȂςŁI",GAME_NOT_WORKING )
GAME( 2010,sekiryuh,0, unmamed, unmamed, 0, ROT0,"^Cg[","t@^W[ RVAII@ԗ",GAME_NOT_WORKING )
GAME( 2010,gndmexvs,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","@mK_EXTREME VS.",GAME_NOT_WORKING )
GAME( 2010,razingsd,0, unmamed, unmamed, 0, ROT0,"iR","CWOXg[SD",GAME_NOT_WORKING )
GAME( 2010,tmntslvg,0, unmamed, unmamed, 0, ROT0,"iR","^[~l[^[@Tx[V",GAME_NOT_WORKING )
GAME( 2010,pkmnkkgt,0, unmamed, unmamed, 0, ROT0,"iR","|P邭Qbg",GAME_NOT_WORKING )
GAME( 2010,rsonline,0, unmamed, unmamed, 0, ROT0,"A[GX","RSIC",GAME_NOT_WORKING )
GAME( 2010,kof13,typexu, unmamed, unmamed, 0, ROT0,"SNKvCA","UELOIut@C^[YXIII",GAME_NOT_WORKING )
GAME( 2010,ochainun,0, unmamed, unmamed, 0, ROT0,"RpCn[g","̃pY",GAME_NOT_WORKING )
GAME( 2010,metalgac,0, unmamed, unmamed, 0, ROT0,"Ri~","^MA@A[P[h",GAME_NOT_WORKING )
GAME( 2010,magician,0, unmamed, unmamed, 0, ROT0,"k{ʐMH","}WV",GAME_NOT_WORKING )
GAME( 2010,crutchst,0, unmamed, unmamed, 0, ROT0,"k{ʐMH","Nb`V[^[",GAME_NOT_WORKING )
GAME( 2010,acesnper,0, unmamed, unmamed, 0, ROT0,"k{ʐMH","G[XXiCp[",GAME_NOT_WORKING )
GAME( 2010,bbpirats,0, unmamed, unmamed, 0, ROT0,"AW[","rrpC[c",GAME_NOT_WORKING )
GAME( 2010,fortunew,0, unmamed, unmamed, 0, ROT0,"AW[","tH[`[Ch",GAME_NOT_WORKING )
GAME( 2010,stomprdx,0, unmamed, unmamed, 0, ROT0,"gIebN","STOMPER DX",GAME_NOT_WORKING )
GAME( 2010,cookmain,0, unmamed, unmamed, 0, ROT0,"ZK","NbLACh@ACI}CI܂",GAME_NOT_WORKING )
GAME( 2010,bakumaru,0, unmamed, unmamed, 0, ROT0,"ZK","",GAME_NOT_WORKING )
GAME( 2010,giturftv,0, unmamed, unmamed, 0, ROT0,"Ri~","GI-turfTV",GAME_NOT_WORKING )
GAME( 2010,dragonht,0, unmamed, unmamed, 0, ROT0,"Ri~","hSn^[",GAME_NOT_WORKING )
GAME( 2010,enueink,0, unmamed, unmamed, 0, ROT0,"SUBTLE STYLE","GkACSE",GAME_NOT_WORKING )
GAME( 2010,refrecbt,0, unmamed, unmamed, 0, ROT0,"Ri~","REFLEC BEAT",GAME_NOT_WORKING )
GAME( 2010,kingyosk,0, unmamed, unmamed, 0, ROT0,"ZK","񂬂傷",GAME_NOT_WORKING )
GAME( 2010,letsgois,0, unmamed, unmamed, 0, ROT0,"ZK","bcS[ACh",GAME_NOT_WORKING )
GAME( 2010,trfmanim,0, unmamed, unmamed, 0, ROT0,"ZK","gXtH[}[ AjCebh",GAME_NOT_WORKING )
GAME( 2010,bbhero10,0, unmamed, unmamed, 0, ROT0,"Ri~","x[X{[q[[Y2010",GAME_NOT_WORKING )
GAME( 2010,bm2dx18r,0, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jAIIDX18 Resort Anthem",GAME_NOT_WORKING )
GAME( 2010,ssf4,typexu, unmamed, unmamed, 0, ROT0,"JvR","X[p[Xg[gt@C^[IV",GAME_NOT_WORKING )
GAME( 2010,sangkt3w,lindbrgu, unmamed, unmamed, 0, ROT0,"ZK","Ou3@Ver3.59@War Begins",GAME_NOT_WORKING )
GAME( 2010,gtflekv7,0, unmamed, unmamed, 0, ROT0,"Ri~","M^[t[NXV7",GAME_NOT_WORKING )
GAME( 2010,drmmanv7,0, unmamed, unmamed, 0, ROT0,"Ri~","h}jAV7",GAME_NOT_WORKING )
GAME( 2010,ddrx2,0, unmamed, unmamed, 0, ROT0,"Ri~","_X_X{[V X2",GAME_NOT_WORKING )
GAME( 2010,scardgen,0, unmamed, unmamed, 0, ROT0,"ZK","SEGA CARD GEN MLB",GAME_NOT_WORKING )
GAME( 2010,taiko14,0, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl14",GAME_NOT_WORKING )
GAME( 2010,popnm19t,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN19 TUNE STREET",GAME_NOT_WORKING )
GAME( 2010,panoramf,0, unmamed, unmamed, 0, ROT0,"Ri~","pm}t@^W[",GAME_NOT_WORKING )
GAME( 2010,tikitiki,0, unmamed, unmamed, 0, ROT0,"iR","`L`L}V҃[X Wacky Races",GAME_NOT_WORKING )
GAME( 2010,tttravel,0, unmamed, unmamed, 0, ROT0,"ZK","^b`^b`gx",GAME_NOT_WORKING )
GAME( 2010,akaikata,0, unmamed, unmamed, 0, ROT0,"PCu/AMI","Ԃ",GAME_NOT_WORKING )
GAME( 2010,loveplus,0, unmamed, unmamed, 0, ROT0,"Ri~","uvX@A[P[h",GAME_NOT_WORKING )
GAME( 2000,hanatudx,0, unmamed, unmamed, 0, ROT0,"_CibNX","ԎDؒDELUXEO`",GAME_NOT_WORKING )
GAME( 1998,hanakadx,0, unmamed, unmamed, 0, ROT0,"_CibNX","ԎDؗzDELUXE",GAME_NOT_WORKING )
GAME( 2010,starhs25,0, unmamed, unmamed, 0, ROT0,"ZK","X^[z[X2 t@CifBXeBl[V",GAME_NOT_WORKING )
GAME( 2010,darabust,0, unmamed, unmamed, 0, ROT0,"^Cg[","_CAXo[Xg@AiU[NjN",GAME_NOT_WORKING )
GAME( 2010,hellokty,0, unmamed, unmamed, 0, ROT0,"GNT","n[LeBƂ܂ق̃Gv",GAME_NOT_WORKING )
GAME( 2010,pengo8,0, unmamed, unmamed, 0, ROT0,"ZK","ySI",GAME_NOT_WORKING )
GAME( 2010,mjkaktuv,0, unmamed, unmamed, 0, ROT0,"Ri~","iy@AeBbgo[W",GAME_NOT_WORKING )
GAME( 2010,answr2lv,0, unmamed, unmamed, 0, ROT0,"ZK","lbg[NΐNCYAnswer~Answer Live!",GAME_NOT_WORKING )
GAME( 2010,vf5final,0, unmamed, unmamed, 0, ROT0,"ZK","o[`t@C^[5@t@CiV[_E",GAME_NOT_WORKING )
GAME( 2001,taiko2,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl2",GAME_NOT_WORKING )
GAME( 2002,taiko3,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl3",GAME_NOT_WORKING )
GAME( 2003,taiko4,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl4",GAME_NOT_WORKING )
GAME( 2003,taiko5,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl5",GAME_NOT_WORKING )
GAME( 2004,taiko6,namcos1x, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl6",GAME_NOT_WORKING )
GAME( 2004,taiko7,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl7",GAME_NOT_WORKING )
GAME( 2005,taiko8,sys2x6u, unmamed, unmamed, 0, ROT0,"iR","ۂ̒Bl8",GAME_NOT_WORKING )
GAME( 1999,popnm2,djmain, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN2",GAME_NOT_WORKING )
GAME( 1999,popnm3,djmain, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN3",GAME_NOT_WORKING )
GAME( 200?,popnm4,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN4",GAME_NOT_WORKING )
GAME( 200?,popnm5,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN5",GAME_NOT_WORKING )
GAME( 200?,popnm6,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN6",GAME_NOT_WORKING )
GAME( 200?,popnm7,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN7",GAME_NOT_WORKING )
GAME( 200?,popnm8,firebeat, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN8",GAME_NOT_WORKING )
GAME( 200?,popnm9,viperu, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN9",GAME_NOT_WORKING )
GAME( 200?,popnm10,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN10",GAME_NOT_WORKING )
GAME( 200?,popnm11,0, unmamed, unmamed, 0, ROT0,"Ri~","|bv~[WbN11",GAME_NOT_WORKING )
GAME( 1994,namcos1x,0, unmamed, unmamed, 0, ROT0,"iR","_Ήi_namcos1x",GAME_NOT_WORKING )
GAME( 1997,djmain,0, unmamed, unmamed, 0, ROT0,"Ri~","_Ήi_djmain",GAME_NOT_WORKING )
GAME( 2000,firebeat,0, unmamed, unmamed, 0, ROT0,"Ri~","_Ήi_firebeat",GAME_NOT_WORKING )
GAME( 2002,beatm7th,djmain, unmamed, unmamed, 0, ROT0,"Ri~","r[g}jA 7th MIX",GAME_NOT_WORKING )
GAME( 1999,pstagex,djmain, unmamed, unmamed, 0, ROT0,"Ri~","|bvXe[W EX",GAME_NOT_WORKING )
GAME( 2001,drumm,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master / h}X^[",GAME_NOT_WORKING )
GAME( 2001,drum2,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 2 / h}X^[2",GAME_NOT_WORKING )
GAME( 2002,drum3,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 3 / h}X^[3",GAME_NOT_WORKING )
GAME( 2003,drum4,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 4 / h}X^[4",GAME_NOT_WORKING )
GAME( 2003,drum5,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 5 / h}X^[5",GAME_NOT_WORKING )
GAME( 2004,drum6,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 6 / h}X^[6",GAME_NOT_WORKING )
GAME( 2005,drum7,namcos1x, unmamed, unmamed, 0, ROT0,"iR","Drum Master 7 / h}X^[7",GAME_NOT_WORKING )
GAME( 2002,hajimei2,namcos1x, unmamed, unmamed, 0, ROT0,"iR / ^Cg[","n[hp`[ ͂߂̈2 ҂ւ̒",GAME_NOT_WORKING )
GAME( 2001,gahahai2,namcos1x, unmamed, unmamed, 0, ROT0,"iR / g","GAHAHAꔭ2",GAME_NOT_WORKING )
GAME( 2002,kurukuru,namcos1x, unmamed, unmamed, 0, ROT0,"iR","邭t[h",GAME_NOT_WORKING )
GAME( 2001,panekuru,namcos1x, unmamed, unmamed, 0, ROT0,"iR","pjplN",GAME_NOT_WORKING )
GAME( 1996,stv,0, unmamed, unmamed, 0, ROT0,"ZK","_Ήi_stv",GAME_NOT_WORKING )
GAME( 1997,priclub2,stv, unmamed, unmamed, 0, ROT0,"AgX","vgy2",GAME_NOT_WORKING )
GAME( 1997,nameclub,stv, unmamed, unmamed, 0, ROT0,"ZK","l[y",GAME_NOT_WORKING )
GAME( 1999,priclubp,stv, unmamed, unmamed, 0, ROT0,"AgX","vgy |P B",GAME_NOT_WORKING )
GAME( 1988,namcos2x,0, unmamed, unmamed, 0, ROT0,"iR","_Ήi_namcos2x",GAME_NOT_WORKING )


