#ifdef DASM1
    case 0x01:
      sprintf(buf, "abs");
      break;

    case 0x02:
      sprintf(buf, "neg");
      break;

    case 0x03:
      sprintf(buf, "add %s,a", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x04:
      sprintf(buf, "add %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x05:
      sprintf(buf, "add %s,m", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x06:
      sprintf(buf, "add %s,m", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x07:
      sprintf(buf, "add %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x08:
      sprintf(buf, "adds %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x09:
      sprintf(buf, "sub %s,a", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x0a:
      sprintf(buf, "sub %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x0b:
      sprintf(buf, "sub %s,m", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x0c:
      sprintf(buf, "sub %s,m", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x0d:
      sprintf(buf, "sub %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x10:
      sprintf(buf, "zacc");
      break;

    case 0x11:
      sprintf(buf, "lacd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x12:
      sprintf(buf, "lacc %s", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x13:
      sprintf(buf, "cmpl");
      break;

    case 0x14:
      sprintf(buf, "and %s,a", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x15:
      sprintf(buf, "and %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x16:
      sprintf(buf, "and %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x17:
      sprintf(buf, "or %s,a", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x18:
      sprintf(buf, "or %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x19:
      sprintf(buf, "or %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x1a:
      sprintf(buf, "xor %s,a", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x1b:
      sprintf(buf, "xor %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x1c:
      sprintf(buf, "xor %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x21:
      sprintf(buf, "mpy %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x22:
      sprintf(buf, "mpy %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x23:
      sprintf(buf, "mpy creg,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x24:
      sprintf(buf, "mac %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x25:
      sprintf(buf, "mac a,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x26:
      sprintf(buf, "mac %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x28:
      sprintf(buf, "mpyu %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x29:
      sprintf(buf, "macu %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x2a:
      sprintf(buf, "macu a,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x2c:
      sprintf(buf, "ampy %s,%s,a", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x2d:
      sprintf(buf, "amac %s,%s,a", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x2e:
      sprintf(buf, "macs %s,a", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x30:
      sprintf(buf, "zmac");
      break;

    case 0x31:
      sprintf(buf, "lmhd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x32:
      sprintf(buf, "lmld %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x33:
      sprintf(buf, "lmhc %s", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x34:
      sprintf(buf, "sfml");
      break;

    case 0x35:
      sprintf(buf, "sfmr");
      break;

    case 0x38:
      sprintf(buf, "wre %s,%s", tms57002_get_memadr(opcode, 'd'), tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x39:
      sprintf(buf, "rde %s", tms57002_get_memadr(opcode, 'c'));
      break;

#endif

#ifdef DASM2
    case 0x01:
      sprintf(buf, "sacc %s", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x02:
      sprintf(buf, "sacd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x03:
      sprintf(buf, "smhd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x04:
      sprintf(buf, "smld %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x05:
      sprintf(buf, "smhc %s", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x06:
      sprintf(buf, "slmh %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x07:
      sprintf(buf, "slml %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x08:
      sprintf(buf, "lcaa");
      break;

    case 0x09:
      sprintf(buf, "lira");
      break;

    case 0x0c:
      sprintf(buf, "ld0t %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x0d:
      sprintf(buf, "std1 %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x0e:
      sprintf(buf, "ref");
      break;

    case 0x0f:
      sprintf(buf, "srbd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x10:
      sprintf(buf, "dis si0_l,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x11:
      sprintf(buf, "dis si0_r,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x12:
      sprintf(buf, "dis si1_l,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x13:
      sprintf(buf, "dis si1_r,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x14:
      sprintf(buf, "dimh si0_l");
      break;

    case 0x15:
      sprintf(buf, "dimh si0_r");
      break;

    case 0x16:
      sprintf(buf, "dimh si1_l");
      break;

    case 0x17:
      sprintf(buf, "dimh si1_r");
      break;

    case 0x18:
      sprintf(buf, "diml si0_l");
      break;

    case 0x19:
      sprintf(buf, "diml si0_r");
      break;

    case 0x1a:
      sprintf(buf, "diml si1_l");
      break;

    case 0x1b:
      sprintf(buf, "diml si1_r");
      break;

    case 0x1c:
      sprintf(buf, "dos so0_l,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x1d:
      sprintf(buf, "dos so0_r,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x1e:
      sprintf(buf, "dos so1_l,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x1f:
      sprintf(buf, "dos so1_r,%s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x20:
      sprintf(buf, "domh so0_l");
      break;

    case 0x21:
      sprintf(buf, "domh so0_r");
      break;

    case 0x22:
      sprintf(buf, "domh so1_l");
      break;

    case 0x23:
      sprintf(buf, "domh so1_r");
      break;

    case 0x24:
      sprintf(buf, "doml so0_l");
      break;

    case 0x25:
      sprintf(buf, "doml so0_r");
      break;

    case 0x26:
      sprintf(buf, "doml so1_l");
      break;

    case 0x27:
      sprintf(buf, "doml so1_r");
      break;

    case 0x30:
      sprintf(buf, "lpd %s", tms57002_get_memadr(opcode, 'd'));
      break;

    case 0x31:
      sprintf(buf, "lpc %s", tms57002_get_memadr(opcode, 'c'));
      break;

    case 0x38:
      sprintf(buf, "raov");
      break;

    case 0x3a:
      sprintf(buf, "rmov");
      break;

    case 0x40:
      sprintf(buf, "rmom");
      break;

    case 0x41:
      sprintf(buf, "smom");
      break;

    case 0x42:
      sprintf(buf, "incd");
      break;

    case 0x44:
      sprintf(buf, "ldpk 0");
      break;

    case 0x45:
      sprintf(buf, "ldpk 1");
      break;

    case 0x48:
      sprintf(buf, "scrm 32");
      break;

    case 0x49:
      sprintf(buf, "scrm 16h");
      break;

    case 0x4a:
      sprintf(buf, "scrm 16l");
      break;

    case 0x4b:
      sprintf(buf, "scrm <3>");
      break;

    case 0x50:
      sprintf(buf, "sfao 0");
      break;

    case 0x51:
      sprintf(buf, "sfao 7");
      break;

    case 0x54:
      sprintf(buf, "sfai 0");
      break;

    case 0x55:
      sprintf(buf, "sfai -1");
      break;

    case 0x58:
      sprintf(buf, "sfma 0");
      break;

    case 0x59:
      sprintf(buf, "sfma 2");
      break;

    case 0x5a:
      sprintf(buf, "sfma 4");
      break;

    case 0x5b:
      sprintf(buf, "sfma -16");
      break;

    case 0x60:
      sprintf(buf, "sfmo 0");
      break;

    case 0x61:
      sprintf(buf, "sfmo 2");
      break;

    case 0x62:
      sprintf(buf, "sfmo 4");
      break;

    case 0x63:
      sprintf(buf, "sfmo -8");
      break;

    case 0x68:
      sprintf(buf, "rnd 48");
      break;

    case 0x69:
      sprintf(buf, "rnd 32");
      break;

    case 0x6a:
      sprintf(buf, "rnd 24");
      break;

    case 0x6b:
      sprintf(buf, "rnd 20");
      break;

    case 0x6c:
      sprintf(buf, "rnd 16");
      break;

    case 0x6d:
      sprintf(buf, "rnd <5>");
      break;

    case 0x6e:
      sprintf(buf, "rnd <6>");
      break;

    case 0x6f:
      sprintf(buf, "rnd <7>");
      break;

#endif

#ifdef DASM3
    case 0x08:
      sprintf(buf, "idle");
      break;

    case 0x10:
      sprintf(buf, "rptk %02x", opcode & 0xff);
      break;

    case 0x18:
      sprintf(buf, "lcak %02x", opcode & 0xff);
      break;

    case 0x20:
      sprintf(buf, "lirk %02x", opcode & 0xff);
      break;

    case 0x28:
      sprintf(buf, "lbrk %02x", opcode & 0xff);
      break;

    case 0x40:
      sprintf(buf, "lcac %02x", opcode & 0xff);
      break;

    case 0x48:
      sprintf(buf, "b %02x", opcode & 0xff);
      break;

    case 0x50:
      sprintf(buf, "bgz %02x", opcode & 0xff);
      break;

    case 0x58:
      sprintf(buf, "blz %02x", opcode & 0xff);
      break;

    case 0x60:
      sprintf(buf, "bnz %02x", opcode & 0xff);
      break;

    case 0x70:
      sprintf(buf, "bioz %02x", opcode & 0xff);
      break;

    case 0x78:
      sprintf(buf, "bv %02x", opcode & 0xff);
      break;

#endif

#ifdef INTRP1
case 0x01: // abs
  s->aacc = tms57002_aacc_to_output(s);
  if(((INT32)s->aacc) < 0) {
    s->aacc = - s->aacc;
    if(((INT32)s->aacc) < 0)
      s->st1 |= ST1_AOV;
  }
  break;

case 0x03: // add
  r = (INT64)(INT32)(tms57002_opc_read_d(s, opcode) << 8) + (INT64)(INT32)tms57002_aacc_to_output(s);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x04: // add
  r = (INT64)(INT32)tms57002_opc_read_c(s, opcode) + (INT64)(INT32)tms57002_aacc_to_output(s);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x05: // add
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output(s) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x06: // add
  r = (INT64)(INT32)tms57002_opc_read_c(s, opcode) + (tms57002_macc_to_output(s) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x07: // add
  r = (INT64)(INT32)(tms57002_opc_read_d(s, opcode) << 8) + (INT64)(INT32)tms57002_opc_read_c(s, opcode);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x09: // sub
  r = (INT64)(INT32)(tms57002_opc_read_d(s, opcode) << 8) - (INT64)(INT32)tms57002_aacc_to_output(s);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x0a: // sub
  r = (INT64)(INT32)tms57002_opc_read_c(s, opcode) - (INT64)(INT32)tms57002_aacc_to_output(s);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x0d: // sub
  r = (INT64)(INT32)(tms57002_opc_read_d(s, opcode) << 8) - (INT64)(INT32)tms57002_opc_read_c(s, opcode);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 0x11: // lacd
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  s->aacc = d;
  break;

case 0x12: // lacc
  s->aacc = tms57002_opc_read_c(s, opcode);
  break;

case 0x14: // and
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  s->aacc &= d;
  break;

case 0x15: // and
  s->aacc &= tms57002_opc_read_c(s, opcode);
  break;

case 0x16: // and
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  s->aacc = tms57002_opc_read_c(s, opcode) & d;
  break;

case 0x17: // or
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  s->aacc |= d;
  break;

case 0x18: // or
  s->aacc |= tms57002_opc_read_c(s, opcode);
  break;

case 0x19: // or
  d =  (tms57002_opc_read_d(s, opcode) << 8);
  if(s->st1 & ST1_SFAI)
    d = ((INT32)d) >> 1;
  s->aacc = tms57002_opc_read_c(s, opcode) | d;
  break;

case 0x21: // mpy
  d = tms57002_opc_read_d(s, opcode);
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 0x22: // mpy
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)(INT32)tms57002_aacc_to_output(s);
  s->macc = r >> 15;
  break;

case 0x24: // mac
  d = tms57002_opc_read_d(s, opcode);
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = tms57002_macc_to_loop(s) + (r >> 7);
  break;

case 0x26: // mac
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)(INT32)tms57002_aacc_to_output(s);
  s->macc = tms57002_macc_to_loop(s) + (r >> 15);
  break;

case 0x28: // mpyu
  s->creg = c = tms57002_opc_read_c(s, opcode);
  d = tms57002_opc_read_d(s, opcode); // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 0x29: // macu
  d = tms57002_opc_read_d(s, opcode); // d is 24bits unsigned
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = tms57002_macc_to_loop(s) + (r >> 7);
  break;

case 0x2a: // macu
  d = tms57002_opc_read_d(s, opcode); // d is 24bits unsigned
  s->creg = c = tms57002_aacc_to_output(s);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = tms57002_macc_to_loop(s) + (r >> 7);
  break;

case 0x2e: // macs
  s->creg = c = tms57002_opc_read_c(s, opcode);
  r = (INT64)(INT32)c * (INT64)(INT32)tms57002_aacc_to_output(s);
  s->macc = tms57002_macc_to_loop(s) + (r >> 14);
  break;

case 0x31: // lmhd
  s->macc = ((INT64)(INT32)(tms57002_opc_read_d(s, opcode) << 8)) << 16;
  break;

case 0x32: // lmld
  s->macc = (s->macc & ~0xffffffULL) | tms57002_opc_read_d(s, opcode);
  break;

case 0x33: // lmhc
  s->macc = ((INT64)(INT32)tms57002_opc_read_c(s, opcode)) << 16;
  break;

case 0x34: // sfml
  s->macc = (s->macc & 0x8000000000000ULL) | ((s->macc << 1) & 0x7ffffffffffffULL);
  break;

case 0x38: // wre
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = tms57002_opc_read_d(s, opcode);
  s->xoa = tms57002_opc_read_c(s, opcode);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 0x39: // rde
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = tms57002_opc_read_c(s, opcode);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

#endif

#ifdef INTRP2A
case 0x01: // sacc
  tms57002_opc_write_c(s, opcode, tms57002_aacc_to_output(s));
  break;

case 0x02: // sacd
  tms57002_opc_write_d(s, opcode, tms57002_aacc_to_output(s) >> 8);
  break;

case 0x03: // smhd
  tms57002_opc_write_d(s, opcode, (tms57002_macc_to_output(s) >> 24) & 0xffffff);
  break;

case 0x05: // smhc
  tms57002_opc_write_c(s, opcode, tms57002_macc_to_output(s) >> 16);
  break;

case 0x06: // slmh
  tms57002_opc_write_d(s, opcode, (tms57002_check_macc_overflow(s) >> 24) & 0xffff00);
  break;

case 0x07: // slml
  tms57002_opc_write_d(s, opcode, (tms57002_check_macc_overflow(s) >> 8) & 0xffffff);
  break;

case 0x08: // lcaa
  s->ca = tms57002_aacc_to_output(s) >> 24;
  break;

case 0x09: // lira
  s->id = tms57002_aacc_to_output(s) >> 24;
  break;

case 0x0e: // ref
  /* nothing to do */
  break;

case 0x0f: // srbd
  tms57002_opc_write_d(s, opcode, s->xrd);
  break;

case 0x10: // dis
  tms57002_opc_write_d(s, opcode, s->si[0]);
  break;

case 0x11: // dis
  tms57002_opc_write_d(s, opcode, s->si[1]);
  break;

case 0x12: // dis
  tms57002_opc_write_d(s, opcode, s->si[2]);
  break;

case 0x13: // dis
  tms57002_opc_write_d(s, opcode, s->si[3]);
  break;

case 0x20: // domh
  s->so[0] = (tms57002_macc_to_output(s) >> 24) & 0xffffff;
  break;

case 0x21: // domh
  s->so[1] = (tms57002_macc_to_output(s) >> 24) & 0xffffff;
  break;

case 0x22: // domh
  s->so[2] = (tms57002_macc_to_output(s) >> 24) & 0xffffff;
  break;

case 0x23: // domh
  s->so[3] = (tms57002_macc_to_output(s) >> 24) & 0xffffff;
  break;

case 0x31: // lpc
  break;

case 0x3a: // rmov
  s->st1 &= ~ST1_MOV;
  break;

case 0x40: // rmom
  s->st1 &= ~ST1_MOVM;
  break;

case 0x41: // smom
  s->st1 |= ST1_MOVM;
  break;

case 0x44: // ldpk
  s->st1 &= ~ST1_DBP;
  break;

case 0x45: // ldpk
  s->st1 |= ST1_DBP;
  break;

case 0x48: // scrm
  s->st1 = (s->st1 & ~ST1_CRM) | (0 << ST1_CRM_SHIFT);
  break;

case 0x49: // scrm
  s->st1 = (s->st1 & ~ST1_CRM) | (1 << ST1_CRM_SHIFT);
  break;

case 0x4a: // scrm
  s->st1 = (s->st1 & ~ST1_CRM) | (2 << ST1_CRM_SHIFT);
  break;

case 0x4b: // scrm
  s->st1 = (s->st1 & ~ST1_CRM) | (3 << ST1_CRM_SHIFT);
  break;

case 0x50: // sfao
  s->st1 &= ~ST1_SFAO;
  break;

case 0x51: // sfao
  s->st1 |= ST1_SFAI;
  break;

case 0x54: // sfai
  break;

case 0x55: // sfai
  break;

case 0x58: // sfma
  break;

case 0x59: // sfma
  break;

case 0x5a: // sfma
  break;

case 0x5b: // sfma
  break;

case 0x60: // sfmo
  s->st1 = (s->st1 & ~ST1_SFMO) | (0 << ST1_SFMO_SHIFT);
  break;

case 0x61: // sfmo
  s->st1 = (s->st1 & ~ST1_SFMO) | (1 << ST1_SFMO_SHIFT);
  break;

case 0x62: // sfmo
  s->st1 = (s->st1 & ~ST1_SFMO) | (2 << ST1_SFMO_SHIFT);
  break;

case 0x63: // sfmo
  s->st1 = (s->st1 & ~ST1_SFMO) | (3 << ST1_SFMO_SHIFT);
  break;

case 0x68: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (0 << ST1_RND_SHIFT);
  break;

case 0x69: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (1 << ST1_RND_SHIFT);
  break;

case 0x6a: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (2 << ST1_RND_SHIFT);
  break;

case 0x6b: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (3 << ST1_RND_SHIFT);
  break;

case 0x6c: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (4 << ST1_RND_SHIFT);
  break;

case 0x6d: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (5 << ST1_RND_SHIFT);
  break;

case 0x6e: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (6 << ST1_RND_SHIFT);
  break;

case 0x6f: // rnd
  s->st1 = (s->st1 & ~ST1_RND) | (7 << ST1_RND_SHIFT);
  break;

#endif

#ifdef INTRP2B
case 0x01: // sacc
  break;

case 0x02: // sacd
  break;

case 0x03: // smhd
  break;

case 0x05: // smhc
  break;

case 0x06: // slmh
  break;

case 0x07: // slml
  break;

case 0x08: // lcaa
  break;

case 0x09: // lira
  break;

case 0x0e: // ref
  break;

case 0x0f: // srbd
  break;

case 0x10: // dis
  break;

case 0x11: // dis
  break;

case 0x12: // dis
  break;

case 0x13: // dis
  break;

case 0x20: // domh
  break;

case 0x21: // domh
  break;

case 0x22: // domh
  break;

case 0x23: // domh
  break;

case 0x31: // lpc
  if(s->sti & S_HOST)
    break;
  c = tms57002_opc_read_c(s, opcode);
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 0x3a: // rmov
  break;

case 0x40: // rmom
  break;

case 0x41: // smom
  break;

case 0x44: // ldpk
  break;

case 0x45: // ldpk
  break;

case 0x48: // scrm
  break;

case 0x49: // scrm
  break;

case 0x4a: // scrm
  break;

case 0x4b: // scrm
  break;

case 0x50: // sfao
  break;

case 0x51: // sfao
  break;

case 0x54: // sfai
  s->st1 &= ~ST1_SFAI;
  break;

case 0x55: // sfai
  s->st1 |= ST1_SFAI;
  break;

case 0x58: // sfma
  s->st1 = (s->st1 & ~ST1_SFMA) | (0 << ST1_SFMA_SHIFT);
  break;

case 0x59: // sfma
  s->st1 = (s->st1 & ~ST1_SFMA) | (1 << ST1_SFMA_SHIFT);
  break;

case 0x5a: // sfma
  s->st1 = (s->st1 & ~ST1_SFMA) | (2 << ST1_SFMA_SHIFT);
  break;

case 0x5b: // sfma
  s->st1 = (s->st1 & ~ST1_SFMA) | (3 << ST1_SFMA_SHIFT);
  break;

case 0x60: // sfmo
  break;

case 0x61: // sfmo
  break;

case 0x62: // sfmo
  break;

case 0x63: // sfmo
  break;

case 0x68: // rnd
  break;

case 0x69: // rnd
  break;

case 0x6a: // rnd
  break;

case 0x6b: // rnd
  break;

case 0x6c: // rnd
  break;

case 0x6d: // rnd
  break;

case 0x6e: // rnd
  break;

case 0x6f: // rnd
  break;

#endif

#ifdef INTRP3
case 0x08: // idle
  s->sti |= S_IDLE;
  break;

case 0x10: // rptk
  s->rptc_next = (opcode & 0xff);
  break;

case 0x18: // lcak
  s->ca = (opcode & 0xff);
  break;

case 0x20: // lirk
  s->id = (opcode & 0xff);
  break;

case 0x40: // lcac
  if(((INT32)s->aacc) >= 0)
    s->ca = (opcode & 0xff);
  break;

case 0x48: // b
  s->pc = (opcode & 0xff);
  s->sti |= S_BRANCH;
  break;

case 0x50: // bgz
  if(((INT32)s->aacc) > 0) {
    s->pc = (opcode & 0xff);
  s->sti |= S_BRANCH;
  }
  break;

case 0x58: // blz
  if(((INT32)s->aacc) < 0) {
    s->pc = (opcode & 0xff);
  s->sti |= S_BRANCH;
  }
  break;

case 0x60: // bnz
  if(s->aacc) {
    s->pc = (opcode & 0xff);
  s->sti |= S_BRANCH;
  }
  break;

case 0x78: // bv
  if(s->st1 & ST1_AOV) {
    s->st1 &= ~ST1_AOV;
    s->pc = (opcode & 0xff);
  s->sti |= S_BRANCH;
  }
  break;

#endif

#ifdef CDEC1
case 0x01: // abs
  *op = 1 + sfao(s->st1);
  break;

case 0x03: // add
  *op = 3 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfao(s->st1);
  break;

case 0x04: // add
  *op = 15 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfao(s->st1);
  break;

case 0x05: // add
  *op = 39 + xmode(opcode, 'd') + 3*sfai(s->st1) + 6*dbp(s->st1) + 12*sfmo(s->st1) + 48*rnd(s->st1) + 384*movm(s->st1);
  break;

case 0x06: // add
  *op = 807 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfmo(s->st1) + 48*rnd(s->st1) + 384*movm(s->st1);
  break;

case 0x07: // add
  *op = 1575 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1);
  break;

case 0x09: // sub
  *op = 1647 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfao(s->st1);
  break;

case 0x0a: // sub
  *op = 1659 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfao(s->st1);
  break;

case 0x0d: // sub
  *op = 1683 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1);
  break;

case 0x11: // lacd
  *op = 1755 + xmode(opcode, 'd') + 3*sfai(s->st1) + 6*dbp(s->st1);
  break;

case 0x12: // lacc
  *op = 1767 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

case 0x14: // and
  *op = 1779 + xmode(opcode, 'd') + 3*sfai(s->st1) + 6*dbp(s->st1);
  break;

case 0x15: // and
  *op = 1791 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

case 0x16: // and
  *op = 1803 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*sfai(s->st1) + 18*crm(s->st1) + 72*dbp(s->st1);
  break;

case 0x17: // or
  *op = 1947 + xmode(opcode, 'd') + 3*sfai(s->st1) + 6*dbp(s->st1);
  break;

case 0x18: // or
  *op = 1959 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

case 0x19: // or
  *op = 1971 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*sfai(s->st1) + 18*crm(s->st1) + 72*dbp(s->st1);
  break;

case 0x21: // mpy
  *op = 2115 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1);
  break;

case 0x22: // mpy
  *op = 2187 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfao(s->st1);
  break;

case 0x24: // mac
  *op = 2211 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1) + 72*sfma(s->st1);
  break;

case 0x26: // mac
  *op = 2499 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfao(s->st1) + 24*sfma(s->st1);
  break;

case 0x28: // mpyu
  *op = 2595 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1);
  break;

case 0x29: // macu
  *op = 2667 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1) + 72*sfma(s->st1);
  break;

case 0x2a: // macu
  *op = 2955 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfao(s->st1) + 12*sfma(s->st1);
  break;

case 0x2e: // macs
  *op = 3003 + xmode(opcode, 'c') + 3*crm(s->st1) + 12*sfao(s->st1) + 24*sfma(s->st1);
  break;

case 0x31: // lmhd
  *op = 3099 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x32: // lmld
  *op = 3105 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x33: // lmhc
  *op = 3111 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

case 0x34: // sfml
  *op = 3123;
  break;

case 0x38: // wre
  *op = 3124 + xmode(opcode, 'c') + 3*xmode(opcode, 'd') + 9*crm(s->st1) + 36*dbp(s->st1);
  break;

case 0x39: // rde
  *op = 3196 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

#endif

#ifdef CDEC2A
case 0x01: // sacc
  *op = 3208 + xmode(opcode, 'c') + 3*sfao(s->st1);
  break;

case 0x02: // sacd
  *op = 3214 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfao(s->st1);
  break;

case 0x03: // smhd
  *op = 3226 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfmo(s->st1) + 24*rnd(s->st1) + 192*movm(s->st1);
  break;

case 0x05: // smhc
  *op = 3610 + xmode(opcode, 'c') + 3*sfmo(s->st1) + 12*rnd(s->st1) + 96*movm(s->st1);
  break;

case 0x06: // slmh
  *op = 3802 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfmo(s->st1) + 24*movm(s->st1);
  break;

case 0x07: // slml
  *op = 3850 + xmode(opcode, 'd') + 3*dbp(s->st1) + 6*sfmo(s->st1) + 24*movm(s->st1);
  break;

case 0x08: // lcaa
  *op = 3898 + sfao(s->st1);
  break;

case 0x09: // lira
  *op = 3900 + sfao(s->st1);
  break;

case 0x0e: // ref
  *op = 3902;
  break;

case 0x0f: // srbd
  *op = 3903 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x10: // dis
  *op = 3909 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x11: // dis
  *op = 3915 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x12: // dis
  *op = 3921 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x13: // dis
  *op = 3927 + xmode(opcode, 'd') + 3*dbp(s->st1);
  break;

case 0x20: // domh
  *op = 3933 + sfmo(s->st1) + 4*rnd(s->st1) + 32*movm(s->st1);
  break;

case 0x21: // domh
  *op = 3997 + sfmo(s->st1) + 4*rnd(s->st1) + 32*movm(s->st1);
  break;

case 0x22: // domh
  *op = 4061 + sfmo(s->st1) + 4*rnd(s->st1) + 32*movm(s->st1);
  break;

case 0x23: // domh
  *op = 4125 + sfmo(s->st1) + 4*rnd(s->st1) + 32*movm(s->st1);
  break;

case 0x31: // lpc
  break;

case 0x3a: // rmov
  *op = 4201;
  break;

case 0x40: // rmom
  *op = 4202;
  s->st1 &= ~ST1_MOVM;
  break;

case 0x41: // smom
  *op = 4203;
  s->st1 |= ST1_MOVM;
  break;

case 0x44: // ldpk
  *op = 4204;
  s->st1 &= ~ST1_DBP;
  break;

case 0x45: // ldpk
  *op = 4205;
  s->st1 |= ST1_DBP;
  break;

case 0x48: // scrm
  *op = 4206;
  s->st1 = (s->st1 & ~ST1_CRM) | (0 << ST1_CRM_SHIFT);
  break;

case 0x49: // scrm
  *op = 4207;
  s->st1 = (s->st1 & ~ST1_CRM) | (1 << ST1_CRM_SHIFT);
  break;

case 0x4a: // scrm
  *op = 4208;
  s->st1 = (s->st1 & ~ST1_CRM) | (2 << ST1_CRM_SHIFT);
  break;

case 0x4b: // scrm
  *op = 4209;
  s->st1 = (s->st1 & ~ST1_CRM) | (3 << ST1_CRM_SHIFT);
  break;

case 0x50: // sfao
  *op = 4210;
  s->st1 &= ~ST1_SFAO;
  break;

case 0x51: // sfao
  *op = 4211;
  s->st1 |= ST1_SFAI;
  break;

case 0x54: // sfai
  break;

case 0x55: // sfai
  break;

case 0x58: // sfma
  break;

case 0x59: // sfma
  break;

case 0x5a: // sfma
  break;

case 0x5b: // sfma
  break;

case 0x60: // sfmo
  *op = 4218;
  s->st1 = (s->st1 & ~ST1_SFMO) | (0 << ST1_SFMO_SHIFT);
  break;

case 0x61: // sfmo
  *op = 4219;
  s->st1 = (s->st1 & ~ST1_SFMO) | (1 << ST1_SFMO_SHIFT);
  break;

case 0x62: // sfmo
  *op = 4220;
  s->st1 = (s->st1 & ~ST1_SFMO) | (2 << ST1_SFMO_SHIFT);
  break;

case 0x63: // sfmo
  *op = 4221;
  s->st1 = (s->st1 & ~ST1_SFMO) | (3 << ST1_SFMO_SHIFT);
  break;

case 0x68: // rnd
  *op = 4222;
  s->st1 = (s->st1 & ~ST1_RND) | (0 << ST1_RND_SHIFT);
  break;

case 0x69: // rnd
  *op = 4223;
  s->st1 = (s->st1 & ~ST1_RND) | (1 << ST1_RND_SHIFT);
  break;

case 0x6a: // rnd
  *op = 4224;
  s->st1 = (s->st1 & ~ST1_RND) | (2 << ST1_RND_SHIFT);
  break;

case 0x6b: // rnd
  *op = 4225;
  s->st1 = (s->st1 & ~ST1_RND) | (3 << ST1_RND_SHIFT);
  break;

case 0x6c: // rnd
  *op = 4226;
  s->st1 = (s->st1 & ~ST1_RND) | (4 << ST1_RND_SHIFT);
  break;

case 0x6d: // rnd
  *op = 4227;
  s->st1 = (s->st1 & ~ST1_RND) | (5 << ST1_RND_SHIFT);
  break;

case 0x6e: // rnd
  *op = 4228;
  s->st1 = (s->st1 & ~ST1_RND) | (6 << ST1_RND_SHIFT);
  break;

case 0x6f: // rnd
  *op = 4229;
  s->st1 = (s->st1 & ~ST1_RND) | (7 << ST1_RND_SHIFT);
  break;

#endif

#ifdef CDEC2B
case 0x01: // sacc
  break;

case 0x02: // sacd
  break;

case 0x03: // smhd
  break;

case 0x05: // smhc
  break;

case 0x06: // slmh
  break;

case 0x07: // slml
  break;

case 0x08: // lcaa
  break;

case 0x09: // lira
  break;

case 0x0e: // ref
  break;

case 0x0f: // srbd
  break;

case 0x10: // dis
  break;

case 0x11: // dis
  break;

case 0x12: // dis
  break;

case 0x13: // dis
  break;

case 0x20: // domh
  break;

case 0x21: // domh
  break;

case 0x22: // domh
  break;

case 0x23: // domh
  break;

case 0x31: // lpc
  *op = 4189 + xmode(opcode, 'c') + 3*crm(s->st1);
  break;

case 0x3a: // rmov
  break;

case 0x40: // rmom
  break;

case 0x41: // smom
  break;

case 0x44: // ldpk
  break;

case 0x45: // ldpk
  break;

case 0x48: // scrm
  break;

case 0x49: // scrm
  break;

case 0x4a: // scrm
  break;

case 0x4b: // scrm
  break;

case 0x50: // sfao
  break;

case 0x51: // sfao
  break;

case 0x54: // sfai
  *op = 4212;
  s->st1 &= ~ST1_SFAI;
  break;

case 0x55: // sfai
  *op = 4213;
  s->st1 |= ST1_SFAI;
  break;

case 0x58: // sfma
  *op = 4214;
  s->st1 = (s->st1 & ~ST1_SFMA) | (0 << ST1_SFMA_SHIFT);
  break;

case 0x59: // sfma
  *op = 4215;
  s->st1 = (s->st1 & ~ST1_SFMA) | (1 << ST1_SFMA_SHIFT);
  break;

case 0x5a: // sfma
  *op = 4216;
  s->st1 = (s->st1 & ~ST1_SFMA) | (2 << ST1_SFMA_SHIFT);
  break;

case 0x5b: // sfma
  *op = 4217;
  s->st1 = (s->st1 & ~ST1_SFMA) | (3 << ST1_SFMA_SHIFT);
  break;

case 0x60: // sfmo
  break;

case 0x61: // sfmo
  break;

case 0x62: // sfmo
  break;

case 0x63: // sfmo
  break;

case 0x68: // rnd
  break;

case 0x69: // rnd
  break;

case 0x6a: // rnd
  break;

case 0x6b: // rnd
  break;

case 0x6c: // rnd
  break;

case 0x6d: // rnd
  break;

case 0x6e: // rnd
  break;

case 0x6f: // rnd
  break;

#endif

#ifdef CDEC3
case 0x08: // idle
  *op = 4230;
  cs->branch = BR_IDLE;
  break;

case 0x10: // rptk
  *op = 4231;
  break;

case 0x18: // lcak
  *op = 4232;
  break;

case 0x20: // lirk
  *op = 4233;
  break;

case 0x40: // lcac
  *op = 4234;
  break;

case 0x48: // b
  *op = 4235;
  cs->branch = BR_UB;
  break;

case 0x50: // bgz
  *op = 4236;
  cs->branch = BR_CB;
  break;

case 0x58: // blz
  *op = 4237;
  cs->branch = BR_CB;
  break;

case 0x60: // bnz
  *op = 4238;
  cs->branch = BR_CB;
  break;

case 0x78: // bv
  *op = 4239;
  cs->branch = BR_CB;
  break;

#endif

#ifdef CINTRP
case 1: // abs sfao=0
  s->aacc = s->aacc;
  if(((INT32)s->aacc) < 0) {
    s->aacc = - s->aacc;
    if(((INT32)s->aacc) < 0)
      s->st1 |= ST1_AOV;
  }
  break;

case 2: // abs sfao=1
  s->aacc = (s->aacc << 7);
  if(((INT32)s->aacc) < 0) {
    s->aacc = - s->aacc;
    if(((INT32)s->aacc) < 0)
      s->st1 |= ST1_AOV;
  }
  break;

case 3: // add dmode=0 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 4: // add dmode=1 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 5: // add dmode=2 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 6: // add dmode=0 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 7: // add dmode=1 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 8: // add dmode=2 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 9: // add dmode=0 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 10: // add dmode=1 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 11: // add dmode=2 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 12: // add dmode=0 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 13: // add dmode=1 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 14: // add dmode=2 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 15: // add cmode=0 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[i->param] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 16: // add cmode=1 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 17: // add cmode=2 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 18: // add cmode=0 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 19: // add cmode=1 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 20: // add cmode=2 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 21: // add cmode=0 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 22: // add cmode=1 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 23: // add cmode=2 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 24: // add cmode=0 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[i->param] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 25: // add cmode=1 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 26: // add cmode=2 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 27: // add cmode=0 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[i->param] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 28: // add cmode=1 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 29: // add cmode=2 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 30: // add cmode=0 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 31: // add cmode=1 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 32: // add cmode=2 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 33: // add cmode=0 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 34: // add cmode=1 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 35: // add cmode=2 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 36: // add cmode=0 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[i->param] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 37: // add cmode=1 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 38: // add cmode=2 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 39: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=0 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 40: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=0 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 41: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=0 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 42: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 43: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 44: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 45: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=0 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 46: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=0 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 47: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=0 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 48: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 49: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 50: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 51: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=0 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 52: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=0 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 53: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=0 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 54: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 55: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 56: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 57: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=0 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 58: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=0 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 59: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=0 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 60: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 61: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 62: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 63: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=0 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 64: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=0 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 65: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=0 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 66: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 67: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 68: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 69: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=0 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 70: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=0 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 71: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=0 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 72: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 73: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 74: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 75: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=0 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 76: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=0 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 77: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=0 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 78: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 79: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 80: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 81: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=0 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 82: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=0 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 83: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=0 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 84: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 85: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 86: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=0 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 87: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=1 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 88: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=1 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 89: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=1 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 90: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 91: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 92: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 93: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=1 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 94: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=1 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 95: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=1 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 96: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 97: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 98: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 99: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=1 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 100: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=1 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 101: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=1 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 102: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 103: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 104: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 105: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=1 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 106: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=1 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 107: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=1 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 108: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 109: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 110: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 111: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=1 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 112: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=1 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 113: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=1 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 114: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 115: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 116: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 117: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=1 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 118: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=1 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 119: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=1 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 120: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 121: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 122: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 123: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=1 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 124: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=1 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 125: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=1 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 126: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 127: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 128: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 129: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=1 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 130: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=1 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 131: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=1 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 132: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 133: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 134: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=1 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 135: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=2 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 136: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=2 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 137: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=2 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 138: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 139: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 140: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 141: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=2 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 142: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=2 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 143: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=2 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 144: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 145: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 146: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 147: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=2 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 148: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=2 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 149: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=2 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 150: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 151: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 152: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 153: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=2 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 154: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=2 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 155: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=2 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 156: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 157: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 158: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 159: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=2 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 160: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=2 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 161: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=2 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 162: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 163: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 164: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 165: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=2 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 166: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=2 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 167: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=2 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 168: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 169: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 170: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 171: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=2 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 172: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=2 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 173: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=2 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 174: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 175: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 176: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 177: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=2 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 178: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=2 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 179: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=2 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 180: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 181: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 182: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=2 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 183: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=3 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 184: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=3 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 185: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=3 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 186: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 187: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 188: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 189: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=3 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 190: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=3 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 191: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=3 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 192: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 193: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 194: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 195: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=3 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 196: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=3 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 197: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=3 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 198: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 199: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 200: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 201: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=3 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 202: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=3 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 203: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=3 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 204: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 205: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 206: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 207: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=3 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 208: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=3 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 209: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=3 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 210: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 211: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 212: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 213: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=3 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 214: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=3 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 215: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=3 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 216: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 217: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 218: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 219: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=3 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 220: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=3 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 221: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=3 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 222: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 223: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 224: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 225: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=3 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 226: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=3 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 227: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=3 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 228: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 229: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 230: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=3 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 231: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=4 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 232: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=4 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 233: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=4 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 234: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 235: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 236: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 237: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=4 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 238: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=4 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 239: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=4 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 240: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 241: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 242: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 243: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=4 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 244: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=4 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 245: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=4 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 246: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 247: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 248: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 249: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=4 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 250: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=4 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 251: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=4 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 252: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 253: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 254: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 255: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=4 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 256: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=4 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 257: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=4 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 258: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 259: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 260: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 261: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=4 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 262: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=4 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 263: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=4 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 264: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 265: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 266: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 267: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=4 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 268: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=4 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 269: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=4 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 270: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 271: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 272: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 273: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=4 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 274: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=4 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 275: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=4 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 276: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 277: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 278: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=4 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 279: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=5 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 280: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=5 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 281: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=5 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 282: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 283: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 284: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 285: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=5 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 286: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=5 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 287: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=5 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 288: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 289: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 290: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 291: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=5 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 292: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=5 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 293: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=5 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 294: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 295: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 296: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 297: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=5 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 298: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=5 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 299: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=5 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 300: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 301: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 302: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 303: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=5 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 304: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=5 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 305: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=5 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 306: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 307: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 308: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 309: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=5 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 310: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=5 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 311: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=5 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 312: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 313: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 314: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 315: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=5 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 316: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=5 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 317: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=5 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 318: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 319: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 320: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 321: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=5 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 322: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=5 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 323: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=5 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 324: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 325: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 326: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=5 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 327: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=6 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 328: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=6 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 329: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=6 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 330: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 331: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 332: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 333: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=6 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 334: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=6 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 335: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=6 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 336: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 337: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 338: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 339: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=6 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 340: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=6 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 341: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=6 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 342: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 343: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 344: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 345: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=6 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 346: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=6 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 347: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=6 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 348: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 349: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 350: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 351: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=6 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 352: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=6 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 353: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=6 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 354: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 355: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 356: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 357: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=6 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 358: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=6 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 359: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=6 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 360: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 361: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 362: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 363: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=6 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 364: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=6 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 365: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=6 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 366: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 367: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 368: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 369: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=6 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 370: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=6 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 371: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=6 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 372: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 373: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 374: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=6 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 375: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=7 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 376: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=7 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 377: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=7 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 378: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 379: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 380: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 381: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=7 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 382: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=7 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 383: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=7 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 384: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 385: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 386: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 387: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=7 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 388: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=7 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 389: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=7 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 390: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 391: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 392: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 393: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=7 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 394: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=7 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 395: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=7 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 396: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 397: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 398: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 399: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=7 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 400: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=7 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 401: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=7 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 402: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 403: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 404: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 405: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=7 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 406: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=7 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 407: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=7 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 408: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 409: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 410: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 411: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=7 movm=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 412: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=7 movm=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 413: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=7 movm=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 414: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 415: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 416: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 417: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=7 movm=0
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 418: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=7 movm=0
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 419: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=7 movm=0
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 420: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 421: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 422: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=7 movm=0
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 423: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=0 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 424: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=0 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 425: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=0 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 426: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 427: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 428: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 429: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=0 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 430: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=0 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 431: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=0 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 432: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 433: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 434: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 435: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=0 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 436: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=0 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 437: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=0 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 438: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 439: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 440: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 441: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=0 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 442: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=0 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 443: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=0 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 444: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 445: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 446: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 447: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=0 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 448: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=0 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 449: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=0 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 450: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 451: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 452: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 453: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=0 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 454: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=0 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 455: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=0 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 456: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 457: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 458: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 459: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=0 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 460: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=0 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 461: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=0 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 462: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 463: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 464: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 465: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=0 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 466: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=0 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 467: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=0 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 468: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 469: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 470: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=0 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 471: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=1 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 472: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=1 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 473: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=1 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 474: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 475: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 476: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 477: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=1 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 478: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=1 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 479: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=1 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 480: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 481: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 482: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 483: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=1 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 484: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=1 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 485: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=1 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 486: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 487: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 488: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 489: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=1 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 490: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=1 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 491: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=1 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 492: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 493: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 494: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 495: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=1 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 496: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=1 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 497: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=1 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 498: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 499: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 500: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 501: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=1 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 502: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=1 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 503: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=1 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 504: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 505: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 506: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 507: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=1 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 508: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=1 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 509: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=1 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 510: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 511: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 512: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 513: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=1 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 514: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=1 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 515: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=1 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 516: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 517: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 518: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=1 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 519: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=2 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 520: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=2 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 521: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=2 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 522: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 523: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 524: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 525: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=2 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 526: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=2 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 527: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=2 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 528: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 529: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 530: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 531: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=2 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 532: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=2 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 533: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=2 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 534: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 535: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 536: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 537: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=2 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 538: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=2 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 539: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=2 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 540: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 541: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 542: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 543: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=2 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 544: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=2 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 545: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=2 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 546: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 547: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 548: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 549: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=2 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 550: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=2 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 551: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=2 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 552: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 553: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 554: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 555: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=2 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 556: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=2 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 557: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=2 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 558: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 559: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 560: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 561: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=2 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 562: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=2 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 563: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=2 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 564: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 565: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 566: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=2 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 567: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=3 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 568: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=3 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 569: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=3 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 570: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 571: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 572: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 573: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=3 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 574: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=3 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 575: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=3 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 576: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 577: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 578: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 579: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=3 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 580: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=3 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 581: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=3 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 582: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 583: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 584: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 585: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=3 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 586: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=3 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 587: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=3 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 588: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 589: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 590: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 591: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=3 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 592: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=3 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 593: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=3 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 594: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 595: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 596: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 597: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=3 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 598: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=3 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 599: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=3 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 600: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 601: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 602: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 603: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=3 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 604: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=3 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 605: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=3 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 606: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 607: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 608: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 609: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=3 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 610: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=3 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 611: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=3 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 612: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 613: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 614: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=3 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 615: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=4 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 616: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=4 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 617: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=4 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 618: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 619: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 620: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 621: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=4 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 622: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=4 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 623: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=4 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 624: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 625: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 626: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 627: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=4 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 628: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=4 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 629: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=4 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 630: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 631: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 632: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 633: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=4 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 634: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=4 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 635: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=4 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 636: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 637: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 638: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 639: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=4 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 640: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=4 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 641: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=4 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 642: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 643: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 644: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 645: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=4 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 646: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=4 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 647: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=4 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 648: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 649: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 650: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 651: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=4 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 652: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=4 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 653: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=4 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 654: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 655: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 656: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 657: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=4 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 658: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=4 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 659: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=4 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 660: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 661: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 662: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=4 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 663: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=5 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 664: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=5 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 665: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=5 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 666: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 667: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 668: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 669: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=5 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 670: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=5 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 671: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=5 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 672: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 673: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 674: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 675: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=5 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 676: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=5 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 677: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=5 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 678: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 679: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 680: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 681: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=5 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 682: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=5 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 683: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=5 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 684: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 685: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 686: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 687: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=5 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 688: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=5 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 689: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=5 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 690: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 691: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 692: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 693: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=5 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 694: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=5 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 695: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=5 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 696: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 697: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 698: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 699: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=5 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 700: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=5 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 701: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=5 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 702: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 703: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 704: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 705: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=5 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 706: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=5 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 707: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=5 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 708: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 709: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 710: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=5 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 711: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=6 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 712: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=6 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 713: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=6 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 714: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 715: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 716: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 717: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=6 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 718: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=6 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 719: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=6 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 720: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 721: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 722: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 723: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=6 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 724: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=6 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 725: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=6 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 726: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 727: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 728: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 729: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=6 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 730: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=6 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 731: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=6 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 732: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 733: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 734: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 735: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=6 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 736: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=6 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 737: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=6 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 738: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 739: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 740: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 741: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=6 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 742: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=6 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 743: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=6 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 744: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 745: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 746: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 747: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=6 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 748: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=6 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 749: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=6 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 750: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 751: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 752: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 753: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=6 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 754: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=6 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 755: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=6 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 756: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 757: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 758: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=6 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 759: // add dmode=0 sfai=0 dbp=0 sfmo=0 rnd=7 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 760: // add dmode=1 sfai=0 dbp=0 sfmo=0 rnd=7 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 761: // add dmode=2 sfai=0 dbp=0 sfmo=0 rnd=7 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 762: // add dmode=0 sfai=1 dbp=0 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 763: // add dmode=1 sfai=1 dbp=0 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 764: // add dmode=2 sfai=1 dbp=0 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 765: // add dmode=0 sfai=0 dbp=1 sfmo=0 rnd=7 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 766: // add dmode=1 sfai=0 dbp=1 sfmo=0 rnd=7 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 767: // add dmode=2 sfai=0 dbp=1 sfmo=0 rnd=7 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 768: // add dmode=0 sfai=1 dbp=1 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 769: // add dmode=1 sfai=1 dbp=1 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 770: // add dmode=2 sfai=1 dbp=1 sfmo=0 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 771: // add dmode=0 sfai=0 dbp=0 sfmo=1 rnd=7 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 772: // add dmode=1 sfai=0 dbp=0 sfmo=1 rnd=7 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 773: // add dmode=2 sfai=0 dbp=0 sfmo=1 rnd=7 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 774: // add dmode=0 sfai=1 dbp=0 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 775: // add dmode=1 sfai=1 dbp=0 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 776: // add dmode=2 sfai=1 dbp=0 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 777: // add dmode=0 sfai=0 dbp=1 sfmo=1 rnd=7 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 778: // add dmode=1 sfai=0 dbp=1 sfmo=1 rnd=7 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 779: // add dmode=2 sfai=0 dbp=1 sfmo=1 rnd=7 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 780: // add dmode=0 sfai=1 dbp=1 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 781: // add dmode=1 sfai=1 dbp=1 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 782: // add dmode=2 sfai=1 dbp=1 sfmo=1 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 783: // add dmode=0 sfai=0 dbp=0 sfmo=2 rnd=7 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 784: // add dmode=1 sfai=0 dbp=0 sfmo=2 rnd=7 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 785: // add dmode=2 sfai=0 dbp=0 sfmo=2 rnd=7 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 786: // add dmode=0 sfai=1 dbp=0 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 787: // add dmode=1 sfai=1 dbp=0 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 788: // add dmode=2 sfai=1 dbp=0 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 789: // add dmode=0 sfai=0 dbp=1 sfmo=2 rnd=7 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 790: // add dmode=1 sfai=0 dbp=1 sfmo=2 rnd=7 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 791: // add dmode=2 sfai=0 dbp=1 sfmo=2 rnd=7 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 792: // add dmode=0 sfai=1 dbp=1 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 793: // add dmode=1 sfai=1 dbp=1 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 794: // add dmode=2 sfai=1 dbp=1 sfmo=2 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 795: // add dmode=0 sfai=0 dbp=0 sfmo=3 rnd=7 movm=1
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 796: // add dmode=1 sfai=0 dbp=0 sfmo=3 rnd=7 movm=1
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 797: // add dmode=2 sfai=0 dbp=0 sfmo=3 rnd=7 movm=1
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 798: // add dmode=0 sfai=1 dbp=0 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 799: // add dmode=1 sfai=1 dbp=0 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 800: // add dmode=2 sfai=1 dbp=0 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 801: // add dmode=0 sfai=0 dbp=1 sfmo=3 rnd=7 movm=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 802: // add dmode=1 sfai=0 dbp=1 sfmo=3 rnd=7 movm=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 803: // add dmode=2 sfai=0 dbp=1 sfmo=3 rnd=7 movm=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 804: // add dmode=0 sfai=1 dbp=1 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 805: // add dmode=1 sfai=1 dbp=1 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 806: // add dmode=2 sfai=1 dbp=1 sfmo=3 rnd=7 movm=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  r = (INT64)(INT32)d + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 807: // add cmode=0 crm=0 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 808: // add cmode=1 crm=0 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 809: // add cmode=2 crm=0 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 810: // add cmode=0 crm=1 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 811: // add cmode=1 crm=1 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 812: // add cmode=2 crm=1 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 813: // add cmode=0 crm=2 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 814: // add cmode=1 crm=2 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 815: // add cmode=2 crm=2 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 816: // add cmode=0 crm=3 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 817: // add cmode=1 crm=3 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 818: // add cmode=2 crm=3 sfmo=0 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 819: // add cmode=0 crm=0 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 820: // add cmode=1 crm=0 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 821: // add cmode=2 crm=0 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 822: // add cmode=0 crm=1 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 823: // add cmode=1 crm=1 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 824: // add cmode=2 crm=1 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 825: // add cmode=0 crm=2 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 826: // add cmode=1 crm=2 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 827: // add cmode=2 crm=2 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 828: // add cmode=0 crm=3 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 829: // add cmode=1 crm=3 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 830: // add cmode=2 crm=3 sfmo=1 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 831: // add cmode=0 crm=0 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 832: // add cmode=1 crm=0 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 833: // add cmode=2 crm=0 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 834: // add cmode=0 crm=1 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 835: // add cmode=1 crm=1 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 836: // add cmode=2 crm=1 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 837: // add cmode=0 crm=2 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 838: // add cmode=1 crm=2 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 839: // add cmode=2 crm=2 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 840: // add cmode=0 crm=3 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 841: // add cmode=1 crm=3 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 842: // add cmode=2 crm=3 sfmo=2 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 843: // add cmode=0 crm=0 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 844: // add cmode=1 crm=0 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 845: // add cmode=2 crm=0 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 846: // add cmode=0 crm=1 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 847: // add cmode=1 crm=1 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 848: // add cmode=2 crm=1 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 849: // add cmode=0 crm=2 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 850: // add cmode=1 crm=2 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 851: // add cmode=2 crm=2 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 852: // add cmode=0 crm=3 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 853: // add cmode=1 crm=3 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 854: // add cmode=2 crm=3 sfmo=3 rnd=0 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 855: // add cmode=0 crm=0 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 856: // add cmode=1 crm=0 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 857: // add cmode=2 crm=0 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 858: // add cmode=0 crm=1 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 859: // add cmode=1 crm=1 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 860: // add cmode=2 crm=1 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 861: // add cmode=0 crm=2 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 862: // add cmode=1 crm=2 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 863: // add cmode=2 crm=2 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 864: // add cmode=0 crm=3 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 865: // add cmode=1 crm=3 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 866: // add cmode=2 crm=3 sfmo=0 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 867: // add cmode=0 crm=0 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 868: // add cmode=1 crm=0 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 869: // add cmode=2 crm=0 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 870: // add cmode=0 crm=1 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 871: // add cmode=1 crm=1 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 872: // add cmode=2 crm=1 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 873: // add cmode=0 crm=2 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 874: // add cmode=1 crm=2 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 875: // add cmode=2 crm=2 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 876: // add cmode=0 crm=3 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 877: // add cmode=1 crm=3 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 878: // add cmode=2 crm=3 sfmo=1 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 879: // add cmode=0 crm=0 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 880: // add cmode=1 crm=0 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 881: // add cmode=2 crm=0 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 882: // add cmode=0 crm=1 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 883: // add cmode=1 crm=1 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 884: // add cmode=2 crm=1 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 885: // add cmode=0 crm=2 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 886: // add cmode=1 crm=2 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 887: // add cmode=2 crm=2 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 888: // add cmode=0 crm=3 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 889: // add cmode=1 crm=3 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 890: // add cmode=2 crm=3 sfmo=2 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 891: // add cmode=0 crm=0 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 892: // add cmode=1 crm=0 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 893: // add cmode=2 crm=0 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 894: // add cmode=0 crm=1 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 895: // add cmode=1 crm=1 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 896: // add cmode=2 crm=1 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 897: // add cmode=0 crm=2 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 898: // add cmode=1 crm=2 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 899: // add cmode=2 crm=2 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 900: // add cmode=0 crm=3 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 901: // add cmode=1 crm=3 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 902: // add cmode=2 crm=3 sfmo=3 rnd=1 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 903: // add cmode=0 crm=0 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 904: // add cmode=1 crm=0 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 905: // add cmode=2 crm=0 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 906: // add cmode=0 crm=1 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 907: // add cmode=1 crm=1 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 908: // add cmode=2 crm=1 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 909: // add cmode=0 crm=2 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 910: // add cmode=1 crm=2 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 911: // add cmode=2 crm=2 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 912: // add cmode=0 crm=3 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 913: // add cmode=1 crm=3 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 914: // add cmode=2 crm=3 sfmo=0 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 915: // add cmode=0 crm=0 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 916: // add cmode=1 crm=0 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 917: // add cmode=2 crm=0 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 918: // add cmode=0 crm=1 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 919: // add cmode=1 crm=1 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 920: // add cmode=2 crm=1 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 921: // add cmode=0 crm=2 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 922: // add cmode=1 crm=2 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 923: // add cmode=2 crm=2 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 924: // add cmode=0 crm=3 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 925: // add cmode=1 crm=3 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 926: // add cmode=2 crm=3 sfmo=1 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 927: // add cmode=0 crm=0 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 928: // add cmode=1 crm=0 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 929: // add cmode=2 crm=0 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 930: // add cmode=0 crm=1 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 931: // add cmode=1 crm=1 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 932: // add cmode=2 crm=1 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 933: // add cmode=0 crm=2 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 934: // add cmode=1 crm=2 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 935: // add cmode=2 crm=2 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 936: // add cmode=0 crm=3 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 937: // add cmode=1 crm=3 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 938: // add cmode=2 crm=3 sfmo=2 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 939: // add cmode=0 crm=0 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 940: // add cmode=1 crm=0 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 941: // add cmode=2 crm=0 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 942: // add cmode=0 crm=1 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 943: // add cmode=1 crm=1 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 944: // add cmode=2 crm=1 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 945: // add cmode=0 crm=2 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 946: // add cmode=1 crm=2 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 947: // add cmode=2 crm=2 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 948: // add cmode=0 crm=3 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 949: // add cmode=1 crm=3 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 950: // add cmode=2 crm=3 sfmo=3 rnd=2 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 951: // add cmode=0 crm=0 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 952: // add cmode=1 crm=0 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 953: // add cmode=2 crm=0 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 954: // add cmode=0 crm=1 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 955: // add cmode=1 crm=1 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 956: // add cmode=2 crm=1 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 957: // add cmode=0 crm=2 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 958: // add cmode=1 crm=2 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 959: // add cmode=2 crm=2 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 960: // add cmode=0 crm=3 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 961: // add cmode=1 crm=3 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 962: // add cmode=2 crm=3 sfmo=0 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 963: // add cmode=0 crm=0 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 964: // add cmode=1 crm=0 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 965: // add cmode=2 crm=0 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 966: // add cmode=0 crm=1 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 967: // add cmode=1 crm=1 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 968: // add cmode=2 crm=1 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 969: // add cmode=0 crm=2 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 970: // add cmode=1 crm=2 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 971: // add cmode=2 crm=2 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 972: // add cmode=0 crm=3 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 973: // add cmode=1 crm=3 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 974: // add cmode=2 crm=3 sfmo=1 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 975: // add cmode=0 crm=0 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 976: // add cmode=1 crm=0 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 977: // add cmode=2 crm=0 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 978: // add cmode=0 crm=1 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 979: // add cmode=1 crm=1 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 980: // add cmode=2 crm=1 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 981: // add cmode=0 crm=2 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 982: // add cmode=1 crm=2 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 983: // add cmode=2 crm=2 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 984: // add cmode=0 crm=3 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 985: // add cmode=1 crm=3 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 986: // add cmode=2 crm=3 sfmo=2 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 987: // add cmode=0 crm=0 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 988: // add cmode=1 crm=0 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 989: // add cmode=2 crm=0 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 990: // add cmode=0 crm=1 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 991: // add cmode=1 crm=1 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 992: // add cmode=2 crm=1 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 993: // add cmode=0 crm=2 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 994: // add cmode=1 crm=2 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 995: // add cmode=2 crm=2 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 996: // add cmode=0 crm=3 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 997: // add cmode=1 crm=3 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 998: // add cmode=2 crm=3 sfmo=3 rnd=3 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 999: // add cmode=0 crm=0 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1000: // add cmode=1 crm=0 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1001: // add cmode=2 crm=0 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1002: // add cmode=0 crm=1 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1003: // add cmode=1 crm=1 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1004: // add cmode=2 crm=1 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1005: // add cmode=0 crm=2 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1006: // add cmode=1 crm=2 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1007: // add cmode=2 crm=2 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1008: // add cmode=0 crm=3 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1009: // add cmode=1 crm=3 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1010: // add cmode=2 crm=3 sfmo=0 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1011: // add cmode=0 crm=0 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1012: // add cmode=1 crm=0 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1013: // add cmode=2 crm=0 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1014: // add cmode=0 crm=1 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1015: // add cmode=1 crm=1 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1016: // add cmode=2 crm=1 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1017: // add cmode=0 crm=2 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1018: // add cmode=1 crm=2 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1019: // add cmode=2 crm=2 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1020: // add cmode=0 crm=3 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1021: // add cmode=1 crm=3 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1022: // add cmode=2 crm=3 sfmo=1 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1023: // add cmode=0 crm=0 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1024: // add cmode=1 crm=0 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1025: // add cmode=2 crm=0 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1026: // add cmode=0 crm=1 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1027: // add cmode=1 crm=1 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1028: // add cmode=2 crm=1 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1029: // add cmode=0 crm=2 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1030: // add cmode=1 crm=2 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1031: // add cmode=2 crm=2 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1032: // add cmode=0 crm=3 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1033: // add cmode=1 crm=3 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1034: // add cmode=2 crm=3 sfmo=2 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1035: // add cmode=0 crm=0 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1036: // add cmode=1 crm=0 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1037: // add cmode=2 crm=0 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1038: // add cmode=0 crm=1 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1039: // add cmode=1 crm=1 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1040: // add cmode=2 crm=1 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1041: // add cmode=0 crm=2 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1042: // add cmode=1 crm=2 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1043: // add cmode=2 crm=2 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1044: // add cmode=0 crm=3 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1045: // add cmode=1 crm=3 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1046: // add cmode=2 crm=3 sfmo=3 rnd=4 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1047: // add cmode=0 crm=0 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1048: // add cmode=1 crm=0 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1049: // add cmode=2 crm=0 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1050: // add cmode=0 crm=1 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1051: // add cmode=1 crm=1 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1052: // add cmode=2 crm=1 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1053: // add cmode=0 crm=2 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1054: // add cmode=1 crm=2 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1055: // add cmode=2 crm=2 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1056: // add cmode=0 crm=3 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1057: // add cmode=1 crm=3 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1058: // add cmode=2 crm=3 sfmo=0 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1059: // add cmode=0 crm=0 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1060: // add cmode=1 crm=0 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1061: // add cmode=2 crm=0 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1062: // add cmode=0 crm=1 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1063: // add cmode=1 crm=1 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1064: // add cmode=2 crm=1 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1065: // add cmode=0 crm=2 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1066: // add cmode=1 crm=2 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1067: // add cmode=2 crm=2 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1068: // add cmode=0 crm=3 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1069: // add cmode=1 crm=3 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1070: // add cmode=2 crm=3 sfmo=1 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1071: // add cmode=0 crm=0 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1072: // add cmode=1 crm=0 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1073: // add cmode=2 crm=0 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1074: // add cmode=0 crm=1 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1075: // add cmode=1 crm=1 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1076: // add cmode=2 crm=1 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1077: // add cmode=0 crm=2 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1078: // add cmode=1 crm=2 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1079: // add cmode=2 crm=2 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1080: // add cmode=0 crm=3 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1081: // add cmode=1 crm=3 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1082: // add cmode=2 crm=3 sfmo=2 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1083: // add cmode=0 crm=0 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1084: // add cmode=1 crm=0 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1085: // add cmode=2 crm=0 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1086: // add cmode=0 crm=1 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1087: // add cmode=1 crm=1 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1088: // add cmode=2 crm=1 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1089: // add cmode=0 crm=2 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1090: // add cmode=1 crm=2 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1091: // add cmode=2 crm=2 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1092: // add cmode=0 crm=3 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1093: // add cmode=1 crm=3 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1094: // add cmode=2 crm=3 sfmo=3 rnd=5 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1095: // add cmode=0 crm=0 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1096: // add cmode=1 crm=0 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1097: // add cmode=2 crm=0 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1098: // add cmode=0 crm=1 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1099: // add cmode=1 crm=1 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1100: // add cmode=2 crm=1 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1101: // add cmode=0 crm=2 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1102: // add cmode=1 crm=2 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1103: // add cmode=2 crm=2 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1104: // add cmode=0 crm=3 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1105: // add cmode=1 crm=3 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1106: // add cmode=2 crm=3 sfmo=0 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1107: // add cmode=0 crm=0 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1108: // add cmode=1 crm=0 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1109: // add cmode=2 crm=0 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1110: // add cmode=0 crm=1 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1111: // add cmode=1 crm=1 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1112: // add cmode=2 crm=1 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1113: // add cmode=0 crm=2 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1114: // add cmode=1 crm=2 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1115: // add cmode=2 crm=2 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1116: // add cmode=0 crm=3 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1117: // add cmode=1 crm=3 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1118: // add cmode=2 crm=3 sfmo=1 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1119: // add cmode=0 crm=0 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1120: // add cmode=1 crm=0 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1121: // add cmode=2 crm=0 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1122: // add cmode=0 crm=1 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1123: // add cmode=1 crm=1 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1124: // add cmode=2 crm=1 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1125: // add cmode=0 crm=2 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1126: // add cmode=1 crm=2 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1127: // add cmode=2 crm=2 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1128: // add cmode=0 crm=3 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1129: // add cmode=1 crm=3 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1130: // add cmode=2 crm=3 sfmo=2 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1131: // add cmode=0 crm=0 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1132: // add cmode=1 crm=0 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1133: // add cmode=2 crm=0 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1134: // add cmode=0 crm=1 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1135: // add cmode=1 crm=1 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1136: // add cmode=2 crm=1 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1137: // add cmode=0 crm=2 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1138: // add cmode=1 crm=2 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1139: // add cmode=2 crm=2 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1140: // add cmode=0 crm=3 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1141: // add cmode=1 crm=3 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1142: // add cmode=2 crm=3 sfmo=3 rnd=6 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1143: // add cmode=0 crm=0 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1144: // add cmode=1 crm=0 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1145: // add cmode=2 crm=0 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1146: // add cmode=0 crm=1 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1147: // add cmode=1 crm=1 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1148: // add cmode=2 crm=1 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1149: // add cmode=0 crm=2 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1150: // add cmode=1 crm=2 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1151: // add cmode=2 crm=2 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1152: // add cmode=0 crm=3 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1153: // add cmode=1 crm=3 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1154: // add cmode=2 crm=3 sfmo=0 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1155: // add cmode=0 crm=0 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1156: // add cmode=1 crm=0 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1157: // add cmode=2 crm=0 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1158: // add cmode=0 crm=1 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1159: // add cmode=1 crm=1 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1160: // add cmode=2 crm=1 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1161: // add cmode=0 crm=2 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1162: // add cmode=1 crm=2 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1163: // add cmode=2 crm=2 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1164: // add cmode=0 crm=3 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1165: // add cmode=1 crm=3 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1166: // add cmode=2 crm=3 sfmo=1 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1167: // add cmode=0 crm=0 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1168: // add cmode=1 crm=0 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1169: // add cmode=2 crm=0 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1170: // add cmode=0 crm=1 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1171: // add cmode=1 crm=1 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1172: // add cmode=2 crm=1 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1173: // add cmode=0 crm=2 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1174: // add cmode=1 crm=2 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1175: // add cmode=2 crm=2 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1176: // add cmode=0 crm=3 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1177: // add cmode=1 crm=3 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1178: // add cmode=2 crm=3 sfmo=2 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1179: // add cmode=0 crm=0 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1180: // add cmode=1 crm=0 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1181: // add cmode=2 crm=0 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1182: // add cmode=0 crm=1 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1183: // add cmode=1 crm=1 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1184: // add cmode=2 crm=1 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1185: // add cmode=0 crm=2 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1186: // add cmode=1 crm=2 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1187: // add cmode=2 crm=2 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1188: // add cmode=0 crm=3 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1189: // add cmode=1 crm=3 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1190: // add cmode=2 crm=3 sfmo=3 rnd=7 movm=0
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1191: // add cmode=0 crm=0 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1192: // add cmode=1 crm=0 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1193: // add cmode=2 crm=0 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1194: // add cmode=0 crm=1 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1195: // add cmode=1 crm=1 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1196: // add cmode=2 crm=1 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1197: // add cmode=0 crm=2 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1198: // add cmode=1 crm=2 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1199: // add cmode=2 crm=2 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1200: // add cmode=0 crm=3 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1201: // add cmode=1 crm=3 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1202: // add cmode=2 crm=3 sfmo=0 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1203: // add cmode=0 crm=0 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1204: // add cmode=1 crm=0 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1205: // add cmode=2 crm=0 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1206: // add cmode=0 crm=1 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1207: // add cmode=1 crm=1 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1208: // add cmode=2 crm=1 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1209: // add cmode=0 crm=2 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1210: // add cmode=1 crm=2 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1211: // add cmode=2 crm=2 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1212: // add cmode=0 crm=3 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1213: // add cmode=1 crm=3 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1214: // add cmode=2 crm=3 sfmo=1 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1215: // add cmode=0 crm=0 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1216: // add cmode=1 crm=0 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1217: // add cmode=2 crm=0 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1218: // add cmode=0 crm=1 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1219: // add cmode=1 crm=1 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1220: // add cmode=2 crm=1 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1221: // add cmode=0 crm=2 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1222: // add cmode=1 crm=2 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1223: // add cmode=2 crm=2 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1224: // add cmode=0 crm=3 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1225: // add cmode=1 crm=3 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1226: // add cmode=2 crm=3 sfmo=2 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1227: // add cmode=0 crm=0 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1228: // add cmode=1 crm=0 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1229: // add cmode=2 crm=0 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1230: // add cmode=0 crm=1 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1231: // add cmode=1 crm=1 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1232: // add cmode=2 crm=1 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1233: // add cmode=0 crm=2 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1234: // add cmode=1 crm=2 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1235: // add cmode=2 crm=2 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1236: // add cmode=0 crm=3 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1237: // add cmode=1 crm=3 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1238: // add cmode=2 crm=3 sfmo=3 rnd=0 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1239: // add cmode=0 crm=0 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1240: // add cmode=1 crm=0 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1241: // add cmode=2 crm=0 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1242: // add cmode=0 crm=1 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1243: // add cmode=1 crm=1 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1244: // add cmode=2 crm=1 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1245: // add cmode=0 crm=2 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1246: // add cmode=1 crm=2 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1247: // add cmode=2 crm=2 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1248: // add cmode=0 crm=3 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1249: // add cmode=1 crm=3 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1250: // add cmode=2 crm=3 sfmo=0 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1251: // add cmode=0 crm=0 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1252: // add cmode=1 crm=0 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1253: // add cmode=2 crm=0 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1254: // add cmode=0 crm=1 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1255: // add cmode=1 crm=1 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1256: // add cmode=2 crm=1 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1257: // add cmode=0 crm=2 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1258: // add cmode=1 crm=2 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1259: // add cmode=2 crm=2 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1260: // add cmode=0 crm=3 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1261: // add cmode=1 crm=3 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1262: // add cmode=2 crm=3 sfmo=1 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1263: // add cmode=0 crm=0 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1264: // add cmode=1 crm=0 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1265: // add cmode=2 crm=0 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1266: // add cmode=0 crm=1 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1267: // add cmode=1 crm=1 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1268: // add cmode=2 crm=1 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1269: // add cmode=0 crm=2 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1270: // add cmode=1 crm=2 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1271: // add cmode=2 crm=2 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1272: // add cmode=0 crm=3 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1273: // add cmode=1 crm=3 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1274: // add cmode=2 crm=3 sfmo=2 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1275: // add cmode=0 crm=0 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1276: // add cmode=1 crm=0 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1277: // add cmode=2 crm=0 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1278: // add cmode=0 crm=1 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1279: // add cmode=1 crm=1 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1280: // add cmode=2 crm=1 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1281: // add cmode=0 crm=2 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1282: // add cmode=1 crm=2 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1283: // add cmode=2 crm=2 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1284: // add cmode=0 crm=3 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1285: // add cmode=1 crm=3 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1286: // add cmode=2 crm=3 sfmo=3 rnd=1 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1287: // add cmode=0 crm=0 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1288: // add cmode=1 crm=0 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1289: // add cmode=2 crm=0 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1290: // add cmode=0 crm=1 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1291: // add cmode=1 crm=1 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1292: // add cmode=2 crm=1 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1293: // add cmode=0 crm=2 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1294: // add cmode=1 crm=2 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1295: // add cmode=2 crm=2 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1296: // add cmode=0 crm=3 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1297: // add cmode=1 crm=3 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1298: // add cmode=2 crm=3 sfmo=0 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1299: // add cmode=0 crm=0 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1300: // add cmode=1 crm=0 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1301: // add cmode=2 crm=0 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1302: // add cmode=0 crm=1 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1303: // add cmode=1 crm=1 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1304: // add cmode=2 crm=1 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1305: // add cmode=0 crm=2 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1306: // add cmode=1 crm=2 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1307: // add cmode=2 crm=2 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1308: // add cmode=0 crm=3 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1309: // add cmode=1 crm=3 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1310: // add cmode=2 crm=3 sfmo=1 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1311: // add cmode=0 crm=0 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1312: // add cmode=1 crm=0 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1313: // add cmode=2 crm=0 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1314: // add cmode=0 crm=1 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1315: // add cmode=1 crm=1 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1316: // add cmode=2 crm=1 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1317: // add cmode=0 crm=2 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1318: // add cmode=1 crm=2 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1319: // add cmode=2 crm=2 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1320: // add cmode=0 crm=3 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1321: // add cmode=1 crm=3 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1322: // add cmode=2 crm=3 sfmo=2 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1323: // add cmode=0 crm=0 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1324: // add cmode=1 crm=0 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1325: // add cmode=2 crm=0 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1326: // add cmode=0 crm=1 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1327: // add cmode=1 crm=1 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1328: // add cmode=2 crm=1 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1329: // add cmode=0 crm=2 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1330: // add cmode=1 crm=2 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1331: // add cmode=2 crm=2 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1332: // add cmode=0 crm=3 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1333: // add cmode=1 crm=3 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1334: // add cmode=2 crm=3 sfmo=3 rnd=2 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1335: // add cmode=0 crm=0 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1336: // add cmode=1 crm=0 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1337: // add cmode=2 crm=0 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1338: // add cmode=0 crm=1 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1339: // add cmode=1 crm=1 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1340: // add cmode=2 crm=1 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1341: // add cmode=0 crm=2 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1342: // add cmode=1 crm=2 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1343: // add cmode=2 crm=2 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1344: // add cmode=0 crm=3 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1345: // add cmode=1 crm=3 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1346: // add cmode=2 crm=3 sfmo=0 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1347: // add cmode=0 crm=0 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1348: // add cmode=1 crm=0 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1349: // add cmode=2 crm=0 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1350: // add cmode=0 crm=1 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1351: // add cmode=1 crm=1 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1352: // add cmode=2 crm=1 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1353: // add cmode=0 crm=2 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1354: // add cmode=1 crm=2 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1355: // add cmode=2 crm=2 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1356: // add cmode=0 crm=3 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1357: // add cmode=1 crm=3 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1358: // add cmode=2 crm=3 sfmo=1 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1359: // add cmode=0 crm=0 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1360: // add cmode=1 crm=0 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1361: // add cmode=2 crm=0 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1362: // add cmode=0 crm=1 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1363: // add cmode=1 crm=1 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1364: // add cmode=2 crm=1 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1365: // add cmode=0 crm=2 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1366: // add cmode=1 crm=2 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1367: // add cmode=2 crm=2 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1368: // add cmode=0 crm=3 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1369: // add cmode=1 crm=3 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1370: // add cmode=2 crm=3 sfmo=2 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1371: // add cmode=0 crm=0 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1372: // add cmode=1 crm=0 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1373: // add cmode=2 crm=0 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1374: // add cmode=0 crm=1 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1375: // add cmode=1 crm=1 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1376: // add cmode=2 crm=1 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1377: // add cmode=0 crm=2 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1378: // add cmode=1 crm=2 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1379: // add cmode=2 crm=2 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1380: // add cmode=0 crm=3 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1381: // add cmode=1 crm=3 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1382: // add cmode=2 crm=3 sfmo=3 rnd=3 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1383: // add cmode=0 crm=0 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1384: // add cmode=1 crm=0 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1385: // add cmode=2 crm=0 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1386: // add cmode=0 crm=1 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1387: // add cmode=1 crm=1 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1388: // add cmode=2 crm=1 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1389: // add cmode=0 crm=2 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1390: // add cmode=1 crm=2 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1391: // add cmode=2 crm=2 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1392: // add cmode=0 crm=3 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1393: // add cmode=1 crm=3 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1394: // add cmode=2 crm=3 sfmo=0 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1395: // add cmode=0 crm=0 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1396: // add cmode=1 crm=0 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1397: // add cmode=2 crm=0 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1398: // add cmode=0 crm=1 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1399: // add cmode=1 crm=1 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1400: // add cmode=2 crm=1 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1401: // add cmode=0 crm=2 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1402: // add cmode=1 crm=2 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1403: // add cmode=2 crm=2 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1404: // add cmode=0 crm=3 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1405: // add cmode=1 crm=3 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1406: // add cmode=2 crm=3 sfmo=1 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1407: // add cmode=0 crm=0 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1408: // add cmode=1 crm=0 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1409: // add cmode=2 crm=0 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1410: // add cmode=0 crm=1 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1411: // add cmode=1 crm=1 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1412: // add cmode=2 crm=1 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1413: // add cmode=0 crm=2 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1414: // add cmode=1 crm=2 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1415: // add cmode=2 crm=2 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1416: // add cmode=0 crm=3 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1417: // add cmode=1 crm=3 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1418: // add cmode=2 crm=3 sfmo=2 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1419: // add cmode=0 crm=0 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1420: // add cmode=1 crm=0 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1421: // add cmode=2 crm=0 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1422: // add cmode=0 crm=1 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1423: // add cmode=1 crm=1 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1424: // add cmode=2 crm=1 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1425: // add cmode=0 crm=2 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1426: // add cmode=1 crm=2 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1427: // add cmode=2 crm=2 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1428: // add cmode=0 crm=3 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1429: // add cmode=1 crm=3 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1430: // add cmode=2 crm=3 sfmo=3 rnd=4 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1431: // add cmode=0 crm=0 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1432: // add cmode=1 crm=0 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1433: // add cmode=2 crm=0 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1434: // add cmode=0 crm=1 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1435: // add cmode=1 crm=1 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1436: // add cmode=2 crm=1 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1437: // add cmode=0 crm=2 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1438: // add cmode=1 crm=2 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1439: // add cmode=2 crm=2 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1440: // add cmode=0 crm=3 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1441: // add cmode=1 crm=3 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1442: // add cmode=2 crm=3 sfmo=0 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1443: // add cmode=0 crm=0 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1444: // add cmode=1 crm=0 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1445: // add cmode=2 crm=0 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1446: // add cmode=0 crm=1 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1447: // add cmode=1 crm=1 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1448: // add cmode=2 crm=1 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1449: // add cmode=0 crm=2 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1450: // add cmode=1 crm=2 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1451: // add cmode=2 crm=2 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1452: // add cmode=0 crm=3 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1453: // add cmode=1 crm=3 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1454: // add cmode=2 crm=3 sfmo=1 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1455: // add cmode=0 crm=0 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1456: // add cmode=1 crm=0 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1457: // add cmode=2 crm=0 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1458: // add cmode=0 crm=1 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1459: // add cmode=1 crm=1 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1460: // add cmode=2 crm=1 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1461: // add cmode=0 crm=2 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1462: // add cmode=1 crm=2 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1463: // add cmode=2 crm=2 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1464: // add cmode=0 crm=3 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1465: // add cmode=1 crm=3 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1466: // add cmode=2 crm=3 sfmo=2 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1467: // add cmode=0 crm=0 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1468: // add cmode=1 crm=0 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1469: // add cmode=2 crm=0 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1470: // add cmode=0 crm=1 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1471: // add cmode=1 crm=1 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1472: // add cmode=2 crm=1 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1473: // add cmode=0 crm=2 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1474: // add cmode=1 crm=2 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1475: // add cmode=2 crm=2 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1476: // add cmode=0 crm=3 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1477: // add cmode=1 crm=3 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1478: // add cmode=2 crm=3 sfmo=3 rnd=5 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1479: // add cmode=0 crm=0 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1480: // add cmode=1 crm=0 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1481: // add cmode=2 crm=0 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1482: // add cmode=0 crm=1 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1483: // add cmode=1 crm=1 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1484: // add cmode=2 crm=1 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1485: // add cmode=0 crm=2 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1486: // add cmode=1 crm=2 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1487: // add cmode=2 crm=2 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1488: // add cmode=0 crm=3 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1489: // add cmode=1 crm=3 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1490: // add cmode=2 crm=3 sfmo=0 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1491: // add cmode=0 crm=0 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1492: // add cmode=1 crm=0 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1493: // add cmode=2 crm=0 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1494: // add cmode=0 crm=1 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1495: // add cmode=1 crm=1 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1496: // add cmode=2 crm=1 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1497: // add cmode=0 crm=2 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1498: // add cmode=1 crm=2 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1499: // add cmode=2 crm=2 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1500: // add cmode=0 crm=3 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1501: // add cmode=1 crm=3 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1502: // add cmode=2 crm=3 sfmo=1 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1503: // add cmode=0 crm=0 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1504: // add cmode=1 crm=0 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1505: // add cmode=2 crm=0 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1506: // add cmode=0 crm=1 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1507: // add cmode=1 crm=1 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1508: // add cmode=2 crm=1 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1509: // add cmode=0 crm=2 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1510: // add cmode=1 crm=2 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1511: // add cmode=2 crm=2 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1512: // add cmode=0 crm=3 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1513: // add cmode=1 crm=3 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1514: // add cmode=2 crm=3 sfmo=2 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1515: // add cmode=0 crm=0 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1516: // add cmode=1 crm=0 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1517: // add cmode=2 crm=0 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1518: // add cmode=0 crm=1 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1519: // add cmode=1 crm=1 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1520: // add cmode=2 crm=1 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1521: // add cmode=0 crm=2 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1522: // add cmode=1 crm=2 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1523: // add cmode=2 crm=2 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1524: // add cmode=0 crm=3 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1525: // add cmode=1 crm=3 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1526: // add cmode=2 crm=3 sfmo=3 rnd=6 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1527: // add cmode=0 crm=0 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1528: // add cmode=1 crm=0 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1529: // add cmode=2 crm=0 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1530: // add cmode=0 crm=1 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1531: // add cmode=1 crm=1 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1532: // add cmode=2 crm=1 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1533: // add cmode=0 crm=2 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1534: // add cmode=1 crm=2 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1535: // add cmode=2 crm=2 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1536: // add cmode=0 crm=3 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1537: // add cmode=1 crm=3 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1538: // add cmode=2 crm=3 sfmo=0 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1539: // add cmode=0 crm=0 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1540: // add cmode=1 crm=0 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1541: // add cmode=2 crm=0 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1542: // add cmode=0 crm=1 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1543: // add cmode=1 crm=1 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1544: // add cmode=2 crm=1 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1545: // add cmode=0 crm=2 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1546: // add cmode=1 crm=2 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1547: // add cmode=2 crm=2 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1548: // add cmode=0 crm=3 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1549: // add cmode=1 crm=3 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1550: // add cmode=2 crm=3 sfmo=1 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1551: // add cmode=0 crm=0 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1552: // add cmode=1 crm=0 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1553: // add cmode=2 crm=0 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1554: // add cmode=0 crm=1 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1555: // add cmode=1 crm=1 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1556: // add cmode=2 crm=1 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1557: // add cmode=0 crm=2 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1558: // add cmode=1 crm=2 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1559: // add cmode=2 crm=2 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1560: // add cmode=0 crm=3 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1561: // add cmode=1 crm=3 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1562: // add cmode=2 crm=3 sfmo=2 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1563: // add cmode=0 crm=0 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1564: // add cmode=1 crm=0 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1565: // add cmode=2 crm=0 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1566: // add cmode=0 crm=1 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1567: // add cmode=1 crm=1 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1568: // add cmode=2 crm=1 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1569: // add cmode=0 crm=2 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1570: // add cmode=1 crm=2 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1571: // add cmode=2 crm=2 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1572: // add cmode=0 crm=3 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[i->param] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1573: // add cmode=1 crm=3 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1574: // add cmode=2 crm=3 sfmo=3 rnd=7 movm=1
  r = (INT64)(INT32)s->cmem[s->ca++] + (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1575: // add cmode=0 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1576: // add cmode=1 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1577: // add cmode=2 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1578: // add cmode=0 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1579: // add cmode=1 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1580: // add cmode=2 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1581: // add cmode=0 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1582: // add cmode=1 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1583: // add cmode=2 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1584: // add cmode=0 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1585: // add cmode=1 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1586: // add cmode=2 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1587: // add cmode=0 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1588: // add cmode=1 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1589: // add cmode=2 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1590: // add cmode=0 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1591: // add cmode=1 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1592: // add cmode=2 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1593: // add cmode=0 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1594: // add cmode=1 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1595: // add cmode=2 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1596: // add cmode=0 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1597: // add cmode=1 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1598: // add cmode=2 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1599: // add cmode=0 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1600: // add cmode=1 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1601: // add cmode=2 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1602: // add cmode=0 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1603: // add cmode=1 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1604: // add cmode=2 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1605: // add cmode=0 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1606: // add cmode=1 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1607: // add cmode=2 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1608: // add cmode=0 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1609: // add cmode=1 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1610: // add cmode=2 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1611: // add cmode=0 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1612: // add cmode=1 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1613: // add cmode=2 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1614: // add cmode=0 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1615: // add cmode=1 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1616: // add cmode=2 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1617: // add cmode=0 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1618: // add cmode=1 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1619: // add cmode=2 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1620: // add cmode=0 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1621: // add cmode=1 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1622: // add cmode=2 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1623: // add cmode=0 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1624: // add cmode=1 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1625: // add cmode=2 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1626: // add cmode=0 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1627: // add cmode=1 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1628: // add cmode=2 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1629: // add cmode=0 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1630: // add cmode=1 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1631: // add cmode=2 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1632: // add cmode=0 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1633: // add cmode=1 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1634: // add cmode=2 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1635: // add cmode=0 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1636: // add cmode=1 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1637: // add cmode=2 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1638: // add cmode=0 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1639: // add cmode=1 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1640: // add cmode=2 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1641: // add cmode=0 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1642: // add cmode=1 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1643: // add cmode=2 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1644: // add cmode=0 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1645: // add cmode=1 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1646: // add cmode=2 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) + (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1647: // sub dmode=0 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1648: // sub dmode=1 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1649: // sub dmode=2 dbp=0 sfao=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1650: // sub dmode=0 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1651: // sub dmode=1 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1652: // sub dmode=2 dbp=1 sfao=0
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1653: // sub dmode=0 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1654: // sub dmode=1 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1655: // sub dmode=2 dbp=0 sfao=1
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1656: // sub dmode=0 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1657: // sub dmode=1 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1658: // sub dmode=2 dbp=1 sfao=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1659: // sub cmode=0 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[i->param] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1660: // sub cmode=1 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1661: // sub cmode=2 crm=0 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca++] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1662: // sub cmode=0 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1663: // sub cmode=1 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1664: // sub cmode=2 crm=1 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1665: // sub cmode=0 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[i->param] << 16) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1666: // sub cmode=1 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1667: // sub cmode=2 crm=2 sfao=0
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1668: // sub cmode=0 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[i->param] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1669: // sub cmode=1 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1670: // sub cmode=2 crm=3 sfao=0
  r = (INT64)(INT32)s->cmem[s->ca++] - (INT64)(INT32)s->aacc;
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1671: // sub cmode=0 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[i->param] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1672: // sub cmode=1 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1673: // sub cmode=2 crm=0 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca++] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1674: // sub cmode=0 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[i->param] & 0xffff0000) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1675: // sub cmode=1 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1676: // sub cmode=2 crm=1 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1677: // sub cmode=0 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[i->param] << 16) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1678: // sub cmode=1 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca] << 16) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1679: // sub cmode=2 crm=2 sfao=1
  r = (INT64)(INT32)(s->cmem[s->ca++] << 16) - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1680: // sub cmode=0 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[i->param] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1681: // sub cmode=1 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1682: // sub cmode=2 crm=3 sfao=1
  r = (INT64)(INT32)s->cmem[s->ca++] - (INT64)(INT32)(s->aacc << 7);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1683: // sub cmode=0 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1684: // sub cmode=1 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1685: // sub cmode=2 dmode=0 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1686: // sub cmode=0 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1687: // sub cmode=1 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1688: // sub cmode=2 dmode=1 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1689: // sub cmode=0 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1690: // sub cmode=1 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1691: // sub cmode=2 dmode=2 crm=0 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1692: // sub cmode=0 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1693: // sub cmode=1 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1694: // sub cmode=2 dmode=0 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1695: // sub cmode=0 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1696: // sub cmode=1 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1697: // sub cmode=2 dmode=1 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1698: // sub cmode=0 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1699: // sub cmode=1 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1700: // sub cmode=2 dmode=2 crm=1 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1701: // sub cmode=0 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1702: // sub cmode=1 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1703: // sub cmode=2 dmode=0 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1704: // sub cmode=0 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1705: // sub cmode=1 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1706: // sub cmode=2 dmode=1 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1707: // sub cmode=0 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1708: // sub cmode=1 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1709: // sub cmode=2 dmode=2 crm=2 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1710: // sub cmode=0 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1711: // sub cmode=1 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1712: // sub cmode=2 dmode=0 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1713: // sub cmode=0 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1714: // sub cmode=1 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1715: // sub cmode=2 dmode=1 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1716: // sub cmode=0 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1717: // sub cmode=1 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1718: // sub cmode=2 dmode=2 crm=3 dbp=0
  r = (INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1719: // sub cmode=0 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1720: // sub cmode=1 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1721: // sub cmode=2 dmode=0 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1722: // sub cmode=0 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1723: // sub cmode=1 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1724: // sub cmode=2 dmode=1 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1725: // sub cmode=0 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1726: // sub cmode=1 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1727: // sub cmode=2 dmode=2 crm=0 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1728: // sub cmode=0 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1729: // sub cmode=1 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1730: // sub cmode=2 dmode=0 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1731: // sub cmode=0 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1732: // sub cmode=1 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1733: // sub cmode=2 dmode=1 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1734: // sub cmode=0 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1735: // sub cmode=1 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1736: // sub cmode=2 dmode=2 crm=1 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1737: // sub cmode=0 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1738: // sub cmode=1 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1739: // sub cmode=2 dmode=0 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1740: // sub cmode=0 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1741: // sub cmode=1 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1742: // sub cmode=2 dmode=1 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1743: // sub cmode=0 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[i->param] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1744: // sub cmode=1 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1745: // sub cmode=2 dmode=2 crm=2 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)(s->cmem[s->ca++] << 16);
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1746: // sub cmode=0 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1747: // sub cmode=1 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1748: // sub cmode=2 dmode=0 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1749: // sub cmode=0 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1750: // sub cmode=1 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1751: // sub cmode=2 dmode=1 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1752: // sub cmode=0 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[i->param];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1753: // sub cmode=1 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1754: // sub cmode=2 dmode=2 crm=3 dbp=1
  r = (INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8) - (INT64)(INT32)s->cmem[s->ca++];
  if(r < -0x80000000 || r > 0x7fffffff)
    s->st1 |= ST1_AOV;
  s->aacc = r;
  break;

case 1755: // lacd dmode=0 sfai=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = d;
  break;

case 1756: // lacd dmode=1 sfai=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = d;
  break;

case 1757: // lacd dmode=2 sfai=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = d;
  break;

case 1758: // lacd dmode=0 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = d;
  break;

case 1759: // lacd dmode=1 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = d;
  break;

case 1760: // lacd dmode=2 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = d;
  break;

case 1761: // lacd dmode=0 sfai=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = d;
  break;

case 1762: // lacd dmode=1 sfai=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = d;
  break;

case 1763: // lacd dmode=2 sfai=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = d;
  break;

case 1764: // lacd dmode=0 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = d;
  break;

case 1765: // lacd dmode=1 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = d;
  break;

case 1766: // lacd dmode=2 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = d;
  break;

case 1767: // lacc cmode=0 crm=0
  s->aacc = s->cmem[i->param];
  break;

case 1768: // lacc cmode=1 crm=0
  s->aacc = s->cmem[s->ca];
  break;

case 1769: // lacc cmode=2 crm=0
  s->aacc = s->cmem[s->ca++];
  break;

case 1770: // lacc cmode=0 crm=1
  s->aacc = (s->cmem[i->param] & 0xffff0000);
  break;

case 1771: // lacc cmode=1 crm=1
  s->aacc = (s->cmem[s->ca] & 0xffff0000);
  break;

case 1772: // lacc cmode=2 crm=1
  s->aacc = (s->cmem[s->ca++] & 0xffff0000);
  break;

case 1773: // lacc cmode=0 crm=2
  s->aacc = (s->cmem[i->param] << 16);
  break;

case 1774: // lacc cmode=1 crm=2
  s->aacc = (s->cmem[s->ca] << 16);
  break;

case 1775: // lacc cmode=2 crm=2
  s->aacc = (s->cmem[s->ca++] << 16);
  break;

case 1776: // lacc cmode=0 crm=3
  s->aacc = s->cmem[i->param];
  break;

case 1777: // lacc cmode=1 crm=3
  s->aacc = s->cmem[s->ca];
  break;

case 1778: // lacc cmode=2 crm=3
  s->aacc = s->cmem[s->ca++];
  break;

case 1779: // and dmode=0 sfai=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc &= d;
  break;

case 1780: // and dmode=1 sfai=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc &= d;
  break;

case 1781: // and dmode=2 sfai=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc &= d;
  break;

case 1782: // and dmode=0 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1783: // and dmode=1 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1784: // and dmode=2 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1785: // and dmode=0 sfai=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc &= d;
  break;

case 1786: // and dmode=1 sfai=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc &= d;
  break;

case 1787: // and dmode=2 sfai=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc &= d;
  break;

case 1788: // and dmode=0 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1789: // and dmode=1 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1790: // and dmode=2 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc &= d;
  break;

case 1791: // and cmode=0 crm=0
  s->aacc &= s->cmem[i->param];
  break;

case 1792: // and cmode=1 crm=0
  s->aacc &= s->cmem[s->ca];
  break;

case 1793: // and cmode=2 crm=0
  s->aacc &= s->cmem[s->ca++];
  break;

case 1794: // and cmode=0 crm=1
  s->aacc &= (s->cmem[i->param] & 0xffff0000);
  break;

case 1795: // and cmode=1 crm=1
  s->aacc &= (s->cmem[s->ca] & 0xffff0000);
  break;

case 1796: // and cmode=2 crm=1
  s->aacc &= (s->cmem[s->ca++] & 0xffff0000);
  break;

case 1797: // and cmode=0 crm=2
  s->aacc &= (s->cmem[i->param] << 16);
  break;

case 1798: // and cmode=1 crm=2
  s->aacc &= (s->cmem[s->ca] << 16);
  break;

case 1799: // and cmode=2 crm=2
  s->aacc &= (s->cmem[s->ca++] << 16);
  break;

case 1800: // and cmode=0 crm=3
  s->aacc &= s->cmem[i->param];
  break;

case 1801: // and cmode=1 crm=3
  s->aacc &= s->cmem[s->ca];
  break;

case 1802: // and cmode=2 crm=3
  s->aacc &= s->cmem[s->ca++];
  break;

case 1803: // and cmode=0 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1804: // and cmode=1 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1805: // and cmode=2 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1806: // and cmode=0 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1807: // and cmode=1 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1808: // and cmode=2 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1809: // and cmode=0 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1810: // and cmode=1 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1811: // and cmode=2 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1812: // and cmode=0 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1813: // and cmode=1 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1814: // and cmode=2 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1815: // and cmode=0 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1816: // and cmode=1 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1817: // and cmode=2 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1818: // and cmode=0 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1819: // and cmode=1 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1820: // and cmode=2 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1821: // and cmode=0 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1822: // and cmode=1 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1823: // and cmode=2 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1824: // and cmode=0 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1825: // and cmode=1 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1826: // and cmode=2 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1827: // and cmode=0 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1828: // and cmode=1 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1829: // and cmode=2 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1830: // and cmode=0 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1831: // and cmode=1 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1832: // and cmode=2 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1833: // and cmode=0 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1834: // and cmode=1 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1835: // and cmode=2 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1836: // and cmode=0 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1837: // and cmode=1 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1838: // and cmode=2 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1839: // and cmode=0 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1840: // and cmode=1 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1841: // and cmode=2 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1842: // and cmode=0 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1843: // and cmode=1 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1844: // and cmode=2 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1845: // and cmode=0 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1846: // and cmode=1 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1847: // and cmode=2 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1848: // and cmode=0 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1849: // and cmode=1 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1850: // and cmode=2 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1851: // and cmode=0 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1852: // and cmode=1 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1853: // and cmode=2 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1854: // and cmode=0 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1855: // and cmode=1 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1856: // and cmode=2 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1857: // and cmode=0 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1858: // and cmode=1 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1859: // and cmode=2 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1860: // and cmode=0 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1861: // and cmode=1 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1862: // and cmode=2 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1863: // and cmode=0 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1864: // and cmode=1 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1865: // and cmode=2 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1866: // and cmode=0 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1867: // and cmode=1 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1868: // and cmode=2 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1869: // and cmode=0 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1870: // and cmode=1 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1871: // and cmode=2 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1872: // and cmode=0 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1873: // and cmode=1 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1874: // and cmode=2 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1875: // and cmode=0 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1876: // and cmode=1 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1877: // and cmode=2 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1878: // and cmode=0 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1879: // and cmode=1 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1880: // and cmode=2 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1881: // and cmode=0 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1882: // and cmode=1 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1883: // and cmode=2 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1884: // and cmode=0 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1885: // and cmode=1 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1886: // and cmode=2 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1887: // and cmode=0 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1888: // and cmode=1 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1889: // and cmode=2 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1890: // and cmode=0 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1891: // and cmode=1 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1892: // and cmode=2 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1893: // and cmode=0 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1894: // and cmode=1 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1895: // and cmode=2 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1896: // and cmode=0 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1897: // and cmode=1 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1898: // and cmode=2 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1899: // and cmode=0 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1900: // and cmode=1 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1901: // and cmode=2 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1902: // and cmode=0 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1903: // and cmode=1 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1904: // and cmode=2 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1905: // and cmode=0 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1906: // and cmode=1 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1907: // and cmode=2 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1908: // and cmode=0 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) & d;
  break;

case 1909: // and cmode=1 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) & d;
  break;

case 1910: // and cmode=2 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) & d;
  break;

case 1911: // and cmode=0 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1912: // and cmode=1 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1913: // and cmode=2 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1914: // and cmode=0 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1915: // and cmode=1 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1916: // and cmode=2 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1917: // and cmode=0 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1918: // and cmode=1 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1919: // and cmode=2 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1920: // and cmode=0 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1921: // and cmode=1 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1922: // and cmode=2 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1923: // and cmode=0 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1924: // and cmode=1 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1925: // and cmode=2 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1926: // and cmode=0 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) & d;
  break;

case 1927: // and cmode=1 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) & d;
  break;

case 1928: // and cmode=2 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) & d;
  break;

case 1929: // and cmode=0 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1930: // and cmode=1 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1931: // and cmode=2 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1932: // and cmode=0 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1933: // and cmode=1 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1934: // and cmode=2 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1935: // and cmode=0 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] & d;
  break;

case 1936: // and cmode=1 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1937: // and cmode=2 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1938: // and cmode=0 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1939: // and cmode=1 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1940: // and cmode=2 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1941: // and cmode=0 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1942: // and cmode=1 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1943: // and cmode=2 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1944: // and cmode=0 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] & d;
  break;

case 1945: // and cmode=1 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] & d;
  break;

case 1946: // and cmode=2 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] & d;
  break;

case 1947: // or dmode=0 sfai=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc |= d;
  break;

case 1948: // or dmode=1 sfai=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc |= d;
  break;

case 1949: // or dmode=2 sfai=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc |= d;
  break;

case 1950: // or dmode=0 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1951: // or dmode=1 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1952: // or dmode=2 sfai=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1953: // or dmode=0 sfai=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc |= d;
  break;

case 1954: // or dmode=1 sfai=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc |= d;
  break;

case 1955: // or dmode=2 sfai=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc |= d;
  break;

case 1956: // or dmode=0 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1957: // or dmode=1 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1958: // or dmode=2 sfai=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc |= d;
  break;

case 1959: // or cmode=0 crm=0
  s->aacc |= s->cmem[i->param];
  break;

case 1960: // or cmode=1 crm=0
  s->aacc |= s->cmem[s->ca];
  break;

case 1961: // or cmode=2 crm=0
  s->aacc |= s->cmem[s->ca++];
  break;

case 1962: // or cmode=0 crm=1
  s->aacc |= (s->cmem[i->param] & 0xffff0000);
  break;

case 1963: // or cmode=1 crm=1
  s->aacc |= (s->cmem[s->ca] & 0xffff0000);
  break;

case 1964: // or cmode=2 crm=1
  s->aacc |= (s->cmem[s->ca++] & 0xffff0000);
  break;

case 1965: // or cmode=0 crm=2
  s->aacc |= (s->cmem[i->param] << 16);
  break;

case 1966: // or cmode=1 crm=2
  s->aacc |= (s->cmem[s->ca] << 16);
  break;

case 1967: // or cmode=2 crm=2
  s->aacc |= (s->cmem[s->ca++] << 16);
  break;

case 1968: // or cmode=0 crm=3
  s->aacc |= s->cmem[i->param];
  break;

case 1969: // or cmode=1 crm=3
  s->aacc |= s->cmem[s->ca];
  break;

case 1970: // or cmode=2 crm=3
  s->aacc |= s->cmem[s->ca++];
  break;

case 1971: // or cmode=0 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 1972: // or cmode=1 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1973: // or cmode=2 dmode=0 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1974: // or cmode=0 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 1975: // or cmode=1 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1976: // or cmode=2 dmode=1 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1977: // or cmode=0 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 1978: // or cmode=1 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1979: // or cmode=2 dmode=2 sfai=0 crm=0 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1980: // or cmode=0 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 1981: // or cmode=1 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1982: // or cmode=2 dmode=0 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1983: // or cmode=0 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 1984: // or cmode=1 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1985: // or cmode=2 dmode=1 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1986: // or cmode=0 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 1987: // or cmode=1 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 1988: // or cmode=2 dmode=2 sfai=1 crm=0 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 1989: // or cmode=0 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 1990: // or cmode=1 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 1991: // or cmode=2 dmode=0 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 1992: // or cmode=0 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 1993: // or cmode=1 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 1994: // or cmode=2 dmode=1 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 1995: // or cmode=0 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 1996: // or cmode=1 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 1997: // or cmode=2 dmode=2 sfai=0 crm=1 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 1998: // or cmode=0 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 1999: // or cmode=1 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2000: // or cmode=2 dmode=0 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2001: // or cmode=0 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2002: // or cmode=1 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2003: // or cmode=2 dmode=1 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2004: // or cmode=0 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2005: // or cmode=1 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2006: // or cmode=2 dmode=2 sfai=1 crm=1 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2007: // or cmode=0 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2008: // or cmode=1 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2009: // or cmode=2 dmode=0 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2010: // or cmode=0 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2011: // or cmode=1 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2012: // or cmode=2 dmode=1 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2013: // or cmode=0 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2014: // or cmode=1 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2015: // or cmode=2 dmode=2 sfai=0 crm=2 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2016: // or cmode=0 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2017: // or cmode=1 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2018: // or cmode=2 dmode=0 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2019: // or cmode=0 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2020: // or cmode=1 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2021: // or cmode=2 dmode=1 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2022: // or cmode=0 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2023: // or cmode=1 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2024: // or cmode=2 dmode=2 sfai=1 crm=2 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2025: // or cmode=0 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2026: // or cmode=1 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2027: // or cmode=2 dmode=0 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(i->param + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2028: // or cmode=0 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2029: // or cmode=1 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2030: // or cmode=2 dmode=1 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[(s->id + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2031: // or cmode=0 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2032: // or cmode=1 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2033: // or cmode=2 dmode=2 sfai=0 crm=3 dbp=0
  d =  (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2034: // or cmode=0 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2035: // or cmode=1 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2036: // or cmode=2 dmode=0 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(i->param + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2037: // or cmode=0 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2038: // or cmode=1 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2039: // or cmode=2 dmode=1 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[(s->id + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2040: // or cmode=0 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2041: // or cmode=1 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2042: // or cmode=2 dmode=2 sfai=1 crm=3 dbp=0
  d = ((INT32)( (s->dmem0[((s->id++) + s->ba0) & 0xff] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2043: // or cmode=0 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2044: // or cmode=1 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2045: // or cmode=2 dmode=0 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2046: // or cmode=0 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2047: // or cmode=1 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2048: // or cmode=2 dmode=1 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2049: // or cmode=0 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2050: // or cmode=1 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2051: // or cmode=2 dmode=2 sfai=0 crm=0 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2052: // or cmode=0 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2053: // or cmode=1 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2054: // or cmode=2 dmode=0 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2055: // or cmode=0 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2056: // or cmode=1 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2057: // or cmode=2 dmode=1 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2058: // or cmode=0 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2059: // or cmode=1 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2060: // or cmode=2 dmode=2 sfai=1 crm=0 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2061: // or cmode=0 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2062: // or cmode=1 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2063: // or cmode=2 dmode=0 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2064: // or cmode=0 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2065: // or cmode=1 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2066: // or cmode=2 dmode=1 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2067: // or cmode=0 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2068: // or cmode=1 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2069: // or cmode=2 dmode=2 sfai=0 crm=1 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2070: // or cmode=0 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2071: // or cmode=1 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2072: // or cmode=2 dmode=0 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2073: // or cmode=0 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2074: // or cmode=1 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2075: // or cmode=2 dmode=1 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2076: // or cmode=0 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] & 0xffff0000) | d;
  break;

case 2077: // or cmode=1 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] & 0xffff0000) | d;
  break;

case 2078: // or cmode=2 dmode=2 sfai=1 crm=1 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] & 0xffff0000) | d;
  break;

case 2079: // or cmode=0 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2080: // or cmode=1 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2081: // or cmode=2 dmode=0 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2082: // or cmode=0 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2083: // or cmode=1 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2084: // or cmode=2 dmode=1 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2085: // or cmode=0 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2086: // or cmode=1 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2087: // or cmode=2 dmode=2 sfai=0 crm=2 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2088: // or cmode=0 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2089: // or cmode=1 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2090: // or cmode=2 dmode=0 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2091: // or cmode=0 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2092: // or cmode=1 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2093: // or cmode=2 dmode=1 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2094: // or cmode=0 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[i->param] << 16) | d;
  break;

case 2095: // or cmode=1 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca] << 16) | d;
  break;

case 2096: // or cmode=2 dmode=2 sfai=1 crm=2 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = (s->cmem[s->ca++] << 16) | d;
  break;

case 2097: // or cmode=0 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2098: // or cmode=1 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2099: // or cmode=2 dmode=0 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(i->param + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2100: // or cmode=0 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2101: // or cmode=1 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2102: // or cmode=2 dmode=1 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[(s->id + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2103: // or cmode=0 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[i->param] | d;
  break;

case 2104: // or cmode=1 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2105: // or cmode=2 dmode=2 sfai=0 crm=3 dbp=1
  d =  (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8);
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2106: // or cmode=0 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2107: // or cmode=1 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2108: // or cmode=2 dmode=0 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(i->param + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2109: // or cmode=0 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2110: // or cmode=1 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2111: // or cmode=2 dmode=1 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[(s->id + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2112: // or cmode=0 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[i->param] | d;
  break;

case 2113: // or cmode=1 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca] | d;
  break;

case 2114: // or cmode=2 dmode=2 sfai=1 crm=3 dbp=1
  d = ((INT32)( (s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8))) >> 1;
  s->aacc = s->cmem[s->ca++] | d;
  break;

case 2115: // mpy cmode=0 dmode=0 crm=0 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2116: // mpy cmode=1 dmode=0 crm=0 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2117: // mpy cmode=2 dmode=0 crm=0 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2118: // mpy cmode=0 dmode=1 crm=0 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2119: // mpy cmode=1 dmode=1 crm=0 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2120: // mpy cmode=2 dmode=1 crm=0 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2121: // mpy cmode=0 dmode=2 crm=0 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2122: // mpy cmode=1 dmode=2 crm=0 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2123: // mpy cmode=2 dmode=2 crm=0 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2124: // mpy cmode=0 dmode=0 crm=1 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2125: // mpy cmode=1 dmode=0 crm=1 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2126: // mpy cmode=2 dmode=0 crm=1 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2127: // mpy cmode=0 dmode=1 crm=1 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2128: // mpy cmode=1 dmode=1 crm=1 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2129: // mpy cmode=2 dmode=1 crm=1 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2130: // mpy cmode=0 dmode=2 crm=1 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2131: // mpy cmode=1 dmode=2 crm=1 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2132: // mpy cmode=2 dmode=2 crm=1 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2133: // mpy cmode=0 dmode=0 crm=2 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2134: // mpy cmode=1 dmode=0 crm=2 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2135: // mpy cmode=2 dmode=0 crm=2 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2136: // mpy cmode=0 dmode=1 crm=2 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2137: // mpy cmode=1 dmode=1 crm=2 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2138: // mpy cmode=2 dmode=1 crm=2 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2139: // mpy cmode=0 dmode=2 crm=2 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2140: // mpy cmode=1 dmode=2 crm=2 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2141: // mpy cmode=2 dmode=2 crm=2 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2142: // mpy cmode=0 dmode=0 crm=3 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2143: // mpy cmode=1 dmode=0 crm=3 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2144: // mpy cmode=2 dmode=0 crm=3 dbp=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2145: // mpy cmode=0 dmode=1 crm=3 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2146: // mpy cmode=1 dmode=1 crm=3 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2147: // mpy cmode=2 dmode=1 crm=3 dbp=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2148: // mpy cmode=0 dmode=2 crm=3 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2149: // mpy cmode=1 dmode=2 crm=3 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2150: // mpy cmode=2 dmode=2 crm=3 dbp=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2151: // mpy cmode=0 dmode=0 crm=0 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2152: // mpy cmode=1 dmode=0 crm=0 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2153: // mpy cmode=2 dmode=0 crm=0 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2154: // mpy cmode=0 dmode=1 crm=0 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2155: // mpy cmode=1 dmode=1 crm=0 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2156: // mpy cmode=2 dmode=1 crm=0 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2157: // mpy cmode=0 dmode=2 crm=0 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2158: // mpy cmode=1 dmode=2 crm=0 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2159: // mpy cmode=2 dmode=2 crm=0 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2160: // mpy cmode=0 dmode=0 crm=1 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2161: // mpy cmode=1 dmode=0 crm=1 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2162: // mpy cmode=2 dmode=0 crm=1 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2163: // mpy cmode=0 dmode=1 crm=1 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2164: // mpy cmode=1 dmode=1 crm=1 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2165: // mpy cmode=2 dmode=1 crm=1 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2166: // mpy cmode=0 dmode=2 crm=1 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2167: // mpy cmode=1 dmode=2 crm=1 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2168: // mpy cmode=2 dmode=2 crm=1 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2169: // mpy cmode=0 dmode=0 crm=2 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2170: // mpy cmode=1 dmode=0 crm=2 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2171: // mpy cmode=2 dmode=0 crm=2 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2172: // mpy cmode=0 dmode=1 crm=2 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2173: // mpy cmode=1 dmode=1 crm=2 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2174: // mpy cmode=2 dmode=1 crm=2 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2175: // mpy cmode=0 dmode=2 crm=2 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2176: // mpy cmode=1 dmode=2 crm=2 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2177: // mpy cmode=2 dmode=2 crm=2 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2178: // mpy cmode=0 dmode=0 crm=3 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2179: // mpy cmode=1 dmode=0 crm=3 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2180: // mpy cmode=2 dmode=0 crm=3 dbp=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2181: // mpy cmode=0 dmode=1 crm=3 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2182: // mpy cmode=1 dmode=1 crm=3 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2183: // mpy cmode=2 dmode=1 crm=3 dbp=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2184: // mpy cmode=0 dmode=2 crm=3 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2185: // mpy cmode=1 dmode=2 crm=3 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2186: // mpy cmode=2 dmode=2 crm=3 dbp=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = r >> 7;
  break;

case 2187: // mpy cmode=0 crm=0 sfao=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2188: // mpy cmode=1 crm=0 sfao=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2189: // mpy cmode=2 crm=0 sfao=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2190: // mpy cmode=0 crm=1 sfao=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2191: // mpy cmode=1 crm=1 sfao=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2192: // mpy cmode=2 crm=1 sfao=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2193: // mpy cmode=0 crm=2 sfao=0
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2194: // mpy cmode=1 crm=2 sfao=0
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2195: // mpy cmode=2 crm=2 sfao=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2196: // mpy cmode=0 crm=3 sfao=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2197: // mpy cmode=1 crm=3 sfao=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2198: // mpy cmode=2 crm=3 sfao=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = r >> 15;
  break;

case 2199: // mpy cmode=0 crm=0 sfao=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2200: // mpy cmode=1 crm=0 sfao=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2201: // mpy cmode=2 crm=0 sfao=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2202: // mpy cmode=0 crm=1 sfao=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2203: // mpy cmode=1 crm=1 sfao=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2204: // mpy cmode=2 crm=1 sfao=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2205: // mpy cmode=0 crm=2 sfao=1
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2206: // mpy cmode=1 crm=2 sfao=1
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2207: // mpy cmode=2 crm=2 sfao=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2208: // mpy cmode=0 crm=3 sfao=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2209: // mpy cmode=1 crm=3 sfao=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2210: // mpy cmode=2 crm=3 sfao=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = r >> 15;
  break;

case 2211: // mac cmode=0 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2212: // mac cmode=1 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2213: // mac cmode=2 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2214: // mac cmode=0 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2215: // mac cmode=1 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2216: // mac cmode=2 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2217: // mac cmode=0 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2218: // mac cmode=1 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2219: // mac cmode=2 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2220: // mac cmode=0 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2221: // mac cmode=1 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2222: // mac cmode=2 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2223: // mac cmode=0 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2224: // mac cmode=1 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2225: // mac cmode=2 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2226: // mac cmode=0 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2227: // mac cmode=1 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2228: // mac cmode=2 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2229: // mac cmode=0 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2230: // mac cmode=1 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2231: // mac cmode=2 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2232: // mac cmode=0 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2233: // mac cmode=1 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2234: // mac cmode=2 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2235: // mac cmode=0 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2236: // mac cmode=1 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2237: // mac cmode=2 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2238: // mac cmode=0 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2239: // mac cmode=1 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2240: // mac cmode=2 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2241: // mac cmode=0 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2242: // mac cmode=1 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2243: // mac cmode=2 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2244: // mac cmode=0 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2245: // mac cmode=1 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2246: // mac cmode=2 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2247: // mac cmode=0 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2248: // mac cmode=1 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2249: // mac cmode=2 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2250: // mac cmode=0 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2251: // mac cmode=1 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2252: // mac cmode=2 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2253: // mac cmode=0 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2254: // mac cmode=1 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2255: // mac cmode=2 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2256: // mac cmode=0 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2257: // mac cmode=1 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2258: // mac cmode=2 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2259: // mac cmode=0 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2260: // mac cmode=1 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2261: // mac cmode=2 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2262: // mac cmode=0 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2263: // mac cmode=1 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2264: // mac cmode=2 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2265: // mac cmode=0 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2266: // mac cmode=1 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2267: // mac cmode=2 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2268: // mac cmode=0 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2269: // mac cmode=1 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2270: // mac cmode=2 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2271: // mac cmode=0 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2272: // mac cmode=1 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2273: // mac cmode=2 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2274: // mac cmode=0 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2275: // mac cmode=1 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2276: // mac cmode=2 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2277: // mac cmode=0 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2278: // mac cmode=1 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2279: // mac cmode=2 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2280: // mac cmode=0 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2281: // mac cmode=1 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2282: // mac cmode=2 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2283: // mac cmode=0 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2284: // mac cmode=1 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2285: // mac cmode=2 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2286: // mac cmode=0 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2287: // mac cmode=1 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2288: // mac cmode=2 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2289: // mac cmode=0 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2290: // mac cmode=1 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2291: // mac cmode=2 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2292: // mac cmode=0 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2293: // mac cmode=1 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2294: // mac cmode=2 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2295: // mac cmode=0 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2296: // mac cmode=1 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2297: // mac cmode=2 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2298: // mac cmode=0 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2299: // mac cmode=1 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2300: // mac cmode=2 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2301: // mac cmode=0 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2302: // mac cmode=1 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2303: // mac cmode=2 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2304: // mac cmode=0 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2305: // mac cmode=1 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2306: // mac cmode=2 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2307: // mac cmode=0 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2308: // mac cmode=1 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2309: // mac cmode=2 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2310: // mac cmode=0 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2311: // mac cmode=1 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2312: // mac cmode=2 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2313: // mac cmode=0 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2314: // mac cmode=1 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2315: // mac cmode=2 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2316: // mac cmode=0 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2317: // mac cmode=1 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2318: // mac cmode=2 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2319: // mac cmode=0 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2320: // mac cmode=1 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2321: // mac cmode=2 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2322: // mac cmode=0 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2323: // mac cmode=1 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2324: // mac cmode=2 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2325: // mac cmode=0 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2326: // mac cmode=1 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2327: // mac cmode=2 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2328: // mac cmode=0 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2329: // mac cmode=1 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2330: // mac cmode=2 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2331: // mac cmode=0 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2332: // mac cmode=1 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2333: // mac cmode=2 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2334: // mac cmode=0 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2335: // mac cmode=1 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2336: // mac cmode=2 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2337: // mac cmode=0 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2338: // mac cmode=1 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2339: // mac cmode=2 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2340: // mac cmode=0 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2341: // mac cmode=1 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2342: // mac cmode=2 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2343: // mac cmode=0 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2344: // mac cmode=1 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2345: // mac cmode=2 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2346: // mac cmode=0 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2347: // mac cmode=1 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2348: // mac cmode=2 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2349: // mac cmode=0 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2350: // mac cmode=1 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2351: // mac cmode=2 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2352: // mac cmode=0 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2353: // mac cmode=1 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2354: // mac cmode=2 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2355: // mac cmode=0 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2356: // mac cmode=1 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2357: // mac cmode=2 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2358: // mac cmode=0 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2359: // mac cmode=1 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2360: // mac cmode=2 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2361: // mac cmode=0 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2362: // mac cmode=1 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2363: // mac cmode=2 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2364: // mac cmode=0 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2365: // mac cmode=1 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2366: // mac cmode=2 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2367: // mac cmode=0 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2368: // mac cmode=1 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2369: // mac cmode=2 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2370: // mac cmode=0 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2371: // mac cmode=1 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2372: // mac cmode=2 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2373: // mac cmode=0 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2374: // mac cmode=1 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2375: // mac cmode=2 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2376: // mac cmode=0 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2377: // mac cmode=1 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2378: // mac cmode=2 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2379: // mac cmode=0 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2380: // mac cmode=1 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2381: // mac cmode=2 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2382: // mac cmode=0 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2383: // mac cmode=1 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2384: // mac cmode=2 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2385: // mac cmode=0 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2386: // mac cmode=1 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2387: // mac cmode=2 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2388: // mac cmode=0 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2389: // mac cmode=1 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2390: // mac cmode=2 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2391: // mac cmode=0 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2392: // mac cmode=1 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2393: // mac cmode=2 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2394: // mac cmode=0 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2395: // mac cmode=1 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2396: // mac cmode=2 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2397: // mac cmode=0 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2398: // mac cmode=1 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2399: // mac cmode=2 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2400: // mac cmode=0 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2401: // mac cmode=1 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2402: // mac cmode=2 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2403: // mac cmode=0 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2404: // mac cmode=1 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2405: // mac cmode=2 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2406: // mac cmode=0 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2407: // mac cmode=1 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2408: // mac cmode=2 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2409: // mac cmode=0 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2410: // mac cmode=1 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2411: // mac cmode=2 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2412: // mac cmode=0 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2413: // mac cmode=1 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2414: // mac cmode=2 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2415: // mac cmode=0 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2416: // mac cmode=1 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2417: // mac cmode=2 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2418: // mac cmode=0 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2419: // mac cmode=1 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2420: // mac cmode=2 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2421: // mac cmode=0 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2422: // mac cmode=1 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2423: // mac cmode=2 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2424: // mac cmode=0 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2425: // mac cmode=1 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2426: // mac cmode=2 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2427: // mac cmode=0 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2428: // mac cmode=1 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2429: // mac cmode=2 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2430: // mac cmode=0 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2431: // mac cmode=1 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2432: // mac cmode=2 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2433: // mac cmode=0 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2434: // mac cmode=1 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2435: // mac cmode=2 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2436: // mac cmode=0 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2437: // mac cmode=1 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2438: // mac cmode=2 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2439: // mac cmode=0 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2440: // mac cmode=1 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2441: // mac cmode=2 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2442: // mac cmode=0 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2443: // mac cmode=1 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2444: // mac cmode=2 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2445: // mac cmode=0 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2446: // mac cmode=1 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2447: // mac cmode=2 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2448: // mac cmode=0 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2449: // mac cmode=1 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2450: // mac cmode=2 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2451: // mac cmode=0 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2452: // mac cmode=1 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2453: // mac cmode=2 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2454: // mac cmode=0 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2455: // mac cmode=1 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2456: // mac cmode=2 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2457: // mac cmode=0 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2458: // mac cmode=1 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2459: // mac cmode=2 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2460: // mac cmode=0 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2461: // mac cmode=1 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2462: // mac cmode=2 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2463: // mac cmode=0 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2464: // mac cmode=1 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2465: // mac cmode=2 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2466: // mac cmode=0 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2467: // mac cmode=1 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2468: // mac cmode=2 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2469: // mac cmode=0 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2470: // mac cmode=1 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2471: // mac cmode=2 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2472: // mac cmode=0 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2473: // mac cmode=1 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2474: // mac cmode=2 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2475: // mac cmode=0 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2476: // mac cmode=1 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2477: // mac cmode=2 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2478: // mac cmode=0 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2479: // mac cmode=1 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2480: // mac cmode=2 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2481: // mac cmode=0 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2482: // mac cmode=1 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2483: // mac cmode=2 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2484: // mac cmode=0 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2485: // mac cmode=1 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2486: // mac cmode=2 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2487: // mac cmode=0 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2488: // mac cmode=1 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2489: // mac cmode=2 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2490: // mac cmode=0 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2491: // mac cmode=1 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2492: // mac cmode=2 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2493: // mac cmode=0 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2494: // mac cmode=1 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2495: // mac cmode=2 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2496: // mac cmode=0 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2497: // mac cmode=1 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2498: // mac cmode=2 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  if(d & 0x00800000)
    d |= 0xff000000;
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2499: // mac cmode=0 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2500: // mac cmode=1 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2501: // mac cmode=2 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2502: // mac cmode=0 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2503: // mac cmode=1 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2504: // mac cmode=2 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2505: // mac cmode=0 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2506: // mac cmode=1 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2507: // mac cmode=2 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2508: // mac cmode=0 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2509: // mac cmode=1 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2510: // mac cmode=2 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 15);
  break;

case 2511: // mac cmode=0 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2512: // mac cmode=1 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2513: // mac cmode=2 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2514: // mac cmode=0 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2515: // mac cmode=1 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2516: // mac cmode=2 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2517: // mac cmode=0 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2518: // mac cmode=1 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2519: // mac cmode=2 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2520: // mac cmode=0 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2521: // mac cmode=1 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2522: // mac cmode=2 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 15);
  break;

case 2523: // mac cmode=0 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2524: // mac cmode=1 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2525: // mac cmode=2 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2526: // mac cmode=0 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2527: // mac cmode=1 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2528: // mac cmode=2 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2529: // mac cmode=0 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2530: // mac cmode=1 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2531: // mac cmode=2 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2532: // mac cmode=0 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2533: // mac cmode=1 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2534: // mac cmode=2 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2535: // mac cmode=0 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2536: // mac cmode=1 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2537: // mac cmode=2 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2538: // mac cmode=0 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2539: // mac cmode=1 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2540: // mac cmode=2 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2541: // mac cmode=0 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2542: // mac cmode=1 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2543: // mac cmode=2 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2544: // mac cmode=0 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2545: // mac cmode=1 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2546: // mac cmode=2 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 15);
  break;

case 2547: // mac cmode=0 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2548: // mac cmode=1 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2549: // mac cmode=2 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2550: // mac cmode=0 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2551: // mac cmode=1 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2552: // mac cmode=2 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2553: // mac cmode=0 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2554: // mac cmode=1 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2555: // mac cmode=2 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2556: // mac cmode=0 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2557: // mac cmode=1 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2558: // mac cmode=2 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2559: // mac cmode=0 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2560: // mac cmode=1 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2561: // mac cmode=2 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2562: // mac cmode=0 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2563: // mac cmode=1 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2564: // mac cmode=2 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2565: // mac cmode=0 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2566: // mac cmode=1 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2567: // mac cmode=2 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2568: // mac cmode=0 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2569: // mac cmode=1 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2570: // mac cmode=2 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 15);
  break;

case 2571: // mac cmode=0 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2572: // mac cmode=1 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2573: // mac cmode=2 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2574: // mac cmode=0 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2575: // mac cmode=1 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2576: // mac cmode=2 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2577: // mac cmode=0 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2578: // mac cmode=1 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2579: // mac cmode=2 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2580: // mac cmode=0 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2581: // mac cmode=1 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2582: // mac cmode=2 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2583: // mac cmode=0 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2584: // mac cmode=1 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2585: // mac cmode=2 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2586: // mac cmode=0 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2587: // mac cmode=1 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2588: // mac cmode=2 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2589: // mac cmode=0 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2590: // mac cmode=1 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2591: // mac cmode=2 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2592: // mac cmode=0 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2593: // mac cmode=1 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2594: // mac cmode=2 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 15);
  break;

case 2595: // mpyu cmode=0 dmode=0 crm=0 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2596: // mpyu cmode=1 dmode=0 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2597: // mpyu cmode=2 dmode=0 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2598: // mpyu cmode=0 dmode=1 crm=0 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2599: // mpyu cmode=1 dmode=1 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2600: // mpyu cmode=2 dmode=1 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2601: // mpyu cmode=0 dmode=2 crm=0 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2602: // mpyu cmode=1 dmode=2 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2603: // mpyu cmode=2 dmode=2 crm=0 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2604: // mpyu cmode=0 dmode=0 crm=1 dbp=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2605: // mpyu cmode=1 dmode=0 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2606: // mpyu cmode=2 dmode=0 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2607: // mpyu cmode=0 dmode=1 crm=1 dbp=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2608: // mpyu cmode=1 dmode=1 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2609: // mpyu cmode=2 dmode=1 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2610: // mpyu cmode=0 dmode=2 crm=1 dbp=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2611: // mpyu cmode=1 dmode=2 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2612: // mpyu cmode=2 dmode=2 crm=1 dbp=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2613: // mpyu cmode=0 dmode=0 crm=2 dbp=0
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2614: // mpyu cmode=1 dmode=0 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2615: // mpyu cmode=2 dmode=0 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2616: // mpyu cmode=0 dmode=1 crm=2 dbp=0
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2617: // mpyu cmode=1 dmode=1 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2618: // mpyu cmode=2 dmode=1 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2619: // mpyu cmode=0 dmode=2 crm=2 dbp=0
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2620: // mpyu cmode=1 dmode=2 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2621: // mpyu cmode=2 dmode=2 crm=2 dbp=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2622: // mpyu cmode=0 dmode=0 crm=3 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2623: // mpyu cmode=1 dmode=0 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2624: // mpyu cmode=2 dmode=0 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2625: // mpyu cmode=0 dmode=1 crm=3 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2626: // mpyu cmode=1 dmode=1 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2627: // mpyu cmode=2 dmode=1 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2628: // mpyu cmode=0 dmode=2 crm=3 dbp=0
  s->creg = c = s->cmem[i->param];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2629: // mpyu cmode=1 dmode=2 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2630: // mpyu cmode=2 dmode=2 crm=3 dbp=0
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2631: // mpyu cmode=0 dmode=0 crm=0 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2632: // mpyu cmode=1 dmode=0 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2633: // mpyu cmode=2 dmode=0 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2634: // mpyu cmode=0 dmode=1 crm=0 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2635: // mpyu cmode=1 dmode=1 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2636: // mpyu cmode=2 dmode=1 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2637: // mpyu cmode=0 dmode=2 crm=0 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2638: // mpyu cmode=1 dmode=2 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2639: // mpyu cmode=2 dmode=2 crm=0 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2640: // mpyu cmode=0 dmode=0 crm=1 dbp=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2641: // mpyu cmode=1 dmode=0 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2642: // mpyu cmode=2 dmode=0 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2643: // mpyu cmode=0 dmode=1 crm=1 dbp=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2644: // mpyu cmode=1 dmode=1 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2645: // mpyu cmode=2 dmode=1 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2646: // mpyu cmode=0 dmode=2 crm=1 dbp=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2647: // mpyu cmode=1 dmode=2 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2648: // mpyu cmode=2 dmode=2 crm=1 dbp=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2649: // mpyu cmode=0 dmode=0 crm=2 dbp=1
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2650: // mpyu cmode=1 dmode=0 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2651: // mpyu cmode=2 dmode=0 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2652: // mpyu cmode=0 dmode=1 crm=2 dbp=1
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2653: // mpyu cmode=1 dmode=1 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2654: // mpyu cmode=2 dmode=1 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2655: // mpyu cmode=0 dmode=2 crm=2 dbp=1
  s->creg = c = (s->cmem[i->param] << 16);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2656: // mpyu cmode=1 dmode=2 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca] << 16);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2657: // mpyu cmode=2 dmode=2 crm=2 dbp=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2658: // mpyu cmode=0 dmode=0 crm=3 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2659: // mpyu cmode=1 dmode=0 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2660: // mpyu cmode=2 dmode=0 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2661: // mpyu cmode=0 dmode=1 crm=3 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2662: // mpyu cmode=1 dmode=1 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2663: // mpyu cmode=2 dmode=1 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2664: // mpyu cmode=0 dmode=2 crm=3 dbp=1
  s->creg = c = s->cmem[i->param];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2665: // mpyu cmode=1 dmode=2 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2666: // mpyu cmode=2 dmode=2 crm=3 dbp=1
  s->creg = c = s->cmem[s->ca++];
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = r >> 7;
  break;

case 2667: // macu cmode=0 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2668: // macu cmode=1 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2669: // macu cmode=2 dmode=0 crm=0 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2670: // macu cmode=0 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2671: // macu cmode=1 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2672: // macu cmode=2 dmode=1 crm=0 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2673: // macu cmode=0 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2674: // macu cmode=1 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2675: // macu cmode=2 dmode=2 crm=0 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2676: // macu cmode=0 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2677: // macu cmode=1 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2678: // macu cmode=2 dmode=0 crm=1 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2679: // macu cmode=0 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2680: // macu cmode=1 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2681: // macu cmode=2 dmode=1 crm=1 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2682: // macu cmode=0 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2683: // macu cmode=1 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2684: // macu cmode=2 dmode=2 crm=1 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2685: // macu cmode=0 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2686: // macu cmode=1 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2687: // macu cmode=2 dmode=0 crm=2 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2688: // macu cmode=0 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2689: // macu cmode=1 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2690: // macu cmode=2 dmode=1 crm=2 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2691: // macu cmode=0 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2692: // macu cmode=1 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2693: // macu cmode=2 dmode=2 crm=2 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2694: // macu cmode=0 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2695: // macu cmode=1 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2696: // macu cmode=2 dmode=0 crm=3 dbp=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2697: // macu cmode=0 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2698: // macu cmode=1 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2699: // macu cmode=2 dmode=1 crm=3 dbp=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2700: // macu cmode=0 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2701: // macu cmode=1 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2702: // macu cmode=2 dmode=2 crm=3 dbp=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2703: // macu cmode=0 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2704: // macu cmode=1 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2705: // macu cmode=2 dmode=0 crm=0 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2706: // macu cmode=0 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2707: // macu cmode=1 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2708: // macu cmode=2 dmode=1 crm=0 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2709: // macu cmode=0 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2710: // macu cmode=1 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2711: // macu cmode=2 dmode=2 crm=0 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2712: // macu cmode=0 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2713: // macu cmode=1 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2714: // macu cmode=2 dmode=0 crm=1 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2715: // macu cmode=0 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2716: // macu cmode=1 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2717: // macu cmode=2 dmode=1 crm=1 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2718: // macu cmode=0 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2719: // macu cmode=1 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2720: // macu cmode=2 dmode=2 crm=1 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2721: // macu cmode=0 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2722: // macu cmode=1 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2723: // macu cmode=2 dmode=0 crm=2 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2724: // macu cmode=0 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2725: // macu cmode=1 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2726: // macu cmode=2 dmode=1 crm=2 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2727: // macu cmode=0 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2728: // macu cmode=1 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2729: // macu cmode=2 dmode=2 crm=2 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2730: // macu cmode=0 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2731: // macu cmode=1 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2732: // macu cmode=2 dmode=0 crm=3 dbp=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2733: // macu cmode=0 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2734: // macu cmode=1 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2735: // macu cmode=2 dmode=1 crm=3 dbp=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2736: // macu cmode=0 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2737: // macu cmode=1 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2738: // macu cmode=2 dmode=2 crm=3 dbp=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2739: // macu cmode=0 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2740: // macu cmode=1 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2741: // macu cmode=2 dmode=0 crm=0 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2742: // macu cmode=0 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2743: // macu cmode=1 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2744: // macu cmode=2 dmode=1 crm=0 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2745: // macu cmode=0 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2746: // macu cmode=1 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2747: // macu cmode=2 dmode=2 crm=0 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2748: // macu cmode=0 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2749: // macu cmode=1 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2750: // macu cmode=2 dmode=0 crm=1 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2751: // macu cmode=0 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2752: // macu cmode=1 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2753: // macu cmode=2 dmode=1 crm=1 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2754: // macu cmode=0 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2755: // macu cmode=1 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2756: // macu cmode=2 dmode=2 crm=1 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2757: // macu cmode=0 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2758: // macu cmode=1 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2759: // macu cmode=2 dmode=0 crm=2 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2760: // macu cmode=0 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2761: // macu cmode=1 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2762: // macu cmode=2 dmode=1 crm=2 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2763: // macu cmode=0 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2764: // macu cmode=1 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2765: // macu cmode=2 dmode=2 crm=2 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2766: // macu cmode=0 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2767: // macu cmode=1 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2768: // macu cmode=2 dmode=0 crm=3 dbp=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2769: // macu cmode=0 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2770: // macu cmode=1 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2771: // macu cmode=2 dmode=1 crm=3 dbp=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2772: // macu cmode=0 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2773: // macu cmode=1 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2774: // macu cmode=2 dmode=2 crm=3 dbp=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2775: // macu cmode=0 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2776: // macu cmode=1 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2777: // macu cmode=2 dmode=0 crm=0 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2778: // macu cmode=0 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2779: // macu cmode=1 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2780: // macu cmode=2 dmode=1 crm=0 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2781: // macu cmode=0 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2782: // macu cmode=1 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2783: // macu cmode=2 dmode=2 crm=0 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2784: // macu cmode=0 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2785: // macu cmode=1 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2786: // macu cmode=2 dmode=0 crm=1 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2787: // macu cmode=0 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2788: // macu cmode=1 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2789: // macu cmode=2 dmode=1 crm=1 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2790: // macu cmode=0 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2791: // macu cmode=1 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2792: // macu cmode=2 dmode=2 crm=1 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2793: // macu cmode=0 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2794: // macu cmode=1 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2795: // macu cmode=2 dmode=0 crm=2 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2796: // macu cmode=0 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2797: // macu cmode=1 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2798: // macu cmode=2 dmode=1 crm=2 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2799: // macu cmode=0 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2800: // macu cmode=1 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2801: // macu cmode=2 dmode=2 crm=2 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2802: // macu cmode=0 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2803: // macu cmode=1 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2804: // macu cmode=2 dmode=0 crm=3 dbp=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2805: // macu cmode=0 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2806: // macu cmode=1 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2807: // macu cmode=2 dmode=1 crm=3 dbp=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2808: // macu cmode=0 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2809: // macu cmode=1 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2810: // macu cmode=2 dmode=2 crm=3 dbp=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2811: // macu cmode=0 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2812: // macu cmode=1 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2813: // macu cmode=2 dmode=0 crm=0 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2814: // macu cmode=0 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2815: // macu cmode=1 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2816: // macu cmode=2 dmode=1 crm=0 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2817: // macu cmode=0 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2818: // macu cmode=1 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2819: // macu cmode=2 dmode=2 crm=0 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2820: // macu cmode=0 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2821: // macu cmode=1 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2822: // macu cmode=2 dmode=0 crm=1 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2823: // macu cmode=0 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2824: // macu cmode=1 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2825: // macu cmode=2 dmode=1 crm=1 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2826: // macu cmode=0 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2827: // macu cmode=1 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2828: // macu cmode=2 dmode=2 crm=1 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2829: // macu cmode=0 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2830: // macu cmode=1 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2831: // macu cmode=2 dmode=0 crm=2 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2832: // macu cmode=0 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2833: // macu cmode=1 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2834: // macu cmode=2 dmode=1 crm=2 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2835: // macu cmode=0 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2836: // macu cmode=1 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2837: // macu cmode=2 dmode=2 crm=2 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2838: // macu cmode=0 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2839: // macu cmode=1 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2840: // macu cmode=2 dmode=0 crm=3 dbp=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2841: // macu cmode=0 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2842: // macu cmode=1 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2843: // macu cmode=2 dmode=1 crm=3 dbp=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2844: // macu cmode=0 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2845: // macu cmode=1 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2846: // macu cmode=2 dmode=2 crm=3 dbp=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2847: // macu cmode=0 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2848: // macu cmode=1 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2849: // macu cmode=2 dmode=0 crm=0 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2850: // macu cmode=0 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2851: // macu cmode=1 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2852: // macu cmode=2 dmode=1 crm=0 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2853: // macu cmode=0 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2854: // macu cmode=1 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2855: // macu cmode=2 dmode=2 crm=0 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2856: // macu cmode=0 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2857: // macu cmode=1 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2858: // macu cmode=2 dmode=0 crm=1 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2859: // macu cmode=0 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2860: // macu cmode=1 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2861: // macu cmode=2 dmode=1 crm=1 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2862: // macu cmode=0 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2863: // macu cmode=1 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2864: // macu cmode=2 dmode=2 crm=1 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2865: // macu cmode=0 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2866: // macu cmode=1 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2867: // macu cmode=2 dmode=0 crm=2 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2868: // macu cmode=0 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2869: // macu cmode=1 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2870: // macu cmode=2 dmode=1 crm=2 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2871: // macu cmode=0 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2872: // macu cmode=1 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2873: // macu cmode=2 dmode=2 crm=2 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2874: // macu cmode=0 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2875: // macu cmode=1 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2876: // macu cmode=2 dmode=0 crm=3 dbp=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2877: // macu cmode=0 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2878: // macu cmode=1 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2879: // macu cmode=2 dmode=1 crm=3 dbp=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2880: // macu cmode=0 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2881: // macu cmode=1 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2882: // macu cmode=2 dmode=2 crm=3 dbp=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2883: // macu cmode=0 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2884: // macu cmode=1 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2885: // macu cmode=2 dmode=0 crm=0 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2886: // macu cmode=0 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2887: // macu cmode=1 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2888: // macu cmode=2 dmode=1 crm=0 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2889: // macu cmode=0 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2890: // macu cmode=1 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2891: // macu cmode=2 dmode=2 crm=0 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2892: // macu cmode=0 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2893: // macu cmode=1 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2894: // macu cmode=2 dmode=0 crm=1 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2895: // macu cmode=0 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2896: // macu cmode=1 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2897: // macu cmode=2 dmode=1 crm=1 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2898: // macu cmode=0 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2899: // macu cmode=1 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2900: // macu cmode=2 dmode=2 crm=1 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2901: // macu cmode=0 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2902: // macu cmode=1 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2903: // macu cmode=2 dmode=0 crm=2 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2904: // macu cmode=0 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2905: // macu cmode=1 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2906: // macu cmode=2 dmode=1 crm=2 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2907: // macu cmode=0 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2908: // macu cmode=1 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2909: // macu cmode=2 dmode=2 crm=2 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2910: // macu cmode=0 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2911: // macu cmode=1 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2912: // macu cmode=2 dmode=0 crm=3 dbp=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2913: // macu cmode=0 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2914: // macu cmode=1 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2915: // macu cmode=2 dmode=1 crm=3 dbp=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2916: // macu cmode=0 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2917: // macu cmode=1 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2918: // macu cmode=2 dmode=2 crm=3 dbp=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2919: // macu cmode=0 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2920: // macu cmode=1 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2921: // macu cmode=2 dmode=0 crm=0 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2922: // macu cmode=0 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2923: // macu cmode=1 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2924: // macu cmode=2 dmode=1 crm=0 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2925: // macu cmode=0 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2926: // macu cmode=1 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2927: // macu cmode=2 dmode=2 crm=0 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2928: // macu cmode=0 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2929: // macu cmode=1 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2930: // macu cmode=2 dmode=0 crm=1 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2931: // macu cmode=0 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2932: // macu cmode=1 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2933: // macu cmode=2 dmode=1 crm=1 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2934: // macu cmode=0 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2935: // macu cmode=1 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2936: // macu cmode=2 dmode=2 crm=1 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2937: // macu cmode=0 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2938: // macu cmode=1 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2939: // macu cmode=2 dmode=0 crm=2 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2940: // macu cmode=0 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2941: // macu cmode=1 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2942: // macu cmode=2 dmode=1 crm=2 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2943: // macu cmode=0 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2944: // macu cmode=1 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2945: // macu cmode=2 dmode=2 crm=2 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2946: // macu cmode=0 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2947: // macu cmode=1 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2948: // macu cmode=2 dmode=0 crm=3 dbp=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2949: // macu cmode=0 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2950: // macu cmode=1 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2951: // macu cmode=2 dmode=1 crm=3 dbp=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2952: // macu cmode=0 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2953: // macu cmode=1 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2954: // macu cmode=2 dmode=2 crm=3 dbp=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2955: // macu dmode=0 dbp=0 sfao=0 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2956: // macu dmode=1 dbp=0 sfao=0 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2957: // macu dmode=2 dbp=0 sfao=0 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2958: // macu dmode=0 dbp=1 sfao=0 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2959: // macu dmode=1 dbp=1 sfao=0 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2960: // macu dmode=2 dbp=1 sfao=0 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2961: // macu dmode=0 dbp=0 sfao=1 sfma=0
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2962: // macu dmode=1 dbp=0 sfao=1 sfma=0
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2963: // macu dmode=2 dbp=0 sfao=1 sfma=0
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2964: // macu dmode=0 dbp=1 sfao=1 sfma=0
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2965: // macu dmode=1 dbp=1 sfao=1 sfma=0
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2966: // macu dmode=2 dbp=1 sfao=1 sfma=0
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = s->macc + (r >> 7);
  break;

case 2967: // macu dmode=0 dbp=0 sfao=0 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2968: // macu dmode=1 dbp=0 sfao=0 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2969: // macu dmode=2 dbp=0 sfao=0 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2970: // macu dmode=0 dbp=1 sfao=0 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2971: // macu dmode=1 dbp=1 sfao=0 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2972: // macu dmode=2 dbp=1 sfao=0 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2973: // macu dmode=0 dbp=0 sfao=1 sfma=1
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2974: // macu dmode=1 dbp=0 sfao=1 sfma=1
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2975: // macu dmode=2 dbp=0 sfao=1 sfma=1
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2976: // macu dmode=0 dbp=1 sfao=1 sfma=1
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2977: // macu dmode=1 dbp=1 sfao=1 sfma=1
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2978: // macu dmode=2 dbp=1 sfao=1 sfma=1
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 2) + (r >> 7);
  break;

case 2979: // macu dmode=0 dbp=0 sfao=0 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2980: // macu dmode=1 dbp=0 sfao=0 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2981: // macu dmode=2 dbp=0 sfao=0 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2982: // macu dmode=0 dbp=1 sfao=0 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2983: // macu dmode=1 dbp=1 sfao=0 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2984: // macu dmode=2 dbp=1 sfao=0 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2985: // macu dmode=0 dbp=0 sfao=1 sfma=2
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2986: // macu dmode=1 dbp=0 sfao=1 sfma=2
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2987: // macu dmode=2 dbp=0 sfao=1 sfma=2
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2988: // macu dmode=0 dbp=1 sfao=1 sfma=2
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2989: // macu dmode=1 dbp=1 sfao=1 sfma=2
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2990: // macu dmode=2 dbp=1 sfao=1 sfma=2
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc << 4) + (r >> 7);
  break;

case 2991: // macu dmode=0 dbp=0 sfao=0 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2992: // macu dmode=1 dbp=0 sfao=0 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2993: // macu dmode=2 dbp=0 sfao=0 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2994: // macu dmode=0 dbp=1 sfao=0 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2995: // macu dmode=1 dbp=1 sfao=0 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2996: // macu dmode=2 dbp=1 sfao=0 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = s->aacc;
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2997: // macu dmode=0 dbp=0 sfao=1 sfma=3
  d = s->dmem0[(i->param + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2998: // macu dmode=1 dbp=0 sfao=1 sfma=3
  d = s->dmem0[(s->id + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 2999: // macu dmode=2 dbp=0 sfao=1 sfma=3
  d = s->dmem0[((s->id++) + s->ba0) & 0xff]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 3000: // macu dmode=0 dbp=1 sfao=1 sfma=3
  d = s->dmem1[(i->param + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 3001: // macu dmode=1 dbp=1 sfao=1 sfma=3
  d = s->dmem1[(s->id + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 3002: // macu dmode=2 dbp=1 sfao=1 sfma=3
  d = s->dmem1[((s->id++) + s->ba1) & 0x1f]; // d is 24bits unsigned
  s->creg = c = (s->aacc << 7);
  r = (INT64)(INT32)c * (INT64)d;
  s->macc = (s->macc >> 16) + (r >> 7);
  break;

case 3003: // macs cmode=0 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3004: // macs cmode=1 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3005: // macs cmode=2 crm=0 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3006: // macs cmode=0 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3007: // macs cmode=1 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3008: // macs cmode=2 crm=1 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3009: // macs cmode=0 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3010: // macs cmode=1 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3011: // macs cmode=2 crm=2 sfao=0 sfma=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3012: // macs cmode=0 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3013: // macs cmode=1 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3014: // macs cmode=2 crm=3 sfao=0 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = s->macc + (r >> 14);
  break;

case 3015: // macs cmode=0 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3016: // macs cmode=1 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3017: // macs cmode=2 crm=0 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3018: // macs cmode=0 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3019: // macs cmode=1 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3020: // macs cmode=2 crm=1 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3021: // macs cmode=0 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3022: // macs cmode=1 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3023: // macs cmode=2 crm=2 sfao=1 sfma=0
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3024: // macs cmode=0 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3025: // macs cmode=1 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3026: // macs cmode=2 crm=3 sfao=1 sfma=0
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = s->macc + (r >> 14);
  break;

case 3027: // macs cmode=0 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3028: // macs cmode=1 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3029: // macs cmode=2 crm=0 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3030: // macs cmode=0 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3031: // macs cmode=1 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3032: // macs cmode=2 crm=1 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3033: // macs cmode=0 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3034: // macs cmode=1 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3035: // macs cmode=2 crm=2 sfao=0 sfma=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3036: // macs cmode=0 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3037: // macs cmode=1 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3038: // macs cmode=2 crm=3 sfao=0 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3039: // macs cmode=0 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3040: // macs cmode=1 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3041: // macs cmode=2 crm=0 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3042: // macs cmode=0 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3043: // macs cmode=1 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3044: // macs cmode=2 crm=1 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3045: // macs cmode=0 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3046: // macs cmode=1 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3047: // macs cmode=2 crm=2 sfao=1 sfma=1
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3048: // macs cmode=0 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3049: // macs cmode=1 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3050: // macs cmode=2 crm=3 sfao=1 sfma=1
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 2) + (r >> 14);
  break;

case 3051: // macs cmode=0 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3052: // macs cmode=1 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3053: // macs cmode=2 crm=0 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3054: // macs cmode=0 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3055: // macs cmode=1 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3056: // macs cmode=2 crm=1 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3057: // macs cmode=0 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3058: // macs cmode=1 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3059: // macs cmode=2 crm=2 sfao=0 sfma=2
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3060: // macs cmode=0 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3061: // macs cmode=1 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3062: // macs cmode=2 crm=3 sfao=0 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3063: // macs cmode=0 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3064: // macs cmode=1 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3065: // macs cmode=2 crm=0 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3066: // macs cmode=0 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3067: // macs cmode=1 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3068: // macs cmode=2 crm=1 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3069: // macs cmode=0 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3070: // macs cmode=1 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3071: // macs cmode=2 crm=2 sfao=1 sfma=2
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3072: // macs cmode=0 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3073: // macs cmode=1 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3074: // macs cmode=2 crm=3 sfao=1 sfma=2
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc << 4) + (r >> 14);
  break;

case 3075: // macs cmode=0 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3076: // macs cmode=1 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3077: // macs cmode=2 crm=0 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3078: // macs cmode=0 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3079: // macs cmode=1 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3080: // macs cmode=2 crm=1 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3081: // macs cmode=0 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3082: // macs cmode=1 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3083: // macs cmode=2 crm=2 sfao=0 sfma=3
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3084: // macs cmode=0 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3085: // macs cmode=1 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3086: // macs cmode=2 crm=3 sfao=0 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)s->aacc;
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3087: // macs cmode=0 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3088: // macs cmode=1 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3089: // macs cmode=2 crm=0 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3090: // macs cmode=0 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[i->param] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3091: // macs cmode=1 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3092: // macs cmode=2 crm=1 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca++] & 0xffff0000);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3093: // macs cmode=0 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[i->param] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3094: // macs cmode=1 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3095: // macs cmode=2 crm=2 sfao=1 sfma=3
  s->creg = c = (s->cmem[s->ca++] << 16);
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3096: // macs cmode=0 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[i->param];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3097: // macs cmode=1 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3098: // macs cmode=2 crm=3 sfao=1 sfma=3
  s->creg = c = s->cmem[s->ca++];
  r = (INT64)(INT32)c * (INT64)(INT32)(s->aacc << 7);
  s->macc = (s->macc >> 16) + (r >> 14);
  break;

case 3099: // lmhd dmode=0 dbp=0
  s->macc = ((INT64)(INT32)(s->dmem0[(i->param + s->ba0) & 0xff] << 8)) << 16;
  break;

case 3100: // lmhd dmode=1 dbp=0
  s->macc = ((INT64)(INT32)(s->dmem0[(s->id + s->ba0) & 0xff] << 8)) << 16;
  break;

case 3101: // lmhd dmode=2 dbp=0
  s->macc = ((INT64)(INT32)(s->dmem0[((s->id++) + s->ba0) & 0xff] << 8)) << 16;
  break;

case 3102: // lmhd dmode=0 dbp=1
  s->macc = ((INT64)(INT32)(s->dmem1[(i->param + s->ba1) & 0x1f] << 8)) << 16;
  break;

case 3103: // lmhd dmode=1 dbp=1
  s->macc = ((INT64)(INT32)(s->dmem1[(s->id + s->ba1) & 0x1f] << 8)) << 16;
  break;

case 3104: // lmhd dmode=2 dbp=1
  s->macc = ((INT64)(INT32)(s->dmem1[((s->id++) + s->ba1) & 0x1f] << 8)) << 16;
  break;

case 3105: // lmld dmode=0 dbp=0
  s->macc = (s->macc & ~0xffffffULL) | s->dmem0[(i->param + s->ba0) & 0xff];
  break;

case 3106: // lmld dmode=1 dbp=0
  s->macc = (s->macc & ~0xffffffULL) | s->dmem0[(s->id + s->ba0) & 0xff];
  break;

case 3107: // lmld dmode=2 dbp=0
  s->macc = (s->macc & ~0xffffffULL) | s->dmem0[((s->id++) + s->ba0) & 0xff];
  break;

case 3108: // lmld dmode=0 dbp=1
  s->macc = (s->macc & ~0xffffffULL) | s->dmem1[(i->param + s->ba1) & 0x1f];
  break;

case 3109: // lmld dmode=1 dbp=1
  s->macc = (s->macc & ~0xffffffULL) | s->dmem1[(s->id + s->ba1) & 0x1f];
  break;

case 3110: // lmld dmode=2 dbp=1
  s->macc = (s->macc & ~0xffffffULL) | s->dmem1[((s->id++) + s->ba1) & 0x1f];
  break;

case 3111: // lmhc cmode=0 crm=0
  s->macc = ((INT64)(INT32)s->cmem[i->param]) << 16;
  break;

case 3112: // lmhc cmode=1 crm=0
  s->macc = ((INT64)(INT32)s->cmem[s->ca]) << 16;
  break;

case 3113: // lmhc cmode=2 crm=0
  s->macc = ((INT64)(INT32)s->cmem[s->ca++]) << 16;
  break;

case 3114: // lmhc cmode=0 crm=1
  s->macc = ((INT64)(INT32)(s->cmem[i->param] & 0xffff0000)) << 16;
  break;

case 3115: // lmhc cmode=1 crm=1
  s->macc = ((INT64)(INT32)(s->cmem[s->ca] & 0xffff0000)) << 16;
  break;

case 3116: // lmhc cmode=2 crm=1
  s->macc = ((INT64)(INT32)(s->cmem[s->ca++] & 0xffff0000)) << 16;
  break;

case 3117: // lmhc cmode=0 crm=2
  s->macc = ((INT64)(INT32)(s->cmem[i->param] << 16)) << 16;
  break;

case 3118: // lmhc cmode=1 crm=2
  s->macc = ((INT64)(INT32)(s->cmem[s->ca] << 16)) << 16;
  break;

case 3119: // lmhc cmode=2 crm=2
  s->macc = ((INT64)(INT32)(s->cmem[s->ca++] << 16)) << 16;
  break;

case 3120: // lmhc cmode=0 crm=3
  s->macc = ((INT64)(INT32)s->cmem[i->param]) << 16;
  break;

case 3121: // lmhc cmode=1 crm=3
  s->macc = ((INT64)(INT32)s->cmem[s->ca]) << 16;
  break;

case 3122: // lmhc cmode=2 crm=3
  s->macc = ((INT64)(INT32)s->cmem[s->ca++]) << 16;
  break;

case 3123: // sfml
  s->macc = (s->macc & 0x8000000000000ULL) | ((s->macc << 1) & 0x7ffffffffffffULL);
  break;

case 3124: // wre cmode=0 dmode=0 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3125: // wre cmode=1 dmode=0 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3126: // wre cmode=2 dmode=0 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3127: // wre cmode=0 dmode=1 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3128: // wre cmode=1 dmode=1 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3129: // wre cmode=2 dmode=1 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3130: // wre cmode=0 dmode=2 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3131: // wre cmode=1 dmode=2 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3132: // wre cmode=2 dmode=2 crm=0 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3133: // wre cmode=0 dmode=0 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3134: // wre cmode=1 dmode=0 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3135: // wre cmode=2 dmode=0 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3136: // wre cmode=0 dmode=1 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3137: // wre cmode=1 dmode=1 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3138: // wre cmode=2 dmode=1 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3139: // wre cmode=0 dmode=2 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3140: // wre cmode=1 dmode=2 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3141: // wre cmode=2 dmode=2 crm=1 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3142: // wre cmode=0 dmode=0 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3143: // wre cmode=1 dmode=0 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3144: // wre cmode=2 dmode=0 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3145: // wre cmode=0 dmode=1 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3146: // wre cmode=1 dmode=1 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3147: // wre cmode=2 dmode=1 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3148: // wre cmode=0 dmode=2 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3149: // wre cmode=1 dmode=2 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3150: // wre cmode=2 dmode=2 crm=2 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3151: // wre cmode=0 dmode=0 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3152: // wre cmode=1 dmode=0 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3153: // wre cmode=2 dmode=0 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(i->param + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3154: // wre cmode=0 dmode=1 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3155: // wre cmode=1 dmode=1 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3156: // wre cmode=2 dmode=1 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[(s->id + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3157: // wre cmode=0 dmode=2 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3158: // wre cmode=1 dmode=2 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3159: // wre cmode=2 dmode=2 crm=3 dbp=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem0[((s->id++) + s->ba0) & 0xff];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3160: // wre cmode=0 dmode=0 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3161: // wre cmode=1 dmode=0 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3162: // wre cmode=2 dmode=0 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3163: // wre cmode=0 dmode=1 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3164: // wre cmode=1 dmode=1 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3165: // wre cmode=2 dmode=1 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3166: // wre cmode=0 dmode=2 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3167: // wre cmode=1 dmode=2 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3168: // wre cmode=2 dmode=2 crm=0 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3169: // wre cmode=0 dmode=0 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3170: // wre cmode=1 dmode=0 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3171: // wre cmode=2 dmode=0 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3172: // wre cmode=0 dmode=1 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3173: // wre cmode=1 dmode=1 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3174: // wre cmode=2 dmode=1 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3175: // wre cmode=0 dmode=2 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3176: // wre cmode=1 dmode=2 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3177: // wre cmode=2 dmode=2 crm=1 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3178: // wre cmode=0 dmode=0 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3179: // wre cmode=1 dmode=0 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3180: // wre cmode=2 dmode=0 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3181: // wre cmode=0 dmode=1 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3182: // wre cmode=1 dmode=1 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3183: // wre cmode=2 dmode=1 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3184: // wre cmode=0 dmode=2 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3185: // wre cmode=1 dmode=2 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3186: // wre cmode=2 dmode=2 crm=2 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3187: // wre cmode=0 dmode=0 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3188: // wre cmode=1 dmode=0 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3189: // wre cmode=2 dmode=0 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(i->param + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3190: // wre cmode=0 dmode=1 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3191: // wre cmode=1 dmode=1 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3192: // wre cmode=2 dmode=1 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[(s->id + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3193: // wre cmode=0 dmode=2 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3194: // wre cmode=1 dmode=2 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3195: // wre cmode=2 dmode=2 crm=3 dbp=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xwr = s->dmem1[((s->id++) + s->ba1) & 0x1f];
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_WRITE;
  break;

case 3196: // rde cmode=0 crm=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3197: // rde cmode=1 crm=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3198: // rde cmode=2 crm=0
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3199: // rde cmode=0 crm=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[i->param] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3200: // rde cmode=1 crm=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[s->ca] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3201: // rde cmode=2 crm=1
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[s->ca++] & 0xffff0000);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3202: // rde cmode=0 crm=2
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[i->param] << 16);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3203: // rde cmode=1 crm=2
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[s->ca] << 16);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3204: // rde cmode=2 crm=2
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = (s->cmem[s->ca++] << 16);
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3205: // rde cmode=0 crm=3
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[i->param];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3206: // rde cmode=1 crm=3
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[s->ca];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3207: // rde cmode=2 crm=3
  if(s->sti & (S_READ|S_WRITE))
    break;
  s->xoa = s->cmem[s->ca++];
  tms57002_xm_init(s);
  s->sti |= S_READ;
  break;

case 3208: // sacc cmode=0 sfao=0
  s->cmem[i->param] = s->aacc;
  break;

case 3209: // sacc cmode=1 sfao=0
  s->cmem[s->ca] = s->aacc;
  break;

case 3210: // sacc cmode=2 sfao=0
  s->cmem[s->ca++] = s->aacc;
  break;

case 3211: // sacc cmode=0 sfao=1
  s->cmem[i->param] = (s->aacc << 7);
  break;

case 3212: // sacc cmode=1 sfao=1
  s->cmem[s->ca] = (s->aacc << 7);
  break;

case 3213: // sacc cmode=2 sfao=1
  s->cmem[s->ca++] = (s->aacc << 7);
  break;

case 3214: // sacd dmode=0 dbp=0 sfao=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->aacc >> 8;
  break;

case 3215: // sacd dmode=1 dbp=0 sfao=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->aacc >> 8;
  break;

case 3216: // sacd dmode=2 dbp=0 sfao=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->aacc >> 8;
  break;

case 3217: // sacd dmode=0 dbp=1 sfao=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->aacc >> 8;
  break;

case 3218: // sacd dmode=1 dbp=1 sfao=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->aacc >> 8;
  break;

case 3219: // sacd dmode=2 dbp=1 sfao=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->aacc >> 8;
  break;

case 3220: // sacd dmode=0 dbp=0 sfao=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (s->aacc << 7) >> 8;
  break;

case 3221: // sacd dmode=1 dbp=0 sfao=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (s->aacc << 7) >> 8;
  break;

case 3222: // sacd dmode=2 dbp=0 sfao=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (s->aacc << 7) >> 8;
  break;

case 3223: // sacd dmode=0 dbp=1 sfao=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (s->aacc << 7) >> 8;
  break;

case 3224: // sacd dmode=1 dbp=1 sfao=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (s->aacc << 7) >> 8;
  break;

case 3225: // sacd dmode=2 dbp=1 sfao=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (s->aacc << 7) >> 8;
  break;

case 3226: // smhd dmode=0 dbp=0 sfmo=0 rnd=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3227: // smhd dmode=1 dbp=0 sfmo=0 rnd=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3228: // smhd dmode=2 dbp=0 sfmo=0 rnd=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3229: // smhd dmode=0 dbp=1 sfmo=0 rnd=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3230: // smhd dmode=1 dbp=1 sfmo=0 rnd=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3231: // smhd dmode=2 dbp=1 sfmo=0 rnd=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3232: // smhd dmode=0 dbp=0 sfmo=1 rnd=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3233: // smhd dmode=1 dbp=0 sfmo=1 rnd=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3234: // smhd dmode=2 dbp=0 sfmo=1 rnd=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3235: // smhd dmode=0 dbp=1 sfmo=1 rnd=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3236: // smhd dmode=1 dbp=1 sfmo=1 rnd=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3237: // smhd dmode=2 dbp=1 sfmo=1 rnd=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3238: // smhd dmode=0 dbp=0 sfmo=2 rnd=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3239: // smhd dmode=1 dbp=0 sfmo=2 rnd=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3240: // smhd dmode=2 dbp=0 sfmo=2 rnd=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3241: // smhd dmode=0 dbp=1 sfmo=2 rnd=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3242: // smhd dmode=1 dbp=1 sfmo=2 rnd=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3243: // smhd dmode=2 dbp=1 sfmo=2 rnd=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3244: // smhd dmode=0 dbp=0 sfmo=3 rnd=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3245: // smhd dmode=1 dbp=0 sfmo=3 rnd=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3246: // smhd dmode=2 dbp=0 sfmo=3 rnd=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3247: // smhd dmode=0 dbp=1 sfmo=3 rnd=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3248: // smhd dmode=1 dbp=1 sfmo=3 rnd=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3249: // smhd dmode=2 dbp=1 sfmo=3 rnd=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3250: // smhd dmode=0 dbp=0 sfmo=0 rnd=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3251: // smhd dmode=1 dbp=0 sfmo=0 rnd=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3252: // smhd dmode=2 dbp=0 sfmo=0 rnd=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3253: // smhd dmode=0 dbp=1 sfmo=0 rnd=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3254: // smhd dmode=1 dbp=1 sfmo=0 rnd=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3255: // smhd dmode=2 dbp=1 sfmo=0 rnd=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3256: // smhd dmode=0 dbp=0 sfmo=1 rnd=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3257: // smhd dmode=1 dbp=0 sfmo=1 rnd=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3258: // smhd dmode=2 dbp=0 sfmo=1 rnd=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3259: // smhd dmode=0 dbp=1 sfmo=1 rnd=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3260: // smhd dmode=1 dbp=1 sfmo=1 rnd=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3261: // smhd dmode=2 dbp=1 sfmo=1 rnd=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3262: // smhd dmode=0 dbp=0 sfmo=2 rnd=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3263: // smhd dmode=1 dbp=0 sfmo=2 rnd=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3264: // smhd dmode=2 dbp=0 sfmo=2 rnd=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3265: // smhd dmode=0 dbp=1 sfmo=2 rnd=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3266: // smhd dmode=1 dbp=1 sfmo=2 rnd=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3267: // smhd dmode=2 dbp=1 sfmo=2 rnd=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3268: // smhd dmode=0 dbp=0 sfmo=3 rnd=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3269: // smhd dmode=1 dbp=0 sfmo=3 rnd=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3270: // smhd dmode=2 dbp=0 sfmo=3 rnd=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3271: // smhd dmode=0 dbp=1 sfmo=3 rnd=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3272: // smhd dmode=1 dbp=1 sfmo=3 rnd=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3273: // smhd dmode=2 dbp=1 sfmo=3 rnd=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3274: // smhd dmode=0 dbp=0 sfmo=0 rnd=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3275: // smhd dmode=1 dbp=0 sfmo=0 rnd=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3276: // smhd dmode=2 dbp=0 sfmo=0 rnd=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3277: // smhd dmode=0 dbp=1 sfmo=0 rnd=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3278: // smhd dmode=1 dbp=1 sfmo=0 rnd=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3279: // smhd dmode=2 dbp=1 sfmo=0 rnd=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3280: // smhd dmode=0 dbp=0 sfmo=1 rnd=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3281: // smhd dmode=1 dbp=0 sfmo=1 rnd=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3282: // smhd dmode=2 dbp=0 sfmo=1 rnd=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3283: // smhd dmode=0 dbp=1 sfmo=1 rnd=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3284: // smhd dmode=1 dbp=1 sfmo=1 rnd=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3285: // smhd dmode=2 dbp=1 sfmo=1 rnd=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3286: // smhd dmode=0 dbp=0 sfmo=2 rnd=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3287: // smhd dmode=1 dbp=0 sfmo=2 rnd=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3288: // smhd dmode=2 dbp=0 sfmo=2 rnd=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3289: // smhd dmode=0 dbp=1 sfmo=2 rnd=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3290: // smhd dmode=1 dbp=1 sfmo=2 rnd=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3291: // smhd dmode=2 dbp=1 sfmo=2 rnd=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3292: // smhd dmode=0 dbp=0 sfmo=3 rnd=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3293: // smhd dmode=1 dbp=0 sfmo=3 rnd=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3294: // smhd dmode=2 dbp=0 sfmo=3 rnd=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3295: // smhd dmode=0 dbp=1 sfmo=3 rnd=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3296: // smhd dmode=1 dbp=1 sfmo=3 rnd=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3297: // smhd dmode=2 dbp=1 sfmo=3 rnd=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3298: // smhd dmode=0 dbp=0 sfmo=0 rnd=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3299: // smhd dmode=1 dbp=0 sfmo=0 rnd=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3300: // smhd dmode=2 dbp=0 sfmo=0 rnd=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3301: // smhd dmode=0 dbp=1 sfmo=0 rnd=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3302: // smhd dmode=1 dbp=1 sfmo=0 rnd=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3303: // smhd dmode=2 dbp=1 sfmo=0 rnd=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3304: // smhd dmode=0 dbp=0 sfmo=1 rnd=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3305: // smhd dmode=1 dbp=0 sfmo=1 rnd=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3306: // smhd dmode=2 dbp=0 sfmo=1 rnd=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3307: // smhd dmode=0 dbp=1 sfmo=1 rnd=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3308: // smhd dmode=1 dbp=1 sfmo=1 rnd=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3309: // smhd dmode=2 dbp=1 sfmo=1 rnd=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3310: // smhd dmode=0 dbp=0 sfmo=2 rnd=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3311: // smhd dmode=1 dbp=0 sfmo=2 rnd=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3312: // smhd dmode=2 dbp=0 sfmo=2 rnd=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3313: // smhd dmode=0 dbp=1 sfmo=2 rnd=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3314: // smhd dmode=1 dbp=1 sfmo=2 rnd=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3315: // smhd dmode=2 dbp=1 sfmo=2 rnd=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3316: // smhd dmode=0 dbp=0 sfmo=3 rnd=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3317: // smhd dmode=1 dbp=0 sfmo=3 rnd=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3318: // smhd dmode=2 dbp=0 sfmo=3 rnd=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3319: // smhd dmode=0 dbp=1 sfmo=3 rnd=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3320: // smhd dmode=1 dbp=1 sfmo=3 rnd=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3321: // smhd dmode=2 dbp=1 sfmo=3 rnd=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3322: // smhd dmode=0 dbp=0 sfmo=0 rnd=4 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3323: // smhd dmode=1 dbp=0 sfmo=0 rnd=4 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3324: // smhd dmode=2 dbp=0 sfmo=0 rnd=4 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3325: // smhd dmode=0 dbp=1 sfmo=0 rnd=4 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3326: // smhd dmode=1 dbp=1 sfmo=0 rnd=4 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3327: // smhd dmode=2 dbp=1 sfmo=0 rnd=4 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3328: // smhd dmode=0 dbp=0 sfmo=1 rnd=4 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3329: // smhd dmode=1 dbp=0 sfmo=1 rnd=4 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3330: // smhd dmode=2 dbp=0 sfmo=1 rnd=4 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3331: // smhd dmode=0 dbp=1 sfmo=1 rnd=4 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3332: // smhd dmode=1 dbp=1 sfmo=1 rnd=4 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3333: // smhd dmode=2 dbp=1 sfmo=1 rnd=4 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3334: // smhd dmode=0 dbp=0 sfmo=2 rnd=4 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3335: // smhd dmode=1 dbp=0 sfmo=2 rnd=4 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3336: // smhd dmode=2 dbp=0 sfmo=2 rnd=4 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3337: // smhd dmode=0 dbp=1 sfmo=2 rnd=4 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3338: // smhd dmode=1 dbp=1 sfmo=2 rnd=4 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3339: // smhd dmode=2 dbp=1 sfmo=2 rnd=4 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3340: // smhd dmode=0 dbp=0 sfmo=3 rnd=4 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3341: // smhd dmode=1 dbp=0 sfmo=3 rnd=4 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3342: // smhd dmode=2 dbp=0 sfmo=3 rnd=4 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3343: // smhd dmode=0 dbp=1 sfmo=3 rnd=4 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3344: // smhd dmode=1 dbp=1 sfmo=3 rnd=4 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3345: // smhd dmode=2 dbp=1 sfmo=3 rnd=4 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3346: // smhd dmode=0 dbp=0 sfmo=0 rnd=5 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3347: // smhd dmode=1 dbp=0 sfmo=0 rnd=5 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3348: // smhd dmode=2 dbp=0 sfmo=0 rnd=5 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3349: // smhd dmode=0 dbp=1 sfmo=0 rnd=5 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3350: // smhd dmode=1 dbp=1 sfmo=0 rnd=5 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3351: // smhd dmode=2 dbp=1 sfmo=0 rnd=5 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3352: // smhd dmode=0 dbp=0 sfmo=1 rnd=5 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3353: // smhd dmode=1 dbp=0 sfmo=1 rnd=5 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3354: // smhd dmode=2 dbp=0 sfmo=1 rnd=5 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3355: // smhd dmode=0 dbp=1 sfmo=1 rnd=5 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3356: // smhd dmode=1 dbp=1 sfmo=1 rnd=5 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3357: // smhd dmode=2 dbp=1 sfmo=1 rnd=5 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3358: // smhd dmode=0 dbp=0 sfmo=2 rnd=5 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3359: // smhd dmode=1 dbp=0 sfmo=2 rnd=5 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3360: // smhd dmode=2 dbp=0 sfmo=2 rnd=5 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3361: // smhd dmode=0 dbp=1 sfmo=2 rnd=5 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3362: // smhd dmode=1 dbp=1 sfmo=2 rnd=5 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3363: // smhd dmode=2 dbp=1 sfmo=2 rnd=5 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3364: // smhd dmode=0 dbp=0 sfmo=3 rnd=5 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3365: // smhd dmode=1 dbp=0 sfmo=3 rnd=5 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3366: // smhd dmode=2 dbp=0 sfmo=3 rnd=5 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3367: // smhd dmode=0 dbp=1 sfmo=3 rnd=5 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3368: // smhd dmode=1 dbp=1 sfmo=3 rnd=5 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3369: // smhd dmode=2 dbp=1 sfmo=3 rnd=5 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3370: // smhd dmode=0 dbp=0 sfmo=0 rnd=6 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3371: // smhd dmode=1 dbp=0 sfmo=0 rnd=6 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3372: // smhd dmode=2 dbp=0 sfmo=0 rnd=6 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3373: // smhd dmode=0 dbp=1 sfmo=0 rnd=6 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3374: // smhd dmode=1 dbp=1 sfmo=0 rnd=6 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3375: // smhd dmode=2 dbp=1 sfmo=0 rnd=6 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3376: // smhd dmode=0 dbp=0 sfmo=1 rnd=6 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3377: // smhd dmode=1 dbp=0 sfmo=1 rnd=6 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3378: // smhd dmode=2 dbp=0 sfmo=1 rnd=6 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3379: // smhd dmode=0 dbp=1 sfmo=1 rnd=6 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3380: // smhd dmode=1 dbp=1 sfmo=1 rnd=6 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3381: // smhd dmode=2 dbp=1 sfmo=1 rnd=6 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3382: // smhd dmode=0 dbp=0 sfmo=2 rnd=6 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3383: // smhd dmode=1 dbp=0 sfmo=2 rnd=6 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3384: // smhd dmode=2 dbp=0 sfmo=2 rnd=6 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3385: // smhd dmode=0 dbp=1 sfmo=2 rnd=6 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3386: // smhd dmode=1 dbp=1 sfmo=2 rnd=6 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3387: // smhd dmode=2 dbp=1 sfmo=2 rnd=6 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3388: // smhd dmode=0 dbp=0 sfmo=3 rnd=6 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3389: // smhd dmode=1 dbp=0 sfmo=3 rnd=6 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3390: // smhd dmode=2 dbp=0 sfmo=3 rnd=6 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3391: // smhd dmode=0 dbp=1 sfmo=3 rnd=6 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3392: // smhd dmode=1 dbp=1 sfmo=3 rnd=6 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3393: // smhd dmode=2 dbp=1 sfmo=3 rnd=6 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3394: // smhd dmode=0 dbp=0 sfmo=0 rnd=7 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3395: // smhd dmode=1 dbp=0 sfmo=0 rnd=7 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3396: // smhd dmode=2 dbp=0 sfmo=0 rnd=7 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3397: // smhd dmode=0 dbp=1 sfmo=0 rnd=7 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3398: // smhd dmode=1 dbp=1 sfmo=0 rnd=7 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3399: // smhd dmode=2 dbp=1 sfmo=0 rnd=7 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3400: // smhd dmode=0 dbp=0 sfmo=1 rnd=7 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3401: // smhd dmode=1 dbp=0 sfmo=1 rnd=7 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3402: // smhd dmode=2 dbp=0 sfmo=1 rnd=7 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3403: // smhd dmode=0 dbp=1 sfmo=1 rnd=7 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3404: // smhd dmode=1 dbp=1 sfmo=1 rnd=7 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3405: // smhd dmode=2 dbp=1 sfmo=1 rnd=7 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3406: // smhd dmode=0 dbp=0 sfmo=2 rnd=7 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3407: // smhd dmode=1 dbp=0 sfmo=2 rnd=7 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3408: // smhd dmode=2 dbp=0 sfmo=2 rnd=7 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3409: // smhd dmode=0 dbp=1 sfmo=2 rnd=7 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3410: // smhd dmode=1 dbp=1 sfmo=2 rnd=7 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3411: // smhd dmode=2 dbp=1 sfmo=2 rnd=7 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3412: // smhd dmode=0 dbp=0 sfmo=3 rnd=7 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3413: // smhd dmode=1 dbp=0 sfmo=3 rnd=7 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3414: // smhd dmode=2 dbp=0 sfmo=3 rnd=7 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3415: // smhd dmode=0 dbp=1 sfmo=3 rnd=7 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3416: // smhd dmode=1 dbp=1 sfmo=3 rnd=7 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3417: // smhd dmode=2 dbp=1 sfmo=3 rnd=7 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3418: // smhd dmode=0 dbp=0 sfmo=0 rnd=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3419: // smhd dmode=1 dbp=0 sfmo=0 rnd=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3420: // smhd dmode=2 dbp=0 sfmo=0 rnd=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3421: // smhd dmode=0 dbp=1 sfmo=0 rnd=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3422: // smhd dmode=1 dbp=1 sfmo=0 rnd=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3423: // smhd dmode=2 dbp=1 sfmo=0 rnd=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3424: // smhd dmode=0 dbp=0 sfmo=1 rnd=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3425: // smhd dmode=1 dbp=0 sfmo=1 rnd=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3426: // smhd dmode=2 dbp=0 sfmo=1 rnd=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3427: // smhd dmode=0 dbp=1 sfmo=1 rnd=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3428: // smhd dmode=1 dbp=1 sfmo=1 rnd=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3429: // smhd dmode=2 dbp=1 sfmo=1 rnd=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3430: // smhd dmode=0 dbp=0 sfmo=2 rnd=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3431: // smhd dmode=1 dbp=0 sfmo=2 rnd=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3432: // smhd dmode=2 dbp=0 sfmo=2 rnd=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3433: // smhd dmode=0 dbp=1 sfmo=2 rnd=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3434: // smhd dmode=1 dbp=1 sfmo=2 rnd=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3435: // smhd dmode=2 dbp=1 sfmo=2 rnd=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3436: // smhd dmode=0 dbp=0 sfmo=3 rnd=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3437: // smhd dmode=1 dbp=0 sfmo=3 rnd=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3438: // smhd dmode=2 dbp=0 sfmo=3 rnd=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3439: // smhd dmode=0 dbp=1 sfmo=3 rnd=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3440: // smhd dmode=1 dbp=1 sfmo=3 rnd=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3441: // smhd dmode=2 dbp=1 sfmo=3 rnd=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3442: // smhd dmode=0 dbp=0 sfmo=0 rnd=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3443: // smhd dmode=1 dbp=0 sfmo=0 rnd=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3444: // smhd dmode=2 dbp=0 sfmo=0 rnd=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3445: // smhd dmode=0 dbp=1 sfmo=0 rnd=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3446: // smhd dmode=1 dbp=1 sfmo=0 rnd=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3447: // smhd dmode=2 dbp=1 sfmo=0 rnd=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3448: // smhd dmode=0 dbp=0 sfmo=1 rnd=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3449: // smhd dmode=1 dbp=0 sfmo=1 rnd=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3450: // smhd dmode=2 dbp=0 sfmo=1 rnd=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3451: // smhd dmode=0 dbp=1 sfmo=1 rnd=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3452: // smhd dmode=1 dbp=1 sfmo=1 rnd=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3453: // smhd dmode=2 dbp=1 sfmo=1 rnd=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3454: // smhd dmode=0 dbp=0 sfmo=2 rnd=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3455: // smhd dmode=1 dbp=0 sfmo=2 rnd=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3456: // smhd dmode=2 dbp=0 sfmo=2 rnd=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3457: // smhd dmode=0 dbp=1 sfmo=2 rnd=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3458: // smhd dmode=1 dbp=1 sfmo=2 rnd=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3459: // smhd dmode=2 dbp=1 sfmo=2 rnd=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3460: // smhd dmode=0 dbp=0 sfmo=3 rnd=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3461: // smhd dmode=1 dbp=0 sfmo=3 rnd=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3462: // smhd dmode=2 dbp=0 sfmo=3 rnd=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3463: // smhd dmode=0 dbp=1 sfmo=3 rnd=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3464: // smhd dmode=1 dbp=1 sfmo=3 rnd=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3465: // smhd dmode=2 dbp=1 sfmo=3 rnd=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3466: // smhd dmode=0 dbp=0 sfmo=0 rnd=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3467: // smhd dmode=1 dbp=0 sfmo=0 rnd=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3468: // smhd dmode=2 dbp=0 sfmo=0 rnd=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3469: // smhd dmode=0 dbp=1 sfmo=0 rnd=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3470: // smhd dmode=1 dbp=1 sfmo=0 rnd=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3471: // smhd dmode=2 dbp=1 sfmo=0 rnd=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3472: // smhd dmode=0 dbp=0 sfmo=1 rnd=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3473: // smhd dmode=1 dbp=0 sfmo=1 rnd=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3474: // smhd dmode=2 dbp=0 sfmo=1 rnd=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3475: // smhd dmode=0 dbp=1 sfmo=1 rnd=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3476: // smhd dmode=1 dbp=1 sfmo=1 rnd=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3477: // smhd dmode=2 dbp=1 sfmo=1 rnd=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3478: // smhd dmode=0 dbp=0 sfmo=2 rnd=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3479: // smhd dmode=1 dbp=0 sfmo=2 rnd=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3480: // smhd dmode=2 dbp=0 sfmo=2 rnd=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3481: // smhd dmode=0 dbp=1 sfmo=2 rnd=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3482: // smhd dmode=1 dbp=1 sfmo=2 rnd=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3483: // smhd dmode=2 dbp=1 sfmo=2 rnd=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3484: // smhd dmode=0 dbp=0 sfmo=3 rnd=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3485: // smhd dmode=1 dbp=0 sfmo=3 rnd=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3486: // smhd dmode=2 dbp=0 sfmo=3 rnd=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3487: // smhd dmode=0 dbp=1 sfmo=3 rnd=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3488: // smhd dmode=1 dbp=1 sfmo=3 rnd=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3489: // smhd dmode=2 dbp=1 sfmo=3 rnd=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3490: // smhd dmode=0 dbp=0 sfmo=0 rnd=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3491: // smhd dmode=1 dbp=0 sfmo=0 rnd=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3492: // smhd dmode=2 dbp=0 sfmo=0 rnd=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3493: // smhd dmode=0 dbp=1 sfmo=0 rnd=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3494: // smhd dmode=1 dbp=1 sfmo=0 rnd=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3495: // smhd dmode=2 dbp=1 sfmo=0 rnd=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3496: // smhd dmode=0 dbp=0 sfmo=1 rnd=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3497: // smhd dmode=1 dbp=0 sfmo=1 rnd=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3498: // smhd dmode=2 dbp=0 sfmo=1 rnd=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3499: // smhd dmode=0 dbp=1 sfmo=1 rnd=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3500: // smhd dmode=1 dbp=1 sfmo=1 rnd=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3501: // smhd dmode=2 dbp=1 sfmo=1 rnd=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3502: // smhd dmode=0 dbp=0 sfmo=2 rnd=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3503: // smhd dmode=1 dbp=0 sfmo=2 rnd=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3504: // smhd dmode=2 dbp=0 sfmo=2 rnd=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3505: // smhd dmode=0 dbp=1 sfmo=2 rnd=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3506: // smhd dmode=1 dbp=1 sfmo=2 rnd=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3507: // smhd dmode=2 dbp=1 sfmo=2 rnd=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3508: // smhd dmode=0 dbp=0 sfmo=3 rnd=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3509: // smhd dmode=1 dbp=0 sfmo=3 rnd=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3510: // smhd dmode=2 dbp=0 sfmo=3 rnd=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3511: // smhd dmode=0 dbp=1 sfmo=3 rnd=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3512: // smhd dmode=1 dbp=1 sfmo=3 rnd=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3513: // smhd dmode=2 dbp=1 sfmo=3 rnd=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3514: // smhd dmode=0 dbp=0 sfmo=0 rnd=4 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3515: // smhd dmode=1 dbp=0 sfmo=0 rnd=4 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3516: // smhd dmode=2 dbp=0 sfmo=0 rnd=4 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3517: // smhd dmode=0 dbp=1 sfmo=0 rnd=4 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3518: // smhd dmode=1 dbp=1 sfmo=0 rnd=4 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3519: // smhd dmode=2 dbp=1 sfmo=0 rnd=4 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3520: // smhd dmode=0 dbp=0 sfmo=1 rnd=4 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3521: // smhd dmode=1 dbp=0 sfmo=1 rnd=4 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3522: // smhd dmode=2 dbp=0 sfmo=1 rnd=4 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3523: // smhd dmode=0 dbp=1 sfmo=1 rnd=4 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3524: // smhd dmode=1 dbp=1 sfmo=1 rnd=4 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3525: // smhd dmode=2 dbp=1 sfmo=1 rnd=4 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3526: // smhd dmode=0 dbp=0 sfmo=2 rnd=4 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3527: // smhd dmode=1 dbp=0 sfmo=2 rnd=4 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3528: // smhd dmode=2 dbp=0 sfmo=2 rnd=4 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3529: // smhd dmode=0 dbp=1 sfmo=2 rnd=4 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3530: // smhd dmode=1 dbp=1 sfmo=2 rnd=4 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3531: // smhd dmode=2 dbp=1 sfmo=2 rnd=4 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3532: // smhd dmode=0 dbp=0 sfmo=3 rnd=4 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3533: // smhd dmode=1 dbp=0 sfmo=3 rnd=4 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3534: // smhd dmode=2 dbp=0 sfmo=3 rnd=4 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3535: // smhd dmode=0 dbp=1 sfmo=3 rnd=4 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3536: // smhd dmode=1 dbp=1 sfmo=3 rnd=4 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3537: // smhd dmode=2 dbp=1 sfmo=3 rnd=4 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3538: // smhd dmode=0 dbp=0 sfmo=0 rnd=5 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3539: // smhd dmode=1 dbp=0 sfmo=0 rnd=5 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3540: // smhd dmode=2 dbp=0 sfmo=0 rnd=5 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3541: // smhd dmode=0 dbp=1 sfmo=0 rnd=5 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3542: // smhd dmode=1 dbp=1 sfmo=0 rnd=5 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3543: // smhd dmode=2 dbp=1 sfmo=0 rnd=5 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3544: // smhd dmode=0 dbp=0 sfmo=1 rnd=5 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3545: // smhd dmode=1 dbp=0 sfmo=1 rnd=5 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3546: // smhd dmode=2 dbp=0 sfmo=1 rnd=5 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3547: // smhd dmode=0 dbp=1 sfmo=1 rnd=5 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3548: // smhd dmode=1 dbp=1 sfmo=1 rnd=5 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3549: // smhd dmode=2 dbp=1 sfmo=1 rnd=5 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3550: // smhd dmode=0 dbp=0 sfmo=2 rnd=5 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3551: // smhd dmode=1 dbp=0 sfmo=2 rnd=5 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3552: // smhd dmode=2 dbp=0 sfmo=2 rnd=5 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3553: // smhd dmode=0 dbp=1 sfmo=2 rnd=5 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3554: // smhd dmode=1 dbp=1 sfmo=2 rnd=5 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3555: // smhd dmode=2 dbp=1 sfmo=2 rnd=5 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3556: // smhd dmode=0 dbp=0 sfmo=3 rnd=5 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3557: // smhd dmode=1 dbp=0 sfmo=3 rnd=5 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3558: // smhd dmode=2 dbp=0 sfmo=3 rnd=5 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3559: // smhd dmode=0 dbp=1 sfmo=3 rnd=5 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3560: // smhd dmode=1 dbp=1 sfmo=3 rnd=5 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3561: // smhd dmode=2 dbp=1 sfmo=3 rnd=5 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3562: // smhd dmode=0 dbp=0 sfmo=0 rnd=6 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3563: // smhd dmode=1 dbp=0 sfmo=0 rnd=6 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3564: // smhd dmode=2 dbp=0 sfmo=0 rnd=6 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3565: // smhd dmode=0 dbp=1 sfmo=0 rnd=6 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3566: // smhd dmode=1 dbp=1 sfmo=0 rnd=6 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3567: // smhd dmode=2 dbp=1 sfmo=0 rnd=6 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3568: // smhd dmode=0 dbp=0 sfmo=1 rnd=6 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3569: // smhd dmode=1 dbp=0 sfmo=1 rnd=6 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3570: // smhd dmode=2 dbp=0 sfmo=1 rnd=6 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3571: // smhd dmode=0 dbp=1 sfmo=1 rnd=6 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3572: // smhd dmode=1 dbp=1 sfmo=1 rnd=6 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3573: // smhd dmode=2 dbp=1 sfmo=1 rnd=6 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3574: // smhd dmode=0 dbp=0 sfmo=2 rnd=6 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3575: // smhd dmode=1 dbp=0 sfmo=2 rnd=6 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3576: // smhd dmode=2 dbp=0 sfmo=2 rnd=6 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3577: // smhd dmode=0 dbp=1 sfmo=2 rnd=6 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3578: // smhd dmode=1 dbp=1 sfmo=2 rnd=6 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3579: // smhd dmode=2 dbp=1 sfmo=2 rnd=6 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3580: // smhd dmode=0 dbp=0 sfmo=3 rnd=6 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3581: // smhd dmode=1 dbp=0 sfmo=3 rnd=6 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3582: // smhd dmode=2 dbp=0 sfmo=3 rnd=6 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3583: // smhd dmode=0 dbp=1 sfmo=3 rnd=6 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3584: // smhd dmode=1 dbp=1 sfmo=3 rnd=6 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3585: // smhd dmode=2 dbp=1 sfmo=3 rnd=6 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3586: // smhd dmode=0 dbp=0 sfmo=0 rnd=7 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3587: // smhd dmode=1 dbp=0 sfmo=0 rnd=7 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3588: // smhd dmode=2 dbp=0 sfmo=0 rnd=7 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3589: // smhd dmode=0 dbp=1 sfmo=0 rnd=7 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3590: // smhd dmode=1 dbp=1 sfmo=0 rnd=7 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3591: // smhd dmode=2 dbp=1 sfmo=0 rnd=7 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3592: // smhd dmode=0 dbp=0 sfmo=1 rnd=7 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3593: // smhd dmode=1 dbp=0 sfmo=1 rnd=7 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3594: // smhd dmode=2 dbp=0 sfmo=1 rnd=7 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3595: // smhd dmode=0 dbp=1 sfmo=1 rnd=7 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3596: // smhd dmode=1 dbp=1 sfmo=1 rnd=7 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3597: // smhd dmode=2 dbp=1 sfmo=1 rnd=7 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3598: // smhd dmode=0 dbp=0 sfmo=2 rnd=7 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3599: // smhd dmode=1 dbp=0 sfmo=2 rnd=7 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3600: // smhd dmode=2 dbp=0 sfmo=2 rnd=7 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3601: // smhd dmode=0 dbp=1 sfmo=2 rnd=7 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3602: // smhd dmode=1 dbp=1 sfmo=2 rnd=7 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3603: // smhd dmode=2 dbp=1 sfmo=2 rnd=7 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3604: // smhd dmode=0 dbp=0 sfmo=3 rnd=7 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3605: // smhd dmode=1 dbp=0 sfmo=3 rnd=7 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3606: // smhd dmode=2 dbp=0 sfmo=3 rnd=7 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3607: // smhd dmode=0 dbp=1 sfmo=3 rnd=7 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3608: // smhd dmode=1 dbp=1 sfmo=3 rnd=7 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3609: // smhd dmode=2 dbp=1 sfmo=3 rnd=7 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3610: // smhc cmode=0 sfmo=0 rnd=0 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3611: // smhc cmode=1 sfmo=0 rnd=0 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3612: // smhc cmode=2 sfmo=0 rnd=0 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3613: // smhc cmode=0 sfmo=1 rnd=0 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3614: // smhc cmode=1 sfmo=1 rnd=0 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3615: // smhc cmode=2 sfmo=1 rnd=0 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3616: // smhc cmode=0 sfmo=2 rnd=0 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3617: // smhc cmode=1 sfmo=2 rnd=0 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3618: // smhc cmode=2 sfmo=2 rnd=0 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3619: // smhc cmode=0 sfmo=3 rnd=0 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3620: // smhc cmode=1 sfmo=3 rnd=0 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3621: // smhc cmode=2 sfmo=3 rnd=0 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3622: // smhc cmode=0 sfmo=0 rnd=1 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3623: // smhc cmode=1 sfmo=0 rnd=1 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3624: // smhc cmode=2 sfmo=0 rnd=1 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3625: // smhc cmode=0 sfmo=1 rnd=1 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3626: // smhc cmode=1 sfmo=1 rnd=1 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3627: // smhc cmode=2 sfmo=1 rnd=1 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3628: // smhc cmode=0 sfmo=2 rnd=1 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3629: // smhc cmode=1 sfmo=2 rnd=1 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3630: // smhc cmode=2 sfmo=2 rnd=1 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3631: // smhc cmode=0 sfmo=3 rnd=1 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3632: // smhc cmode=1 sfmo=3 rnd=1 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3633: // smhc cmode=2 sfmo=3 rnd=1 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3634: // smhc cmode=0 sfmo=0 rnd=2 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3635: // smhc cmode=1 sfmo=0 rnd=2 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3636: // smhc cmode=2 sfmo=0 rnd=2 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3637: // smhc cmode=0 sfmo=1 rnd=2 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3638: // smhc cmode=1 sfmo=1 rnd=2 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3639: // smhc cmode=2 sfmo=1 rnd=2 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3640: // smhc cmode=0 sfmo=2 rnd=2 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3641: // smhc cmode=1 sfmo=2 rnd=2 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3642: // smhc cmode=2 sfmo=2 rnd=2 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3643: // smhc cmode=0 sfmo=3 rnd=2 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3644: // smhc cmode=1 sfmo=3 rnd=2 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3645: // smhc cmode=2 sfmo=3 rnd=2 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3646: // smhc cmode=0 sfmo=0 rnd=3 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3647: // smhc cmode=1 sfmo=0 rnd=3 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3648: // smhc cmode=2 sfmo=0 rnd=3 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3649: // smhc cmode=0 sfmo=1 rnd=3 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3650: // smhc cmode=1 sfmo=1 rnd=3 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3651: // smhc cmode=2 sfmo=1 rnd=3 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3652: // smhc cmode=0 sfmo=2 rnd=3 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3653: // smhc cmode=1 sfmo=2 rnd=3 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3654: // smhc cmode=2 sfmo=2 rnd=3 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3655: // smhc cmode=0 sfmo=3 rnd=3 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3656: // smhc cmode=1 sfmo=3 rnd=3 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3657: // smhc cmode=2 sfmo=3 rnd=3 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3658: // smhc cmode=0 sfmo=0 rnd=4 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3659: // smhc cmode=1 sfmo=0 rnd=4 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3660: // smhc cmode=2 sfmo=0 rnd=4 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3661: // smhc cmode=0 sfmo=1 rnd=4 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3662: // smhc cmode=1 sfmo=1 rnd=4 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3663: // smhc cmode=2 sfmo=1 rnd=4 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3664: // smhc cmode=0 sfmo=2 rnd=4 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3665: // smhc cmode=1 sfmo=2 rnd=4 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3666: // smhc cmode=2 sfmo=2 rnd=4 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3667: // smhc cmode=0 sfmo=3 rnd=4 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3668: // smhc cmode=1 sfmo=3 rnd=4 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3669: // smhc cmode=2 sfmo=3 rnd=4 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3670: // smhc cmode=0 sfmo=0 rnd=5 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3671: // smhc cmode=1 sfmo=0 rnd=5 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3672: // smhc cmode=2 sfmo=0 rnd=5 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3673: // smhc cmode=0 sfmo=1 rnd=5 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3674: // smhc cmode=1 sfmo=1 rnd=5 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3675: // smhc cmode=2 sfmo=1 rnd=5 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3676: // smhc cmode=0 sfmo=2 rnd=5 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3677: // smhc cmode=1 sfmo=2 rnd=5 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3678: // smhc cmode=2 sfmo=2 rnd=5 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3679: // smhc cmode=0 sfmo=3 rnd=5 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3680: // smhc cmode=1 sfmo=3 rnd=5 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3681: // smhc cmode=2 sfmo=3 rnd=5 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3682: // smhc cmode=0 sfmo=0 rnd=6 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3683: // smhc cmode=1 sfmo=0 rnd=6 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3684: // smhc cmode=2 sfmo=0 rnd=6 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3685: // smhc cmode=0 sfmo=1 rnd=6 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3686: // smhc cmode=1 sfmo=1 rnd=6 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3687: // smhc cmode=2 sfmo=1 rnd=6 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3688: // smhc cmode=0 sfmo=2 rnd=6 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3689: // smhc cmode=1 sfmo=2 rnd=6 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3690: // smhc cmode=2 sfmo=2 rnd=6 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3691: // smhc cmode=0 sfmo=3 rnd=6 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3692: // smhc cmode=1 sfmo=3 rnd=6 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3693: // smhc cmode=2 sfmo=3 rnd=6 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3694: // smhc cmode=0 sfmo=0 rnd=7 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3695: // smhc cmode=1 sfmo=0 rnd=7 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3696: // smhc cmode=2 sfmo=0 rnd=7 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3697: // smhc cmode=0 sfmo=1 rnd=7 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3698: // smhc cmode=1 sfmo=1 rnd=7 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3699: // smhc cmode=2 sfmo=1 rnd=7 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3700: // smhc cmode=0 sfmo=2 rnd=7 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3701: // smhc cmode=1 sfmo=2 rnd=7 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3702: // smhc cmode=2 sfmo=2 rnd=7 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3703: // smhc cmode=0 sfmo=3 rnd=7 movm=0
  s->cmem[i->param] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3704: // smhc cmode=1 sfmo=3 rnd=7 movm=0
  s->cmem[s->ca] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3705: // smhc cmode=2 sfmo=3 rnd=7 movm=0
  s->cmem[s->ca++] = tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3706: // smhc cmode=0 sfmo=0 rnd=0 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3707: // smhc cmode=1 sfmo=0 rnd=0 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3708: // smhc cmode=2 sfmo=0 rnd=0 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3709: // smhc cmode=0 sfmo=1 rnd=0 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3710: // smhc cmode=1 sfmo=1 rnd=0 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3711: // smhc cmode=2 sfmo=1 rnd=0 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3712: // smhc cmode=0 sfmo=2 rnd=0 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3713: // smhc cmode=1 sfmo=2 rnd=0 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3714: // smhc cmode=2 sfmo=2 rnd=0 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3715: // smhc cmode=0 sfmo=3 rnd=0 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3716: // smhc cmode=1 sfmo=3 rnd=0 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3717: // smhc cmode=2 sfmo=3 rnd=0 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3718: // smhc cmode=0 sfmo=0 rnd=1 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3719: // smhc cmode=1 sfmo=0 rnd=1 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3720: // smhc cmode=2 sfmo=0 rnd=1 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3721: // smhc cmode=0 sfmo=1 rnd=1 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3722: // smhc cmode=1 sfmo=1 rnd=1 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3723: // smhc cmode=2 sfmo=1 rnd=1 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3724: // smhc cmode=0 sfmo=2 rnd=1 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3725: // smhc cmode=1 sfmo=2 rnd=1 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3726: // smhc cmode=2 sfmo=2 rnd=1 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3727: // smhc cmode=0 sfmo=3 rnd=1 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3728: // smhc cmode=1 sfmo=3 rnd=1 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3729: // smhc cmode=2 sfmo=3 rnd=1 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 16;
  break;

case 3730: // smhc cmode=0 sfmo=0 rnd=2 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3731: // smhc cmode=1 sfmo=0 rnd=2 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3732: // smhc cmode=2 sfmo=0 rnd=2 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3733: // smhc cmode=0 sfmo=1 rnd=2 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3734: // smhc cmode=1 sfmo=1 rnd=2 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3735: // smhc cmode=2 sfmo=1 rnd=2 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3736: // smhc cmode=0 sfmo=2 rnd=2 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3737: // smhc cmode=1 sfmo=2 rnd=2 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3738: // smhc cmode=2 sfmo=2 rnd=2 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3739: // smhc cmode=0 sfmo=3 rnd=2 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3740: // smhc cmode=1 sfmo=3 rnd=2 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3741: // smhc cmode=2 sfmo=3 rnd=2 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 16;
  break;

case 3742: // smhc cmode=0 sfmo=0 rnd=3 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3743: // smhc cmode=1 sfmo=0 rnd=3 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3744: // smhc cmode=2 sfmo=0 rnd=3 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3745: // smhc cmode=0 sfmo=1 rnd=3 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3746: // smhc cmode=1 sfmo=1 rnd=3 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3747: // smhc cmode=2 sfmo=1 rnd=3 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3748: // smhc cmode=0 sfmo=2 rnd=3 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3749: // smhc cmode=1 sfmo=2 rnd=3 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3750: // smhc cmode=2 sfmo=2 rnd=3 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3751: // smhc cmode=0 sfmo=3 rnd=3 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3752: // smhc cmode=1 sfmo=3 rnd=3 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3753: // smhc cmode=2 sfmo=3 rnd=3 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 16;
  break;

case 3754: // smhc cmode=0 sfmo=0 rnd=4 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3755: // smhc cmode=1 sfmo=0 rnd=4 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3756: // smhc cmode=2 sfmo=0 rnd=4 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3757: // smhc cmode=0 sfmo=1 rnd=4 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3758: // smhc cmode=1 sfmo=1 rnd=4 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3759: // smhc cmode=2 sfmo=1 rnd=4 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3760: // smhc cmode=0 sfmo=2 rnd=4 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3761: // smhc cmode=1 sfmo=2 rnd=4 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3762: // smhc cmode=2 sfmo=2 rnd=4 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3763: // smhc cmode=0 sfmo=3 rnd=4 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3764: // smhc cmode=1 sfmo=3 rnd=4 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3765: // smhc cmode=2 sfmo=3 rnd=4 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 16;
  break;

case 3766: // smhc cmode=0 sfmo=0 rnd=5 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3767: // smhc cmode=1 sfmo=0 rnd=5 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3768: // smhc cmode=2 sfmo=0 rnd=5 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3769: // smhc cmode=0 sfmo=1 rnd=5 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3770: // smhc cmode=1 sfmo=1 rnd=5 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3771: // smhc cmode=2 sfmo=1 rnd=5 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3772: // smhc cmode=0 sfmo=2 rnd=5 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3773: // smhc cmode=1 sfmo=2 rnd=5 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3774: // smhc cmode=2 sfmo=2 rnd=5 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3775: // smhc cmode=0 sfmo=3 rnd=5 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3776: // smhc cmode=1 sfmo=3 rnd=5 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3777: // smhc cmode=2 sfmo=3 rnd=5 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3778: // smhc cmode=0 sfmo=0 rnd=6 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3779: // smhc cmode=1 sfmo=0 rnd=6 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3780: // smhc cmode=2 sfmo=0 rnd=6 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3781: // smhc cmode=0 sfmo=1 rnd=6 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3782: // smhc cmode=1 sfmo=1 rnd=6 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3783: // smhc cmode=2 sfmo=1 rnd=6 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3784: // smhc cmode=0 sfmo=2 rnd=6 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3785: // smhc cmode=1 sfmo=2 rnd=6 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3786: // smhc cmode=2 sfmo=2 rnd=6 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3787: // smhc cmode=0 sfmo=3 rnd=6 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3788: // smhc cmode=1 sfmo=3 rnd=6 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3789: // smhc cmode=2 sfmo=3 rnd=6 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3790: // smhc cmode=0 sfmo=0 rnd=7 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3791: // smhc cmode=1 sfmo=0 rnd=7 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3792: // smhc cmode=2 sfmo=0 rnd=7 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3793: // smhc cmode=0 sfmo=1 rnd=7 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3794: // smhc cmode=1 sfmo=1 rnd=7 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3795: // smhc cmode=2 sfmo=1 rnd=7 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3796: // smhc cmode=0 sfmo=2 rnd=7 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3797: // smhc cmode=1 sfmo=2 rnd=7 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3798: // smhc cmode=2 sfmo=2 rnd=7 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3799: // smhc cmode=0 sfmo=3 rnd=7 movm=1
  s->cmem[i->param] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3800: // smhc cmode=1 sfmo=3 rnd=7 movm=1
  s->cmem[s->ca] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3801: // smhc cmode=2 sfmo=3 rnd=7 movm=1
  s->cmem[s->ca++] = tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 16;
  break;

case 3802: // slmh dmode=0 dbp=0 sfmo=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3803: // slmh dmode=1 dbp=0 sfmo=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3804: // slmh dmode=2 dbp=0 sfmo=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3805: // slmh dmode=0 dbp=1 sfmo=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3806: // slmh dmode=1 dbp=1 sfmo=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3807: // slmh dmode=2 dbp=1 sfmo=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 24) & 0xffff00;
  break;

case 3808: // slmh dmode=0 dbp=0 sfmo=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3809: // slmh dmode=1 dbp=0 sfmo=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3810: // slmh dmode=2 dbp=0 sfmo=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3811: // slmh dmode=0 dbp=1 sfmo=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3812: // slmh dmode=1 dbp=1 sfmo=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3813: // slmh dmode=2 dbp=1 sfmo=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 24) & 0xffff00;
  break;

case 3814: // slmh dmode=0 dbp=0 sfmo=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3815: // slmh dmode=1 dbp=0 sfmo=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3816: // slmh dmode=2 dbp=0 sfmo=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3817: // slmh dmode=0 dbp=1 sfmo=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3818: // slmh dmode=1 dbp=1 sfmo=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3819: // slmh dmode=2 dbp=1 sfmo=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 24) & 0xffff00;
  break;

case 3820: // slmh dmode=0 dbp=0 sfmo=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3821: // slmh dmode=1 dbp=0 sfmo=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3822: // slmh dmode=2 dbp=0 sfmo=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3823: // slmh dmode=0 dbp=1 sfmo=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3824: // slmh dmode=1 dbp=1 sfmo=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3825: // slmh dmode=2 dbp=1 sfmo=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 24) & 0xffff00;
  break;

case 3826: // slmh dmode=0 dbp=0 sfmo=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3827: // slmh dmode=1 dbp=0 sfmo=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3828: // slmh dmode=2 dbp=0 sfmo=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3829: // slmh dmode=0 dbp=1 sfmo=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3830: // slmh dmode=1 dbp=1 sfmo=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3831: // slmh dmode=2 dbp=1 sfmo=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 24) & 0xffff00;
  break;

case 3832: // slmh dmode=0 dbp=0 sfmo=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3833: // slmh dmode=1 dbp=0 sfmo=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3834: // slmh dmode=2 dbp=0 sfmo=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3835: // slmh dmode=0 dbp=1 sfmo=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3836: // slmh dmode=1 dbp=1 sfmo=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3837: // slmh dmode=2 dbp=1 sfmo=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 24) & 0xffff00;
  break;

case 3838: // slmh dmode=0 dbp=0 sfmo=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3839: // slmh dmode=1 dbp=0 sfmo=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3840: // slmh dmode=2 dbp=0 sfmo=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3841: // slmh dmode=0 dbp=1 sfmo=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3842: // slmh dmode=1 dbp=1 sfmo=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3843: // slmh dmode=2 dbp=1 sfmo=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 24) & 0xffff00;
  break;

case 3844: // slmh dmode=0 dbp=0 sfmo=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3845: // slmh dmode=1 dbp=0 sfmo=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3846: // slmh dmode=2 dbp=0 sfmo=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3847: // slmh dmode=0 dbp=1 sfmo=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3848: // slmh dmode=1 dbp=1 sfmo=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3849: // slmh dmode=2 dbp=1 sfmo=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 24) & 0xffff00;
  break;

case 3850: // slml dmode=0 dbp=0 sfmo=0 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3851: // slml dmode=1 dbp=0 sfmo=0 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3852: // slml dmode=2 dbp=0 sfmo=0 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3853: // slml dmode=0 dbp=1 sfmo=0 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3854: // slml dmode=1 dbp=1 sfmo=0 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3855: // slml dmode=2 dbp=1 sfmo=0 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0(s) >> 8) & 0xffffff;
  break;

case 3856: // slml dmode=0 dbp=0 sfmo=1 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3857: // slml dmode=1 dbp=0 sfmo=1 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3858: // slml dmode=2 dbp=0 sfmo=1 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3859: // slml dmode=0 dbp=1 sfmo=1 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3860: // slml dmode=1 dbp=1 sfmo=1 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3861: // slml dmode=2 dbp=1 sfmo=1 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1(s) >> 8) & 0xffffff;
  break;

case 3862: // slml dmode=0 dbp=0 sfmo=2 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3863: // slml dmode=1 dbp=0 sfmo=2 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3864: // slml dmode=2 dbp=0 sfmo=2 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3865: // slml dmode=0 dbp=1 sfmo=2 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3866: // slml dmode=1 dbp=1 sfmo=2 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3867: // slml dmode=2 dbp=1 sfmo=2 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2(s) >> 8) & 0xffffff;
  break;

case 3868: // slml dmode=0 dbp=0 sfmo=3 movm=0
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3869: // slml dmode=1 dbp=0 sfmo=3 movm=0
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3870: // slml dmode=2 dbp=0 sfmo=3 movm=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3871: // slml dmode=0 dbp=1 sfmo=3 movm=0
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3872: // slml dmode=1 dbp=1 sfmo=3 movm=0
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3873: // slml dmode=2 dbp=1 sfmo=3 movm=0
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3(s) >> 8) & 0xffffff;
  break;

case 3874: // slml dmode=0 dbp=0 sfmo=0 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3875: // slml dmode=1 dbp=0 sfmo=0 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3876: // slml dmode=2 dbp=0 sfmo=0 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3877: // slml dmode=0 dbp=1 sfmo=0 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3878: // slml dmode=1 dbp=1 sfmo=0 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3879: // slml dmode=2 dbp=1 sfmo=0 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_0s(s) >> 8) & 0xffffff;
  break;

case 3880: // slml dmode=0 dbp=0 sfmo=1 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3881: // slml dmode=1 dbp=0 sfmo=1 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3882: // slml dmode=2 dbp=0 sfmo=1 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3883: // slml dmode=0 dbp=1 sfmo=1 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3884: // slml dmode=1 dbp=1 sfmo=1 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3885: // slml dmode=2 dbp=1 sfmo=1 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_1s(s) >> 8) & 0xffffff;
  break;

case 3886: // slml dmode=0 dbp=0 sfmo=2 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3887: // slml dmode=1 dbp=0 sfmo=2 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3888: // slml dmode=2 dbp=0 sfmo=2 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3889: // slml dmode=0 dbp=1 sfmo=2 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3890: // slml dmode=1 dbp=1 sfmo=2 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3891: // slml dmode=2 dbp=1 sfmo=2 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_2s(s) >> 8) & 0xffffff;
  break;

case 3892: // slml dmode=0 dbp=0 sfmo=3 movm=1
  s->dmem0[(i->param + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3893: // slml dmode=1 dbp=0 sfmo=3 movm=1
  s->dmem0[(s->id + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3894: // slml dmode=2 dbp=0 sfmo=3 movm=1
  s->dmem0[((s->id++) + s->ba0) & 0xff] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3895: // slml dmode=0 dbp=1 sfmo=3 movm=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3896: // slml dmode=1 dbp=1 sfmo=3 movm=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3897: // slml dmode=2 dbp=1 sfmo=3 movm=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = (tms57002_check_macc_overflow_3s(s) >> 8) & 0xffffff;
  break;

case 3898: // lcaa sfao=0
  s->ca = s->aacc >> 24;
  break;

case 3899: // lcaa sfao=1
  s->ca = (s->aacc << 7) >> 24;
  break;

case 3900: // lira sfao=0
  s->id = s->aacc >> 24;
  break;

case 3901: // lira sfao=1
  s->id = (s->aacc << 7) >> 24;
  break;

case 3902: // ref
  /* nothing to do */
  break;

case 3903: // srbd dmode=0 dbp=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->xrd;
  break;

case 3904: // srbd dmode=1 dbp=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->xrd;
  break;

case 3905: // srbd dmode=2 dbp=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->xrd;
  break;

case 3906: // srbd dmode=0 dbp=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->xrd;
  break;

case 3907: // srbd dmode=1 dbp=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->xrd;
  break;

case 3908: // srbd dmode=2 dbp=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->xrd;
  break;

case 3909: // dis dmode=0 dbp=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->si[0];
  break;

case 3910: // dis dmode=1 dbp=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->si[0];
  break;

case 3911: // dis dmode=2 dbp=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->si[0];
  break;

case 3912: // dis dmode=0 dbp=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->si[0];
  break;

case 3913: // dis dmode=1 dbp=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->si[0];
  break;

case 3914: // dis dmode=2 dbp=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->si[0];
  break;

case 3915: // dis dmode=0 dbp=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->si[1];
  break;

case 3916: // dis dmode=1 dbp=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->si[1];
  break;

case 3917: // dis dmode=2 dbp=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->si[1];
  break;

case 3918: // dis dmode=0 dbp=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->si[1];
  break;

case 3919: // dis dmode=1 dbp=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->si[1];
  break;

case 3920: // dis dmode=2 dbp=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->si[1];
  break;

case 3921: // dis dmode=0 dbp=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->si[2];
  break;

case 3922: // dis dmode=1 dbp=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->si[2];
  break;

case 3923: // dis dmode=2 dbp=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->si[2];
  break;

case 3924: // dis dmode=0 dbp=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->si[2];
  break;

case 3925: // dis dmode=1 dbp=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->si[2];
  break;

case 3926: // dis dmode=2 dbp=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->si[2];
  break;

case 3927: // dis dmode=0 dbp=0
  s->dmem0[(i->param + s->ba0) & 0xff] = s->si[3];
  break;

case 3928: // dis dmode=1 dbp=0
  s->dmem0[(s->id + s->ba0) & 0xff] = s->si[3];
  break;

case 3929: // dis dmode=2 dbp=0
  s->dmem0[((s->id++) + s->ba0) & 0xff] = s->si[3];
  break;

case 3930: // dis dmode=0 dbp=1
  s->dmem1[(i->param + s->ba1) & 0x1f] = s->si[3];
  break;

case 3931: // dis dmode=1 dbp=1
  s->dmem1[(s->id + s->ba1) & 0x1f] = s->si[3];
  break;

case 3932: // dis dmode=2 dbp=1
  s->dmem1[((s->id++) + s->ba1) & 0x1f] = s->si[3];
  break;

case 3933: // domh sfmo=0 rnd=0 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3934: // domh sfmo=1 rnd=0 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3935: // domh sfmo=2 rnd=0 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3936: // domh sfmo=3 rnd=0 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3937: // domh sfmo=0 rnd=1 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3938: // domh sfmo=1 rnd=1 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3939: // domh sfmo=2 rnd=1 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3940: // domh sfmo=3 rnd=1 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3941: // domh sfmo=0 rnd=2 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3942: // domh sfmo=1 rnd=2 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3943: // domh sfmo=2 rnd=2 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3944: // domh sfmo=3 rnd=2 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3945: // domh sfmo=0 rnd=3 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3946: // domh sfmo=1 rnd=3 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3947: // domh sfmo=2 rnd=3 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3948: // domh sfmo=3 rnd=3 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3949: // domh sfmo=0 rnd=4 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3950: // domh sfmo=1 rnd=4 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3951: // domh sfmo=2 rnd=4 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3952: // domh sfmo=3 rnd=4 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3953: // domh sfmo=0 rnd=5 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3954: // domh sfmo=1 rnd=5 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3955: // domh sfmo=2 rnd=5 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3956: // domh sfmo=3 rnd=5 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3957: // domh sfmo=0 rnd=6 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3958: // domh sfmo=1 rnd=6 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3959: // domh sfmo=2 rnd=6 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3960: // domh sfmo=3 rnd=6 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3961: // domh sfmo=0 rnd=7 movm=0
  s->so[0] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3962: // domh sfmo=1 rnd=7 movm=0
  s->so[0] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3963: // domh sfmo=2 rnd=7 movm=0
  s->so[0] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3964: // domh sfmo=3 rnd=7 movm=0
  s->so[0] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3965: // domh sfmo=0 rnd=0 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3966: // domh sfmo=1 rnd=0 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3967: // domh sfmo=2 rnd=0 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3968: // domh sfmo=3 rnd=0 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3969: // domh sfmo=0 rnd=1 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3970: // domh sfmo=1 rnd=1 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3971: // domh sfmo=2 rnd=1 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3972: // domh sfmo=3 rnd=1 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 3973: // domh sfmo=0 rnd=2 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3974: // domh sfmo=1 rnd=2 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3975: // domh sfmo=2 rnd=2 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3976: // domh sfmo=3 rnd=2 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 3977: // domh sfmo=0 rnd=3 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3978: // domh sfmo=1 rnd=3 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3979: // domh sfmo=2 rnd=3 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3980: // domh sfmo=3 rnd=3 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 3981: // domh sfmo=0 rnd=4 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3982: // domh sfmo=1 rnd=4 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3983: // domh sfmo=2 rnd=4 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3984: // domh sfmo=3 rnd=4 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 3985: // domh sfmo=0 rnd=5 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3986: // domh sfmo=1 rnd=5 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3987: // domh sfmo=2 rnd=5 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3988: // domh sfmo=3 rnd=5 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3989: // domh sfmo=0 rnd=6 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3990: // domh sfmo=1 rnd=6 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3991: // domh sfmo=2 rnd=6 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3992: // domh sfmo=3 rnd=6 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3993: // domh sfmo=0 rnd=7 movm=1
  s->so[0] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3994: // domh sfmo=1 rnd=7 movm=1
  s->so[0] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3995: // domh sfmo=2 rnd=7 movm=1
  s->so[0] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3996: // domh sfmo=3 rnd=7 movm=1
  s->so[0] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3997: // domh sfmo=0 rnd=0 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3998: // domh sfmo=1 rnd=0 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 3999: // domh sfmo=2 rnd=0 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4000: // domh sfmo=3 rnd=0 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4001: // domh sfmo=0 rnd=1 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4002: // domh sfmo=1 rnd=1 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4003: // domh sfmo=2 rnd=1 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4004: // domh sfmo=3 rnd=1 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4005: // domh sfmo=0 rnd=2 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4006: // domh sfmo=1 rnd=2 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4007: // domh sfmo=2 rnd=2 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4008: // domh sfmo=3 rnd=2 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4009: // domh sfmo=0 rnd=3 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4010: // domh sfmo=1 rnd=3 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4011: // domh sfmo=2 rnd=3 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4012: // domh sfmo=3 rnd=3 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4013: // domh sfmo=0 rnd=4 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4014: // domh sfmo=1 rnd=4 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4015: // domh sfmo=2 rnd=4 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4016: // domh sfmo=3 rnd=4 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4017: // domh sfmo=0 rnd=5 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4018: // domh sfmo=1 rnd=5 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4019: // domh sfmo=2 rnd=5 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4020: // domh sfmo=3 rnd=5 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4021: // domh sfmo=0 rnd=6 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4022: // domh sfmo=1 rnd=6 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4023: // domh sfmo=2 rnd=6 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4024: // domh sfmo=3 rnd=6 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4025: // domh sfmo=0 rnd=7 movm=0
  s->so[1] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4026: // domh sfmo=1 rnd=7 movm=0
  s->so[1] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4027: // domh sfmo=2 rnd=7 movm=0
  s->so[1] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4028: // domh sfmo=3 rnd=7 movm=0
  s->so[1] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4029: // domh sfmo=0 rnd=0 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4030: // domh sfmo=1 rnd=0 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4031: // domh sfmo=2 rnd=0 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4032: // domh sfmo=3 rnd=0 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4033: // domh sfmo=0 rnd=1 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4034: // domh sfmo=1 rnd=1 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4035: // domh sfmo=2 rnd=1 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4036: // domh sfmo=3 rnd=1 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4037: // domh sfmo=0 rnd=2 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4038: // domh sfmo=1 rnd=2 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4039: // domh sfmo=2 rnd=2 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4040: // domh sfmo=3 rnd=2 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4041: // domh sfmo=0 rnd=3 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4042: // domh sfmo=1 rnd=3 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4043: // domh sfmo=2 rnd=3 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4044: // domh sfmo=3 rnd=3 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4045: // domh sfmo=0 rnd=4 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4046: // domh sfmo=1 rnd=4 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4047: // domh sfmo=2 rnd=4 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4048: // domh sfmo=3 rnd=4 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4049: // domh sfmo=0 rnd=5 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4050: // domh sfmo=1 rnd=5 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4051: // domh sfmo=2 rnd=5 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4052: // domh sfmo=3 rnd=5 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4053: // domh sfmo=0 rnd=6 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4054: // domh sfmo=1 rnd=6 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4055: // domh sfmo=2 rnd=6 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4056: // domh sfmo=3 rnd=6 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4057: // domh sfmo=0 rnd=7 movm=1
  s->so[1] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4058: // domh sfmo=1 rnd=7 movm=1
  s->so[1] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4059: // domh sfmo=2 rnd=7 movm=1
  s->so[1] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4060: // domh sfmo=3 rnd=7 movm=1
  s->so[1] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4061: // domh sfmo=0 rnd=0 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4062: // domh sfmo=1 rnd=0 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4063: // domh sfmo=2 rnd=0 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4064: // domh sfmo=3 rnd=0 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4065: // domh sfmo=0 rnd=1 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4066: // domh sfmo=1 rnd=1 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4067: // domh sfmo=2 rnd=1 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4068: // domh sfmo=3 rnd=1 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4069: // domh sfmo=0 rnd=2 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4070: // domh sfmo=1 rnd=2 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4071: // domh sfmo=2 rnd=2 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4072: // domh sfmo=3 rnd=2 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4073: // domh sfmo=0 rnd=3 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4074: // domh sfmo=1 rnd=3 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4075: // domh sfmo=2 rnd=3 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4076: // domh sfmo=3 rnd=3 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4077: // domh sfmo=0 rnd=4 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4078: // domh sfmo=1 rnd=4 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4079: // domh sfmo=2 rnd=4 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4080: // domh sfmo=3 rnd=4 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4081: // domh sfmo=0 rnd=5 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4082: // domh sfmo=1 rnd=5 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4083: // domh sfmo=2 rnd=5 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4084: // domh sfmo=3 rnd=5 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4085: // domh sfmo=0 rnd=6 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4086: // domh sfmo=1 rnd=6 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4087: // domh sfmo=2 rnd=6 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4088: // domh sfmo=3 rnd=6 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4089: // domh sfmo=0 rnd=7 movm=0
  s->so[2] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4090: // domh sfmo=1 rnd=7 movm=0
  s->so[2] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4091: // domh sfmo=2 rnd=7 movm=0
  s->so[2] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4092: // domh sfmo=3 rnd=7 movm=0
  s->so[2] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4093: // domh sfmo=0 rnd=0 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4094: // domh sfmo=1 rnd=0 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4095: // domh sfmo=2 rnd=0 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4096: // domh sfmo=3 rnd=0 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4097: // domh sfmo=0 rnd=1 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4098: // domh sfmo=1 rnd=1 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4099: // domh sfmo=2 rnd=1 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4100: // domh sfmo=3 rnd=1 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4101: // domh sfmo=0 rnd=2 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4102: // domh sfmo=1 rnd=2 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4103: // domh sfmo=2 rnd=2 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4104: // domh sfmo=3 rnd=2 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4105: // domh sfmo=0 rnd=3 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4106: // domh sfmo=1 rnd=3 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4107: // domh sfmo=2 rnd=3 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4108: // domh sfmo=3 rnd=3 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4109: // domh sfmo=0 rnd=4 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4110: // domh sfmo=1 rnd=4 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4111: // domh sfmo=2 rnd=4 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4112: // domh sfmo=3 rnd=4 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4113: // domh sfmo=0 rnd=5 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4114: // domh sfmo=1 rnd=5 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4115: // domh sfmo=2 rnd=5 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4116: // domh sfmo=3 rnd=5 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4117: // domh sfmo=0 rnd=6 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4118: // domh sfmo=1 rnd=6 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4119: // domh sfmo=2 rnd=6 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4120: // domh sfmo=3 rnd=6 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4121: // domh sfmo=0 rnd=7 movm=1
  s->so[2] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4122: // domh sfmo=1 rnd=7 movm=1
  s->so[2] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4123: // domh sfmo=2 rnd=7 movm=1
  s->so[2] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4124: // domh sfmo=3 rnd=7 movm=1
  s->so[2] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4125: // domh sfmo=0 rnd=0 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4126: // domh sfmo=1 rnd=0 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4127: // domh sfmo=2 rnd=0 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4128: // domh sfmo=3 rnd=0 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4129: // domh sfmo=0 rnd=1 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4130: // domh sfmo=1 rnd=1 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4131: // domh sfmo=2 rnd=1 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4132: // domh sfmo=3 rnd=1 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4133: // domh sfmo=0 rnd=2 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4134: // domh sfmo=1 rnd=2 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4135: // domh sfmo=2 rnd=2 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4136: // domh sfmo=3 rnd=2 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4137: // domh sfmo=0 rnd=3 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4138: // domh sfmo=1 rnd=3 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4139: // domh sfmo=2 rnd=3 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4140: // domh sfmo=3 rnd=3 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4141: // domh sfmo=0 rnd=4 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4142: // domh sfmo=1 rnd=4 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4143: // domh sfmo=2 rnd=4 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4144: // domh sfmo=3 rnd=4 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4145: // domh sfmo=0 rnd=5 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4146: // domh sfmo=1 rnd=5 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4147: // domh sfmo=2 rnd=5 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4148: // domh sfmo=3 rnd=5 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4149: // domh sfmo=0 rnd=6 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4150: // domh sfmo=1 rnd=6 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4151: // domh sfmo=2 rnd=6 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4152: // domh sfmo=3 rnd=6 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4153: // domh sfmo=0 rnd=7 movm=0
  s->so[3] = (tms57002_macc_to_output_0(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4154: // domh sfmo=1 rnd=7 movm=0
  s->so[3] = (tms57002_macc_to_output_1(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4155: // domh sfmo=2 rnd=7 movm=0
  s->so[3] = (tms57002_macc_to_output_2(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4156: // domh sfmo=3 rnd=7 movm=0
  s->so[3] = (tms57002_macc_to_output_3(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4157: // domh sfmo=0 rnd=0 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4158: // domh sfmo=1 rnd=0 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4159: // domh sfmo=2 rnd=0 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4160: // domh sfmo=3 rnd=0 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4161: // domh sfmo=0 rnd=1 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4162: // domh sfmo=1 rnd=1 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4163: // domh sfmo=2 rnd=1 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4164: // domh sfmo=3 rnd=1 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000008000ULL, 0xffffffffffff0000ULL) >> 24) & 0xffffff;
  break;

case 4165: // domh sfmo=0 rnd=2 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4166: // domh sfmo=1 rnd=2 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4167: // domh sfmo=2 rnd=2 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4168: // domh sfmo=3 rnd=2 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000800000ULL, 0xffffffffff000000ULL) >> 24) & 0xffffff;
  break;

case 4169: // domh sfmo=0 rnd=3 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4170: // domh sfmo=1 rnd=3 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4171: // domh sfmo=2 rnd=3 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4172: // domh sfmo=3 rnd=3 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000020000ULL, 0xfffffffffffc0000ULL) >> 24) & 0xffffff;
  break;

case 4173: // domh sfmo=0 rnd=4 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4174: // domh sfmo=1 rnd=4 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4175: // domh sfmo=2 rnd=4 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4176: // domh sfmo=3 rnd=4 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000080000000ULL, 0xffffffff00000000ULL) >> 24) & 0xffffff;
  break;

case 4177: // domh sfmo=0 rnd=5 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4178: // domh sfmo=1 rnd=5 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4179: // domh sfmo=2 rnd=5 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4180: // domh sfmo=3 rnd=5 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4181: // domh sfmo=0 rnd=6 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4182: // domh sfmo=1 rnd=6 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4183: // domh sfmo=2 rnd=6 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4184: // domh sfmo=3 rnd=6 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4185: // domh sfmo=0 rnd=7 movm=1
  s->so[3] = (tms57002_macc_to_output_0s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4186: // domh sfmo=1 rnd=7 movm=1
  s->so[3] = (tms57002_macc_to_output_1s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4187: // domh sfmo=2 rnd=7 movm=1
  s->so[3] = (tms57002_macc_to_output_2s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4188: // domh sfmo=3 rnd=7 movm=1
  s->so[3] = (tms57002_macc_to_output_3s(s, 0x0000000000000000ULL, 0xffffffffffffffffULL) >> 24) & 0xffffff;
  break;

case 4189: // lpc cmode=0 crm=0
  if(s->sti & S_HOST)
    break;
  c = s->cmem[i->param];
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 4190: // lpc cmode=1 crm=0
  if(s->sti & S_HOST)
    break;
  c = s->cmem[s->ca];
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 4191: // lpc cmode=2 crm=0
  if(s->sti & S_HOST)
    break;
  c = s->cmem[s->ca++];
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 4192: // lpc cmode=0 crm=1
  if(s->sti & S_HOST)
    break;
  c = (s->cmem[i->param] & 0xffff0000);
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 4193: // lpc cmode=1 crm=1
  if(s->sti & S_HOST)
    break;
  c = (s->cmem[s->ca] & 0xffff0000);
  s->host[0] = c >> 24;
  s->host[1] = c >> 16;
  s->host[2] = c >> 8;
  s->host[3] = c;
  s->hidx = 0;
  s->sti |= S_HOST;
  break;

case 4194: // lpc cmode=2 crm=1
  if(s-