/***************************************************************************

  vidhrdw.c

  Functions to emulate the video hardware of the machine.

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"

static int spritectrl[3];

int crbaloon_collision;

/***************************************************************************

  Convert the color PROMs into a more useable format.

  Crazy Balloon has no PROMs, the color code directly maps to a color:
  all bits are inverted
  bit 3 HALF (intensity)
  bit 2 BLUE
  bit 1 GREEN
  bit 0 RED

***************************************************************************/
PALETTE_INIT( crbaloon )
{
	int i;
	#define TOTAL_COLORS(gfxn) (Machine->gfx[gfxn]->total_colors * Machine->gfx[gfxn]->color_granularity)
	#define COLOR(gfxn,offs) (colortable[Machine->drv->gfxdecodeinfo[gfxn].color_codes_start + offs])


	for (i = 0;i < Machine->drv->total_colors;i++)
	{
		int intensity,r,g,b;


		intensity = (~i & 0x08) ? 0xff : 0x55;

		/* red component */
		r = intensity * ((~i >> 0) & 1);
		/* green component */
		g = intensity * ((~i >> 1) & 1);
		/* blue component */
		b = intensity * ((~i >> 2) & 1);
		palette_set_color(i,r,g,b);
	}

	for (i = 0;i < TOTAL_COLORS(0);i += 2)
	{
		COLOR(0,i) = 15;		/* black background */
		COLOR(0,i + 1) = i / 2;	/* colored foreground */
	}
}



WRITE_HANDLER( crbaloon_spritectrl_w )
{
	spritectrl[offset] = data;
}



WRITE_HANDLER( crbaloon_flipscreen_w )
{
	flip_screen_set(data & 1);
}

/***************************************************************************

  Draw the game screen in the given mame_bitmap.
  Do NOT call osd_update_display() from this function, it will be called by
  the main emulation engine.

 ***************************************************************************/

VIDEO_UPDATE( crbaloon )
{
	int offs,x,y;
	int bx,by;


	if (get_vh_global_attribute_changed())
		memset(dirtybuffer,1,videoram_size);


	/* for every character in the Video RAM, check if it has been modified */
	/* since last time and update it accordingly. */
	for (offs = videoram_size - 1;offs >= 0;offs--)
	{
		if (dirtybuffer[offs])
		{
			int sx,sy;


			dirtybuffer[offs] = 0;

			sx = offs % 32;
			sy = offs / 32;
			if (!flip_screen)
			{
				sx = 31 - sx;
				sy = 31 - sy;
			}

			drawgfx(tmpbitmap,Machine->gfx[0],
					videoram[offs],
					colorram[offs] & 0x0f,
					flip_screen,flip_screen,
					8*sx,8*sy,
					&Machine->visible_area,TRANSPARENCY_NONE,0);
		}
	}

	/* copy the character mapped graphics */
	copybitmap(bitmap,tmpbitmap,0,0,0,0,&Machine->visible_area,TRANSPARENCY_NONE,0);


    /* Check Collision - Draw balloon in background colour, if no */
    /* collision occured, bitmap will be same as tmpbitmap        */

	bx = spritectrl[1];
	by = spritectrl[2] - 32;

	if (flip_screen)
	{
		by += 32;
	}

	drawgfx(bitmap,Machine->gfx[1],
			spritectrl[0] & 0x0f,
			15,
			0,0,
			bx,by,
			&Machine->visible_area,TRANSPARENCY_PEN,0);

    crbaloon_collision = 0;

	for (x = bx; x < bx + Machine->gfx[1]->width; x++)
	{
		for (y = by; y < by + Machine->gfx[1]->height; y++)
        {
			if ((x < Machine->visible_area.min_x) ||
			    (x > Machine->visible_area.max_x) ||
			    (y < Machine->visible_area.min_y) ||
			    (y > Machine->visible_area.max_y))
			{
				continue;
			}

        	if (read_pixel(bitmap, x, y) != read_pixel(tmpbitmap, x, y))
        	{
				crbaloon_collision = -1;
				break;
			}
        }
	}


	/* actually draw the balloon */

	drawgfx(bitmap,Machine->gfx[1],
			spritectrl[0] & 0x0f,
			(spritectrl[0] & 0xf0) >> 4,
			0,0,
			bx,by,
			&Machine->visible_area,TRANSPARENCY_PEN,0);
}
