/*************************************************
		KOF'99p Patch
*************************************************/

#define PATCH_END (-1)

#include "driver.h"
#include "kof99p_p1.c"
#include "kof99p_p2.c"
#include "kof99p_s1.c"

static void neogeo_kof99p_p1_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU1);
	int i = 0;

	while (kof99p_p1_address[i] != PATCH_END)
	{
		mem8[kof99p_p1_address[i]] = kof99p_p1_data[i];
		i++;
	}
}


static void neogeo_kof99p_p2_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU1) + 0x100000L;
	int i = 0;

	while (kof99p_p2_address[i] != PATCH_END)
	{
		mem8[kof99p_p2_address[i]] = kof99p_p2_data[i];
		i++;
	}
}


static void neogeo_kof99p_s1_patch(void)
{
	data8_t *mem8 = memory_region(REGION_GFX1);
	int i = 0;

	while (kof99p_s1_address[i] != PATCH_END)
	{
		mem8[kof99p_s1_address[i]] = kof99p_s1_data[i];
		i++;
	}
}


void neogeo_kof99p_patch(void)
{
	neogeo_kof99p_p1_patch();
	neogeo_kof99p_p2_patch();
	neogeo_kof99p_s1_patch();
}
