/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "jalecodriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "jalecodriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */

	/* Jaleco games */
	DRIVER( exerion )	/* (c) 1983 Jaleco */
	DRIVER( exeriont )	/* (c) 1983 Jaleco + Taito America license */
	DRIVER( exerionb )	/* bootleg */
	DRIVER( formatz )	/* (c) 1984 Jaleco */
	DRIVER( aeroboto )	/* (c) 1984 Williams */
	DRIVER( citycon )	/* (c) 1985 Jaleco */
	DRIVER( citycona )	/* (c) 1985 Jaleco */
	DRIVER( cruisin )	/* (c) 1985 Jaleco/Kitkorp */
	DRIVER( momoko )	/* (c) 1986 Jaleco */
	DRIVER( argus )		/* (c) 1986 Jaleco */
	DRIVER( valtric )	/* (c) 1986 Jaleco */
	DRIVER( butasan )	/* (c) 1987 Jaleco */
	DRIVER( psychic5 )	/* (c) 1987 Jaleco */
	DRIVER( ginganin )	/* (c) 1987 Jaleco */
	DRIVER( skyfox )	/* (c) 1987 Jaleco + Nichibutsu USA license */
	DRIVER( exerizrb )	/* bootleg */
	DRIVER( bigrun )	/* (c) 1989 Jaleco */
	DRIVER( cischeat )	/* (c) 1990 Jaleco */
	DRIVER( f1gpstar )	/* (c) 1991 Jaleco */
	DRIVER( scudhamm )	/* (c) 1994 Jaleco */
	DRIVER( tetrisp2 )	/* (c) 1997 Jaleco */
	DRIVER( teplus2j )	/* (c) 1997 Jaleco */
	DRIVER( rockn )	/* (c) 1999 Jaleco */
	DRIVER( rockn2 )	/* (c) 1999 Jaleco */
	DRIVER( rocknms )	/* (c) 1999 Jaleco */
	DRIVER( rockn3 )	/* (c) 1999 Jaleco */
	DRIVER( rockn4 )	/* (c) 2000 Jaleco */
	DRIVER( rocknmsm1 )	/* (c) 1999 Jaleco */
	//DRIVER( rocknmsm2 )	/* (c) 1999 Jaleco */

	/* Jaleco Mega System 1 games */
	DRIVER( lomakai )	/* (c) 1988 (World) */
	DRIVER( makaiden )	/* (c) 1988 (Japan) */
	DRIVER( p47 )		/* (c) 1988 */
	DRIVER( p47j )		/* (c) 1988 (Japan) */
	DRIVER( kickoff )	/* (c) 1988 (Japan) */
	DRIVER( tshingen )	/* (c) 1988 (Japan) */
	DRIVER( tshingna )	/* (c) 1988 (Japan) */
	DRIVER( iganinju )	/* (c) 1988 (Japan) */
	DRIVER( astyanax )	/* (c) 1989 */
	DRIVER( lordofk )	/* (c) 1989 (Japan) */
	DRIVER( hachoo )	/* (c) 1989 */
	DRIVER( jitsupro )	/* (c) 1989 (Japan) */
	DRIVER( plusalph )	/* (c) 1989 */
	DRIVER( stdragon )	/* (c) 1989 */
	DRIVER( rodland )	/* (c) 1990 */
	DRIVER( rodlandj )	/* (c) 1990 (Japan) */
	DRIVER( rodlndjb )	/* bootleg */
	DRIVER( avspirit )	/* (c) 1991 */
	DRIVER( phantasm )	/* (c) 1991 (Japan) */
	DRIVER( edf )		/* (c) 1991 */
	DRIVER( 64street )	/* (c) 1991 */
	DRIVER( 64streej )	/* (c) 1991 (Japan) */
	DRIVER( soldamj )	/* (c) 1992 (Japan) */
	DRIVER( bigstrik )	/* (c) 1992 */
	DRIVER( chimerab )	/* (c) 1993 */
	DRIVER( cybattlr )	/* (c) 1993 */
	DRIVER( peekaboo )	/* (c) 1993 */


#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
