/* CPS 3 */

/*

CPS3 Games are supplied with a CD and Cartridge.
CD contains the game data, Cartridge appears to contain a chip for the encryption and a Bios rom

the CPU is thought to be SH-2 based

the cartridges are backed up by a battery and are highly sensitive.

this driver does nothing, it is for reference purposes only for now.

Very few games were produced for this system (6 in total)

JoJo no Kimyouna Bouken / JoJo's Venture
JoJo no Kimyouna Bouken  Miraie no Isan / JoJo's Bizarre Adventure  Heritage for the Future
Street Fighter III  New Generation
Street Fighter III, 2nd Impact  Giant Attack
Street Fighter III, 3rd Strike  Fight for the Future
Warzard / Red Earth

Notes:

JoJo Venture  -  bios dumped
JoJo Biz Adv  -  bios not dumped
SF3 - New Gen -  bios dumped
SF3 - Sec Imp -  bios not dumped
SF3 - 3rd Str -  bios not dumped
Warzard       -  bios dumped


Bios Rom in cart = region?

CD image also contains bmp format files of the title logos

2nd impact is interesting as the data isn't encrypted on it

CPS3 can read CD-R images, security is provided by the cartridge.  rom data from cd is checksumed.

*/

/* load extracted cd content? */
#define LOAD_CD_CONTENT 1

#include "driver.h"

VIDEO_START(cps3)
{
	return 0;
}

VIDEO_UPDATE(cps3)
{

}

static MEMORY_READ_START( readmem )
/*	{ 0xffff0000, 0xffff7fff, MRA_BANK1 } */
MEMORY_END

static MEMORY_WRITE_START( writemem )
/*	{ 0xffff0000, 0xffff7fff, MWA_BANK1 } */
MEMORY_END

INPUT_PORTS_START( cps3 )
INPUT_PORTS_END

static MACHINE_DRIVER_START( cps3 )
	/* basic machine hardware */
	MDRV_CPU_ADD_TAG("main", SH2, 28636880 * 2) // ??
	MDRV_CPU_MEMORY(readmem,writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(64*8, 64*4)
	MDRV_VISIBLE_AREA(0, 64*8-1, 0, 64*4-1)
	MDRV_PALETTE_LENGTH( (16384 * 2 ) + 32 ) // Wrong!!

	MDRV_VIDEO_START(cps3)
	MDRV_VIDEO_UPDATE(cps3)
MACHINE_DRIVER_END
/*
static DRIVER_INIT (nocpu)
{
	cpunum_set_input_line(0, INPUT_LINE_RESET, ASSERT_LINE);
}
*/

ROM_START( sfiii )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "sf3bios",  0x000000, 0x080000, 0x74205250) 

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "sf3.cue",  0x0000000, 0x0000046, 0x54c89005) 
	ROM_REGION( 0x331f980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "sf3.bin",  0x0000000, 0x331f980, 0x6e72edcc) 

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x800000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x0000000, 0x800000, 0xe896dc27)
	ROM_REGION( 0x2400000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0x98c2d07c)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x7115a396)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x839f0972)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x8a8b252c)
	ROM_LOAD( "50",  0x2000000, 0x400000, 0x58933dc2)
	/* 90,91,92,93 are bmp images, not extracted */
	#endif
ROM_END

ROM_START( sfiii2 )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "sf32ibios.rom",  0x000000, 0x080000, 0xfaea0a3e) 

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "cap-3ga-1.cue",  0x0000000, 0x000004b, 0x2ba55809)
	ROM_REGION( 0x4a17980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "cap-3ga-1.bin",  0x0000000, 0x4a17980, 0x1c95fdd3)

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x1000000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x0000000, 0x800000, 0x682b014a)
	ROM_LOAD( "20",  0x0800000, 0x800000, 0x38090460)
	ROM_REGION( 0x3000000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0x77c197c0)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x7470a6f2)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x01a85ced)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0xfb346d74)
	ROM_LOAD( "50",  0x2000000, 0x800000, 0x32f79449)
	ROM_LOAD( "51",  0x2800000, 0x800000, 0x1102b8eb)
	/* 90,91,92,93 are bmp images, not extracted */
	#endif
ROM_END

ROM_START( sfiii3 )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "sf33rdbios.rom",  0x000000, 0x080000, 0x9fa37a05) // fixed bits

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "cap-33s-1.cue",  0x0000000, 0x000004b, 0xbd084ff0)
	ROM_REGION( 0x5c77980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "cap-33s-1.bin",  0x0000000, 0x5c77980, 0xbc8845b9)

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x1000000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x0000000, 0x800000, 0x77233d39)
	ROM_LOAD( "20",  0x0800000, 0x800000, 0x5ca8faba)
	ROM_REGION( 0x4000000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0xb37cf960)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x450ec982)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x632c965f)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x7a4c5f33)
	ROM_LOAD( "50",  0x2000000, 0x800000, 0x8562358e)
	ROM_LOAD( "51",  0x2800000, 0x800000, 0x7baf234b)
	ROM_LOAD( "60",  0x3000000, 0x800000, 0xbc9487b7)
	ROM_LOAD( "61",  0x3800000, 0x800000, 0xb813a1b1)
	/* 92,93 are bmp images, not extracted */
	#endif
ROM_END

ROM_START( warzard )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "warzard_cart_flashrom.bin",  0x000000, 0x080000, 0xf8e2f0c6)

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "wz.cue",  0x0000000, 0x0000045,  0x46dfcbee) 
	ROM_REGION( 0x331f980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "wz.bin",  0x0000000, 0x331f980, 0x0d93d45a) 

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x800000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x000000, 0x800000, 0x68188016)
	ROM_REGION( 0x2400000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0x074cab4d)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x14e2cad4)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x72d98890)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x88ccb33c)
	ROM_LOAD( "50",  0x2000000, 0x400000, 0x2f5b44bd)
	/* 90,91,92,93 are bmp images, not extracted */
	#endif
ROM_END

ROM_START( jojo )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "jojocart.bin",  0x000000, 0x080000, 0x02778f60)

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "cap-jjk-140.cue",  0x0000000, 0x000004d, 0x7eae4b4d)
	ROM_REGION( 0x3c4f980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "cap-jjk-140.bin",  0x0000000, 0x3c4f980, 0xbeb952ae)

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x1000000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x0000000, 0x800000, 0xe40dc123)
	ROM_LOAD( "20",  0x0800000, 0x800000, 0x0571e37c)
	ROM_REGION( 0x2400000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0x1d99181b)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x6889fbda)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x8069f9de)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x9c426823)
	ROM_LOAD( "50",  0x2000000, 0x400000, 0x1c749cc7)
	/* 92,93 are bmp images, not extracted */
	#endif
ROM_END


ROM_START( jojoba )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	// this was from a version which doesn't require the cd to run
	ROM_LOAD( "jojoba.rom",  0x000000, 0x080000, 0x4dab19f5)

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "cap-jjm-110.cue",  0x0000000, 0x000004d, 0xc9d6c2e8)
	ROM_REGION( 0x4a17980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "cap-jjm-110.bin",  0x0000000, 0x4a17980, 0x6b02c63a)

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x1000000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x000000, 0x800000, 0x6e2490f6)
	ROM_LOAD( "20",  0x800000, 0x800000, 0x1293892b)
	ROM_REGION( 0x3000000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0xd25c5005)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x51bb3dba)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x94dc26d4)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x1c53ee62)
	ROM_LOAD( "50",  0x2000000, 0x800000, 0x36e416ed)
	ROM_LOAD( "51",  0x2800000, 0x800000, 0xeedf19ca)
	/* 92,93 are bmp images, not extracted */
	#endif
ROM_END

ROM_START( jojobaa )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* dummy cpu region */

	ROM_REGION( 0x080000, REGION_USER1, 0 ) /* bios region */
	ROM_LOAD( "jojobacart.bin",  0x000000, 0x080000,  0x3085478c)

	/* Convert this to CHD? */
	ROM_REGION( 0x0000800, REGION_USER2, 0 ) /* cd cue image */
	ROM_LOAD( "cap-jjm-110.cue",  0x0000000, 0x000004d, 0xc9d6c2e8)
	ROM_REGION( 0x4a17980, REGION_USER3, 0 ) /* cd bin image */
	ROM_LOAD( "cap-jjm-110.bin",  0x0000000, 0x4a17980, 0x6b02c63a)

	#ifdef LOAD_CD_CONTENT
	/* Note: These regions contains the rom data extracted from the cd.
	         This is done only to make analysis easier. Once correct
	         emulation is possible this region will be removed and the
	         roms will be loaded into flashram from the CD by the system */
	ROM_REGION( 0x1000000, REGION_USER4, 0 ) /* cd content region */
	ROM_LOAD( "10",  0x000000, 0x800000, 0x6e2490f6)
	ROM_LOAD( "20",  0x800000, 0x800000, 0x1293892b)
	ROM_REGION( 0x3000000, REGION_USER5, 0 ) /* cd content region */
	ROM_LOAD( "30",  0x0000000, 0x800000, 0xd25c5005)
	ROM_LOAD( "31",  0x0800000, 0x800000, 0x51bb3dba)
	ROM_LOAD( "40",  0x1000000, 0x800000, 0x94dc26d4)
	ROM_LOAD( "41",  0x1800000, 0x800000, 0x1c53ee62)
	ROM_LOAD( "50",  0x2000000, 0x800000, 0x36e416ed)
	ROM_LOAD( "51",  0x2800000, 0x800000, 0xeedf19ca)
	/* 92,93 are bmp images, not extracted */
	#endif
ROM_END




GAMEX( 1997, sfiii,   0,        cps3, cps3, 0, ROT0,   "Capcom", "Street Fighter III - New Generation (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1998, sfiii2,  0,        cps3, cps3, 0, ROT0,   "Capcom", "Street Fighter III 2nd Impact - Giant Attack (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1999, sfiii3,  0,        cps3, cps3, 0, ROT0,   "Capcom", "Street Fighter III 3rd Strike -  Fight for the Future (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1996, warzard, 0,        cps3, cps3, 0, ROT0,   "Capcom", "Warzard (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1998, jojo,    0,        cps3, cps3, 0, ROT0,   "Capcom", "JoJo's Venture (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1999, jojoba,  0,        cps3, cps3, 0, ROT0,   "Capcom", "JoJo's Bizarre Adventure (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
GAMEX( 1999, jojobaa, jojoba,   cps3, cps3, 0, ROT0,   "Capcom", "JoJo's Bizarre Adventure (alt) (Cue+CD Data & NOCD Ver. File)", GAME_NOT_WORKING|GAME_NO_SOUND )
