﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Threading;
using System.Threading.Tasks;
using System.ComponentModel;
using System.Net;

namespace AssistRB
{
    /// <summary>
    /// WindowConnection.xaml の相互作用ロジック
    /// </summary>
    public partial class WindowConnection : Window
    {
        List<FindRecbox.RecboxInfo> recboxList = new List<FindRecbox.RecboxInfo>();
        BackgroundWorker findWorker = new BackgroundWorker();

        public WindowConnection()
        {
            InitializeComponent();

            findWorker.DoWork += new DoWorkEventHandler(findDoWork);
            findWorker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(findCompleted);
            findWorker.RunWorkerAsync();

            button1.IsEnabled = false;
            WriteLog("Recboxを検索しています");
        }

        private void findDoWork(object sender, DoWorkEventArgs e)
        {
            FindRecbox findrecbox = new FindRecbox();
            findrecbox.Search();
            recboxList = findrecbox.GetRecboxList();
        }

        private void findCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            comboBox1.ItemsSource = recboxList;
            if (recboxList.Count == 0)
            {
                comboBox1.SelectedIndex = -1;
                WriteLog("Recboxが見つかりませんでした");
            }
            else
            {
                comboBox1.SelectedIndex = 0;
                button1.IsEnabled = true;
                WriteLog("Recboxが見つかりました");
            }

            findWorker.Dispose();
        }

        private object lockObject = new object();
        private bool hasError;
        private System.Threading.Timer timer;

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            button1.IsEnabled = false;

            targetRecbox = comboBox1.SelectedItem as FindRecbox.RecboxInfo;
            initializeComplete = false;

            hasError = false;

            Task task = new Task(() =>
            {
                {
                    WriteLog("接続を開始します\n");

                    if (targetRecbox == null)
                    {
                        WriteLog("接続先が選択されていません。ツールを終了してください。\n");
                        return;
                    }

                    try
                    {
                        WebClient web = new WebClient();
                        byte[] recv = web.DownloadData("http://" + targetRecbox.Address);
                    WriteLog("トップ画面を取得しました\n");
                    }
                    catch
                    {
                        hasError = true;
                    }
                }

                if (!hasError)
                {
                    try
                    {
                        WebClient web = new WebClient();
                        byte[] recv = web.DownloadData("http://" + targetRecbox.Address + "/start/link.cgi");
                    WriteLog("コンテンツ画面に移動します\n");

                    WriteLog("接続が完了しました\n");
                    }
                    catch
                    {
                        hasError = true;
                    }

                    initializeComplete = true;

                    Finished();
                }
            });

            task.Start();
        }

        private FindRecbox.RecboxInfo targetRecbox;
        private bool initializeComplete = false;

        private void WriteLog(string s)
        {
            textBlock1.Dispatcher.Invoke(new WriteLogDelegate(WriteLogFunc), s);
        }

        private delegate void WriteLogDelegate(string s);
        private void WriteLogFunc(string s)
        {
            textBlock1.Text = s;
        }

        private void Finished()
        {
            this.Dispatcher.Invoke(new FinishedDelegate(FinishedFunc));
        }

        private delegate void FinishedDelegate();
        private void FinishedFunc()
        {
            this.Close();
        }

        public FindRecbox.RecboxInfo GetTargetRecbox()
        {
            if (initializeComplete)
            {
                return targetRecbox;
            }

            return null;
        }
    }
}
