﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Net;
using System.IO;
using Codeplex.Data;

namespace AssistRB
{
    /// <summary>
    /// 低レベル処理
    /// 1関数で完結したstatic関数群です
    /// </summary>
    public class WebLowlayer
    {
        public class ServerList
        {
            public string udn { get; set; }
            public string friendlyName { get; set; }

            public class StorageList
            {
                public string id { get; set; }
                public string friendlyName { get; set; }
            };

            public List<StorageList> strageList = new List<StorageList>();
            public List<StorageList> storageList
            {
                get
                {
                    return strageList;
                }
            }
        };

        /// <summary>
        /// フォルダの内容を取得する
        /// </summary>
        /// <param name="target">フォルダのID</param>
        /// <returns>フォルダの中身のリスト</returns>
        public static List<DlnaItem> UpdateFolder(string host_url, string target)
        {
            List<DlnaItem> items = new List<DlnaItem>();

            string tool_api_url = host_url + "/dms/transfer_tool/api";
            string uri = tool_api_url + "/browse?";

            int start = 0;
            while (true)
            {
                string queryFormat = @"{0}id={1}&starting_index={2}&requested_count={3}";
                string query = string.Format(queryFormat, uri, target, start, 100);

                System.Console.WriteLine(query);
                WebRequest request = WebRequest.Create(query);
                WebResponse responce = request.GetResponse();
                Stream stream = responce.GetResponseStream();
                if (stream == null)
                {
                    responce.Close();
                    break;
                }

                var json = DynamicJson.Parse(stream);
                stream.Close();
                responce.Close();

                if (json != null)
                {
                    var result = json.results;
                    if (result != null && result.IsArray)
                    {
                        foreach (var item in result)
                        {
                            if (item.IsDefined("id") && item.IsDefined("title"))
                            {
                                DlnaItem ditem = new DlnaItem();
                                ditem.Parent = target;
                                ditem.Id = item.id;
                                ditem.Title = item.title;
                                if (item.IsDefined("size"))
                                {
                                    var size = item.size;
                                    ditem.Size = (Int64)size;
                                }
                                if (item.IsDefined("date"))
                                {
                                    ditem.Date = item.date;
                                }

                                string exp =
                                    @"^(.*≫)*(［二］|（二）|（字）|\[(HV|ニ|新|無)\])?"
                                    + @"(?<title>.+)"
                                    + @"[ ]+#[0-9]+((・#|-#|,)[0-9]+)?"
                                    + @"[ ]*(新|終|END|（完）)?$";
                                Regex regex = new Regex(exp);
                                Match match = regex.Match(ditem.Title);
                                if (match.Success)
                                {
                                    ditem.Series = match.Groups["title"].Value;
                                    ditem.Series = ditem.Series.Replace(":", "：");
                                }
                                else
                                {
                                    ditem.Series = "";
                                }

                                ditem.ClassType = item["class"];

                                items.Add(ditem);
                            }
                        }
                    }

                    if (!json.IsDefined("startingIndex")
                     && !json.IsDefined("totalMatches")
                     && !json.IsDefined("numberReturned"))
                    {
                        break;
                    }

                    var si = json.startingIndex;
                    int startingIndex = (int)si;
                    var tm = json.totalMatches;
                    int totalMatches = (int)tm;
                    var nr = json.numberReturned;
                    int numberReturned = (int)nr;

                    if (start >= startingIndex + numberReturned)
                    {
                        break;
                    }
                    start = startingIndex + numberReturned;

                    if (start >= totalMatches)
                    {
                        break;
                    }
                }

            }
            return items;
        }

        /// <summary>
        /// ディレクトリを作ります
        /// </summary>
        /// <param name="parent">親ディレクトリのID</param>
        /// <param name="name">ディレクトリ名</param>
        /// <returns>成功すればtrueを返す</returns>
        public static bool MkDir(string host_url, string parent, string name)
        {
            string tool_api_url = host_url + "/dms/transfer_tool/api";
            string uri = tool_api_url + "/make_directory";

            WebClient wc = new WebClient();
            System.Collections.Specialized.NameValueCollection ps =
                new System.Collections.Specialized.NameValueCollection();
            ps.Add("parent_id", parent);
            ps.Add("name", name);
            try
            {
                byte[] resdata = wc.UploadValues(uri, ps);
            }
            catch (Exception e)
            {
                if (e is WebException)
                {
                    WebException we = e as WebException;
                }
                return false;
            }
            finally
            {
                wc.Dispose();
            }

            DlnaItemList.GetInstance().Invalidate(parent);

            return true;
        }

        /// <summary>
        /// ファイルを移動します（ネットワーク転送ではなくコンテンツ移動です）
        /// 移動元のアイテムは同じディレクトリに存在していないとダメなようです
        /// 移動自体は非同期処理です
        /// </summary>
        /// <param name="parent">移動先のディレクトリのID</param>
        /// <param name="items">移動するアイテム</param>
        /// <returns>即時エラーが返ってこなければtrueを返します</returns>
        public static bool Move(string host_url, string parent, string[] items)
        {
            string tool_api_url = host_url + "/dms/transfer_tool/api";
            string uri = tool_api_url + "/move";

            WebClient wc = new WebClient();
            System.Collections.Specialized.NameValueCollection ps =
                new System.Collections.Specialized.NameValueCollection();

            string src_ids = string.Join(",", items);

            ps.Add("src_ids", src_ids);
            ps.Add("dst_id", parent);
            try
            {
                byte[] resdata = wc.UploadValues(uri, ps);
            }
            catch (Exception e)
            {
                if (e is WebException)
                {
                    WebException we = e as WebException;
                }
                return false;
            }
            finally
            {
                wc.Dispose();
            }

            return true;
        }

        /// <summary>
        /// ファイルを移動します（ネットワーク転送です）
        /// 移動自体は非同期処理です
        /// </summary>
        /// <param name="items">移動するアイテム</param>
        /// <returns>即時エラーが返ってこなければtrueを返します</returns>
        public static bool Transfer(string host_url, string dst_udn, string dst_id, string[] items)
        {
            string tool_api_url = host_url + "/dms/transfer_tool/api";
            string uri = tool_api_url + "/transfer";

            WebClient wc = new WebClient();
            System.Collections.Specialized.NameValueCollection ps =
                new System.Collections.Specialized.NameValueCollection();

            string src_ids = string.Join(",", items);

            ps.Add("src_ids", src_ids);
            ps.Add("dst_udn", dst_udn);
            ps.Add("dst_id", dst_id);
            try
            {
                byte[] resdata = wc.UploadValues(uri, ps);
            }
            catch (Exception e)
            {
                if (e is WebException)
                {
                    WebException we = e as WebException;
                }
                return false;
            }
            finally
            {
                wc.Dispose();
            }

            return true;
        }

        /// <summary>
        /// 名前を変更します
        /// </summary>
        /// <param name="id">アイテムのID</param>
        /// <param name="name">変更後の名前</param>
        /// <returns>変更出来ればtrueを返します</returns>
        public static bool Rename(string host_url, string id, string name)
        {
            string tool_api_url = host_url + "/dms/transfer_tool/api";
            string uri = tool_api_url + "/rename";

            WebClient wc = new WebClient();
            System.Collections.Specialized.NameValueCollection ps =
                new System.Collections.Specialized.NameValueCollection();

            ps.Add("id", id);
            ps.Add("new_name", name);
            try
            {
                byte[] resdata = wc.UploadValues(uri, ps);
            }
            catch (Exception e)
            {
                if (e is WebException)
                {
                    WebException we = e as WebException;
                }
                return false;
            }
            finally
            {
                wc.Dispose();
            }

            return true;
        }

        /// <summary>
        /// </summary>
        public static List<ServerList> GetUdnList(string host_url)
        {
            List<ServerList> serverList = new List<ServerList>();

            {
                string tool_api_url = host_url + "/dms/transfer_tool/api";
                string uri = tool_api_url + "/dms_list";

                string query = uri;

                WebRequest request = WebRequest.Create(query);
                WebResponse responce = request.GetResponse();
                Stream stream = responce.GetResponseStream();
                if (stream == null)
                {
                    responce.Close();
                    return null;
                }

                var json = DynamicJson.Parse(stream);
                stream.Close();
                responce.Close();

                if (json != null)
                {
                    var result = json.results;
                    if (result != null && result.IsArray)
                    {
                        foreach (var item in result)
                        {
                            if (item.IsDefined("udn") && item.IsDefined("friendlyName"))
                            {
                                ServerList server = new ServerList();
                                server.udn = item.udn;
                                server.friendlyName = item.friendlyName;
                                serverList.Add(server);
                            }
                        }
                    }
                }
            }

            foreach (ServerList server in serverList)
            {
                string tool_api_url = host_url + "/dms/transfer_tool/api";
                string uri = tool_api_url + "/rec_dest_list";

                WebClient wc = new WebClient();
                System.Collections.Specialized.NameValueCollection ps =
                    new System.Collections.Specialized.NameValueCollection();

                ps.Add("udn", server.udn);
                try
                {
                    byte[] resdata = wc.UploadValues(uri, ps);

                    Stream stream = new MemoryStream(resdata);
                    if (stream == null)
                    {
                        wc.Dispose();
                        continue;
                    }

                    var json = DynamicJson.Parse(stream);
                    stream.Close();

                    if (json != null)
                    {
                        var result = json.results;
                        if (result != null && result.IsArray)
                        {
                            foreach (var item in result)
                            {
                                if (item.IsDefined("id") && item.IsDefined("friendlyName"))
                                {
                                    ServerList.StorageList storage = new ServerList.StorageList();
                                    storage.id = item.id;
                                    storage.friendlyName = item.friendlyName;
                                    server.strageList.Add(storage);
                                }
                            }
                        }
                    }
                }
                catch (Exception)
                {
                }
                wc.Dispose();
            }

            return serverList;
        }
    }
}
