﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace AssistRB
{
    /// <summary>
    /// ツールのログ表示のためのクラスです
    /// 破棄できません。
    /// </summary>
    public class ToolLog : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private Object messageLock = new Object();

        const int MaxLogLine = 100;

        private void OnPropertyChanged(string propertyName)
        {
            if (this.PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private static ToolLog toolLog = null;

        public static ToolLog GetInstance()
        {
            if (toolLog == null)
            {
                toolLog = new ToolLog();
            }
            return toolLog;
        }

        public void Add(string message)
        {
            this.AddOutputWindow(message);
        }

        private string statusMessage = "";
        public string StatusMessage
        {
            get
            {
                return statusMessage;
            }
            set
            {
                if (statusMessage != value)
                {
                    statusMessage = value;
                    this.OnPropertyChanged("StatusMessage");
                }
            }
        }

        private Queue<string> outputWindowBuffer = new Queue<string>();
        public string OutputWindowBuffer
        {
            get
            {
                string allMessage = "";
                foreach (string s in this.outputWindowBuffer)
                {
                    allMessage += s;
                }
                return allMessage;
            }
        }

        public void AddOutputWindow(string message)
        {
            DateTime tm = new DateTime(DateTime.Now.Ticks);

            string timemessage =
                string.Format(
                "{0:d4}/{1:d2}/{2:d2} {3:d2}:{4:d2}:{5:d2} ",
                tm.Year, tm.Month, tm.Day, tm.Hour, tm.Minute, tm.Second)
                + message
                + "\n";

            lock (messageLock)
            {
                this.StatusMessage = message;

                if (this.outputWindowBuffer.Count > MaxLogLine)
                {
                    this.outputWindowBuffer.Dequeue();
                }
                this.outputWindowBuffer.Enqueue(timemessage);
                this.OnPropertyChanged("OutputWindowBuffer");
            }
        }
    }
}
