﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net;
using Codeplex.Data;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.Web;

namespace AssistRB
{
    public delegate void DlnaItemUpdatedDelegate();

    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string propertyName)
        {
            if (this.PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private RecboxController recbox;
        private Thread recboxThread;

        private TransferStatusChecker transferStatusChecker;
        private Thread transferStatusThread;

        public ToolLog Log
        {
            get
            {
                return ToolLog.GetInstance();
            }
        }

        private bool isProcessing = false;
        public bool AllowNewRequest
        {
            get
            {
                return !isProcessing;
            }

            set
            {
                if (isProcessing == value)
                {
                    isProcessing = !value;
                    this.OnPropertyChanged("AllowNewRequest");
                }
            }
        }

        public void RecboxProcessDone()
        {
            AllowNewRequest = true;
        }

        private List<DlnaItem> allItemList = new List<DlnaItem>();
        public List<DlnaItem> AllItemList
        {
            get
            {
                return this.allItemList;
            }

            set
            {
                this.allItemList = new List<DlnaItem>(value);
                this.OnPropertyChanged("AllItemList");
            }
        }

        public void AllItemListChanged()
        {
            AllItemList = DlnaItemList.GetInstance().GetList();
        }

        private List<RenameItem> renameItemList = new List<RenameItem>();
        public List<RenameItem> RenameItemList
        {
            get
            {
                return this.renameItemList;
            }

            set
            {
                this.renameItemList = new List<RenameItem>(value);
                this.OnPropertyChanged("RenameItemList");
            }
        }

        public void RenameListChanged()
        {
            RenameItemList = recbox.RenameList;
        }

        private List<DispatchItem> dispatchItemList = new List<DispatchItem>();
        public List<DispatchItem> DispatchItemList
        {
            get
            {
                return this.dispatchItemList;
            }

            set
            {
                this.dispatchItemList = new List<DispatchItem>(value);
                this.OnPropertyChanged("DispatchItemList");
            }
        }

        public void DispatchListChanged()
        {
            DispatchItemList = recbox.DispatchList;
        }

        private List<DustboxItem> dustboxItemList = new List<DustboxItem>();
        public List<DustboxItem> DustboxItemList
        {
            get
            {
                return this.dustboxItemList;
            }

            set
            {
                this.dustboxItemList = new List<DustboxItem>(value);
                this.OnPropertyChanged("DustboxItemList");
            }
        }

        public void DustboxListChanged()
        {
            DustboxItemList = recbox.DustboxList;
        }

        private List<WebLowlayer.ServerList> serverList = new List<WebLowlayer.ServerList>();
        public List<WebLowlayer.ServerList> ServerList
        {
            get
            {
                return this.serverList;
            }

            set
            {
                this.serverList = new List<WebLowlayer.ServerList>(value);
                this.OnPropertyChanged("ServerList");
            }
        }

        public void ServerListChanged()
        {
            ServerList = recbox.ServerList;
        }

        FindRecbox.RecboxInfo targetRecbox;

        public MainWindow()
        {
            InitializeComponent();

            ToolLog.GetInstance().Add("開始しました");

            // ステータス監視用のスレッドを起動
            transferStatusChecker = TransferStatusChecker.GetInstance();
            transferStatusThread = new Thread(transferStatusChecker.worker);
            transferStatusThread.IsBackground = true;
            transferStatusThread.Start();

            // RECBOXとの通信（メイン）のスレッドを起動
            recbox = new RecboxController();
            recboxThread = new Thread(recbox.worker);
            recboxThread.IsBackground = true;
            recboxThread.Start();

            // RECBOXとステータス監視を関連付け
            transferStatusChecker.TransferStatusChanged +=
                new TransferStatusChecker.TransferStatusChangedDelegate(recbox.ChangeTransferProcessing);

            // RECBOXのイベント追加
            recbox.AllItemListChanged += new RecboxController.RecboxEventHandler(AllItemListChanged);
            recbox.RenameChanged += new RecboxController.RecboxEventHandler(RenameListChanged);
            recbox.DispatchChanged += new RecboxController.RecboxEventHandler(DispatchListChanged);
            recbox.DustboxChanged += new RecboxController.RecboxEventHandler(DustboxListChanged);
            recbox.ProcessDone += new RecboxController.RecboxEventHandler(RecboxProcessDone);
            recbox.ServerListChanged += new RecboxController.RecboxEventHandler(ServerListChanged);
        }

        ~MainWindow()
        {
            transferStatusChecker.Terminate();
            transferStatusThread.Join();

            recbox.Stop();
            recboxThread.Join();
        }

        private string GetTargetUrl()
        {
            string host_url = targetRecbox.Address.ToString();
            if (host_url == null)
            {
                return null;
            }

            return "http://" + host_url + ":55247";
        }

        // Load
        private void buttonLoad_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            if (host_url != null)
            {
                transferStatusChecker.Initializer(host_url);

                DlnaItemList.GetInstance().InvalidateAll();

                recbox.RequestUpdateList(host_url);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void buttonCheck_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            bool includeDir = false;
            if (checkBoxRenameIncludeDir.IsChecked.HasValue)
            {
                includeDir = checkBoxRenameIncludeDir.IsChecked.Value;
            }

            recbox.RequestRenameCheck(textBox2.Text, includeDir);
        }

        // Exec
        private void buttonExec_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            if (host_url != null)
            {
                transferStatusChecker.Initializer(host_url);

                recbox.RequestRename(host_url);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void buttonDispatchCheck_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            recbox.RequestDispatchCheck(textBoxDispatchRule.Text);
        }

        // Exec
        private void buttonDispatchExec_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            if (host_url != null)
            {
                transferStatusChecker.Initializer(host_url);

                recbox.RequestDispatch(host_url);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void buttonDustboxCheck_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            bool includeDir = false;
            if (checkBoxDustboxIncludeDir.IsChecked.HasValue)
            {
                includeDir = checkBoxDustboxIncludeDir.IsChecked.Value;
            }

            recbox.RequestDustboxCheck(textBoxDustboxRule.Text, includeDir);
        }

        // Exec
        private void buttonDustboxExec_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            if (host_url != null)
            {
                transferStatusChecker.Initializer(host_url);

                recbox.RequestDustbox(host_url, textBoxDustboxFolder.Text);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void buttonAllTransfer_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            WebLowlayer.ServerList server = comboBoxAllTransferUDN.SelectedItem as WebLowlayer.ServerList;
            WebLowlayer.ServerList.StorageList storage = comboBoxAllTransferDisk.SelectedItem as WebLowlayer.ServerList.StorageList;
            if (host_url != null && server != null && storage != null)
            {
                transferStatusChecker.Initializer(host_url);

                recbox.RequestAllTransfer(host_url, server.udn, storage.id);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void buttonAllTransferGetList_Click(object sender, RoutedEventArgs e)
        {
            this.AllowNewRequest = false;

            string host_url = GetTargetUrl();
            if (host_url != null)
            {
                transferStatusChecker.Initializer(host_url);

                recbox.RequestAllTransferGetList(host_url);
            }
            else
            {
                this.AllowNewRequest = true;
            }
        }

        private void comboBoxAllTransferUDN_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            WebLowlayer.ServerList server = comboBoxAllTransferUDN.SelectedItem as WebLowlayer.ServerList;
            if (server == null || server.storageList.Count == 0)
            {
                comboBoxAllTransferDisk.SelectedIndex = -1;
            }
            else
            {
                comboBoxAllTransferDisk.SelectedIndex = 0;
            }
        }

        private void Window_Initialized(object sender, EventArgs e)
        {
            WindowConnection windowConnection = new WindowConnection();
            windowConnection.ShowDialog();

            targetRecbox = windowConnection.GetTargetRecbox();
            if (targetRecbox == null)
            {
                this.Close();
            }
            else
            {
                targetUri.Text = targetRecbox.Address.ToString();
            }
        }
    }
}
