package com.momiage.app.asom.main;

import java.io.File;
import java.util.List;

import javax.swing.SwingUtilities;

import com.momiage.app.asom.gui.SourceChaserFrame;
import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceInfoReader;
import com.momiage.app.asom.logic.SourceTrackInfo;
import com.momiage.app.asom.logic.MusicCreator;

public class ASOMTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SourceInfo si1;
				List<SourceTrackInfo> lsti1;
				String baseDir = "C:/sf_svn/asom.local/experiment/src/com/momiage/app/asom/";
				try {
					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.java"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.java.mid"));
					SourceChaserFrame application1 = new SourceChaserFrame(si1,
							lsti1);
					application1.setVisible(true);

					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.c"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.c.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);

					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.cpp"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.cpp.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);

					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.n88basic"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.n88basic.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);

					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.cobol"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.cobol.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);

					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "source/HelloAsomWorld.sh"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/HelloAsomWorld.sh.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);
					
					si1 = SourceInfoReader.readSource(new File(baseDir
							+ "main/ASOMTest.java"));
					lsti1 = MusicCreator.create(si1, new File(
							"C:/ASOMTest.java.mid"));
					application1 = new SourceChaserFrame(si1, lsti1);
					application1.setVisible(true);

				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

	}

	public void debugPrint() {

	}

}
