package com.momiage.app.asom.logic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

import com.momiage.app.asom.common.DebugCommon;

public class MusicCreator {

	// l24tickƂ
	public static final int BASE_TICK = 24;

	// etickł킷
	public static final int NOTE_LEN_1 = BASE_TICK * 4;
	public static final int NOTE_LEN_2 = BASE_TICK * 2;
	public static final int NOTE_LEN_4 = BASE_TICK;
	public static final int NOTE_LEN_8 = BASE_TICK / 2;
	public static final int NOTE_LEN_16 = BASE_TICK / 4;
	public static final int NOTE_LEN_32 = BASE_TICK / 8;

	public static final int NOTE_LEN_2_DOT = NOTE_LEN_2 + NOTE_LEN_4;
	public static final int NOTE_LEN_4_DOT = NOTE_LEN_4 + NOTE_LEN_8;
	public static final int NOTE_LEN_8_DOT = NOTE_LEN_8 + NOTE_LEN_16;
	public static final int NOTE_LEN_16_DOT = NOTE_LEN_16 + NOTE_LEN_32;

	public static final int NOTE_LEN_4_TRI = NOTE_LEN_2 / 3;
	public static final int NOTE_LEN_8_TRI = NOTE_LEN_4 / 3;

	public static List<SourceTrackInfo> create(SourceInfo si, File f)
			throws InvalidMidiDataException, IOException {

		List<SourceTrackInfo> sti = new Vector<SourceTrackInfo>();

		// ̒̎
		// Ƃ肠At_RAȂǂ͎gȂ
		int[] notelenKind = { NOTE_LEN_1, NOTE_LEN_2, NOTE_LEN_4, NOTE_LEN_8,
				NOTE_LEN_16, NOTE_LEN_32,

		};

		int channel = 0;
		int firstPitch = 48;
		int nowPitch = 48;
		int velocity = 127;
		int instrument = si.getInstNo();
		int tickPos = 0;

		// MIDȈݒ
		Sequence seq = new Sequence(Sequence.PPQ, BASE_TICK);
		Track trk = seq.createTrack();

		MetaMessage mmessage = new MetaMessage();
		int tempo = si.getTempo();
		int l = 60 * 1000000 / tempo;
		mmessage.setMessage(0x51, new byte[] { (byte) (l / 65536),
				(byte) (l % 65536 / 256), (byte) (l % 256) }, 3);
		trk.add(new MidiEvent(mmessage, 0));

		ShortMessage message = new ShortMessage();
		debugSetMessage(message, ShortMessage.PROGRAM_CHANGE, channel,
				instrument, 0, 0);
		trk.add(new MidiEvent(message, 0));

		// xL̎擾
		String restChar = si.getRestChar();

		boolean isRest = false;
		char oldc = 0;
		char c = 0;
		int oldlenIndex = -1;
		int lenIndex = -1;
		int allcharpos = 0;
		int charpos = 0;
		int linepos = 0;

		Set<Integer> scale = MusicTheory.getMajorScaleNotes(si.getKey());

		// \[X̎擾
		Iterator<String> it = si.getSourceBody().iterator();
		while (it.hasNext()) {
			allcharpos += charpos;
			linepos++;
			charpos = 0;
			String line = it.next();

			// gbN쐬[v
			while (charpos < line.length()) {

				try {

					while (restChar.indexOf(c) > 0) {
						c = debugCharAt(line, charpos++);
					}

					isRest = false;

					c = debugCharAt(line, charpos++);

					if (restChar.indexOf(c) > 0) {
						// is rest.
						DebugCommon.print("");
						DebugCommon.print("isRest");
						isRest = true;

						while (restChar.indexOf(c) > 0) {
							c = debugCharAt(line, charpos++);
						}

					} else {
						int diff = oldc - c;
						// is note.
						if (0 == oldc) {
							nowPitch = firstPitch;
						} else {
							diff = diff % si.getMaxNoteRange();
							nowPitch = nowPitch + diff;
						}

						if (nowPitch > 127) {
							nowPitch = 127;
						} else if (nowPitch < 1) {
							nowPitch = 1;
						}

						// XP[̒ɓ
						int lowNote = (Integer)scale.toArray()[0];
						if (diff >= si.getScaleOutNoteRate()) {
							while (!scale.contains(nowPitch)) {
								nowPitch--;
								DebugCommon.print("Scale In Key " + si.getKey() + " = " + nowPitch);
								if (lowNote > nowPitch) {
									nowPitch = lowNote;
								}
							}
						}
						
						message = new ShortMessage();
						debugSetMessage(message, ShortMessage.NOTE_ON, channel,
								nowPitch, velocity, tickPos);
						trk.add(new MidiEvent(message, tickPos));

						sti.add(new SourceTrackInfo(ShortMessage.NOTE_ON,
								tickPos, nowPitch, linepos, allcharpos
										+ charpos));

						c = debugCharAt(line, charpos++);

						while (restChar.indexOf(c) > 0) {
							c = debugCharAt(line, charpos++);
						}

					}
				} catch (java.lang.StringIndexOutOfBoundsException e) {

				}

				// length
				lenIndex = c % notelenKind.length;
				if (-1 != oldlenIndex) {
					int diff = oldlenIndex - lenIndex;
					diff = diff % si.maxLengthRange;
					lenIndex = oldlenIndex + diff;
					DebugCommon.print("lenIndex = " + lenIndex);
					if (lenIndex < 0) {
						lenIndex = 2;
					} else if (lenIndex >= notelenKind.length) {
						lenIndex = notelenKind.length - 2;
					}
				}
				tickPos += notelenKind[lenIndex];
				oldlenIndex = lenIndex;

				if (!isRest) {
					message = new ShortMessage();
					debugSetMessage(message, ShortMessage.NOTE_OFF, channel,
							nowPitch, velocity, tickPos);
					trk.add(new MidiEvent(message, tickPos));

					sti.add(new SourceTrackInfo(ShortMessage.NOTE_OFF, tickPos,
							nowPitch, linepos, allcharpos + charpos));
				}

				oldc = c;

			}

		}

		// write to file
		if (null != f) {
			MidiSystem.write(seq, 0, f);
		}

		MusicTheory.getMajorScaleNotes(si.getKey());
		
		return sti;

	}

	private static char debugCharAt(String s, int pos) {
		char c = s.charAt(pos);
		DebugCommon.print(c);
		return c;
	}

	private static void debugSetMessage(ShortMessage mes, int onoff,
			int channel, int pitch, int velocity, int tick)
			throws InvalidMidiDataException {
		DebugCommon.print("");
		DebugCommon.print("data = " + onoff + ", " + channel + ", " + pitch
				+ ", " + velocity + ", " + tick);
		mes.setMessage(onoff, channel, pitch, velocity);
	}

}
